# Stone Soup
[![CircleCI branch](https://img.shields.io/circleci/project/github/dstl/Stone-Soup/master.svg?label=tests&style=flat)](https://circleci.com/gh/dstl/Stone-Soup)
[![Codecov](https://img.shields.io/codecov/c/github/dstl/Stone-Soup.svg)](https://codecov.io/gh/dstl/Stone-Soup)
[![Read the Docs](https://img.shields.io/readthedocs/stonesoup.svg?style=flat)](https://stonesoup.readthedocs.io/en/latest/?badge=latest)
[![Gitter](https://img.shields.io/gitter/room/dstl/Stone-Soup.svg?color=informational&style=flat)](https://gitter.im/dstl/Stone-Soup?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

## Background
Stone Soup is a software project to provide the target tracking and state estimation
community with a framework for the development and testing of tracking and state
estimation algorithms.

An article is [available](https://www.gov.uk/government/news/dstl-shares-new-open-source-framework-initiative) that details the background to the project, and contains links to sample data.

Stone Soup is currently in *beta*.

Please see the
[Stone Soup documentation](https://stonesoup.readthedocs.org/) for more
information.

Please see the [tutorials](https://stonesoup.readthedocs.io/en/latest/auto_tutorials/index.html),
[examples](https://stonesoup.readthedocs.io/en/latest/auto_examples/index.html),
and [demonstrations](https://stonesoup.readthedocs.io/en/latest/auto_demos/index.html).

## Dependencies
Stone Soup uses the following dependencies:

| Name | License |
| ---- | ------- |
| [Python](https://www.python.org/) (v3.6+) | PSFL |
| [SciPy](https://www.scipy.org/) | BSD |
| [matplotlib](https://matplotlib.org/) | [PSF/BSD-compatible](https://matplotlib.org/users/license.html) |
| [ruamel.yaml](https://yaml.readthedocs.io/) | MIT |
| [pymap3d](https://github.com/scivision/pymap3d) | MIT |
| [utm](https://github.com/Turbo87/utm) | MIT |

### Development

#### Testing
These dependencies are required for running Stone Soup tests.

| Name | License |
| ---- | ------- |
| [pytest](https://docs.pytest.org/) | MIT |
| [Flake8](https://flake8.pycqa.org/) | MIT |
| [Coverage.py](https://coverage.readthedocs.io/) | Apache 2.0 |

#### Documentation
These dependencies are required for building Stone Soup documentation.

| Name | License |
| ---- | ------- |
| [Sphinx](https://www.sphinx-doc.org/) | BSD |
| [sphinx-gallery](https://sphinx-gallery.github.io/) | BSD |
| [pillow](https://pillow.readthedocs.io/en/stable/index.html) | [PIL Software License](https://pillow.readthedocs.io/en/stable/about.html#license) |
| [folium](https://python-visualization.github.io/folium/) | MIT |

## License
Stone Soup is released under MIT License. Please see [License](LICENSE) for details.
