"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSipMediaApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const pstnCustomResources_1 = require("./pstnCustomResources");
const sipMediaApplicationValidator_1 = require("./sipMediaApplicationValidator");
class ChimeSipMediaApp extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, endpoint, region } = props;
        sipMediaApplicationValidator_1.sipMediaApplicationValidator(props);
        const sipMediaAppRequest = new pstnCustomResources_1.PSTNResources(this, 'sipMediaAppRequest', {
            resourceType: 'SMA',
            uid: uid,
            properties: {
                region: region || cdk.Stack.of(this).region,
                name: name !== null && name !== void 0 ? name : uid,
                endpoint: endpoint,
            },
        });
        this.sipMediaAppId =
            sipMediaAppRequest.pstnCustomResource.getAttString('sipMediaAppId');
    }
}
exports.ChimeSipMediaApp = ChimeSipMediaApp;
_a = JSII_RTTI_SYMBOL_1;
ChimeSipMediaApp[_a] = { fqn: "cdk-amazon-chime-resources.ChimeSipMediaApp", version: "0.1.9" };
//# sourceMappingURL=data:application/json;base64,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