from datetime import datetime
from pydantic import BaseModel, Field


class RevenueEventsSchema(BaseModel):
    """
    Доходы.
    https://appmetrica.yandex.ru/docs/mobile-api/logs/endpoints.html#revenue
    """
    revenue_quantity: int | None = Field(
        description='Количество покупок (купленных товаров).'
    )
    revenue_price: str | None = Field(
        description='Стоимость. Может быть отрицательной (например, для возврата).'
    )
    revenue_currency: str | None = Field(
        description='Код валюты покупки в формате ISO 4217.'
    )
    revenue_product_id: str | None = Field(
        description='Идентификатор товара.'
    )
    revenue_order_id: str | None = Field(
        description='Идентификатор заказа.'
    )
    revenue_order_id_source: str | None = Field(
        description='Источник идентификатора заказа. Возможные значения: autogenerated | user_defined.'
    )
    is_revenue_verified: str | None = Field(
        description='Признак верификации покупки в магазине.'
    )
    event_datetime: datetime | None = Field(
        description='Дата и время события в формате yyyy-mm-dd hh:mm:ss.'
    )
    event_name: str | None = Field(
        description='Имя события (как передано в SDK).'
    )
    event_receive_datetime: datetime | None = Field(
        description='Дата и время получения сервером события.'
    )
    event_receive_timestamp: int | None = Field(
        description='Время получения сервером события в формате UNIX-time.'
    )
    event_timestamp: int | None = Field(
        description='Время события в формате UNIX-time.'
    )
    session_id: int | None = Field(
        description='Идентификатор сессии.'
    )
    installation_id: str | None = Field(
        description='Идентификатор установки.'
    )
    android_id: str | None = Field(
        description='Идентификатор Android.'
    )
    appmetrica_device_id: str | None = Field(
        description='Уникальный идентификатор устройства, который устанавливает AppMetrica.'
    )
    appmetrica_sdk_version: int | None = Field(
        description='Версия AppMetrica SDK.'
    )
    city: str | None = Field(
        description='Название города на английском языке.'
    )
    connection_type: str | None = Field(
        description='Тип подключения устройства. Возможные значения: wifi | cell | unknown.'
    )
    country_iso_code: str | None = Field(
        description='ISO-код страны.'
    )
    device_ipv6: str | None = Field(
        description='IP-адрес в момент совершения события в формате IPv6.'
    )
    device_locale: str | None = Field(
        description='Язык интерфейса устройства.'
    )
    device_manufacturer: str | None = Field(
        description='Производитель устройства, определяется сервисом AppMetrica'
    )
    device_model: str | None = Field(
        description='Модель устройства, определяется сервисом AppMetrica'
    )
    google_aid: str | None = Field(
        description='Google AID устройства в формате, в котором получен от устройства.'
    )
    ios_ifa: str | None = Field(
        description='IFA устройства в формате, в котором получен от устройства.'
    )
    ios_ifv: str | None = Field(
        description='IFV для приложения в формате, в котором получен от устройства.'
    )
    mcc: int | None = Field(
        description='Мобильный код страны.'
    )
    mnc: int | None = Field(
        description='Код мобильной сети.'
    )
    operator_name: str | None = Field(
        description='Имя оператора сотовой связи.'
    )
    original_device_model: str | None = Field(
        description='Заводская модель устройства'
    )
    os_version: str | None = Field(
        description='Версия операционной системы на устройстве пользователя.'
    )
    profile_id: str | None = Field(
        description='Идентификатор пользовательского профиля.'
    )
    windows_aid: str | None = Field(
        description='Windows AID устройства в формате, в котором получен от устройства.'
    )
    app_build_number: int | None = Field(
        description='Номер сборки приложения.'
    )
    app_package_name: str | None = Field(
        description='Имя пакета для Android или Bundle ID для iOS'
    )
    app_version_name: str | None = Field(
        description='Версия приложения в виде, как указана разработчиком.'
    )
