import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowCxAgentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The URI of the agent's avatar.
     *
     * Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#avatar_uri DialogflowCxAgent#avatar_uri}
     *
     * @stability stable
     */
    readonly avatarUri?: string;
    /**
     * The default language of the agent as a language tag.
     *
     * [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be updated after creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#default_language_code DialogflowCxAgent#default_language_code}
     *
     * @stability stable
     */
    readonly defaultLanguageCode: string;
    /**
     * The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#description DialogflowCxAgent#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The human-readable name of the agent, unique within the location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#display_name DialogflowCxAgent#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Indicates if automatic spell correction is enabled in detect intent requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#enable_spell_correction DialogflowCxAgent#enable_spell_correction}
     *
     * @stability stable
     */
    readonly enableSpellCorrection?: boolean | cdktf.IResolvable;
    /**
     * Determines whether this agent should log conversation queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#enable_stackdriver_logging DialogflowCxAgent#enable_stackdriver_logging}
     *
     * @stability stable
     */
    readonly enableStackdriverLogging?: boolean | cdktf.IResolvable;
    /**
     * The name of the location this agent is located in.
     *
     * ~> **Note:** The first time you are deploying an Agent in your project you must configure location settings.
     * This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
     * Another options is to use global location so you don't need to manually configure location settings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#location DialogflowCxAgent#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#project DialogflowCxAgent#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#security_settings DialogflowCxAgent#security_settings}
     *
     * @stability stable
     */
    readonly securitySettings?: string;
    /**
     * The list of all languages supported by this agent (except for the default_language_code).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#supported_language_codes DialogflowCxAgent#supported_language_codes}
     *
     * @stability stable
     */
    readonly supportedLanguageCodes?: string[];
    /**
     * The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#time_zone DialogflowCxAgent#time_zone}
     *
     * @stability stable
     */
    readonly timeZone: string;
    /**
     * speech_to_text_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#speech_to_text_settings DialogflowCxAgent#speech_to_text_settings}
     *
     * @stability stable
     */
    readonly speechToTextSettings?: DialogflowCxAgentSpeechToTextSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#timeouts DialogflowCxAgent#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowCxAgentTimeouts;
}
/**
 * @stability stable
 */
export interface DialogflowCxAgentSpeechToTextSettings {
    /**
     * Whether to use speech adaptation for speech recognition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#enable_speech_adaptation DialogflowCxAgent#enable_speech_adaptation}
     *
     * @stability stable
     */
    readonly enableSpeechAdaptation?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DialogflowCxAgentSpeechToTextSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableSpeechAdaptation?;
    /**
     * @stability stable
     */
    get enableSpeechAdaptation(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableSpeechAdaptation(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableSpeechAdaptation(): void;
    /**
     * @stability stable
     */
    get enableSpeechAdaptationInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxAgentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#create DialogflowCxAgent#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#delete DialogflowCxAgent#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#update DialogflowCxAgent#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class DialogflowCxAgentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html google_dialogflow_cx_agent}.
 *
 * @stability stable
 */
export declare class DialogflowCxAgent extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html google_dialogflow_cx_agent} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowCxAgentConfig);
    private _avatarUri?;
    /**
     * @stability stable
     */
    get avatarUri(): string | undefined;
    /**
     * @stability stable
     */
    set avatarUri(value: string | undefined);
    /**
     * @stability stable
     */
    resetAvatarUri(): void;
    /**
     * @stability stable
     */
    get avatarUriInput(): string | undefined;
    private _defaultLanguageCode?;
    /**
     * @stability stable
     */
    get defaultLanguageCode(): string;
    /**
     * @stability stable
     */
    set defaultLanguageCode(value: string);
    /**
     * @stability stable
     */
    get defaultLanguageCodeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enableSpellCorrection?;
    /**
     * @stability stable
     */
    get enableSpellCorrection(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableSpellCorrection(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableSpellCorrection(): void;
    /**
     * @stability stable
     */
    get enableSpellCorrectionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStackdriverLogging?;
    /**
     * @stability stable
     */
    get enableStackdriverLogging(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableStackdriverLogging(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableStackdriverLogging(): void;
    /**
     * @stability stable
     */
    get enableStackdriverLoggingInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _securitySettings?;
    /**
     * @stability stable
     */
    get securitySettings(): string | undefined;
    /**
     * @stability stable
     */
    set securitySettings(value: string | undefined);
    /**
     * @stability stable
     */
    resetSecuritySettings(): void;
    /**
     * @stability stable
     */
    get securitySettingsInput(): string | undefined;
    /**
     * @stability stable
     */
    get startFlow(): string;
    private _supportedLanguageCodes?;
    /**
     * @stability stable
     */
    get supportedLanguageCodes(): string[] | undefined;
    /**
     * @stability stable
     */
    set supportedLanguageCodes(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSupportedLanguageCodes(): void;
    /**
     * @stability stable
     */
    get supportedLanguageCodesInput(): string[] | undefined;
    private _timeZone?;
    /**
     * @stability stable
     */
    get timeZone(): string;
    /**
     * @stability stable
     */
    set timeZone(value: string);
    /**
     * @stability stable
     */
    get timeZoneInput(): string | undefined;
    private _speechToTextSettings?;
    private __speechToTextSettingsOutput;
    /**
     * @stability stable
     */
    get speechToTextSettings(): DialogflowCxAgentSpeechToTextSettingsOutputReference;
    /**
     * @stability stable
     */
    putSpeechToTextSettings(value: DialogflowCxAgentSpeechToTextSettings | undefined): void;
    /**
     * @stability stable
     */
    resetSpeechToTextSettings(): void;
    /**
     * @stability stable
     */
    get speechToTextSettingsInput(): DialogflowCxAgentSpeechToTextSettings | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowCxAgentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DialogflowCxAgentTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowCxAgentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
