import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WorkflowsWorkflowConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the workflow provided by the user. Must be at most 1000 unicode characters long.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#description WorkflowsWorkflow#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * A set of key/value label pairs to assign to this Workflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#labels WorkflowsWorkflow#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the Workflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#name WorkflowsWorkflow#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#name_prefix WorkflowsWorkflow#name_prefix}.
     *
     * @stability stable
     */
    readonly namePrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#project WorkflowsWorkflow#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region of the workflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#region WorkflowsWorkflow#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Name of the service account associated with the latest workflow version.
     *
     * This service
     * account represents the identity of the workflow and determines what permissions the workflow has.
     *
     * Format: projects/{project}/serviceAccounts/{account}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#service_account WorkflowsWorkflow#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * Workflow code to be executed. The size limit is 32KB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#source_contents WorkflowsWorkflow#source_contents}
     *
     * @stability stable
     */
    readonly sourceContents?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#timeouts WorkflowsWorkflow#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WorkflowsWorkflowTimeouts;
}
/**
 * @stability stable
 */
export interface WorkflowsWorkflowTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#create WorkflowsWorkflow#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#delete WorkflowsWorkflow#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#update WorkflowsWorkflow#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class WorkflowsWorkflowTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html google_workflows_workflow}.
 *
 * @stability stable
 */
export declare class WorkflowsWorkflow extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html google_workflows_workflow} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: WorkflowsWorkflowConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namePrefix?;
    /**
     * @stability stable
     */
    get namePrefix(): string | undefined;
    /**
     * @stability stable
     */
    set namePrefix(value: string | undefined);
    /**
     * @stability stable
     */
    resetNamePrefix(): void;
    /**
     * @stability stable
     */
    get namePrefixInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get revisionId(): string;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string | undefined;
    /**
     * @stability stable
     */
    set serviceAccount(value: string | undefined);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
    private _sourceContents?;
    /**
     * @stability stable
     */
    get sourceContents(): string | undefined;
    /**
     * @stability stable
     */
    set sourceContents(value: string | undefined);
    /**
     * @stability stable
     */
    resetSourceContents(): void;
    /**
     * @stability stable
     */
    get sourceContentsInput(): string | undefined;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): WorkflowsWorkflowTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WorkflowsWorkflowTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WorkflowsWorkflowTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
