# AstroPy

 **AstroPy** to biblioteka w języku Python do obliczania, analizy i wizualizacji kosmogramów astrologicznych. Obsługuje efemerydy Swiss Ephemeris oraz generuje profesjonalne wykresy horoskopowe z aspektami, domami i układami planet.

##  Funkcje

- Obliczanie pozycji planet, ASC/MC i domów (Placidus) z użyciem `pyswisseph`
- Obsługa dodatkowych punktów: Chiron, Lilith, Węzeł Księżycowy, Punkt Fortuny, Vertex
- Wyświetlanie:
  - pełnego **koła horoskopu** (z aspektami, domami, zodiakiem)
  - **tabeli aspektów** w formie macierzy (pełna lub trójkątna)
  - **tabeli żywiołów i jakości** (FIR, AIR, EAR, WAT × CAR, FIX, MUT)
- Formatowanie pozycji do notacji astrologicznej (np. `13°17′ ♋︎`)
- W pełni modularna i rozszerzalna architektura

##  Wymagania

- Python 3.10+
- [pyswisseph](https://pypi.org/project/pyswisseph/)
- [matplotlib](https://matplotlib.org/)
- [skyfield](https://rhodesmill.org/skyfield/)
- [pandas](https://pandas.pydata.org/)

##  Przykład użycia

```python
from astro_py.core import Horoscope
from astro_py.plot_aspect_table import plot_aspect_matrix

# Dane urodzeniowe
h = Horoscope("1978-01-25", "22:41", ("Zielona Góra", 52.0, 15.5))
h.compute()

# Rysuj tabelę aspektów
plot_aspect_matrix(h)



AstroPy/
├── astro_py/
│   ├── core.py
│   ├── utils.py
│   ├── plot_aspect_table.py
│   ├── plot_aspect_triangle.py
│   ├── plot_element_mode.py
│   └── __init__.py
├── scripts/
├── tests/
├── data/
├── LICENSE
├── README.md
├── pyproject.toml
└── requirements.txt

##Licencja
Ten projekt jest dostępny na licencji [MIT License](LICENSE).  
Można go swobodnie używać, modyfikować i rozpowszechniać z podaniem źródła.


# AstroPy

**AstroPy** is a Python library for calculating, analyzing, and visualizing astrological charts (horoscopes). It supports Swiss Ephemeris and generates professional-grade horoscope diagrams with planetary positions, houses, and aspects.

##Features

- Calculation of planetary positions, ASC/MC and house cusps (Placidus system) using `pyswisseph`
- Support for additional points: Chiron, Lilith, Lunar Node, Part of Fortune, Vertex
- Visualization of:
  - Full **horoscope wheel** with zodiac signs, houses, and planetary aspects
  - **Aspect tables** in square or triangular matrix form
  - **Element and modality matrix** (FIR, AIR, EAR, WAT × CAR, FIX, MUT)
- Formatted zodiac-style positions (e.g. `13°17′ ♋︎`)
- Fully modular and extensible architecture

## Requirements

- Python 3.10+
- [pyswisseph](https://pypi.org/project/pyswisseph/)
- [matplotlib](https://matplotlib.org/)
- [skyfield](https://rhodesmill.org/skyfield/)
- [pandas](https://pandas.pydata.org/)

## Example usage

```python
from astro_py.core import Horoscope
from astro_py.plot_aspect_table import plot_aspect_matrix

h = Horoscope("1978-01-25", "22:41", ("Zielona Góra", 52.0, 15.5))
h.compute()
plot_aspect_matrix(h)

##Project structure

AstroPy/
├── astro_py/
│   ├── core.py
│   ├── utils.py
│   ├── plot_aspect_table.py
│   ├── plot_aspect_triangle.py
│   ├── plot_element_mode.py
│   └── __init__.py
├── scripts/
├── tests/
├── data/
├── LICENSE
├── README.md
├── pyproject.toml
└── requirements.txt

##License
This project is licensed under the terms of the [MIT License](LICENSE).  
You are free to use, modify, and distribute it with attribution.