import math

ZODIAC_SIGNS = [
    '♈︎',  # Baran
    '♉︎',  # Byk
    '♊︎',  # Bliźnięta
    '♋︎',  # Rak
    '♌︎',  # Lew
    '♍︎',  # Panna
    '♎︎',  # Waga
    '♏︎',  # Skorpion
    '♐︎',  # Strzelec
    '♑︎',  # Koziorożec
    '♒︎',  # Wodnik
    '♓︎',  # Ryby
]

PLANET_COLORS = {
    'Sun': 'tab:blue',
    'Moon': 'tab:orange',
    'Mercury': 'tab:green',
    'Venus': 'tab:red',
    'Mars': 'tab:brown',
    'Jupiter': 'tab:purple',
    'Saturn': 'tab:pink',
    'Uranus': 'tab:gray',
    'Neptune': 'olive',
    'Pluto': 'cyan',
    'ASC': 'blue',
    'MC': 'red',
    'Fortune': 'gold',
    'Vertex': 'magenta',
    'Lilith': 'black',
    'Node': 'darkgreen',
    'Chiron': 'darkorange'
}

PLANET_SYMBOLS = {
    'Sun': '☉', 'Moon': '☽', 'Mercury': '☿', 'Venus': '♀', 'Mars': '♂',
    'Jupiter': '♃', 'Saturn': '♄', 'Uranus': '♅', 'Neptune': '♆',
    'Pluto': '♇', 'Chiron': '⚷', 'Lilith': '⚸', 'Node': '☊',
    'Fortune': '⊗', 'Vertex': 'Vx'
}

ASPECTS = {
    'Conjunction':   {'angle': 0,   'orb': 8, 'color': 'black'},
    'Opposition':    {'angle': 180, 'orb': 8, 'color': 'red'},
    'Trine':         {'angle': 120, 'orb': 7, 'color': 'green'},
    'Square':        {'angle': 90,  'orb': 6, 'color': 'red'},
    'Sextile':       {'angle': 60,  'orb': 5, 'color': 'blue'},
    'Semisextile':   {'angle': 30,  'orb': 2, 'color': 'gray'},
    'Quincunx':      {'angle': 150, 'orb': 3, 'color': 'gray'},
}


def format_degree_to_zodiac(degree: float) -> str:

    deg = degree % 360
    sign_index = int(deg // 30)
    sign_deg = int(deg % 30)
    minutes = int((deg % 1) * 60)
    sign = ZODIAC_SIGNS[sign_index]
    return f"{sign_deg:02d}°{minutes:02d}′ {sign}"

def calculate_aspects(positions, aspects_def):
    aspects_found = []
    planets = list(positions.keys())

    for i in range(len(planets)):
        for j in range(i + 1, len(planets)):
            p1, p2 = planets[i], planets[j]
            lon1, lon2 = positions[p1]['longitude'], positions[p2]['longitude']
            diff = abs((lon1 - lon2) % 360)
            if diff > 180:
                diff = 360 - diff

            for name, aspect in aspects_def.items():
                if abs(diff - aspect['angle']) <= aspect['orb']:
                    aspects_found.append((p1, p2, name, aspect['color']))
                    break
    return aspects_found

