# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/Config/000_config.ipynb.

# %% auto 0
__all__ = ['logger', 'config_path_env', 'config_path_local', 'DB_HOSTS']

# %% ../../nbs/Config/000_config.ipynb 4
import logging
import os
import toml
from pathlib import Path

# Config.
logging.basicConfig(
    level=logging.INFO, format="%(asctime)s - %(message)s", datefmt="%Y-%m-%d %H:%M:%S"
)

logger = logging.getLogger(__name__)

# Read local `config.toml` file.
config_path_env = os.getenv("BETTING_ENV_CONFIG")
config_path_local = Path(os.getenv("HOME")) / "secrets" / "config.toml"
config_path_local = config_path_local if config_path_local.exists() else Path("/secrets/config.toml")

if config_path_local.exists():
    CONFIG = toml.load(config_path_local)
elif not config_path_env is None:
    CONFIG = toml.load(config_path_env)
else:
    logger.error(
        "No config file found under `BETTING_ENV_CONFIG`, pkg root or in `/secrets/config.toml`!"
    )

# Defined database hosts.
DB_HOSTS = set([db for db in CONFIG["databases"]])
