"""utils contains convenient helper functions and variables"""

from .colour import *

HTTP_CODES = {
    100: 'Continue', 101: 'Switching Protocols', 102: 'Processing',
    103: 'Early Hints', 200: 'OK', 201: 'Created', 202: 'Accepted',
    203: 'Non-Authoritative Information', 204: 'No Content', 205:
    'Reset Content', 206: 'Partial Content', 207: 'Multi-Status', 208:
    'Already Reported', 226: 'IM Used', 300: 'Multiple Choices', 301:
    'Moved Permanently', 302: 'Found', 303: 'See Other', 304: 'Not Modified',
    305: 'Use Proxy', 306: 'Switch Proxy', 307: 'Temporary Redirect',
    308: 'Permanent Redirect', 400: 'Bad Request', 401:
    'Unauthorized', 402: 'Payment Required', 403: 'Forbidden', 404:
    'Not Found', 405: 'Method Not Allowed', 406: 'Not Acceptable', 407:
    'Proxy Authentication Required', 408: 'Request Timeout', 409:
    'Conflict', 410: 'Gone', 411: 'Length Required', 412: 'Precondition Failed',
    413: 'Payload Too Large', 414: 'URI Too Long', 415:
    'Unsupported Media Type', 416: 'Range Not Satisfiable', 417:
    'Expectation Failed', 418: "I'm a teapot", 421: 'Misdirected Request',
    422: 'Unprocessable Entity', 423: 'Locked',
    424: 'Failed Dependency', 425: 'Too Early', 426: 'Upgrade Required', 428:
    'Precondition Required', 429: 'Too Many Requests',
    431: 'Request Header Fields Too Large', 451: 'Unavailable For Legal Reasons',
    500: 'Internal Server Error', 501: 'Not Implemented', 502: 'Bad Gateway',
    503: 'Service Unavailable', 504: 'Gateway Timeout', 505:
    'HTTP Version Not Supported', 506: 'Variant Also Negotiates', 507:
    'Insufficient Storage', 508: 'Loop Detected', 510: 'Not Extended',
    511: 'Network Authentication Required'
}


def info_banner() -> str:
    """info_banner returns a formatted info banner"""
    return f"{BLUE_BACKGROUND}{BOLD}[INFO]{NORMAL}"


def error_banner() -> str:
    """error_banner returns a formatted error banner"""
    return f"{RED_BACKGROUND}{BOLD}[ERROR]{NORMAL}"


def print_ketter_banner():
    """prints ketter banner to stdout"""
    banner = [10, 32, 95, 32, 32, 32, 32, 32, 32, 32, 32, 95, 32, 32, 32, 95,
              32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95, 10,
              124, 32, 124, 32, 95, 95, 95, 95, 95, 124, 32, 124, 95, 124, 32,
              124, 95, 32, 95, 95, 95, 32, 95, 32, 95, 95, 32, 32, 92, 32, 92,
              10, 124, 32, 124, 47, 32, 47, 32, 95, 32, 92, 32, 95, 95, 124,
              32, 95, 95, 47, 32, 95, 32, 92, 32, 39, 95, 95, 124, 32, 32, 92,
              32, 92, 10, 124, 32, 32, 32, 60, 32, 32, 95, 95, 47, 32, 124, 95,
              124, 32, 124, 124, 32, 32, 95, 95, 47, 32, 124, 32, 32, 32, 32,
              32, 47, 32, 47, 10, 124, 95, 124, 92, 95, 92, 95, 95, 95, 124,
              92, 95, 95, 124, 92, 95, 95, 92, 95, 95, 95, 124, 95, 124, 32,
              32, 32, 32, 47, 95, 47, 10]

    print(f"{YELLOW}{BOLD}{bytes(banner).decode('utf-8')}{NORMAL}")


def format_user_submitted(user_str: str) -> str:
    return f"{UNDERLINE}{CYAN}{user_str}{NORMAL}"


def capitalise(string: str) -> str:
    pieces = string.split("-")
    capped_pieces = map(lambda piece: piece[0].upper() + piece[1:], pieces)
    return "-".join(capped_pieces)
