#include <iostream>
#include <cmath>

#include <dune/fem/quadrature/pardgsimplexquadrature.hh>


namespace Dune {
namespace Fem {
namespace ParDGSimplexQuadrature
{

// 1d quadrature rules for the interval (0,1)
//
// naming convention of quad1d_x: x denotes the order of the formula
//                                i.e. the maximum degree of polynimials
//                                that is integrated exact by the formula.
//
// exception quad1d_0: this is a dummy that has no points



// return a quadrature formula that has at least degree minimum_degree
template <>
const Quadrature<1>& Quadrature<1>::quadrature(int minimum_degree)
{
  if (minimum_degree < 0) return quad1d_0;

  switch (minimum_degree){
  case 0: case 1: return quad1d_1; break;
  case 2: case 3: return quad1d_3; break;
  case 4: case 5: return quad1d_5; break;
  case 6: case 7: return quad1d_7; break;
  case 8: case 9: return quad1d_9; break;
  case 10: case 11: return quad1d_11; break;
  case 12: case 13: return quad1d_13; break;
  case 14: case 15: return quad1d_15; break;
  case 16: case 17: return quad1d_17; break;
  case 18: case 19: return quad1d_19; break;
  case 20: case 21: return quad1d_21; break;
  case 22: case 23: return quad1d_23; break;
  case 24: case 25: return quad1d_25; break;
  case 26: case 27: return quad1d_27; break;
  case 28: case 29: return quad1d_29; break;
  case 30: case 31: return quad1d_31; break;
  case 32: case 33: return quad1d_33; break;
  case 34: case 35: return quad1d_35; break;
  case 36: case 37: return quad1d_37; break;
  case 38: case 39: return quad1d_39; break;
  default:
    {
      std::cerr << "Quadrature1d::quadrature: order " << minimum_degree << " not avaiable" << std::endl;
      assert(0);
      abort();
    }
  }

  return quad1d_0;
}



template<>
void Quadrature1d::check() const
{
  double total_error = 0.0;

  for(int m=0; m<=degree; m++){
    double sum = 0.0;
    for(int r=0; r<nop; r++){
      double x_m = 1.0;
      for(int i=1; i<=m; i++) x_m *= x(r)[0];
      sum += w(r) * x_m;
    }

    double error = fabs(sum - 1.0/(m+1));
    total_error += error;

    std::cout << m << "  "
        << "   error: " << error << "  "
        << std::endl;
  }

  std::cout << "total error: " << total_error << std::endl;
}



// dummy
static const double quad1d_0_x[][2] = {{}};
const Quadrature1d quad1d_0(0, 0, quad1d_0_x);




// quadrature rules for the interval (0,1)
static const double _quad1d_1_x[][2] =
  {{0.50000000000000000000,   1.00000000000000000000}
  };
const Quadrature1d quad1d_1(1, 1, _quad1d_1_x);

static const double _quad1d_3_x[][2] =
  {{0.21132486540518713447,   0.49999999999999977796},
   {0.78867513459481286553,   0.49999999999999977796}
  };
const Quadrature1d quad1d_3(2, 3, _quad1d_3_x);

static const double _quad1d_5_x[][2] =
  {{0.11270166537925829786,   0.27777777777777634682},
   {0.50000000000000000000,   0.44444444444444441977},
   {0.88729833462074170214,   0.27777777777777634682}
  };
const Quadrature1d quad1d_5(3, 5, _quad1d_5_x);

static const double _quad1d_7_x[][2] =
  {{0.06943184420297371373,   0.17392742256872378848},
   {0.33000947820757187134,   0.32607257743127321392},
   {0.66999052179242812866,   0.32607257743127321392},
   {0.93056815579702623076,   0.17392742256872378848}
  };
const Quadrature1d quad1d_7(4, 7, _quad1d_7_x);

static const double _quad1d_9_x[][2] =
  {{0.04691007703066801815,   0.11846344252809086484},
   {0.23076534494715844614,   0.23931433524968323545},
   {0.50000000000000000000,   0.28444444444444444420},
   {0.76923465505284149835,   0.23931433524968323545},
   {0.95308992296933192634,   0.11846344252809086484}
  };
const Quadrature1d quad1d_9(5, 9, _quad1d_9_x);

static const double _quad1d_11_x[][2] =
  {{0.03376524289842397497,   0.08566224618958116765},
   {0.16939530676686770372,   0.18038078652406930313},
   {0.38069040695840156152,   0.23395696728634474137},
   {0.61930959304159849399,   0.23395696728634474137},
   {0.83060469323313235179,   0.18038078652406930313},
   {0.96623475710157602503,   0.08566224618958116765}
  };
const Quadrature1d quad1d_11(6, 11, _quad1d_11_x);

static const double _quad1d_13_x[][2] =
  {{0.02544604382862075687,   0.06474248308443122935},
   {0.12923440720030276996,   0.13985269574463835007},
   {0.29707742431130140792,   0.19091502525255951705},
   {0.50000000000000000000,   0.20897959183673470163},
   {0.70292257568869853657,   0.19091502525255951705},
   {0.87076559279969723004,   0.13985269574463835007},
   {0.97455395617137918762,   0.06474248308443122935}
  };
const Quadrature1d quad1d_13(7, 13, _quad1d_13_x);

static const double _quad1d_15_x[][2] =
  {{0.01985507175123191193,   0.05061426814518486111},
   {0.10166676129318658051,   0.11119051722668722715},
   {0.23723379504183550459,   0.15685332293894369005},
   {0.40828267875217510996,   0.18134189168918099511},
   {0.59171732124782483453,   0.18134189168918099511},
   {0.76276620495816449541,   0.15685332293894369005},
   {0.89833323870681347501,   0.11119051722668722715},
   {0.98014492824876808807,   0.05061426814518486111}
  };
const Quadrature1d quad1d_15(8, 15, _quad1d_15_x);

static const double _quad1d_17_x[][2] =
  {{0.01591988024618695707,   0.04063719418078436812},
   {0.08198444633668205972,   0.09032408034742878122},
   {0.19331428364970476563,   0.13030534820146777442},
   {0.33787328829809554209,   0.15617353852000095960},
   {0.50000000000000000000,   0.16511967750062989113},
   {0.66212671170190451342,   0.15617353852000095960},
   {0.80668571635029517886,   0.13030534820146777442},
   {0.91801555366331788477,   0.09032408034742878122},
   {0.98408011975381304293,   0.04063719418078436812}
  };
const Quadrature1d quad1d_17(9, 17, _quad1d_17_x);

static const double _quad1d_19_x[][2] =
  {{0.01304673574141418380,   0.03333567215434143222},
   {0.06746831665550773183,   0.07472567457529026569},
   {0.16029521585048778221,   0.10954318125799103467},
   {0.28330230293537639330,   0.13463335965499587110},
   {0.42556283050918441990,   0.14776211235737646277},
   {0.57443716949081558010,   0.14776211235737646277},
   {0.71669769706462360670,   0.13463335965499587110},
   {0.83970478414951221779,   0.10954318125799103467},
   {0.93253168334449232368,   0.07472567457529026569},
   {0.98695326425858587172,   0.03333567215434143222}
  };
const Quadrature1d quad1d_19(10, 19, _quad1d_19_x);

static const double _quad1d_21_x[][2] =
  {{0.01088567092697151351,   0.02783428355808480192},
   {0.05646870011595234162,   0.06279018473245236154},
   {0.13492399721297532178,   0.09314510546386713108},
   {0.24045193539659409643,   0.11659688229598906550},
   {0.36522842202382754806,   0.13140227225512329801},
   {0.50000000000000000000,   0.13646254338895030811},
   {0.63477157797617245194,   0.13140227225512329801},
   {0.75954806460340584806,   0.11659688229598906550},
   {0.86507600278702467822,   0.09314510546386713108},
   {0.94353129988404771389,   0.06279018473245236154},
   {0.98911432907302843098,   0.02783428355808480192}
  };
const Quadrature1d quad1d_21(11, 21, _quad1d_21_x);

static const double _quad1d_23_x[][2] =
  {{0.00921968287664037822,   0.02358766819325391201},
   {0.04794137181476260112,   0.05346966299765908842},
   {0.11504866290284765373,   0.08003916427167316605},
   {0.20634102285669125854,   0.10158371336153292075},
   {0.31608425050090993569,   0.11674626826917729183},
   {0.43738329574426554336,   0.12457352290670144213},
   {0.56261670425573440113,   0.12457352290670144213},
   {0.68391574949909006431,   0.11674626826917729183},
   {0.79365897714330868595,   0.10158371336153292075},
   {0.88495133709715234627,   0.08003916427167316605},
   {0.95205862818523745439,   0.05346966299765908842},
   {0.99078031712335956627,   0.02358766819325391201}
  };
const Quadrature1d quad1d_23(12, 23, _quad1d_23_x);

static const double _quad1d_25_x[][2] =
  {{0.00790847264070593248,   0.02024200238265614835},
   {0.04120080038851098303,   0.04606074991886419112},
   {0.09921095463334506093,   0.06943675510989359700},
   {0.17882533027982988605,   0.08907299038097284127},
   {0.27575362448177653807,   0.10390802376844394950},
   {0.38477084202243261313,   0.11314159013144857446},
   {0.50000000000000000000,   0.11627577661543694876},
   {0.61522915797756738687,   0.11314159013144857446},
   {0.72424637551822346193,   0.10390802376844394950},
   {0.82117466972017005844,   0.08907299038097284127},
   {0.90078904536665493907,   0.06943675510989359700},
   {0.95879919961148907248,   0.04606074991886419112},
   {0.99209152735929406752,   0.02024200238265614835}
  };
const Quadrature1d quad1d_25(13, 25, _quad1d_25_x);

static const double _quad1d_27_x[][2] =
  {{0.00685809565159384293,   0.01755973016587452848},
   {0.03578255816821318547,   0.04007904357988018723},
   {0.08639934246511749016,   0.06075928534395155789},
   {0.15635354759415726056,   0.07860158357909680094},
   {0.24237568182092295022,   0.09276919873896821711},
   {0.34044381553605512769,   0.10259923186064774658},
   {0.44597252564632816618,   0.10763192673157888357},
   {0.55402747435367183382,   0.10763192673157888357},
   {0.65955618446394481680,   0.10259923186064774658},
   {0.75762431817907704978,   0.09276919873896821711},
   {0.84364645240584268393,   0.07860158357909680094},
   {0.91360065753488250984,   0.06075928534395155789},
   {0.96421744183178681453,   0.04007904357988018723},
   {0.99314190434840621258,   0.01755973016587452848}
  };
const Quadrature1d quad1d_27(14, 27, _quad1d_27_x);

static const double _quad1d_29_x[][2] =
  {{0.00600374098975725579,   0.01537662099805739424},
   {0.03136330379964702431,   0.03518302374405413852},
   {0.07589670829478639691,   0.05357961023358601832},
   {0.13779113431991496519,   0.06978533896307713424},
   {0.21451391369573058476,   0.08313460290849568335},
   {0.30292432646121830730,   0.09308050000778111954},
   {0.39940295300128275668,   0.09921574266355578930},
   {0.50000000000000000000,   0.10128912096278064325},
   {0.60059704699871729883,   0.09921574266355578930},
   {0.69707567353878174821,   0.09308050000778111954},
   {0.78548608630426941524,   0.08313460290849568335},
   {0.86220886568008503481,   0.06978533896307713424},
   {0.92410329170521365860,   0.05357961023358601832},
   {0.96863669620035297569,   0.03518302374405413852},
   {0.99399625901024268870,   0.01537662099805739424}
  };
const Quadrature1d quad1d_29(15, 29, _quad1d_29_x);

static const double _quad1d_31_x[][2] =
  {{0.00529953250417503074,   0.01357622970587592584},
   {0.02771248846338369987,   0.03112676196932388784},
   {0.06718439880608412240,   0.04757925584124644836},
   {0.12229779582249850067,   0.06231448562776697314},
   {0.19106187779867811471,   0.07479799440828664714},
   {0.27099161117138631516,   0.08457825969750121242},
   {0.35919822461037054229,   0.09130170752246180577},
   {0.45249374508118128668,   0.09472530522753423721},
   {0.54750625491881876883,   0.09472530522753423721},
   {0.64080177538962945771,   0.09130170752246180577},
   {0.72900838882861362933,   0.08457825969750121242},
   {0.80893812220132188529,   0.07479799440828664714},
   {0.87770220417750155484,   0.06231448562776697314},
   {0.93281560119391593311,   0.04757925584124644836},
   {0.97228751153661630013,   0.03112676196932388784},
   {0.99470046749582496926,   0.01357622970587592584}
  };
const Quadrature1d quad1d_31(16, 31, _quad1d_31_x);

static const double _quad1d_33_x[][2] =
  {{0.00471226234279131795,   0.01207415143427311918},
   {0.02466223911561610249,   0.02772976468699356670},
   {0.05988042313650704385,   0.04251807415858957495},
   {0.10924299805159931598,   0.05594192359670196318},
   {0.17116442039165458144,   0.06756818423426051712},
   {0.24365473145676153077,   0.07702288053840498916},
   {0.32438411827306184998,   0.08400205107822494854},
   {0.41075790925207605886,   0.08828135268349632248},
   {0.50000000000000000000,   0.08972323517810326665},
   {0.58924209074792388563,   0.08828135268349632248},
   {0.67561588172693820553,   0.08400205107822494854},
   {0.75634526854323846923,   0.07702288053840498916},
   {0.82883557960834541856,   0.06756818423426051712},
   {0.89075700194840068402,   0.05594192359670196318},
   {0.94011957686349290064,   0.04251807415858957495},
   {0.97533776088438384200,   0.02772976468699356670},
   {0.99528773765720868205,   0.01207415143427311918}
  };
const Quadrature1d quad1d_33(17, 33, _quad1d_33_x);

static const double _quad1d_35_x[][2] =
  {{0.00421741578953449547,   0.01080800676324069828},
   {0.02208802521430114352,   0.02485727444748491929},
   {0.05369876675122214893,   0.03821286512744458824},
   {0.09814752051373842878,   0.05047102205314361184},
   {0.15415647846982338809,   0.06127760335573649575},
   {0.22011458446302623049,   0.07032145733532516041},
   {0.29412441926857868513,   0.07734233756313259323},
   {0.37405688715424723068,   0.08213824187291633716},
   {0.45761249347913235397,   0.08457119148157177246},
   {0.54238750652086764603,   0.08457119148157177246},
   {0.62594311284575276932,   0.08213824187291633716},
   {0.70587558073142131487,   0.07734233756313259323},
   {0.77988541553697376951,   0.07032145733532516041},
   {0.84584352153017661191,   0.06127760335573649575},
   {0.90185247948626157122,   0.05047102205314361184},
   {0.94630123324877790658,   0.03821286512744458824},
   {0.97791197478569880097,   0.02485727444748491929},
   {0.99578258421046550453,   0.01080800676324069828}
  };
const Quadrature1d quad1d_35(18, 35, _quad1d_35_x);

static const double _quad1d_37_x[][2] =
  {{0.00379657807820782400,   0.00973089411486242201},
   {0.01989592393258499126,   0.02240711338284979287},
   {0.04842204819259104953,   0.03452227136882062702},
   {0.08864267173142859058,   0.04574501081122506890},
   {0.13951691133238530718,   0.05578332277366374742},
   {0.19972734766915950511,   0.06437698126966782952},
   {0.26771462931201950308,   0.07130335108680328771},
   {0.34171795001818505710,   0.07638302103292986256},
   {0.41982067717988730271,   0.07948442169697721160},
   {0.50000000000000000000,   0.08052722492439184920},
   {0.58017932282011264178,   0.07948442169697721160},
   {0.65828204998181494290,   0.07638302103292986256},
   {0.73228537068798049692,   0.07130335108680328771},
   {0.80027265233084055041,   0.06437698126966782952},
   {0.86048308866761469282,   0.05578332277366374742},
   {0.91135732826857140942,   0.04574501081122506890},
   {0.95157795180740900598,   0.03452227136882062702},
   {0.98010407606741500874,   0.02240711338284979287},
   {0.99620342192179212049,   0.00973089411486242201}
  };
const Quadrature1d quad1d_37(19, 37, _quad1d_37_x);

static const double _quad1d_39_x[][2] =
  {{0.00343570040745255767,   0.00880700356957528872},
   {0.01801403636104309536,   0.02030071490019352484},
   {0.04388278587433702693,   0.03133602416705452004},
   {0.08044151408889055332,   0.04163837078835237043},
   {0.12683404676992460214,   0.05096505990861661256},
   {0.18197315963674248751,   0.05909726598075887294},
   {0.24456649902458643675,   0.06584431922458830466},
   {0.31314695564229022562,   0.07104805465919107610},
   {0.38610707442917746590,   0.07458649323630188455},
   {0.46173673943325133084,   0.07637669356536298804},
   {0.53826326056674866916,   0.07637669356536298804},
   {0.61389292557082253410,   0.07458649323630188455},
   {0.68685304435770977438,   0.07104805465919107610},
   {0.75543350097541361876,   0.06584431922458830466},
   {0.81802684036325756800,   0.05909726598075887294},
   {0.87316595323007539786,   0.05096505990861661256},
   {0.91955848591110944668,   0.04163837078835237043},
   {0.95611721412566297307,   0.03133602416705452004},
   {0.98198596363895696015,   0.02030071490019352484},
   {0.99656429959254744233,   0.00880700356957528872}
  };
const Quadrature1d quad1d_39(20, 39, _quad1d_39_x);


} // ParDGSimplexQuadrature
} // Fem
} // Dune
