"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointGroup = exports.HealthCheckProtocol = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const _accelerator_security_group_1 = require("./_accelerator-security-group");
const ga = require("./globalaccelerator.generated");
/**
 * The protocol for the connections from clients to the accelerator.
 *
 * @stability stable
 */
var HealthCheckProtocol;
(function (HealthCheckProtocol) {
    HealthCheckProtocol["TCP"] = "TCP";
    HealthCheckProtocol["HTTP"] = "HTTP";
    HealthCheckProtocol["HTTPS"] = "HTTPS";
})(HealthCheckProtocol = exports.HealthCheckProtocol || (exports.HealthCheckProtocol = {}));
/**
 * EndpointGroup construct.
 *
 * @stability stable
 */
class EndpointGroup extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f;
        super(scope, id);
        /**
         * The array of the endpoints in this endpoint group.
         *
         * @stability stable
         */
        this.endpoints = new Array();
        const resource = new ga.CfnEndpointGroup(this, 'Resource', {
            listenerArn: props.listener.listenerArn,
            endpointGroupRegion: (_b = props.region) !== null && _b !== void 0 ? _b : cdk.Lazy.string({ produce: () => this.firstEndpointRegion() }),
            endpointConfigurations: cdk.Lazy.any({ produce: () => this.renderEndpoints() }, { omitEmptyArray: true }),
            healthCheckIntervalSeconds: (_c = props.healthCheckInterval) === null || _c === void 0 ? void 0 : _c.toSeconds({ integral: true }),
            healthCheckPath: props.healthCheckPath,
            healthCheckPort: props.healthCheckPort,
            healthCheckProtocol: props.healthCheckProtocol,
            thresholdCount: props.healthCheckThreshold,
            trafficDialPercentage: props.trafficDialPercentage,
            portOverrides: (_d = props.portOverrides) === null || _d === void 0 ? void 0 : _d.map(o => ({
                endpointPort: o.endpointPort,
                listenerPort: o.listenerPort,
            })),
        });
        this.endpointGroupArn = resource.attrEndpointGroupArn;
        this.endpointGroupName = (_e = props.endpointGroupName) !== null && _e !== void 0 ? _e : resource.logicalId;
        for (const endpoint of (_f = props.endpoints) !== null && _f !== void 0 ? _f : []) {
            this.addEndpoint(endpoint);
        }
    }
    /**
     * import from ARN.
     *
     * @stability stable
     */
    static fromEndpointGroupArn(scope, id, endpointGroupArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.endpointGroupArn = endpointGroupArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Add an endpoint.
     *
     * @stability stable
     */
    addEndpoint(endpoint) {
        this.endpoints.push(endpoint);
    }
    /**
     * Return an object that represents the Accelerator's Security Group.
     *
     * Uses a Custom Resource to look up the Security Group that Accelerator
     * creates at deploy time. Requires your VPC ID to perform the lookup.
     *
     * The Security Group will only be created if you enable **Client IP
     * Preservation** on any of the endpoints.
     *
     * You cannot manipulate the rules inside this security group, but you can
     * use this security group as a Peer in Connections rules on other
     * constructs.
     *
     * @stability stable
     */
    connectionsPeer(id, vpc) {
        return _accelerator_security_group_1.AcceleratorSecurityGroupPeer.fromVpc(this, id, vpc, this);
    }
    renderEndpoints() {
        return this.endpoints.map(e => e.renderEndpointConfiguration());
    }
    /**
     * Return the first (readable) region of the endpoints in this group
     */
    firstEndpointRegion() {
        for (const endpoint of this.endpoints) {
            if (endpoint.region) {
                return endpoint.region;
            }
        }
        return cdk.Stack.of(this).region;
    }
}
exports.EndpointGroup = EndpointGroup;
_a = JSII_RTTI_SYMBOL_1;
EndpointGroup[_a] = { fqn: "@aws-cdk/aws-globalaccelerator.EndpointGroup", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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