# -*- coding: utf-8 -*-
# Generated by Django 1.11.5 on 2017-10-05 20:28
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [("core", "0003_field_docs")]

    operations = [
        migrations.AlterField(
            model_name="division",
            name="redirect",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="core.Division",
            ),
        ),
        migrations.AlterField(
            model_name="jurisdiction",
            name="division",
            field=models.ForeignKey(
                help_text="A link to a Division related to this Jurisdiction.",
                on_delete=django.db.models.deletion.PROTECT,
                related_name="jurisdictions",
                to="core.Division",
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="on_behalf_of",
            field=models.ForeignKey(
                help_text="The Organization on whose behalf the Person is a member of the Organization.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="memberships_on_behalf_of",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="person",
            field=models.ForeignKey(
                help_text="A link to the Person that is a member of the Organization.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="memberships",
                to="core.Person",
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="post",
            field=models.ForeignKey(
                help_text="\tThe Post held by the member in the Organization.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="memberships",
                to="core.Post",
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="jurisdiction",
            field=models.ForeignKey(
                help_text="A link to the Jurisdiction that contains this Organization.",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="organizations",
                to="core.Jurisdiction",
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="parent",
            field=models.ForeignKey(
                help_text="A link to another Organization that serves as this Organization's parent.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="children",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="division",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="The Division where the post exists.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="posts",
                to="core.Division",
            ),
        ),
    ]
