import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
export interface DataBrewCodePipelineProps {
    /**
       * The ARN of the IAM role in the pre-production account.
       */
    readonly preproductionIamRoleArn: string;
    /**
       * The ARN of the IAM role in the production account.
       */
    readonly productionIamRoleArn: string;
    /**
       * The name of the S3 bucket for the CodePipeline DataBrew CICD pipeline.
       *
       * @default 'databrew-cicd-codepipelineartifactstorebucket'
       */
    readonly bucketName?: string;
    /**
       * The name of the CodeCommit repositroy for the DataBrew CICD pipeline.
       *
       * @default 'DataBrew-Recipes-Repo'
       */
    readonly repoName?: string;
    /**
       * The name of the branch that will trigger the DataBrew CICD pipeline.
       *
       * @default 'main'
       */
    readonly branchName?: string;
    /**
       * The name of the CodePipeline Databrew CICD pipeline.
       *
       * @default 'DataBrew-Recipe-Application'
       */
    readonly pipelineName?: string;
    /**
       * the (required) name of the Artifact at the first stage.
       *
       * @default 'SourceOutput'
       */
    readonly firstStageArtifactName?: string;
}
export declare class DataBrewCodePipeline extends Construct {
    /**
       * The ARN of the S3 bucket for the CodePipeline DataBrew CICD pipeline.
       */
    readonly bucketArn: string;
    /**
       * The name of the CodeCommit repositroy for the DataBrew CICD pipeline.
       */
    readonly repoName: string;
    /**
       * The name of the branch that will trigger the DataBrew CICD pipeline.
       */
    readonly branchName: string;
    /**
       * the (required) name of the Artifact at the first stage.
       */
    readonly firstStageArtifactName: string;
    /**
       * The ARN of the Lambda function for the pre-production account.
       */
    readonly preproductionFunctionArn: string;
    /**
       * The ARN of the Lambda function for the production account.
       */
    readonly productionFunctionArn: string;
    /**
       * The ARN of the CodeCommit repository
       */
    readonly codeCommitRepoArn: string;
    /**
       * The ARN of the DataBrew CICD pipeline.
       */
    readonly codePipelineArn: string;
    constructor(scope: Construct, name: string, props: DataBrewCodePipelineProps);
    /**
         * Creates a source action.
         *
         * @param codeCommitRepo the CodeCommit repository used in the DataBrew CICD pipeline.
         * @param role the IAM role used by the CodePipeline pipeline.
         * @returns the CodeCOmmit source action.
         */
    private createSourceAction;
}
export interface InfraIamRoleProps {
    /**
       * The role name for the infrastructure account.
       *
       * @default 'CrossAccountRepositoryContributorRole'
       */
    readonly roleName?: string;
}
export declare class InfraIamRole extends Construct {
    /**
       * The ARN of the IAM role for the infrastructure account.
       */
    readonly roleArn: string;
    constructor(scope: Construct, name: string, props: InfraIamRoleProps);
}
export interface CodePipelineIamRoleProps {
    /**
       * The ARN of the S3 bucket where you store your artifacts.
       */
    readonly bucketArn: string;
    /**
       * The ARN of the Lambda function for the pre-production account.
       */
    readonly preproductionLambdaArn: string;
    /**
       * The ARN of the Lambda function for the production account.
       */
    readonly productionLambdaArn: string;
    /**
       * The role name for the CodePipeline CICD pipeline.
       *
       * @default 'DataBrew-Recipe-Pipeline-Role'
       */
    readonly roleName?: string;
}
export declare class CodePipelineIamRole extends Construct {
    /**
       * The ARN of the IAM role for the CodePipeline CICD pipeline.
       */
    readonly roleArn: string;
    /**
       * The representative of the IAM role for the CodePipeline CICD pipeline.
       */
    readonly role: iam.Role;
    constructor(scope: Construct, name: string, props: CodePipelineIamRoleProps);
}
