import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export interface PreProductionLambdaProps {
    /**
       * The ARN of the S3 bucket for the DataBrew CICD pipeline.
       */
    readonly bucketArn: string;
    /**
     * The ARN of the IAM role in the pre-production account.
     */
    readonly preproductionIamRoleArn: string;
    /**
     * The name of the IAM role for the pre-produciton Lambda function.
     *
     * @default 'PreProd-DataBrew-Recipe-Deployer-role'
     * */
    readonly roleName?: string;
    /**
     * The Lambda funciton name for the pre-production account
     *
     * @default 'PreProd-DataBrew-Recipe-Deployer'
     * */
    readonly functionName?: string;
}
export declare class PreProductionLambda extends Construct {
    /**
       * The name of the IAM role for the pre-produciton Lambda function.
       */
    readonly roleName: string;
    /**
       * The Lambda funciton name for the pre-production account.
       */
    readonly functionName: string;
    /**
       * The representative of Lambda function for the pre-production account.
       */
    readonly function: lambda.IFunction;
    constructor(scope: Construct, name: string, props: PreProductionLambdaProps);
}
export interface ProductionLambdaProps {
    /**
     * The ARN of the S3 bucket for the DataBrew CICD pipeline.
     */
    readonly bucketArn: string;
    /**
     * The ARN of the IAM role in the production account.
     * */
    readonly productionIamRoleArn: string;
    /**
     * The name of the IAM role for the produciton Lambda function.
     *
     * @default 'Prod-DataBrew-Recipe-Deployer-role'
     * */
    readonly roleName?: string;
    /**
     * The Lambda funciton name for the production account.
     *
     * @default 'Prod-DataBrew-Recipe-Deployer'
     * */
    readonly functionName?: string;
}
export declare class ProductionLambda extends Construct {
    /**
       * The name of the IAM role for the produciton Lambda function.
       */
    readonly roleName: string;
    /**
       * The Lambda funciton name for the production account.
       */
    readonly functionName: string;
    /**
       * The representative of Lambda function for the production account.
       */
    readonly function: lambda.IFunction;
    constructor(scope: Construct, name: string, props: ProductionLambdaProps);
}
export interface FirstCommitHandlerProps {
    /**
     * The ARN of the CodeCommit repository.
     */
    readonly codeCommitRepoArn: string;
    /**
     * The name of the CodeCommit repo.
     */
    readonly repoName: string;
    /**
     * The branch name used in the CodeCommit repo.
     */
    readonly branchName: string;
    /**
     * The name of the IAM role for the Lambda function which deals with first commit via AWS CodeCommit.
     *
     * @default 'LambdaForInitialCommitRole'
     * */
    readonly roleName?: string;
    /**
     * The name of the Lambda function which deals with first commit via AWS CodeCommit.
     * @default 'FirstCommitHandler'
     * */
    readonly functionName?: string;
}
export declare class FirstCommitHandler extends Construct {
    /**
     * The name of the IAM role for the Lambda function which deals with first commit via AWS CodeCommit.
     */
    readonly roleName: string;
    /**
     * The name of the Lambda function which deals with first commit via AWS CodeCommit.
     */
    readonly functionName: string;
    /**
     * The representative of Lambda function which deals with first commit via AWS CodeCommit.
     */
    readonly function: lambda.IFunction;
    constructor(scope: Construct, name: string, props: FirstCommitHandlerProps);
}
