import { Construct } from 'constructs';
export interface IamRoleProps {
    /**
       * 'preproduction' or 'production'
       */
    readonly environment: string;
    /**
       * The ID of your infrastructure account
       */
    readonly accountID: string;
    /**
       * The role name.
       *
       * @default '{environment}-Databrew-Cicd-Role'
       */
    readonly roleName?: string;
}
/**
 * IAM Role.
 *
 * Defines an IAM role for pre-production and production AWS accounts.
 */
export declare class IamRole extends Construct {
    /**
       * The ARN of the IAM role for pre-production or production.
       */
    readonly roleArn: string;
    constructor(scope: Construct, name: string, props: IamRoleProps);
}
