"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IamRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
/**
 * IAM Role.
 *
 * Defines an IAM role for pre-production and production AWS accounts.
 */
class IamRole extends constructs_1.Construct {
    constructor(scope, name, props) {
        super(scope, name);
        if (props.environment !== 'preproduction' && props.environment !== 'production') {
            throw new Error('The value of `environment` should be either \'production\' or \'preproduction\'');
        }
        const role = new iam.Role(this, `${props.environment}IamRole`, {
            assumedBy: new iam.AccountPrincipal(props.accountID),
            roleName: props.roleName ?? `${props.environment}-Databrew-Cicd-Role`,
            description: `The IAM role for DataBrew CICD in the ${props.environment} account.`,
        });
        role.addToPolicy(new iam.PolicyStatement({
            sid: 'DataBrewPermissions',
            effect: iam.Effect.ALLOW,
            actions: [
                'databrew:ListRecipes',
                'databrew:CreateRecipe',
                'databrew:PublishRecipe',
                'databrew:UpdateRecipe',
            ],
            resources: ['*'],
        }));
        this.roleArn = role.roleArn;
    }
}
exports.IamRole = IamRole;
_a = JSII_RTTI_SYMBOL_1;
IamRole[_a] = { fqn: "cdk-databrew-cicd.IamRole", version: "2.0.44" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2RrLWlhbS1yb2xlcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9jZGstaWFtLXJvbGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsMkNBQTJDO0FBQzNDLDJDQUF1QztBQWtCdkM7Ozs7R0FJRztBQUNILE1BQWEsT0FBUSxTQUFRLHNCQUFTO0lBS3BDLFlBQVksS0FBZ0IsRUFBRSxJQUFZLEVBQUUsS0FBbUI7UUFDN0QsS0FBSyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztRQUVuQixJQUFJLEtBQUssQ0FBQyxXQUFXLEtBQUssZUFBZSxJQUFJLEtBQUssQ0FBQyxXQUFXLEtBQUssWUFBWSxFQUFFO1lBQy9FLE1BQU0sSUFBSSxLQUFLLENBQUMsaUZBQWlGLENBQUMsQ0FBQztTQUNwRztRQUVELE1BQU0sSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsR0FBRyxLQUFLLENBQUMsV0FBVyxTQUFTLEVBQUU7WUFDN0QsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUM7WUFDcEQsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRLElBQUksR0FBRyxLQUFLLENBQUMsV0FBVyxxQkFBcUI7WUFDckUsV0FBVyxFQUFFLHlDQUF5QyxLQUFLLENBQUMsV0FBVyxXQUFXO1NBQ25GLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1lBQ3ZDLEdBQUcsRUFBRSxxQkFBcUI7WUFDMUIsTUFBTSxFQUFFLEdBQUcsQ0FBQyxNQUFNLENBQUMsS0FBSztZQUN4QixPQUFPLEVBQUU7Z0JBQ1Asc0JBQXNCO2dCQUN0Qix1QkFBdUI7Z0JBQ3ZCLHdCQUF3QjtnQkFDeEIsdUJBQXVCO2FBQ3hCO1lBQ0QsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDO1NBQ2pCLENBQUMsQ0FBQyxDQUFDO1FBQ0osSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQzlCLENBQUM7O0FBN0JILDBCQThCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIElhbVJvbGVQcm9wcyB7XG4gIC8qKlxuICAgICAqICdwcmVwcm9kdWN0aW9uJyBvciAncHJvZHVjdGlvbidcbiAgICAgKi9cbiAgcmVhZG9ubHkgZW52aXJvbm1lbnQ6IHN0cmluZztcbiAgLyoqXG4gICAgICogVGhlIElEIG9mIHlvdXIgaW5mcmFzdHJ1Y3R1cmUgYWNjb3VudFxuICAgICAqL1xuICByZWFkb25seSBhY2NvdW50SUQ6IHN0cmluZztcbiAgLyoqXG4gICAgICogVGhlIHJvbGUgbmFtZS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0ICd7ZW52aXJvbm1lbnR9LURhdGFicmV3LUNpY2QtUm9sZSdcbiAgICAgKi9cbiAgcmVhZG9ubHkgcm9sZU5hbWU/OiBzdHJpbmc7XG59XG4vKipcbiAqIElBTSBSb2xlLlxuICpcbiAqIERlZmluZXMgYW4gSUFNIHJvbGUgZm9yIHByZS1wcm9kdWN0aW9uIGFuZCBwcm9kdWN0aW9uIEFXUyBhY2NvdW50cy5cbiAqL1xuZXhwb3J0IGNsYXNzIElhbVJvbGUgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICAvKipcbiAgICAgKiBUaGUgQVJOIG9mIHRoZSBJQU0gcm9sZSBmb3IgcHJlLXByb2R1Y3Rpb24gb3IgcHJvZHVjdGlvbi5cbiAgICAgKi9cbiAgcmVhZG9ubHkgcm9sZUFybjogc3RyaW5nO1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBuYW1lOiBzdHJpbmcsIHByb3BzOiBJYW1Sb2xlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgbmFtZSk7XG5cbiAgICBpZiAocHJvcHMuZW52aXJvbm1lbnQgIT09ICdwcmVwcm9kdWN0aW9uJyAmJiBwcm9wcy5lbnZpcm9ubWVudCAhPT0gJ3Byb2R1Y3Rpb24nKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1RoZSB2YWx1ZSBvZiBgZW52aXJvbm1lbnRgIHNob3VsZCBiZSBlaXRoZXIgXFwncHJvZHVjdGlvblxcJyBvciBcXCdwcmVwcm9kdWN0aW9uXFwnJyk7XG4gICAgfVxuXG4gICAgY29uc3Qgcm9sZSA9IG5ldyBpYW0uUm9sZSh0aGlzLCBgJHtwcm9wcy5lbnZpcm9ubWVudH1JYW1Sb2xlYCwge1xuICAgICAgYXNzdW1lZEJ5OiBuZXcgaWFtLkFjY291bnRQcmluY2lwYWwocHJvcHMuYWNjb3VudElEKSxcbiAgICAgIHJvbGVOYW1lOiBwcm9wcy5yb2xlTmFtZSA/PyBgJHtwcm9wcy5lbnZpcm9ubWVudH0tRGF0YWJyZXctQ2ljZC1Sb2xlYCxcbiAgICAgIGRlc2NyaXB0aW9uOiBgVGhlIElBTSByb2xlIGZvciBEYXRhQnJldyBDSUNEIGluIHRoZSAke3Byb3BzLmVudmlyb25tZW50fSBhY2NvdW50LmAsXG4gICAgfSk7XG4gICAgcm9sZS5hZGRUb1BvbGljeShuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICBzaWQ6ICdEYXRhQnJld1Blcm1pc3Npb25zJyxcbiAgICAgIGVmZmVjdDogaWFtLkVmZmVjdC5BTExPVyxcbiAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgJ2RhdGFicmV3Okxpc3RSZWNpcGVzJyxcbiAgICAgICAgJ2RhdGFicmV3OkNyZWF0ZVJlY2lwZScsXG4gICAgICAgICdkYXRhYnJldzpQdWJsaXNoUmVjaXBlJyxcbiAgICAgICAgJ2RhdGFicmV3OlVwZGF0ZVJlY2lwZScsXG4gICAgICBdLFxuICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICB9KSk7XG4gICAgdGhpcy5yb2xlQXJuID0gcm9sZS5yb2xlQXJuO1xuICB9XG59Il19