#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const cdk_databrew_cicd_1 = require("../../cdk-databrew-cicd");
class TypescriptStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const preproductionAccountId = 'PREPRODUCTION_ACCOUNT_ID';
        const productionAccountId = 'PRODUCTION_ACCOUNT_ID';
        const dataBrewPipeline = new cdk_databrew_cicd_1.DataBrewCodePipeline(this, 'DataBrewCicdPipeline', {
            preproductionIamRoleArn: `arn:${cdk.Aws.PARTITION}:iam::${preproductionAccountId}:role/preproduction-Databrew-Cicd-Role`,
            productionIamRoleArn: `arn:${cdk.Aws.PARTITION}:iam::${productionAccountId}:role/production-Databrew-Cicd-Role`,
        });
        new cdk.CfnOutput(this, 'OPreproductionLambdaArn', { value: dataBrewPipeline.preproductionFunctionArn });
        new cdk.CfnOutput(this, 'OProductionLambdaArn', { value: dataBrewPipeline.productionFunctionArn });
        new cdk.CfnOutput(this, 'OCodeCommitRepoArn', { value: dataBrewPipeline.codeCommitRepoArn });
        new cdk.CfnOutput(this, 'OCodePipelineArn', { value: dataBrewPipeline.codePipelineArn });
    }
}
const app = new cdk.App();
new TypescriptStack(app, 'TypescriptStack', {
    stackName: 'DataBrew-CICD',
});
//# sourceMappingURL=data:application/json;base64,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