# Generated by Django 2.2.4 on 2020-06-25 17:17

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import internationalflavor.countries.models
import internationalflavor.vat_number.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Cart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('delivery_name', models.CharField(db_index=True, max_length=30, verbose_name='full name or company name')),
                ('delivery_street', models.CharField(max_length=200, verbose_name='street and number')),
                ('delivery_postcode', models.CharField(max_length=30, verbose_name='postcode')),
                ('delivery_city', models.CharField(max_length=50, verbose_name='city')),
                ('delivery_country', internationalflavor.countries.models.CountryField(db_index=True, verbose_name='country')),
                ('billing_name', models.CharField(max_length=100, verbose_name='full name or company name')),
                ('billing_street', models.CharField(max_length=200, verbose_name='street')),
                ('billing_postcode', models.CharField(max_length=30, verbose_name='postcode')),
                ('billing_city', models.CharField(max_length=50, verbose_name='city')),
                ('billing_country', internationalflavor.countries.models.CountryField(db_index=True, verbose_name='country')),
                ('reg_id', models.CharField(blank=True, max_length=30, verbose_name='Company Registration No.')),
                ('tax_id', models.CharField(blank=True, max_length=30, verbose_name='TAX ID')),
                ('vat_id', internationalflavor.vat_number.models.VATNumberField(blank=True, verbose_name='VAT ID')),
                ('email', models.EmailField(max_length=254, verbose_name='email')),
                ('phone', models.CharField(max_length=30, verbose_name='phone')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'shopping cart',
                'verbose_name_plural': 'shopping carts',
            },
        ),
        migrations.CreateModel(
            name='Item',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('quantity', models.PositiveSmallIntegerField(verbose_name='quantity')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('cart', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='commerce.Cart')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name': 'item',
                'verbose_name_plural': 'items',
            },
        ),
    ]
