# Generated by Django 2.2.4 on 2020-06-25 18:48

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import internationalflavor.countries.models
import internationalflavor.vat_number.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('commerce', '0006_cart_shipping'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='shipping',
            options={'ordering': ('fee',), 'verbose_name': 'shipping option', 'verbose_name_plural': 'shipping options'},
        ),
        migrations.RenameField(
            model_name='cart',
            old_name='shipping',
            new_name='shipping_option',
        ),
        migrations.AlterField(
            model_name='shipping',
            name='fee',
            field=models.DecimalField(db_index=True, decimal_places=2, default=0, help_text='EUR', max_digits=10, validators=[django.core.validators.MinValueValidator(0)], verbose_name='fee'),
            preserve_default=False,
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=50, verbose_name='title')),
                ('method', models.CharField(choices=[('CASH_ON_DELIVERY', 'cash on delivery'), ('WIRE_TRANSFER', 'wire transfer'), ('ONLINE_PAYMENT', 'online payment'), ('PAYPAL', 'PayPal')], max_length=16, verbose_name='method')),
                ('fee', models.DecimalField(db_index=True, decimal_places=2, help_text='EUR', max_digits=10, validators=[django.core.validators.MinValueValidator(0)], verbose_name='fee')),
                ('shippings', models.ManyToManyField(to='commerce.Shipping')),
            ],
            options={
                'verbose_name': 'payment method',
                'verbose_name_plural': 'payment methods',
                'ordering': ('fee',),
            },
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('AWAITING_PAYMENT', 'Awaiting Payment'), ('AWAITING_FULFILLMENT', 'Awaiting Fulfillment'), ('AWAITING_SHIPMENT', 'Awaiting Shipment'), ('AWAITING_PICKUP', 'Awaiting Pickup'), ('PARTIALLY_SHIPPED', 'Partially Shipped'), ('SHIPPED', 'Shipped'), ('COMPLETED', 'Completed'), ('CANCELLED', 'Cancelled'), ('DECLINED', 'Declined'), ('REFUNDED', 'Refunded'), ('PARTIALLY_REFUNDED', 'Partially Refunded'), ('DISPUTED', 'Disputed'), ('ON_HOLD', 'On hold')], max_length=20, verbose_name='status')),
                ('number', models.PositiveSmallIntegerField(db_index=True, verbose_name='number')),
                ('delivery_name', models.CharField(db_index=True, max_length=30, verbose_name='full name or company name')),
                ('delivery_street', models.CharField(max_length=200, verbose_name='street and number')),
                ('delivery_postcode', models.CharField(max_length=30, verbose_name='postcode')),
                ('delivery_city', models.CharField(max_length=50, verbose_name='city')),
                ('delivery_country', internationalflavor.countries.models.CountryField(db_index=True, verbose_name='country')),
                ('billing_name', models.CharField(max_length=100, verbose_name='full name or company name')),
                ('billing_street', models.CharField(max_length=200, verbose_name='street')),
                ('billing_postcode', models.CharField(max_length=30, verbose_name='postcode')),
                ('billing_city', models.CharField(max_length=50, verbose_name='city')),
                ('billing_country', internationalflavor.countries.models.CountryField(db_index=True, verbose_name='country')),
                ('reg_id', models.CharField(blank=True, max_length=30, verbose_name='Company Registration No.')),
                ('tax_id', models.CharField(blank=True, max_length=30, verbose_name='TAX ID')),
                ('vat_id', internationalflavor.vat_number.models.VATNumberField(blank=True, verbose_name='VAT ID')),
                ('email', models.EmailField(max_length=254, verbose_name='email')),
                ('phone', models.CharField(max_length=30, verbose_name='phone')),
                ('shipping_fee', models.DecimalField(db_index=True, decimal_places=2, help_text='EUR', max_digits=10, validators=[django.core.validators.MinValueValidator(0)], verbose_name='shipping fee')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('payment_method', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='commerce.Payment')),
                ('shipping_option', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='commerce.Shipping')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'order',
                'verbose_name_plural': 'orders',
                'ordering': ('created',),
            },
        ),
        migrations.AddField(
            model_name='cart',
            name='payment_method',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='commerce.Payment'),
        ),
    ]
