# Generated by Django 2.2.4 on 2020-07-05 15:30

import django.contrib.postgres.indexes
import django.core.validators
from django.db import migrations, models
import modeltrans.fields


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('commerce', '0018_auto_20200702_2144'),
    ]

    operations = [
        migrations.CreateModel(
            name='Discount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=10, verbose_name='code')),
                ('amount', models.PositiveSmallIntegerField(help_text='%', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)], verbose_name='amount')),
                ('description', models.CharField(max_length=100, verbose_name='description')),
                ('valid_until', models.DateTimeField(db_index=True, verbose_name='valid until')),
                ('promoted', models.BooleanField(default=False, help_text='show in topbar', verbose_name='promoted')),
                ('add_to_cart', models.BooleanField(default=False, help_text='automatically', verbose_name='add to cart')),
                ('i18n', modeltrans.fields.TranslationField(fields=('description',), required_languages=(), virtual_fields=True)),
                ('content_types', models.ManyToManyField(to='contenttypes.ContentType', verbose_name='content types')),
            ],
            options={
                'verbose_name': 'discount',
                'verbose_name_plural': 'discounts',
                'ordering': ('-amount',),
            },
        ),
        migrations.AddIndex(
            model_name='discount',
            index=django.contrib.postgres.indexes.GinIndex(fields=['i18n'], name='commerce_di_i18n_2608c3_gin'),
        ),
    ]
