# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository   # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class WaitForConditions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'count': 'int',
        'count_type': 'str',
        'inbox_id': 'str',
        'matches': 'list[MatchOption]',
        'sort_direction': 'str',
        'timeout': 'int',
        'unread_only': 'bool'
    }

    attribute_map = {
        'count': 'count',
        'count_type': 'countType',
        'inbox_id': 'inboxId',
        'matches': 'matches',
        'sort_direction': 'sortDirection',
        'timeout': 'timeout',
        'unread_only': 'unreadOnly'
    }

    def __init__(self, count=None, count_type=None, inbox_id=None, matches=None, sort_direction=None, timeout=None, unread_only=None, local_vars_configuration=None):  # noqa: E501
        """WaitForConditions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._count = None
        self._count_type = None
        self._inbox_id = None
        self._matches = None
        self._sort_direction = None
        self._timeout = None
        self._unread_only = None
        self.discriminator = None

        if count is not None:
            self.count = count
        if count_type is not None:
            self.count_type = count_type
        if inbox_id is not None:
            self.inbox_id = inbox_id
        if matches is not None:
            self.matches = matches
        if sort_direction is not None:
            self.sort_direction = sort_direction
        if timeout is not None:
            self.timeout = timeout
        if unread_only is not None:
            self.unread_only = unread_only

    @property
    def count(self):
        """Gets the count of this WaitForConditions.  # noqa: E501

        Number of results that should match conditions. Either exactly or at least this amount based on the `countType`. If count condition is not met and the timeout has not been reached the `waitFor` method will retry the operation.  # noqa: E501

        :return: The count of this WaitForConditions.  # noqa: E501
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """Sets the count of this WaitForConditions.

        Number of results that should match conditions. Either exactly or at least this amount based on the `countType`. If count condition is not met and the timeout has not been reached the `waitFor` method will retry the operation.  # noqa: E501

        :param count: The count of this WaitForConditions.  # noqa: E501
        :type: int
        """

        self._count = count

    @property
    def count_type(self):
        """Gets the count_type of this WaitForConditions.  # noqa: E501

        How should the found count be compared to the expected count.  # noqa: E501

        :return: The count_type of this WaitForConditions.  # noqa: E501
        :rtype: str
        """
        return self._count_type

    @count_type.setter
    def count_type(self, count_type):
        """Sets the count_type of this WaitForConditions.

        How should the found count be compared to the expected count.  # noqa: E501

        :param count_type: The count_type of this WaitForConditions.  # noqa: E501
        :type: str
        """
        allowed_values = ["EXACTLY", "ATLEAST"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and count_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `count_type` ({0}), must be one of {1}"  # noqa: E501
                .format(count_type, allowed_values)
            )

        self._count_type = count_type

    @property
    def inbox_id(self):
        """Gets the inbox_id of this WaitForConditions.  # noqa: E501

        ID of inbox to search within and apply conditions to. Essentially filtering the emails found to give a count.  # noqa: E501

        :return: The inbox_id of this WaitForConditions.  # noqa: E501
        :rtype: str
        """
        return self._inbox_id

    @inbox_id.setter
    def inbox_id(self, inbox_id):
        """Sets the inbox_id of this WaitForConditions.

        ID of inbox to search within and apply conditions to. Essentially filtering the emails found to give a count.  # noqa: E501

        :param inbox_id: The inbox_id of this WaitForConditions.  # noqa: E501
        :type: str
        """

        self._inbox_id = inbox_id

    @property
    def matches(self):
        """Gets the matches of this WaitForConditions.  # noqa: E501

        Conditions that should be matched for an email to qualify for results. Each condition will be applied in order to each email within an inbox to filter a result list of matching emails you are waiting for.  # noqa: E501

        :return: The matches of this WaitForConditions.  # noqa: E501
        :rtype: list[MatchOption]
        """
        return self._matches

    @matches.setter
    def matches(self, matches):
        """Sets the matches of this WaitForConditions.

        Conditions that should be matched for an email to qualify for results. Each condition will be applied in order to each email within an inbox to filter a result list of matching emails you are waiting for.  # noqa: E501

        :param matches: The matches of this WaitForConditions.  # noqa: E501
        :type: list[MatchOption]
        """

        self._matches = matches

    @property
    def sort_direction(self):
        """Gets the sort_direction of this WaitForConditions.  # noqa: E501

        Direction to sort matching emails by created time  # noqa: E501

        :return: The sort_direction of this WaitForConditions.  # noqa: E501
        :rtype: str
        """
        return self._sort_direction

    @sort_direction.setter
    def sort_direction(self, sort_direction):
        """Sets the sort_direction of this WaitForConditions.

        Direction to sort matching emails by created time  # noqa: E501

        :param sort_direction: The sort_direction of this WaitForConditions.  # noqa: E501
        :type: str
        """
        allowed_values = ["ASC", "DESC"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and sort_direction not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `sort_direction` ({0}), must be one of {1}"  # noqa: E501
                .format(sort_direction, allowed_values)
            )

        self._sort_direction = sort_direction

    @property
    def timeout(self):
        """Gets the timeout of this WaitForConditions.  # noqa: E501

        Max time in milliseconds to retry the `waitFor` operation until conditions are met.  # noqa: E501

        :return: The timeout of this WaitForConditions.  # noqa: E501
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this WaitForConditions.

        Max time in milliseconds to retry the `waitFor` operation until conditions are met.  # noqa: E501

        :param timeout: The timeout of this WaitForConditions.  # noqa: E501
        :type: int
        """

        self._timeout = timeout

    @property
    def unread_only(self):
        """Gets the unread_only of this WaitForConditions.  # noqa: E501

        Apply conditions only to **unread** emails. All emails begin with `read=false`. An email is marked `read=true` when an `EmailDto` representation of it has been returned to the user at least once. For example you have called `getEmail` or `waitForLatestEmail` etc., or you have viewed the email in the dashboard.   # noqa: E501

        :return: The unread_only of this WaitForConditions.  # noqa: E501
        :rtype: bool
        """
        return self._unread_only

    @unread_only.setter
    def unread_only(self, unread_only):
        """Sets the unread_only of this WaitForConditions.

        Apply conditions only to **unread** emails. All emails begin with `read=false`. An email is marked `read=true` when an `EmailDto` representation of it has been returned to the user at least once. For example you have called `getEmail` or `waitForLatestEmail` etc., or you have viewed the email in the dashboard.   # noqa: E501

        :param unread_only: The unread_only of this WaitForConditions.  # noqa: E501
        :type: bool
        """

        self._unread_only = unread_only

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WaitForConditions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WaitForConditions):
            return True

        return self.to_dict() != other.to_dict()
