import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PublicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Sets the tables list to publish to ALL tables
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/publication#all_tables Publication#all_tables}
    */
    readonly allTables?: boolean | cdktf.IResolvable;
    /**
    * Sets the database to add the publication for
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/publication#database Publication#database}
    */
    readonly database?: string;
    /**
    * When true, will also drop all the objects that depend on the publication, and in turn all objects that depend on those objects
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/publication#drop_cascade Publication#drop_cascade}
    */
    readonly dropCascade?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/publication#name Publication#name}
    */
    readonly name: string;
    /**
    * Sets the owner of the publication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/publication#owner Publication#owner}
    */
    readonly owner?: string;
    /**
    * Sets which DML operations will be published
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/publication#publish_param Publication#publish_param}
    */
    readonly publishParam?: string[];
    /**
    * Sets whether changes in a partitioned table using the identity and schema of the partitioned table
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/publication#publish_via_partition_root_param Publication#publish_via_partition_root_param}
    */
    readonly publishViaPartitionRootParam?: boolean | cdktf.IResolvable;
    /**
    * Sets the tables list to publish
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/publication#tables Publication#tables}
    */
    readonly tables?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/publication postgresql_publication}
*/
export declare class Publication extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_publication";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/publication postgresql_publication} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PublicationConfig
    */
    constructor(scope: Construct, id: string, config: PublicationConfig);
    private _allTables?;
    get allTables(): boolean | cdktf.IResolvable;
    set allTables(value: boolean | cdktf.IResolvable);
    resetAllTables(): void;
    get allTablesInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _dropCascade?;
    get dropCascade(): boolean | cdktf.IResolvable;
    set dropCascade(value: boolean | cdktf.IResolvable);
    resetDropCascade(): void;
    get dropCascadeInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _publishParam?;
    get publishParam(): string[];
    set publishParam(value: string[]);
    resetPublishParam(): void;
    get publishParamInput(): string[] | undefined;
    private _publishViaPartitionRootParam?;
    get publishViaPartitionRootParam(): boolean | cdktf.IResolvable;
    set publishViaPartitionRootParam(value: boolean | cdktf.IResolvable);
    resetPublishViaPartitionRootParam(): void;
    get publishViaPartitionRootParamInput(): boolean | cdktf.IResolvable | undefined;
    private _tables?;
    get tables(): string[];
    set tables(value: string[]);
    resetTables(): void;
    get tablesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
