/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyramidTiffReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PyramidTiffReader.class);

    public PyramidTiffReader() {
        super("Pyramid TIFF", new String[]{"tif", "tiff"});
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
        this.equalStrips = true;
        this.noSubresolutions = true;
        this.canSeparateSeries = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        parser.setAssumeEqualStrips(this.equalStrips);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        if (software == null) {
            return false;
        }
        return software.indexOf("Faas") >= 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int index = this.getCoreIndex();
        this.tiffParser.setAssumeEqualStrips(this.equalStrips);
        this.tiffParser.getSamples((IFD)this.ifds.get(index), buf, x, y, w, h2);
        return buf;
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.getCoreIndex())).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.getCoreIndex())).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        int seriesCount = this.ifds.size();
        this.core.clear();
        this.core.add();
        for (int s2 = 0; s2 < seriesCount; ++s2) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(0, ms);
            if (s2 == 0) {
                ms.resolutionCount = seriesCount;
            }
            IFD ifd = (IFD)this.ifds.get(s2);
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            ms.rgb = samples > 1 || p == PhotoInterp.RGB;
            long numTileRows = ifd.getTilesPerColumn() - 1L;
            long numTileCols = ifd.getTilesPerRow() - 1L;
            ms.sizeX = (int)ifd.getImageWidth();
            ms.sizeY = (int)ifd.getImageLength();
            ms.sizeZ = 1;
            ms.sizeT = 1;
            ms.sizeC = ms.rgb ? samples : 1;
            ms.littleEndian = ifd.isLittleEndian();
            ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            ms.imageCount = 1;
            ms.pixelType = ifd.getPixelType();
            ms.metadataComplete = true;
            ms.interleaved = false;
            ms.falseColor = false;
            ms.dimensionOrder = "XYCZT";
            ms.thumbnail = s2 > 0;
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
        }
    }
}

