import java.io
import java.lang
import java.util
import java.util.regex
import jpype.protocol
import bioformats_jar._loci
import bioformats_jar._loci.common
import bioformats_jar._loci.common.xml
import bioformats_jar._loci.formats
import bioformats_jar._loci.formats.meta
import bioformats_jar._loci.formats.ome
import bioformats_jar._loci.formats.services
import bioformats_jar._loci.formats.tiff
import ome.units.quantity
import org.w3c.dom
import org.xml.sax
import org.xml.sax.helpers
import typing



class AFIReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...

class AIMReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class APLReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class APNGReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ARFReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class AVIReader(loci.formats.FormatReader):
    AVI_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class AliconaReader(loci.formats.FormatReader):
    AL3D_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class AmiraReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class AnalyzeReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class BDReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class BDVReader(loci.formats.FormatReader):
    HDF_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    BDV_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class BIFormatReader(loci.formats.FormatReader):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class BMPReader(loci.formats.FormatReader):
    BMP_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class BaseTiffReader(loci.formats.in_.MinimalTiffReader):
    DATE_FORMATS: typing.ClassVar[typing.List[java.lang.String]] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    @staticmethod
    def getExifTagName(int: int) -> java.lang.String: ...

class BaseZeissReader(loci.formats.FormatReader):
    layers: java.util.ArrayList = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    class Context(java.lang.Enum['BaseZeissReader.Context']):
        MAIN: typing.ClassVar['BaseZeissReader.Context'] = ...
        SCALING: typing.ClassVar['BaseZeissReader.Context'] = ...
        PLANE: typing.ClassVar['BaseZeissReader.Context'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: typing.Union[java.lang.String, str]) -> 'BaseZeissReader.Context': ...
        @staticmethod
        def values() -> typing.List['BaseZeissReader.Context']: ...
    class Tag:
        @typing.overload
        def __init__(self, baseZeissReader: 'BaseZeissReader', int: int, string: typing.Union[java.lang.String, str], context: 'BaseZeissReader.Context'): ...
        @typing.overload
        def __init__(self, baseZeissReader: 'BaseZeissReader', int: int, context: 'BaseZeissReader.Context'): ...
        def getCategory(self) -> int: ...
        def getIndex(self) -> int: ...
        def getKey(self) -> java.lang.String: ...
        def getKeyID(self) -> int: ...
        def getValue(self) -> java.lang.String: ...
        def setCategory(self, int: int) -> None: ...
        def setIndex(self, int: int) -> None: ...
        def setKey(self, int: int) -> None: ...
        def setValue(self, string: typing.Union[java.lang.String, str]) -> None: ...
        def toString(self) -> java.lang.String: ...
        def valid(self) -> bool: ...

class BioRadGelReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class BioRadReader(loci.formats.FormatReader):
    NOTE_NAMES: typing.ClassVar[typing.List[java.lang.String]] = ...
    NOTE_TYPE_LIVE: typing.ClassVar[int] = ...
    NOTE_TYPE_FILE1: typing.ClassVar[int] = ...
    NOTE_TYPE_NUMBER: typing.ClassVar[int] = ...
    NOTE_TYPE_USER: typing.ClassVar[int] = ...
    NOTE_TYPE_LINE: typing.ClassVar[int] = ...
    NOTE_TYPE_COLLECT: typing.ClassVar[int] = ...
    NOTE_TYPE_FILE2: typing.ClassVar[int] = ...
    NOTE_TYPE_SCALEBAR: typing.ClassVar[int] = ...
    NOTE_TYPE_MERGE: typing.ClassVar[int] = ...
    NOTE_TYPE_THRUVIEW: typing.ClassVar[int] = ...
    NOTE_TYPE_ARROW: typing.ClassVar[int] = ...
    NOTE_TYPE_VARIABLE: typing.ClassVar[int] = ...
    NOTE_TYPE_STRUCTURE: typing.ClassVar[int] = ...
    NOTE_TYPE_4D_SERIES: typing.ClassVar[int] = ...
    STRUCTURE_LABELS_1: typing.ClassVar[typing.List[java.lang.String]] = ...
    STRUCTURE_LABELS_2: typing.ClassVar[typing.List[java.lang.String]] = ...
    STRUCTURE_LABELS_3: typing.ClassVar[typing.List[java.lang.String]] = ...
    STRUCTURE_LABELS_4: typing.ClassVar[typing.List[java.lang.String]] = ...
    STRUCTURE_LABELS_5: typing.ClassVar[typing.List[java.lang.String]] = ...
    STRUCTURE_LABELS_6: typing.ClassVar[typing.List[java.lang.String]] = ...
    PIC_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    LUT_LENGTH: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class BioRadSCNReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class BrukerReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class BurleighReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class CV7000Reader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class CanonRawReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class CellH5Reader(loci.formats.FormatReader):
    HDF_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...
    class CellH5Constants:
        PREFIX_PATH: typing.ClassVar[java.lang.String] = ...
        IMAGE_PATH: typing.ClassVar[java.lang.String] = ...
        SEGMENTATION_PATH: typing.ClassVar[java.lang.String] = ...
        PLATE: typing.ClassVar[java.lang.String] = ...
        WELL: typing.ClassVar[java.lang.String] = ...
        SITE: typing.ClassVar[java.lang.String] = ...
        DEFINITION: typing.ClassVar[java.lang.String] = ...
        OBJECT: typing.ClassVar[java.lang.String] = ...
        FEATURE: typing.ClassVar[java.lang.String] = ...
        IMAGE: typing.ClassVar[java.lang.String] = ...
        BBOX: typing.ClassVar[java.lang.String] = ...
        CLASS_LABELS: typing.ClassVar[java.lang.String] = ...
        PREDICTED_CLASS_LABELS: typing.ClassVar[java.lang.String] = ...
        def __init__(self, cellH5Reader: 'CellH5Reader'): ...
    class CellH5Coordinate:
        plate: java.lang.String = ...
        well: java.lang.String = ...
        site: java.lang.String = ...
        def toString(self) -> java.lang.String: ...

class CellSensReader(loci.formats.FormatReader):
    FAIL_ON_MISSING_KEY: typing.ClassVar[java.lang.String] = ...
    FAIL_ON_MISSING_DEFAULT: typing.ClassVar[bool] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def failOnMissingETS(self) -> bool: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class CellVoyagerReader(loci.formats.FormatReader):
    def __init__(self): ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class CellWorxReader(loci.formats.FormatReader):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class CellomicsReader(loci.formats.FormatReader):
    C01_MAGIC_BYTES: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ColumbusReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class DNGReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class DefaultMetadataOptions(loci.formats.in_.MetadataOptions):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, metadataLevel: 'MetadataLevel'): ...
    def getMetadataLevel(self) -> 'MetadataLevel': ...
    def isValidate(self) -> bool: ...
    def setMetadataLevel(self, metadataLevel: 'MetadataLevel') -> None: ...
    def setValidate(self, boolean: bool) -> None: ...

class DeltavisionReader(loci.formats.FormatReader):
    DV_MAGIC_BYTES_1: typing.ClassVar[int] = ...
    DV_MAGIC_BYTES_2: typing.ClassVar[int] = ...
    DATE_FORMAT: typing.ClassVar[java.lang.String] = ...
    DATE_FORMATS: typing.ClassVar[typing.List[java.lang.String]] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getPlaneByteOffset(self, int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def setTruncatedFileFlag(self, boolean: bool) -> None: ...

class DynamicMetadataOptions(loci.formats.in_.MetadataOptions):
    METADATA_LEVEL_KEY: typing.ClassVar[java.lang.String] = ...
    METADATA_LEVEL_DEFAULT: typing.ClassVar['MetadataLevel'] = ...
    READER_VALIDATE_KEY: typing.ClassVar[java.lang.String] = ...
    READER_VALIDATE_DEFAULT: typing.ClassVar[bool] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, metadataLevel: 'MetadataLevel'): ...
    @typing.overload
    def get(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def get(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getBoolean(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def getBoolean(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def getClass(self) -> typing.Type[typing.Any]: ...
    @typing.overload
    def getClass(self, string: typing.Union[java.lang.String, str]) -> typing.Type[typing.Any]: ...
    @typing.overload
    def getClass(self, string: typing.Union[java.lang.String, str], class_: typing.Type[typing.Any]) -> typing.Type[typing.Any]: ...
    @typing.overload
    def getDouble(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDouble(self, string: typing.Union[java.lang.String, str], double: float) -> float: ...
    _getEnum__T = typing.TypeVar('_getEnum__T', bound=java.lang.Enum)  # <T>
    def getEnum(self, string: typing.Union[java.lang.String, str], t: _getEnum__T) -> _getEnum__T: ...
    @typing.overload
    def getFile(self, string: typing.Union[java.lang.String, str]) -> java.io.File: ...
    @typing.overload
    def getFile(self, string: typing.Union[java.lang.String, str], file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> java.io.File: ...
    @typing.overload
    def getFloat(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getFloat(self, string: typing.Union[java.lang.String, str], float: float) -> float: ...
    @typing.overload
    def getInteger(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getInteger(self, string: typing.Union[java.lang.String, str], integer: int) -> int: ...
    @typing.overload
    def getLong(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getLong(self, string: typing.Union[java.lang.String, str], long: int) -> int: ...
    def getMetadataLevel(self) -> 'MetadataLevel': ...
    @staticmethod
    def getMetadataOptionsFile(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def isValidate(self) -> bool: ...
    def loadOptions(self, string: typing.Union[java.lang.String, str], arrayList: java.util.ArrayList[typing.Union[java.lang.String, str]]) -> None: ...
    def set(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def setBoolean(self, string: typing.Union[java.lang.String, str], boolean: bool) -> None: ...
    def setClass(self, string: typing.Union[java.lang.String, str], class_: typing.Type[typing.Any]) -> None: ...
    def setDouble(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    _setEnum__T = typing.TypeVar('_setEnum__T', bound=java.lang.Enum)  # <T>
    def setEnum(self, string: typing.Union[java.lang.String, str], t: _setEnum__T) -> None: ...
    def setFile(self, string: typing.Union[java.lang.String, str], file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    def setFloat(self, string: typing.Union[java.lang.String, str], float: float) -> None: ...
    def setInteger(self, string: typing.Union[java.lang.String, str], integer: int) -> None: ...
    def setLong(self, string: typing.Union[java.lang.String, str], long: int) -> None: ...
    def setMetadataLevel(self, metadataLevel: 'MetadataLevel') -> None: ...
    def setValidate(self, boolean: bool) -> None: ...

class EPSReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class Ecat7Reader(loci.formats.FormatReader):
    ECAT7_MAGIC: typing.ClassVar[java.lang.String] = ...
    ECAT7_MAGIC_REGEX: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class FEIReader(loci.formats.FormatReader):
    FEI_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class FEITiffReader(BaseTiffReader):
    SFEG_TAG: typing.ClassVar[int] = ...
    HELIOS_TAG: typing.ClassVar[int] = ...
    TITAN_TAG: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...

class FV1000Reader(loci.formats.FormatReader):
    FV1000_MAGIC_STRING_1: typing.ClassVar[java.lang.String] = ...
    FV1000_MAGIC_STRING_2: typing.ClassVar[java.lang.String] = ...
    OIB_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    OIF_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    FV1000_SUFFIXES: typing.ClassVar[typing.List[java.lang.String]] = ...
    PREVIEWNAME_PREFIXES: typing.ClassVar[typing.List[java.lang.String]] = ...
    DATE_FORMAT: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class FakeReader(loci.formats.FormatReader):
    BOX_SIZE: typing.ClassVar[int] = ...
    DEFAULT_SIZE_X: typing.ClassVar[int] = ...
    DEFAULT_SIZE_Y: typing.ClassVar[int] = ...
    DEFAULT_SIZE_Z: typing.ClassVar[int] = ...
    DEFAULT_SIZE_C: typing.ClassVar[int] = ...
    DEFAULT_SIZE_T: typing.ClassVar[int] = ...
    DEFAULT_PIXEL_TYPE: typing.ClassVar[int] = ...
    DEFAULT_RGB_CHANNEL_COUNT: typing.ClassVar[int] = ...
    DEFAULT_DIMENSION_ORDER: typing.ClassVar[java.lang.String] = ...
    DEFAULT_RESOLUTION_SCALE: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOmeXmlMetadata(self) -> bioformats_jar._loci.formats.ome.OMEXMLMetadata: ...
    def getOmeXmlService(self) -> bioformats_jar._loci.formats.services.OMEXMLService: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def readSpecialPixels(byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def readSpecialPixels(byteArray: typing.List[int], int: int, boolean: bool) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def readSpecialPixels(byteArray: typing.List[int], int: int, boolean: bool, int2: int, boolean2: bool) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class FilePatternReader(loci.formats.WrappedReader):
    def __init__(self): ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getCoreMetadataList(self) -> java.util.List[loci.formats.CoreMetadata]: ...
    def getMetadataStore(self) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def hasCompanionFiles(self) -> bool: ...
    def hasFlattenedResolutions(self) -> bool: ...
    def isGroupFiles(self) -> bool: ...
    def isMetadataFiltered(self) -> bool: ...
    def isNormalized(self) -> bool: ...
    def isOriginalMetadataPopulated(self) -> bool: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def setFlattenedResolutions(self, boolean: bool) -> None: ...
    def setGroupFiles(self, boolean: bool) -> None: ...
    def setMetadataFiltered(self, boolean: bool) -> None: ...
    def setMetadataStore(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    def setNormalized(self, boolean: bool) -> None: ...
    def setOriginalMetadataPopulated(self, boolean: bool) -> None: ...

class FitsReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class FlexReader(loci.formats.FormatReader):
    FLEX: typing.ClassVar[int] = ...
    FLEX_SUFFIX: typing.ClassVar[java.lang.String] = ...
    MEA_SUFFIX: typing.ClassVar[java.lang.String] = ...
    RES_SUFFIX: typing.ClassVar[java.lang.String] = ...
    MEASUREMENT_SUFFIXES: typing.ClassVar[typing.List[java.lang.String]] = ...
    SUFFIXES: typing.ClassVar[typing.List[java.lang.String]] = ...
    SCREENING: typing.ClassVar[java.lang.String] = ...
    ARCHIVE: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @staticmethod
    def appendServerMap(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    @staticmethod
    def mapServer(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    @staticmethod
    def mapServer(string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]) -> None: ...
    @staticmethod
    def mapServersFromConfigurationFile(string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    class FlexHandler(loci.common.xml.BaseHandler):
        def __init__(self, flexReader: 'FlexReader', list: java.util.List, list2: java.util.List, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, boolean: bool, int: int, int2: int): ...
        def characters(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
        def endElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
        def startElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], attributes: org.xml.sax.Attributes) -> None: ...
    class MeaHandler(loci.common.xml.BaseHandler):
        def __init__(self, flexReader: 'FlexReader'): ...
        def getFlexFiles(self) -> java.util.List[java.lang.String]: ...
        def startElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], attributes: org.xml.sax.Attributes) -> None: ...
    class ResHandler(loci.common.xml.BaseHandler):
        def __init__(self, flexReader: 'FlexReader'): ...
        def startElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], attributes: org.xml.sax.Attributes) -> None: ...

class FlowSightReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class FluoviewReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class FujiReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class GIFReader(loci.formats.FormatReader):
    GIF_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class GatanDM2Reader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class GatanReader(loci.formats.FormatReader):
    DM3_MAGIC_BYTES: typing.ClassVar[int] = ...
    DM4_MAGIC_BYTES: typing.ClassVar[int] = ...
    SPLIT_MONTAGE: typing.ClassVar[java.lang.String] = ...
    SPLIT_MONTAGE_DEFAULT: typing.ClassVar[bool] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def splitMontage(self) -> bool: ...

class GelReader(BaseTiffReader):
    DATE_FORMAT: typing.ClassVar[java.lang.String] = ...
    TIME_FORMAT: typing.ClassVar[java.lang.String] = ...
    DATE_TIME_FORMAT: typing.ClassVar[java.lang.String] = ...
    FORMATS: typing.ClassVar[typing.List[java.lang.String]] = ...
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class HISReader(loci.formats.FormatReader):
    HIS_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class HRDGDFReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class HamamatsuVMSReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class HitachiReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class I2IReader(loci.formats.FormatReader):
    def __init__(self): ...
    def initFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ICSReader(loci.formats.FormatReader):
    NL: typing.ClassVar[java.lang.String] = ...
    DATE_FORMATS: typing.ClassVar[typing.List[java.lang.String]] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isInterleaved(self) -> bool: ...
    @typing.overload
    def isInterleaved(self, int: int) -> bool: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class IM3Reader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getSpectra(self) -> java.util.List['IM3Reader.Spectrum']: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @staticmethod
    def main(stringArray: typing.List[java.lang.String]) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openRaw(self) -> typing.List[int]: ...
    def setSeries(self, int: int) -> None: ...
    def writeSummary(self) -> None: ...
    class Spectrum:
        def getMagnitudes(self) -> typing.List[float]: ...
        def getName(self) -> java.lang.String: ...
        def getWavelengths(self) -> typing.List[float]: ...

class IMODReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class INRReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class IPLabReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class IPWReader(loci.formats.FormatReader):
    IPW_MAGIC_BYTES: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ImaconReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ImageIOReader(BIFormatReader):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getOptimalTileHeight(self) -> int: ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...

class ImagicReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class ImarisHDFReader(loci.formats.SubResolutionFormatReader):
    HDF_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ImarisReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ImarisTiffReader(BaseTiffReader):
    def __init__(self): ...

class ImprovisionTiffReader(BaseTiffReader):
    IMPROVISION_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ImspectorReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class InCell3000Reader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class InCellReader(loci.formats.FormatReader):
    INCELL_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    CYTELL_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class InveonReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class IonpathMIBITiffReader(BaseTiffReader):
    IONPATH_MIBI_SOFTWARE_PREFIX: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class IvisionReader(loci.formats.FormatReader):
    DATE_FORMAT: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class JEOLReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class JPEG2000MetadataParser:
    @typing.overload
    def __init__(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream): ...
    @typing.overload
    def __init__(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, long: int): ...
    def getCodestreamOffset(self) -> int: ...
    def getCodestreamPixelType(self) -> int: ...
    def getCodestreamSizeC(self) -> int: ...
    def getCodestreamSizeX(self) -> int: ...
    def getCodestreamSizeY(self) -> int: ...
    def getComments(self) -> java.util.ArrayList[java.lang.String]: ...
    def getHeaderPixelType(self) -> int: ...
    def getHeaderSizeC(self) -> int: ...
    def getHeaderSizeX(self) -> int: ...
    def getHeaderSizeY(self) -> int: ...
    def getLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getResolutionLevels(self) -> int: ...
    def isRawCodestream(self) -> bool: ...

class JPEG2000Reader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class JPEGReader(loci.formats.DelegateReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class JPKReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class JPXReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class KLBReader(loci.formats.FormatReader):
    CHANNEL_PREFIX: typing.ClassVar[java.lang.String] = ...
    TIME_PREFIX: typing.ClassVar[java.lang.String] = ...
    TIME_SUFFIX: typing.ClassVar[java.lang.String] = ...
    PROJECTION_PREFIX: typing.ClassVar[java.lang.String] = ...
    PROJECTION_SUFFIX: typing.ClassVar[java.lang.String] = ...
    SERIES_PREFIXES: typing.ClassVar[java.util.Set] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class KhorosReader(loci.formats.FormatReader):
    KHOROS_MAGIC_BYTES: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class KodakReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class L2DReader(loci.formats.FormatReader):
    DATE_FORMAT: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class LEOReader(BaseTiffReader):
    LEO_TAG: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...

class LIFReader(loci.formats.FormatReader):
    OLD_PHYSICAL_SIZE_KEY: typing.ClassVar[java.lang.String] = ...
    OLD_PHYSICAL_SIZE_DEFAULT: typing.ClassVar[bool] = ...
    LIF_MAGIC_BYTE: typing.ClassVar[int] = ...
    LIF_MEMORY_BYTE: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def useOldPhysicalSizeCalculation(self) -> bool: ...

class LIMReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class LegacyND2Reader(loci.formats.FormatReader):
    def __init__(self): ...
    def getBytesPerPixel(self, int: int) -> int: ...
    def getChannelName(self, int: int, int2: int, int3: int, int4: int) -> java.lang.String: ...
    def getChannels(self, int: int) -> int: ...
    def getDT(self, int: int, int2: int, int3: int, int4: int) -> float: ...
    def getDX(self, int: int, int2: int, int3: int, int4: int) -> float: ...
    def getDY(self, int: int, int2: int, int3: int, int4: int) -> float: ...
    def getDZ(self, int: int, int2: int, int3: int, int4: int) -> float: ...
    def getHeight(self, int: int) -> int: ...
    def getImage(self, byteArray: typing.List[int], int: int, int2: int, int3: int, int4: int) -> typing.List[int]: ...
    def getMagnification(self, int: int, int2: int, int3: int, int4: int) -> float: ...
    def getModality(self, int: int, int2: int, int3: int, int4: int) -> int: ...
    def getNA(self, int: int, int2: int, int3: int, int4: int) -> float: ...
    def getNumSeries(self) -> int: ...
    def getObjectiveName(self, int: int, int2: int, int3: int, int4: int) -> java.lang.String: ...
    def getTFrames(self, int: int) -> int: ...
    def getWavelength(self, int: int, int2: int, int3: int, int4: int) -> float: ...
    def getWidth(self, int: int) -> int: ...
    def getZSlices(self, int: int) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openFile(self, string: typing.Union[java.lang.String, str]) -> None: ...

class LegacyQTReader(BIFormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...

class LeicaHandler(loci.common.xml.BaseHandler):
    def __init__(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, metadataLevel: 'MetadataLevel'): ...
    def endElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
    def getCoreMetadataList(self) -> java.util.List[loci.formats.CoreMetadata]: ...
    def getGlobalMetadata(self) -> java.util.Hashtable: ...
    def getLutNames(self) -> java.util.Vector[java.lang.String]: ...
    def startElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], attributes: org.xml.sax.Attributes) -> None: ...

class LeicaReader(loci.formats.FormatReader):
    LEI_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class LeicaSCNReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getThumbSizeX(self) -> int: ...
    def getThumbSizeY(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...

class LiFlimReader(loci.formats.FormatReader):
    INFO_TABLE: typing.ClassVar[java.lang.String] = ...
    LAYOUT_TABLE: typing.ClassVar[java.lang.String] = ...
    BACKGROUND_TABLE: typing.ClassVar[java.lang.String] = ...
    VERSION_KEY: typing.ClassVar[java.lang.String] = ...
    COMPRESSION_KEY: typing.ClassVar[java.lang.String] = ...
    DATATYPE_KEY: typing.ClassVar[java.lang.String] = ...
    C_KEY: typing.ClassVar[java.lang.String] = ...
    X_KEY: typing.ClassVar[java.lang.String] = ...
    Y_KEY: typing.ClassVar[java.lang.String] = ...
    Z_KEY: typing.ClassVar[java.lang.String] = ...
    P_KEY: typing.ClassVar[java.lang.String] = ...
    F_KEY: typing.ClassVar[java.lang.String] = ...
    T_KEY: typing.ClassVar[java.lang.String] = ...
    DarkImage_KEY: typing.ClassVar[java.lang.String] = ...
    TIMESTAMP_KEY: typing.ClassVar[java.lang.String] = ...
    KNOWN_VERSIONS: typing.ClassVar[typing.List[java.lang.String]] = ...
    COMPRESSION_NONE: typing.ClassVar[java.lang.String] = ...
    COMPRESSION_GZIP: typing.ClassVar[java.lang.String] = ...
    DATATYPE_UINT8: typing.ClassVar[java.lang.String] = ...
    DATATYPE_INT8: typing.ClassVar[java.lang.String] = ...
    DATATYPE_UINT16: typing.ClassVar[java.lang.String] = ...
    DATATYPE_INT16: typing.ClassVar[java.lang.String] = ...
    DATATYPE_UINT32: typing.ClassVar[java.lang.String] = ...
    DATATYPE_INT32: typing.ClassVar[java.lang.String] = ...
    DATATYPE_REAL32: typing.ClassVar[java.lang.String] = ...
    DATATYPE_REAL64: typing.ClassVar[java.lang.String] = ...
    DATATYPE_UINT12: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class MIASReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def parseMasks(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    def populateMaskPixels(self, int: int, int2: int, int3: int, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> bool: ...
    def setAutomaticallyParseMasks(self, boolean: bool) -> None: ...

class MINCReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class MNGReader(BIFormatReader):
    MNG_MAGIC_BYTES: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...

class MRCReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def initFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class MRWReader(loci.formats.FormatReader):
    MRW_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class MetadataLevel(java.lang.Enum['MetadataLevel']):
    MINIMUM: typing.ClassVar['MetadataLevel'] = ...
    NO_OVERLAYS: typing.ClassVar['MetadataLevel'] = ...
    ALL: typing.ClassVar['MetadataLevel'] = ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'MetadataLevel': ...
    @staticmethod
    def values() -> typing.List['MetadataLevel']: ...

class MetadataOptions:
    def getMetadataLevel(self) -> MetadataLevel: ...
    def isValidate(self) -> bool: ...
    def setMetadataLevel(self, metadataLevel: MetadataLevel) -> None: ...
    def setValidate(self, boolean: bool) -> None: ...

class MetamorphHandler(loci.common.xml.BaseHandler):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, hashtable: java.util.Hashtable): ...
    def getBinning(self) -> java.lang.String: ...
    def getChannelName(self) -> java.lang.String: ...
    def getChannelNames(self) -> java.util.Vector[java.lang.String]: ...
    def getDate(self) -> java.lang.String: ...
    def getExposures(self) -> java.util.Vector[float]: ...
    def getGain(self) -> float: ...
    def getImageName(self) -> java.lang.String: ...
    def getLensNA(self) -> float: ...
    def getLensRI(self) -> float: ...
    def getPixelSizeX(self) -> float: ...
    def getPixelSizeY(self) -> float: ...
    def getReadOutRate(self) -> float: ...
    def getStageLabel(self) -> java.lang.String: ...
    def getStagePositionX(self) -> ome.units.quantity.Length: ...
    def getStagePositionY(self) -> ome.units.quantity.Length: ...
    def getTemperature(self) -> float: ...
    def getTimestamps(self) -> java.util.Vector[java.lang.String]: ...
    def getWavelengths(self) -> java.util.Vector[int]: ...
    def getZPositions(self) -> java.util.Vector[float]: ...
    def getZoom(self) -> float: ...
    def hasDualCamera(self) -> bool: ...
    def startElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], attributes: org.xml.sax.Attributes) -> None: ...

class MetamorphReader(BaseTiffReader):
    SHORT_DATE_FORMAT: typing.ClassVar[java.lang.String] = ...
    LONG_DATE_FORMAT: typing.ClassVar[java.lang.String] = ...
    ND_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    STK_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    WELL_COORDS: typing.ClassVar[java.util.regex.Pattern] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @staticmethod
    def decodeDate(int: int) -> java.lang.String: ...
    @staticmethod
    def decodeTime(int: int) -> java.lang.String: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @staticmethod
    def intFormat(int: int, int2: int) -> java.lang.String: ...
    @staticmethod
    def intFormatMax(int: int, int2: int) -> java.lang.String: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class MetamorphTiffReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class MetaxpressTiffReader(CellWorxReader):
    def __init__(self): ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...

class MicroCTReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class MicromanagerReader(loci.formats.FormatReader):
    DATE_FORMAT: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def initFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def populateMetadataStore(self, stringArray: typing.List[java.lang.String]) -> None: ...

class MikroscanTiffReader(loci.formats.in_.SVSReader):
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...

class MinimalTiffReader(loci.formats.SubResolutionFormatReader):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getIFDs(self) -> bioformats_jar._loci.formats.tiff.IFDList: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getThumbSizeX(self) -> int: ...
    def getThumbSizeY(self) -> int: ...
    def getThumbnailIFDs(self) -> bioformats_jar._loci.formats.tiff.IFDList: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class MolecularImagingReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class NAFReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ND2Handler(loci.common.xml.BaseHandler):
    @typing.overload
    def __init__(self, coreMetadataList: bioformats_jar._loci.formats.CoreMetadataList, boolean: bool, int: int): ...
    @typing.overload
    def __init__(self, coreMetadataList: bioformats_jar._loci.formats.CoreMetadataList, int: int): ...
    def endDocument(self) -> None: ...
    @typing.overload
    def endElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], attributes: org.xml.sax.Attributes) -> None: ...
    @typing.overload
    def endElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
    def getBinnings(self) -> java.util.ArrayList[java.lang.String]: ...
    def getCameraModel(self) -> java.lang.String: ...
    def getChannelColors(self) -> java.util.Hashtable[java.lang.String, int]: ...
    def getChannelNames(self) -> java.util.ArrayList[java.lang.String]: ...
    def getCoreMetadataList(self) -> bioformats_jar._loci.formats.CoreMetadataList: ...
    def getCorrection(self) -> java.lang.String: ...
    def getDate(self) -> java.lang.String: ...
    def getEmissionWavelengths(self) -> java.util.ArrayList[float]: ...
    def getExcitationWavelengths(self) -> java.util.ArrayList[float]: ...
    def getExposureTimes(self) -> java.util.ArrayList[float]: ...
    def getFieldIndex(self) -> int: ...
    def getGains(self) -> java.util.ArrayList[float]: ...
    def getImmersion(self) -> java.lang.String: ...
    def getMagnification(self) -> float: ...
    def getMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getModalities(self) -> java.util.ArrayList[java.lang.String]: ...
    def getNumericalAperture(self) -> float: ...
    def getObjectiveModel(self) -> java.lang.String: ...
    def getPinholeSize(self) -> float: ...
    def getPixelSizeX(self) -> float: ...
    def getPixelSizeY(self) -> float: ...
    def getPixelSizeZ(self) -> float: ...
    def getPositionNames(self) -> java.util.ArrayList[java.lang.String]: ...
    def getPowers(self) -> java.util.ArrayList[int]: ...
    def getROIs(self) -> java.util.ArrayList[java.util.Hashtable[java.lang.String, java.lang.String]]: ...
    def getRefractiveIndex(self) -> float: ...
    def getSeriesCount(self) -> int: ...
    def getSpeeds(self) -> java.util.ArrayList[float]: ...
    def getTemperatures(self) -> java.util.ArrayList[float]: ...
    def getTimepoints(self) -> java.util.ArrayList[int]: ...
    def getVoltage(self) -> float: ...
    def getXFields(self) -> int: ...
    def getXPositions(self) -> java.util.ArrayList[ome.units.quantity.Length]: ...
    def getYPositions(self) -> java.util.ArrayList[ome.units.quantity.Length]: ...
    def getZPositions(self) -> java.util.ArrayList[ome.units.quantity.Length]: ...
    def getZSections(self) -> java.util.ArrayList[int]: ...
    def isDimensions(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def isLossless(self) -> bool: ...
    def parseKeyAndValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
    def populateROIs(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    def startElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], attributes: org.xml.sax.Attributes) -> None: ...

class ND2Reader(loci.formats.DelegateReader):
    def __init__(self): ...
    def getOptimalTileHeight(self) -> int: ...

class NDPIReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...

class NDPISReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class NRRDReader(loci.formats.FormatReader):
    NRRD_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class NativeND2Reader(loci.formats.SubResolutionFormatReader):
    ND2_MAGIC_BYTES_1: typing.ClassVar[int] = ...
    ND2_MAGIC_BYTES_2: typing.ClassVar[int] = ...
    USE_CHUNKMAP_KEY: typing.ClassVar[java.lang.String] = ...
    USE_CHUNKMAP_DEFAULT: typing.ClassVar[bool] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @staticmethod
    def sanitizeControl(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def useChunkMap(self) -> bool: ...

class NativeQTReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class NiftiReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class NikonElementsTiffReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...

class NikonReader(BaseTiffReader):
    NEF_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class NikonTiffReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...

class OBFReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class OIRReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class OMETiffReader(loci.formats.SubResolutionFormatReader):
    OME_TIFF_SUFFIXES: typing.ClassVar[typing.List[java.lang.String]] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    def getMetadataStoreForConversion(self) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    def getMetadataStoreForDisplay(self) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class OMEXMLReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class OpenlabRawReader(loci.formats.FormatReader):
    OPENLAB_RAW_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class OpenlabReader(loci.formats.FormatReader):
    LIFF_MAGIC_BYTES: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class OperettaReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class OxfordInstrumentsReader(loci.formats.FormatReader):
    OXFORD_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PCIReader(loci.formats.FormatReader):
    PCI_MAGIC_BYTES: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PCORAWReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PCXReader(loci.formats.FormatReader):
    PCX_MAGIC_BYTE: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PDSReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PGMReader(loci.formats.FormatReader):
    PGM_MAGIC_CHAR: typing.ClassVar[str] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PQBinReader(loci.formats.FormatReader):
    HEADER_SIZE: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PSDReader(loci.formats.FormatReader):
    PSD_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PerkinElmerReader(loci.formats.FormatReader):
    CFG_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    ANO_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    REC_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    TIM_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    CSV_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    ZPO_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    HTM_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    HTML_REGEX: typing.ClassVar[java.lang.String] = ...
    DATE_FORMAT: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PhotoshopTiffReader(BaseTiffReader):
    IMAGE_SOURCE_DATA: typing.ClassVar[int] = ...
    PACKBITS: typing.ClassVar[int] = ...
    ZIP: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PictReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def setLegacy(self, boolean: bool) -> None: ...

class PovrayReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PrairieMetadata:
    def __init__(self, document: org.w3c.dom.Document, document2: org.w3c.dom.Document, document3: org.w3c.dom.Document): ...
    def getActiveChannels(self) -> typing.List[int]: ...
    def getBitDepth(self) -> int: ...
    @typing.overload
    def getConfig(self, string: typing.Union[java.lang.String, str]) -> 'PrairieMetadata.Value': ...
    @typing.overload
    def getConfig(self) -> 'PrairieMetadata.ValueTable': ...
    def getCycleCount(self) -> int: ...
    def getCycleMax(self) -> int: ...
    def getCycleMin(self) -> int: ...
    def getDate(self) -> java.lang.String: ...
    def getFile(self, int: int, int2: int, int3: int) -> 'PrairieMetadata.PFile': ...
    def getFirstSequence(self) -> 'PrairieMetadata.Sequence': ...
    def getFrame(self, int: int, int2: int) -> 'PrairieMetadata.Frame': ...
    def getLaserPower(self) -> float: ...
    def getSequence(self, int: int) -> 'PrairieMetadata.Sequence': ...
    def getSequences(self) -> java.util.ArrayList['PrairieMetadata.Sequence']: ...
    def getValue(self, string: typing.Union[java.lang.String, str]) -> 'PrairieMetadata.Value': ...
    def getValues(self) -> 'PrairieMetadata.ValueTable': ...
    def getWaitTime(self) -> float: ...
    def isInvertX(self) -> bool: ...
    def isInvertY(self) -> bool: ...
    class Frame:
        def __init__(self, prairieMetadata: 'PrairieMetadata', sequence: 'PrairieMetadata.Sequence', element: org.w3c.dom.Element): ...
        def getAbsoluteTime(self) -> float: ...
        def getFile(self, int: int) -> 'PrairieMetadata.PFile': ...
        def getFirstFile(self) -> 'PrairieMetadata.PFile': ...
        def getGain(self, int: int) -> float: ...
        def getImagingDevice(self) -> java.lang.String: ...
        def getImmersion(self) -> java.lang.String: ...
        def getIndex(self) -> int: ...
        def getLinesPerFrame(self) -> int: ...
        def getMagnification(self) -> float: ...
        def getMicronsPerPixelX(self) -> float: ...
        def getMicronsPerPixelY(self) -> float: ...
        def getObjectiveLens(self) -> java.lang.String: ...
        def getObjectiveLensNA(self) -> float: ...
        def getObjectiveManufacturer(self) -> java.lang.String: ...
        def getOffset(self, int: int) -> float: ...
        def getOpticalZoom(self) -> float: ...
        def getPixelsPerLine(self) -> int: ...
        def getPositionX(self) -> ome.units.quantity.Length: ...
        def getPositionY(self) -> ome.units.quantity.Length: ...
        def getPositionZ(self) -> ome.units.quantity.Length: ...
        def getRelativeTime(self) -> float: ...
        def getSequence(self) -> 'PrairieMetadata.Sequence': ...
        def getValue(self, string: typing.Union[java.lang.String, str]) -> 'PrairieMetadata.Value': ...
        def getValues(self) -> 'PrairieMetadata.ValueTable': ...
        def parse(self, element: org.w3c.dom.Element) -> None: ...
    class PFile:
        def __init__(self, prairieMetadata: 'PrairieMetadata', frame: 'PrairieMetadata.Frame', element: org.w3c.dom.Element): ...
        def getChannel(self) -> int: ...
        def getChannelName(self) -> java.lang.String: ...
        def getFilename(self) -> java.lang.String: ...
        def getFrame(self) -> 'PrairieMetadata.Frame': ...
        def getWavelengthMax(self) -> float: ...
        def getWavelengthMin(self) -> float: ...
        def parse(self, element: org.w3c.dom.Element) -> None: ...
    class Sequence:
        def __init__(self, prairieMetadata: 'PrairieMetadata', element: org.w3c.dom.Element): ...
        def getCycle(self) -> int: ...
        def getFile(self, int: int, int2: int) -> 'PrairieMetadata.PFile': ...
        def getFirstFrame(self) -> 'PrairieMetadata.Frame': ...
        def getFrame(self, int: int) -> 'PrairieMetadata.Frame': ...
        def getIndexCount(self) -> int: ...
        def getIndexMax(self) -> int: ...
        def getIndexMin(self) -> int: ...
        def getType(self) -> java.lang.String: ...
        def getValue(self, string: typing.Union[java.lang.String, str]) -> 'PrairieMetadata.Value': ...
        def getValues(self) -> 'PrairieMetadata.ValueTable': ...
        def isSpectralMode(self) -> bool: ...
        def isTimeSeries(self) -> bool: ...
        def parse(self, element: org.w3c.dom.Element) -> None: ...
    class Value:
        def description(self) -> java.lang.String: ...
        @typing.overload
        def get(self, int: int) -> 'PrairieMetadata.Value': ...
        @typing.overload
        def get(self, object: typing.Any) -> 'PrairieMetadata.Value': ...
        def isTable(self) -> bool: ...
        def value(self) -> java.lang.String: ...
    class ValueItem(loci.formats.in_.PrairieMetadata.Value):
        def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
        def description(self) -> java.lang.String: ...
        @typing.overload
        def get(self, int: int) -> 'PrairieMetadata.Value': ...
        @typing.overload
        def get(self, object: typing.Any) -> 'PrairieMetadata.Value': ...
        def isTable(self) -> bool: ...
        def toString(self) -> java.lang.String: ...
        def value(self) -> java.lang.String: ...
    class ValueTable(java.util.HashMap[java.lang.String, 'PrairieMetadata.Value'], bioformats_jar._loci.formats.in_.PrairieMetadata.Value):
        def __init__(self): ...
        def description(self) -> java.lang.String: ...
        @typing.overload
        def get(self, object: typing.Any) -> typing.Any: ...
        @typing.overload
        def get(self, int: int) -> 'PrairieMetadata.Value': ...
        def isTable(self) -> bool: ...
        def value(self) -> java.lang.String: ...

class PrairieReader(loci.formats.FormatReader):
    CFG_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    ENV_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    XML_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    PRAIRIE_SUFFIXES: typing.ClassVar[typing.List[java.lang.String]] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class PyramidTiffReader(BaseTiffReader):
    def __init__(self): ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class QTReader(loci.formats.DelegateReader):
    def __init__(self): ...

class QuesantReader(loci.formats.FormatReader):
    MAX_HEADER_SIZE: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class RCPNLReader(DeltavisionReader):
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...

class RHKReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class SBIGReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class SDTInfo:
    BH_HEADER_CHKSUM: typing.ClassVar[int] = ...
    BH_HEADER_NOT_VALID: typing.ClassVar[int] = ...
    BH_HEADER_VALID: typing.ClassVar[int] = ...
    SETUP_IDENTIFIER: typing.ClassVar[java.lang.String] = ...
    DATA_IDENTIFIER: typing.ClassVar[java.lang.String] = ...
    FLOW_DATA_IDENTIFIER: typing.ClassVar[java.lang.String] = ...
    DLL_DATA_IDENTIFIER: typing.ClassVar[java.lang.String] = ...
    FCS_DATA_IDENTIFIER: typing.ClassVar[java.lang.String] = ...
    X_STRING: typing.ClassVar[java.lang.String] = ...
    Y_STRING: typing.ClassVar[java.lang.String] = ...
    T_STRING: typing.ClassVar[java.lang.String] = ...
    C_STRING: typing.ClassVar[java.lang.String] = ...
    X_IMG_STRING: typing.ClassVar[java.lang.String] = ...
    Y_IMG_STRING: typing.ClassVar[java.lang.String] = ...
    BINARY_SETUP: typing.ClassVar[java.lang.String] = ...
    width: int = ...
    height: int = ...
    timeBins: int = ...
    channels: int = ...
    timepoints: int = ...
    revision: int = ...
    infoOffs: int = ...
    infoLength: int = ...
    setupOffs: int = ...
    setupLength: int = ...
    dataBlockOffs: int = ...
    noOfDataBlocks: int = ...
    dataBlockLength: int = ...
    measDescBlockOffs: int = ...
    noOfMeasDescBlocks: int = ...
    measDescBlockLength: int = ...
    headerValid: int = ...
    reserved1: int = ...
    reserved2: int = ...
    chksum: int = ...
    info: java.lang.String = ...
    setup: java.lang.String = ...
    hasMeasureInfo: bool = ...
    time: java.lang.String = ...
    date: java.lang.String = ...
    modSerNo: java.lang.String = ...
    measMode: int = ...
    cfdLL: float = ...
    cfdLH: float = ...
    cfdZC: float = ...
    cfdHF: float = ...
    synZC: float = ...
    synFD: int = ...
    synHF: float = ...
    tacR: float = ...
    tacG: int = ...
    tacOF: float = ...
    tacLL: float = ...
    tacLH: float = ...
    adcRE: int = ...
    ealDE: int = ...
    ncx: int = ...
    ncy: int = ...
    page: int = ...
    colT: float = ...
    repT: float = ...
    stopt: int = ...
    overfl: int = ...
    useMotor: int = ...
    steps: int = ...
    offset: float = ...
    dither: int = ...
    incr: int = ...
    memBank: int = ...
    modType: java.lang.String = ...
    synTH: float = ...
    deadTimeComp: int = ...
    polarityL: int = ...
    polarityF: int = ...
    polarityP: int = ...
    linediv: int = ...
    accumulate: int = ...
    flbckY: int = ...
    flbckX: int = ...
    bordU: int = ...
    bordL: int = ...
    pixTime: float = ...
    pixClk: int = ...
    trigger: int = ...
    scanX: int = ...
    scanY: int = ...
    scanRX: int = ...
    scanRY: int = ...
    fifoTyp: int = ...
    epxDiv: int = ...
    modTypeCode: int = ...
    modFpgaVer: int = ...
    overflowCorrFactor: float = ...
    adcZoom: int = ...
    cycles: int = ...
    hasMeasStopInfo: bool = ...
    status: int = ...
    flags: int = ...
    stopTime: float = ...
    curStep: int = ...
    curCycle: int = ...
    curPage: int = ...
    minSyncRate: float = ...
    minCfdRate: float = ...
    minTacRate: float = ...
    minAdcRate: float = ...
    maxSyncRate: float = ...
    maxCfdRate: float = ...
    maxTacRate: float = ...
    maxAdcRate: float = ...
    mReserved1: int = ...
    mReserved2: float = ...
    hasMeasFCSInfo: bool = ...
    chan: int = ...
    fcsDecayCalc: int = ...
    mtResol: int = ...
    cortime: float = ...
    calcPhotons: int = ...
    fcsPoints: int = ...
    endTime: float = ...
    overruns: int = ...
    fcsType: int = ...
    crossChan: int = ...
    mod: int = ...
    crossMod: int = ...
    crossMtResol: int = ...
    hasExtendedMeasureInfo: bool = ...
    imageX: int = ...
    imageY: int = ...
    imageRX: int = ...
    imageRY: int = ...
    xyGain: int = ...
    masterClock: int = ...
    adcDE: int = ...
    detType: int = ...
    xAxis: int = ...
    hasMeasHISTInfo: bool = ...
    fidaTime: float = ...
    fildaTime: float = ...
    fidaPoints: int = ...
    fildaPoints: int = ...
    mcsTime: float = ...
    mcsPoints: int = ...
    mcstaPoints: int = ...
    blockNo: int = ...
    dataOffs: int = ...
    nextBlockOffs: int = ...
    allBlockOffsets: typing.List[int] = ...
    allBlockLengths: typing.List[int] = ...
    blockType: int = ...
    measDescBlockNo: int = ...
    lblockNo: int = ...
    blockLength: int = ...
    def __init__(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, hashtable: java.util.Hashtable): ...

class SDTReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getChannelCount(self) -> int: ...
    def getInfo(self) -> SDTInfo: ...
    def getTimeBinCount(self) -> int: ...
    def isIntensity(self) -> bool: ...
    @typing.overload
    def isInterleaved(self) -> bool: ...
    @typing.overload
    def isInterleaved(self, int: int) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def setIntensity(self, boolean: bool) -> None: ...
    def setPreLoad(self, boolean: bool) -> None: ...

class SEQReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class SIFReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class SISReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...

class SMCameraReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class SPCReader(loci.formats.FormatReader):
    TAC_RANGE: typing.ClassVar[java.lang.String] = ...
    TAC_GAIN: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class SPEReader(loci.formats.FormatReader):
    FLOAT: typing.ClassVar[int] = ...
    INT32: typing.ClassVar[int] = ...
    INT16: typing.ClassVar[int] = ...
    UNINT16: typing.ClassVar[int] = ...
    UNINT32: typing.ClassVar[int] = ...
    coreMetaData: typing.ClassVar[java.util.List] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class SVSReader(BaseTiffReader):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...

class ScanrReader(loci.formats.FormatReader):
    SKIP_MISSING_WELLS: typing.ClassVar[java.lang.String] = ...
    SKIP_MISSING_WELLS_DEFAULT: typing.ClassVar[bool] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def skipMissingWells(self) -> bool: ...

class SeikoReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class SimplePCITiffReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class SlidebookReader(loci.formats.FormatReader):
    SLD_MAGIC_BYTES_1_0: typing.ClassVar[int] = ...
    SLD_MAGIC_BYTES_1_1: typing.ClassVar[int] = ...
    SLD_MAGIC_BYTES_1_2: typing.ClassVar[int] = ...
    SLD_MAGIC_BYTES_2_0: typing.ClassVar[int] = ...
    SLD_MAGIC_BYTES_2_1: typing.ClassVar[int] = ...
    SLD_MAGIC_BYTES_3: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class SlidebookTiffReader(BaseTiffReader):
    SLIDEBOOK_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class SpiderReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class TCSReader(loci.formats.FormatReader):
    DATE_FORMAT: typing.ClassVar[java.lang.String] = ...
    PREFIX: typing.ClassVar[java.lang.String] = ...
    SUFFIX: typing.ClassVar[java.lang.String] = ...
    XML_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class TargaReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class TecanReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class TextReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getChannelLabel(self, int: int) -> java.lang.String: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...

class TiffDelegateReader(loci.formats.DelegateReader):
    def __init__(self): ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class TiffJAIReader(BIFormatReader):
    def __init__(self): ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...

class TiffReader(BaseTiffReader):
    TIFF_SUFFIXES: typing.ClassVar[typing.List[java.lang.String]] = ...
    COMPANION_SUFFIXES: typing.ClassVar[typing.List[java.lang.String]] = ...
    IMAGEJ_TAG: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...

class TileJPEGReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def initFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...

class TillVisionReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class TopometrixReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class TrestleReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class UBMReader(loci.formats.FormatReader):
    HEADER_SIZE: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class UnisokuReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class VGSAMReader(loci.formats.FormatReader):
    VG_MAGIC_STRING: typing.ClassVar[java.lang.String] = ...
    PIXEL_OFFSET: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class VarianFDFReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class VectraReader(BaseTiffReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getScanProfileXML(self) -> java.lang.String: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...

class VeecoReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class VentanaReader(BaseTiffReader):
    SPLIT_TILES_KEY: typing.ClassVar[java.lang.String] = ...
    SPLIT_TILES_DEFAULT: typing.ClassVar[bool] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getThumbSizeX(self) -> int: ...
    def getThumbSizeY(self) -> int: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def splitTiles(self) -> bool: ...

class VisitechReader(loci.formats.FormatReader):
    HTML_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    HEADER_MARKER: typing.ClassVar[java.lang.String] = ...
    PIXELS_MARKER: typing.ClassVar[typing.List[int]] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getOptimalTileHeight(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class VolocityClippingReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class VolocityReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class WATOPReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class WlzReader(loci.formats.FormatReader):
    NO_WLZ_MSG: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ZeissCZIReader(loci.formats.FormatReader):
    ALLOW_AUTOSTITCHING_KEY: typing.ClassVar[java.lang.String] = ...
    ALLOW_AUTOSTITCHING_DEFAULT: typing.ClassVar[bool] = ...
    INCLUDE_ATTACHMENTS_KEY: typing.ClassVar[java.lang.String] = ...
    INCLUDE_ATTACHMENTS_DEFAULT: typing.ClassVar[bool] = ...
    TRIM_DIMENSIONS_KEY: typing.ClassVar[java.lang.String] = ...
    TRIM_DIMENSIONS_DEFAULT: typing.ClassVar[bool] = ...
    RELATIVE_POSITIONS_KEY: typing.ClassVar[java.lang.String] = ...
    RELATIVE_POSITIONS_DEFAULT: typing.ClassVar[bool] = ...
    def __init__(self): ...
    def allowAutostitching(self) -> bool: ...
    def canReadAttachments(self) -> bool: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def storeRelativePositions(self) -> bool: ...
    def trimDimensions(self) -> bool: ...

class ZeissLMSReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def initFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ZeissLSMReader(loci.formats.FormatReader):
    MDB_SUFFIX: typing.ClassVar[typing.List[java.lang.String]] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def setCoreIndex(self, int: int) -> None: ...
    def setSeries(self, int: int) -> None: ...

class ZeissTIFFHandler(org.xml.sax.helpers.DefaultHandler):
    main_tagset: 'ZeissTIFFHandler.TagSet' = ...
    planes: java.util.ArrayList = ...
    scalings: java.util.ArrayList = ...
    layers: java.util.ArrayList = ...
    def characters(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    def endElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
    def startElement(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], attributes: org.xml.sax.Attributes) -> None: ...
    def toString(self) -> java.lang.String: ...
    class Plane:
        basename: java.lang.String = ...
        tagset: 'ZeissTIFFHandler.TagSet' = ...
        def toString(self) -> java.lang.String: ...

class ZeissTIFFReader(BaseZeissReader):
    TIFF_SUFFIXES: typing.ClassVar[typing.List[java.lang.String]] = ...
    XML_NAME: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ZeissZVIReader(BaseZeissReader):
    ZVI_MAGIC_BYTES: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ZipReader(loci.formats.FormatReader):
    def __init__(self): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...
    def setGroupFiles(self, boolean: bool) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.formats.in_")``.

    AFIReader: typing.Type[AFIReader]
    AIMReader: typing.Type[AIMReader]
    APLReader: typing.Type[APLReader]
    APNGReader: typing.Type[APNGReader]
    ARFReader: typing.Type[ARFReader]
    AVIReader: typing.Type[AVIReader]
    AliconaReader: typing.Type[AliconaReader]
    AmiraReader: typing.Type[AmiraReader]
    AnalyzeReader: typing.Type[AnalyzeReader]
    BDReader: typing.Type[BDReader]
    BDVReader: typing.Type[BDVReader]
    BIFormatReader: typing.Type[BIFormatReader]
    BMPReader: typing.Type[BMPReader]
    BaseTiffReader: typing.Type[BaseTiffReader]
    BaseZeissReader: typing.Type[BaseZeissReader]
    BioRadGelReader: typing.Type[BioRadGelReader]
    BioRadReader: typing.Type[BioRadReader]
    BioRadSCNReader: typing.Type[BioRadSCNReader]
    BrukerReader: typing.Type[BrukerReader]
    BurleighReader: typing.Type[BurleighReader]
    CV7000Reader: typing.Type[CV7000Reader]
    CanonRawReader: typing.Type[CanonRawReader]
    CellH5Reader: typing.Type[CellH5Reader]
    CellSensReader: typing.Type[CellSensReader]
    CellVoyagerReader: typing.Type[CellVoyagerReader]
    CellWorxReader: typing.Type[CellWorxReader]
    CellomicsReader: typing.Type[CellomicsReader]
    ColumbusReader: typing.Type[ColumbusReader]
    DNGReader: typing.Type[DNGReader]
    DefaultMetadataOptions: typing.Type[DefaultMetadataOptions]
    DeltavisionReader: typing.Type[DeltavisionReader]
    DynamicMetadataOptions: typing.Type[DynamicMetadataOptions]
    EPSReader: typing.Type[EPSReader]
    Ecat7Reader: typing.Type[Ecat7Reader]
    FEIReader: typing.Type[FEIReader]
    FEITiffReader: typing.Type[FEITiffReader]
    FV1000Reader: typing.Type[FV1000Reader]
    FakeReader: typing.Type[FakeReader]
    FilePatternReader: typing.Type[FilePatternReader]
    FitsReader: typing.Type[FitsReader]
    FlexReader: typing.Type[FlexReader]
    FlowSightReader: typing.Type[FlowSightReader]
    FluoviewReader: typing.Type[FluoviewReader]
    FujiReader: typing.Type[FujiReader]
    GIFReader: typing.Type[GIFReader]
    GatanDM2Reader: typing.Type[GatanDM2Reader]
    GatanReader: typing.Type[GatanReader]
    GelReader: typing.Type[GelReader]
    HISReader: typing.Type[HISReader]
    HRDGDFReader: typing.Type[HRDGDFReader]
    HamamatsuVMSReader: typing.Type[HamamatsuVMSReader]
    HitachiReader: typing.Type[HitachiReader]
    I2IReader: typing.Type[I2IReader]
    ICSReader: typing.Type[ICSReader]
    IM3Reader: typing.Type[IM3Reader]
    IMODReader: typing.Type[IMODReader]
    INRReader: typing.Type[INRReader]
    IPLabReader: typing.Type[IPLabReader]
    IPWReader: typing.Type[IPWReader]
    ImaconReader: typing.Type[ImaconReader]
    ImageIOReader: typing.Type[ImageIOReader]
    ImagicReader: typing.Type[ImagicReader]
    ImarisHDFReader: typing.Type[ImarisHDFReader]
    ImarisReader: typing.Type[ImarisReader]
    ImarisTiffReader: typing.Type[ImarisTiffReader]
    ImprovisionTiffReader: typing.Type[ImprovisionTiffReader]
    ImspectorReader: typing.Type[ImspectorReader]
    InCell3000Reader: typing.Type[InCell3000Reader]
    InCellReader: typing.Type[InCellReader]
    InveonReader: typing.Type[InveonReader]
    IonpathMIBITiffReader: typing.Type[IonpathMIBITiffReader]
    IvisionReader: typing.Type[IvisionReader]
    JEOLReader: typing.Type[JEOLReader]
    JPEG2000MetadataParser: typing.Type[JPEG2000MetadataParser]
    JPEG2000Reader: typing.Type[JPEG2000Reader]
    JPEGReader: typing.Type[JPEGReader]
    JPKReader: typing.Type[JPKReader]
    JPXReader: typing.Type[JPXReader]
    KLBReader: typing.Type[KLBReader]
    KhorosReader: typing.Type[KhorosReader]
    KodakReader: typing.Type[KodakReader]
    L2DReader: typing.Type[L2DReader]
    LEOReader: typing.Type[LEOReader]
    LIFReader: typing.Type[LIFReader]
    LIMReader: typing.Type[LIMReader]
    LegacyND2Reader: typing.Type[LegacyND2Reader]
    LegacyQTReader: typing.Type[LegacyQTReader]
    LeicaHandler: typing.Type[LeicaHandler]
    LeicaReader: typing.Type[LeicaReader]
    LeicaSCNReader: typing.Type[LeicaSCNReader]
    LiFlimReader: typing.Type[LiFlimReader]
    MIASReader: typing.Type[MIASReader]
    MINCReader: typing.Type[MINCReader]
    MNGReader: typing.Type[MNGReader]
    MRCReader: typing.Type[MRCReader]
    MRWReader: typing.Type[MRWReader]
    MetadataLevel: typing.Type[MetadataLevel]
    MetadataOptions: typing.Type[MetadataOptions]
    MetamorphHandler: typing.Type[MetamorphHandler]
    MetamorphReader: typing.Type[MetamorphReader]
    MetamorphTiffReader: typing.Type[MetamorphTiffReader]
    MetaxpressTiffReader: typing.Type[MetaxpressTiffReader]
    MicroCTReader: typing.Type[MicroCTReader]
    MicromanagerReader: typing.Type[MicromanagerReader]
    MikroscanTiffReader: typing.Type[MikroscanTiffReader]
    MinimalTiffReader: typing.Type[MinimalTiffReader]
    MolecularImagingReader: typing.Type[MolecularImagingReader]
    NAFReader: typing.Type[NAFReader]
    ND2Handler: typing.Type[ND2Handler]
    ND2Reader: typing.Type[ND2Reader]
    NDPIReader: typing.Type[NDPIReader]
    NDPISReader: typing.Type[NDPISReader]
    NRRDReader: typing.Type[NRRDReader]
    NativeND2Reader: typing.Type[NativeND2Reader]
    NativeQTReader: typing.Type[NativeQTReader]
    NiftiReader: typing.Type[NiftiReader]
    NikonElementsTiffReader: typing.Type[NikonElementsTiffReader]
    NikonReader: typing.Type[NikonReader]
    NikonTiffReader: typing.Type[NikonTiffReader]
    OBFReader: typing.Type[OBFReader]
    OIRReader: typing.Type[OIRReader]
    OMETiffReader: typing.Type[OMETiffReader]
    OMEXMLReader: typing.Type[OMEXMLReader]
    OpenlabRawReader: typing.Type[OpenlabRawReader]
    OpenlabReader: typing.Type[OpenlabReader]
    OperettaReader: typing.Type[OperettaReader]
    OxfordInstrumentsReader: typing.Type[OxfordInstrumentsReader]
    PCIReader: typing.Type[PCIReader]
    PCORAWReader: typing.Type[PCORAWReader]
    PCXReader: typing.Type[PCXReader]
    PDSReader: typing.Type[PDSReader]
    PGMReader: typing.Type[PGMReader]
    PQBinReader: typing.Type[PQBinReader]
    PSDReader: typing.Type[PSDReader]
    PerkinElmerReader: typing.Type[PerkinElmerReader]
    PhotoshopTiffReader: typing.Type[PhotoshopTiffReader]
    PictReader: typing.Type[PictReader]
    PovrayReader: typing.Type[PovrayReader]
    PrairieMetadata: typing.Type[PrairieMetadata]
    PrairieReader: typing.Type[PrairieReader]
    PyramidTiffReader: typing.Type[PyramidTiffReader]
    QTReader: typing.Type[QTReader]
    QuesantReader: typing.Type[QuesantReader]
    RCPNLReader: typing.Type[RCPNLReader]
    RHKReader: typing.Type[RHKReader]
    SBIGReader: typing.Type[SBIGReader]
    SDTInfo: typing.Type[SDTInfo]
    SDTReader: typing.Type[SDTReader]
    SEQReader: typing.Type[SEQReader]
    SIFReader: typing.Type[SIFReader]
    SISReader: typing.Type[SISReader]
    SMCameraReader: typing.Type[SMCameraReader]
    SPCReader: typing.Type[SPCReader]
    SPEReader: typing.Type[SPEReader]
    SVSReader: typing.Type[SVSReader]
    ScanrReader: typing.Type[ScanrReader]
    SeikoReader: typing.Type[SeikoReader]
    SimplePCITiffReader: typing.Type[SimplePCITiffReader]
    SlidebookReader: typing.Type[SlidebookReader]
    SlidebookTiffReader: typing.Type[SlidebookTiffReader]
    SpiderReader: typing.Type[SpiderReader]
    TCSReader: typing.Type[TCSReader]
    TargaReader: typing.Type[TargaReader]
    TecanReader: typing.Type[TecanReader]
    TextReader: typing.Type[TextReader]
    TiffDelegateReader: typing.Type[TiffDelegateReader]
    TiffJAIReader: typing.Type[TiffJAIReader]
    TiffReader: typing.Type[TiffReader]
    TileJPEGReader: typing.Type[TileJPEGReader]
    TillVisionReader: typing.Type[TillVisionReader]
    TopometrixReader: typing.Type[TopometrixReader]
    TrestleReader: typing.Type[TrestleReader]
    UBMReader: typing.Type[UBMReader]
    UnisokuReader: typing.Type[UnisokuReader]
    VGSAMReader: typing.Type[VGSAMReader]
    VarianFDFReader: typing.Type[VarianFDFReader]
    VectraReader: typing.Type[VectraReader]
    VeecoReader: typing.Type[VeecoReader]
    VentanaReader: typing.Type[VentanaReader]
    VisitechReader: typing.Type[VisitechReader]
    VolocityClippingReader: typing.Type[VolocityClippingReader]
    VolocityReader: typing.Type[VolocityReader]
    WATOPReader: typing.Type[WATOPReader]
    WlzReader: typing.Type[WlzReader]
    ZeissCZIReader: typing.Type[ZeissCZIReader]
    ZeissLMSReader: typing.Type[ZeissLMSReader]
    ZeissLSMReader: typing.Type[ZeissLSMReader]
    ZeissTIFFHandler: typing.Type[ZeissTIFFHandler]
    ZeissTIFFReader: typing.Type[ZeissTIFFReader]
    ZeissZVIReader: typing.Type[ZeissZVIReader]
    ZipReader: typing.Type[ZipReader]
