import java.lang
import bioformats_jar._loci.formats
import bioformats_jar._loci.formats.ome
import ome.xml.meta
import ome.xml.model
import ome.xml.model.primitives
import typing



class BaseMetadata(ome.xml.meta.BaseMetadata): ...

class IMinMaxStore:
    def setChannelGlobalMinMax(self, int: int, double: float, double2: float, int2: int) -> None: ...

class IPyramidStore:
    def getResolutionCount(self, int: int) -> int: ...
    def getResolutionSizeX(self, int: int, int2: int) -> ome.xml.model.primitives.PositiveInteger: ...
    def getResolutionSizeY(self, int: int, int2: int) -> ome.xml.model.primitives.PositiveInteger: ...
    def setResolutionSizeX(self, positiveInteger: ome.xml.model.primitives.PositiveInteger, int: int, int2: int) -> None: ...
    def setResolutionSizeY(self, positiveInteger: ome.xml.model.primitives.PositiveInteger, int: int, int2: int) -> None: ...

class MetadataConverter:
    @staticmethod
    def convertMetadata(metadataRetrieve: ome.xml.meta.MetadataRetrieve, metadataStore: ome.xml.meta.MetadataStore) -> None: ...

class MetadataRetrieve(ome.xml.meta.MetadataRetrieve): ...

class MetadataStore(ome.xml.meta.MetadataStore): ...

class ModuloAnnotation(ome.xml.model.XMLAnnotation):
    MODULO_NS: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def setModulo(self, oMEXMLMetadata: bioformats_jar._loci.formats.ome.OMEXMLMetadata, modulo: bioformats_jar._loci.formats.Modulo) -> None: ...

class OriginalMetadataAnnotation(ome.xml.model.XMLAnnotation):
    ORIGINAL_METADATA_NS: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def getKey(self) -> java.lang.String: ...
    def getValueForKey(self) -> java.lang.String: ...
    def setKeyValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...

class FilterMetadata(ome.xml.meta.FilterMetadata, MetadataStore):
    def __init__(self, metadataStore: MetadataStore, boolean: bool): ...

class IMetadata(ome.xml.meta.IMetadata, MetadataStore, MetadataRetrieve): ...

class DummyMetadata(ome.xml.meta.DummyMetadata, IMetadata):
    def __init__(self): ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.formats.meta")``.

    BaseMetadata: typing.Type[BaseMetadata]
    DummyMetadata: typing.Type[DummyMetadata]
    FilterMetadata: typing.Type[FilterMetadata]
    IMetadata: typing.Type[IMetadata]
    IMinMaxStore: typing.Type[IMinMaxStore]
    IPyramidStore: typing.Type[IPyramidStore]
    MetadataConverter: typing.Type[MetadataConverter]
    MetadataRetrieve: typing.Type[MetadataRetrieve]
    MetadataStore: typing.Type[MetadataStore]
    ModuloAnnotation: typing.Type[ModuloAnnotation]
    OriginalMetadataAnnotation: typing.Type[OriginalMetadataAnnotation]
