import ch.qos.logback.classic.spi
import ch.qos.logback.core
import ij
import ij.gui
import ij.process
import ij.text
import java.awt
import java.awt.event
import java.awt.image
import java.lang
import java.util
import javax.swing
import bioformats_jar._loci.formats
import bioformats_jar._loci.formats.cache
import bioformats_jar._loci.formats.gui
import bioformats_jar._loci.formats.meta
import typing



class BFVirtualStack(ij.VirtualStack):
    def __init__(self, string: typing.Union[java.lang.String, str], iFormatReader: bioformats_jar._loci.formats.IFormatReader, boolean: bool, boolean2: bool, boolean3: bool): ...
    def getCache(self) -> bioformats_jar._loci.formats.cache.Cache: ...
    def getHeight(self) -> int: ...
    def getMethodStack(self) -> java.util.List['RecordedImageProcessor.MethodEntry']: ...
    def getPath(self) -> java.lang.String: ...
    def getProcessor(self, int: int) -> ij.process.ImageProcessor: ...
    def getReader(self) -> 'ImageProcessorReader': ...
    def getRecordedProcessor(self) -> 'RecordedImageProcessor': ...
    def getSize(self) -> int: ...
    def getWidth(self) -> int: ...
    def setPlaneIndexes(self, intArray: typing.List[int]) -> None: ...

class BrowserOptionsWindow(javax.swing.JFrame):
    def __init__(self, string: typing.Union[java.lang.String, str], cache: bioformats_jar._loci.formats.cache.Cache, stringArray: typing.List[java.lang.String]): ...

class DataBrowser(ij.gui.StackWindow):
    @typing.overload
    def __init__(self, imagePlus: ij.ImagePlus): ...
    @typing.overload
    def __init__(self, imagePlus: ij.ImagePlus, imageCanvas: ij.gui.ImageCanvas, stringArray: typing.List[java.lang.String], intArray: typing.List[int]): ...
    @typing.overload
    def __init__(self, imagePlus: ij.ImagePlus, imageCanvas: ij.gui.ImageCanvas, stringArray: typing.List[java.lang.String], intArray: typing.List[int], xMLWindow: bioformats_jar._loci.formats.gui.XMLWindow): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def adjustmentValueChanged(self, adjustmentEvent: java.awt.event.AdjustmentEvent) -> None: ...
    def mouseWheelMoved(self, mouseWheelEvent: java.awt.event.MouseWheelEvent) -> None: ...
    def pack(self) -> None: ...
    def setVisible(self, boolean: bool) -> None: ...
    def setXML(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def showMetadataWindow(self) -> None: ...
    def showOptionsWindow(self) -> None: ...
    def toggleAnimation(self) -> None: ...

class IJStatusEchoer(ch.qos.logback.core.AppenderBase[ch.qos.logback.classic.spi.ILoggingEvent]):
    def __init__(self): ...

class ImageProcessorReader(loci.formats.ReaderWrapper):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatReader: bioformats_jar._loci.formats.IFormatReader): ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    @staticmethod
    def makeImageProcessorReader(iFormatReader: bioformats_jar._loci.formats.IFormatReader) -> 'ImageProcessorReader': ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...
    @typing.overload
    def openProcessors(self, int: int) -> typing.List[ij.process.ImageProcessor]: ...
    @typing.overload
    def openProcessors(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[ij.process.ImageProcessor]: ...
    def openThumbProcessors(self, int: int) -> typing.List[ij.process.ImageProcessor]: ...

class ImageProcessorSource(loci.formats.cache.ICacheSource):
    def __init__(self, iFormatReader: bioformats_jar._loci.formats.IFormatReader): ...
    def getObject(self, int: int) -> typing.Any: ...
    def getObjectCount(self) -> int: ...

class LibraryChecker:
    IMAGEJ_VERSION: typing.ClassVar[java.lang.String] = ...
    IMAGEJ_MSG: typing.ClassVar[java.lang.String] = ...
    URL_BF_SOFTWARE: typing.ClassVar[java.lang.String] = ...
    @staticmethod
    def checkClass(string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    @staticmethod
    def checkImageJ() -> bool: ...
    @typing.overload
    @staticmethod
    def checkImageJ(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    @staticmethod
    def checkImageJ(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> bool: ...
    @staticmethod
    def checkJava() -> bool: ...
    @typing.overload
    @staticmethod
    def checkLibrary(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], hashSet: java.util.HashSet[typing.Union[java.lang.String, str]]) -> None: ...
    @typing.overload
    @staticmethod
    def checkLibrary(library: 'LibraryChecker.Library', hashSet: java.util.HashSet[typing.Union[java.lang.String, str]]) -> None: ...
    @staticmethod
    def checkMissing(hashSet: java.util.HashSet[typing.Union[java.lang.String, str]]) -> bool: ...
    class Library(java.lang.Enum['LibraryChecker.Library']):
        BIO_FORMATS: typing.ClassVar['LibraryChecker.Library'] = ...
        OME_JAVA_XML: typing.ClassVar['LibraryChecker.Library'] = ...
        FORMS: typing.ClassVar['LibraryChecker.Library'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: typing.Union[java.lang.String, str]) -> 'LibraryChecker.Library': ...
        @staticmethod
        def values() -> typing.List['LibraryChecker.Library']: ...

class LociPrefs:
    PREF_READER_ENABLED: typing.ClassVar[java.lang.String] = ...
    PREF_READER_WINDOWLESS: typing.ClassVar[java.lang.String] = ...
    PREF_ND2_NIKON: typing.ClassVar[java.lang.String] = ...
    PREF_PICT_QTJAVA: typing.ClassVar[java.lang.String] = ...
    PREF_QT_QTJAVA: typing.ClassVar[java.lang.String] = ...
    PREF_SDT_INTENSITY: typing.ClassVar[java.lang.String] = ...
    PREF_TIFF_IMAGEIO: typing.ClassVar[java.lang.String] = ...
    PREF_CZI_AUTOSTITCH: typing.ClassVar[java.lang.String] = ...
    PREF_CZI_ATTACHMENT: typing.ClassVar[java.lang.String] = ...
    PREF_ND2_CHUNKMAP: typing.ClassVar[java.lang.String] = ...
    PREF_LEICA_LIF_PHYSICAL_SIZE: typing.ClassVar[java.lang.String] = ...
    PREF_SLICE_LABEL_PATTERN: typing.ClassVar[java.lang.String] = ...
    PREF_SLICE_LABEL_BASE_INDEX: typing.ClassVar[java.lang.String] = ...
    PREF_CELLSENS_FAIL: typing.ClassVar[java.lang.String] = ...
    @staticmethod
    def allowCZIAutostitch() -> bool: ...
    @staticmethod
    def getSliceLabelBaseIndex() -> int: ...
    @staticmethod
    def getSliceLabelPattern() -> java.lang.String: ...
    @staticmethod
    def includeCZIAttachments() -> bool: ...
    @staticmethod
    def isCellsensFailOnMissing() -> bool: ...
    @staticmethod
    def isLeicaLIFPhysicalSizeBackwardsCompatible() -> bool: ...
    @staticmethod
    def isND2Nikon() -> bool: ...
    @staticmethod
    def isPictQTJava() -> bool: ...
    @staticmethod
    def isQTQTJava() -> bool: ...
    @staticmethod
    def isReaderEnabled(class_: typing.Type[loci.formats.IFormatReader]) -> bool: ...
    @staticmethod
    def isSDTIntensity() -> bool: ...
    @staticmethod
    def isTiffImageIO() -> bool: ...
    @staticmethod
    def isWindowless(iFormatReader: bioformats_jar._loci.formats.IFormatReader) -> bool: ...
    @staticmethod
    def makeImageReader() -> bioformats_jar._loci.formats.ImageReader: ...
    @staticmethod
    def useND2Chunkmap() -> bool: ...

class LuraWave:
    MAX_TRIES: typing.ClassVar[int] = ...
    TOO_MANY_TRIES: typing.ClassVar[java.lang.String] = ...
    @staticmethod
    def initLicenseCode() -> java.lang.String: ...
    @staticmethod
    def isLicenseCodeException(formatException: bioformats_jar._loci.formats.FormatException) -> bool: ...
    @staticmethod
    def promptLicenseCode(string: typing.Union[java.lang.String, str], boolean: bool) -> java.lang.String: ...

class ROIHandler:
    def __init__(self): ...
    @typing.overload
    @staticmethod
    def openROIs(iMetadata: bioformats_jar._loci.formats.meta.IMetadata, imagePlusArray: typing.List[ij.ImagePlus]) -> None: ...
    @typing.overload
    @staticmethod
    def openROIs(iMetadata: bioformats_jar._loci.formats.meta.IMetadata, imagePlusArray: typing.List[ij.ImagePlus], boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def openROIs(iMetadata: bioformats_jar._loci.formats.meta.IMetadata, imagePlusArray: typing.List[ij.ImagePlus], boolean: bool, string: typing.Union[java.lang.String, str]) -> None: ...
    @staticmethod
    def readFromOverlays() -> typing.List[ij.gui.Roi]: ...
    @staticmethod
    def readFromRoiManager() -> typing.List[ij.gui.Roi]: ...
    @staticmethod
    def saveROIs(metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...

class RecordedImageProcessor(ij.process.ImageProcessor):
    @typing.overload
    def __init__(self, imageProcessor: ij.process.ImageProcessor): ...
    @typing.overload
    def __init__(self, imageProcessor: ij.process.ImageProcessor, int: int, imageProcessorArray: typing.List[ij.process.ImageProcessor]): ...
    def abs(self) -> None: ...
    @typing.overload
    def add(self, double: float) -> None: ...
    @typing.overload
    def add(self, int: int) -> None: ...
    def applyMethodStack(self, list: java.util.List['RecordedImageProcessor.MethodEntry']) -> None: ...
    def applyTable(self, intArray: typing.List[int]) -> None: ...
    def autoThreshold(self) -> None: ...
    def convertToByte(self, boolean: bool) -> ij.process.ImageProcessor: ...
    def convertToFloat(self) -> ij.process.ImageProcessor: ...
    def convertToRGB(self) -> ij.process.ImageProcessor: ...
    def convertToShort(self, boolean: bool) -> ij.process.ImageProcessor: ...
    def convolve(self, floatArray: typing.List[float], int: int, int2: int) -> None: ...
    def convolve3x3(self, intArray: typing.List[int]) -> None: ...
    def copyBits(self, imageProcessor: ij.process.ImageProcessor, int: int, int2: int, int3: int) -> None: ...
    def createImage(self) -> java.awt.Image: ...
    def createProcessor(self, int: int, int2: int) -> ij.process.ImageProcessor: ...
    def crop(self) -> ij.process.ImageProcessor: ...
    def dilate(self) -> None: ...
    def drawDot(self, int: int, int2: int) -> None: ...
    def drawLine(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def drawOval(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def drawPixel(self, int: int, int2: int) -> None: ...
    def drawPolygon(self, polygon: java.awt.Polygon) -> None: ...
    def drawRect(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @typing.overload
    def drawString(self, string: typing.Union[java.lang.String, str], int: int, int2: int, color: java.awt.Color) -> None: ...
    @typing.overload
    def drawString(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def drawString(self, string: typing.Union[java.lang.String, str], int: int, int2: int) -> None: ...
    def duplicate(self) -> ij.process.ImageProcessor: ...
    def erode(self) -> None: ...
    def exp(self) -> None: ...
    @typing.overload
    def fill(self, roi: ij.gui.Roi) -> None: ...
    @typing.overload
    def fill(self) -> None: ...
    @typing.overload
    def fill(self, imageProcessor: ij.process.ImageProcessor) -> None: ...
    def fillOval(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def fillPolygon(self, polygon: java.awt.Polygon) -> None: ...
    def filter(self, int: int) -> None: ...
    def findEdges(self) -> None: ...
    def flipHorizontal(self) -> None: ...
    def flipVertical(self) -> None: ...
    def gamma(self, double: float) -> None: ...
    @typing.overload
    def get(self, int: int) -> int: ...
    @typing.overload
    def get(self, int: int, int2: int) -> int: ...
    @typing.overload
    def getAutoThreshold(self) -> int: ...
    @typing.overload
    def getAutoThreshold(self, intArray: typing.List[int]) -> int: ...
    def getBackgroundValue(self) -> float: ...
    def getBestIndex(self, color: java.awt.Color) -> int: ...
    def getBufferedImage(self) -> java.awt.image.BufferedImage: ...
    def getCalibrationTable(self) -> typing.List[float]: ...
    def getChild(self) -> ij.process.ImageProcessor: ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    def getColumn(self, int: int, int2: int, intArray: typing.List[int], int4: int) -> None: ...
    def getCurrentColorModel(self) -> java.awt.image.ColorModel: ...
    def getDefaultColorModel(self) -> java.awt.image.IndexColorModel: ...
    def getFloatArray(self) -> typing.List[typing.List[float]]: ...
    def getFontMetrics(self) -> java.awt.FontMetrics: ...
    def getHeight(self) -> int: ...
    @typing.overload
    def getHistogram(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def getHistogram(self) -> typing.List[int]: ...
    def getHistogramMax(self) -> float: ...
    def getHistogramMin(self) -> float: ...
    def getHistogramSize(self) -> int: ...
    def getIntArray(self) -> typing.List[typing.List[int]]: ...
    def getInterpolate(self) -> bool: ...
    def getInterpolatedPixel(self, double: float, double2: float) -> float: ...
    def getLine(self, double: float, double2: float, double3: float, double4: float) -> typing.List[float]: ...
    def getLutUpdateMode(self) -> int: ...
    def getMask(self) -> ij.process.ImageProcessor: ...
    def getMaskArray(self) -> typing.List[int]: ...
    def getMax(self) -> float: ...
    def getMaxThreshold(self) -> float: ...
    def getMethodStack(self) -> java.util.List['RecordedImageProcessor.MethodEntry']: ...
    def getMin(self) -> float: ...
    def getMinThreshold(self) -> float: ...
    def getNChannels(self) -> int: ...
    @typing.overload
    def getPixel(self, int: int, int2: int) -> int: ...
    @typing.overload
    def getPixel(self, int: int, int2: int, intArray: typing.List[int]) -> typing.List[int]: ...
    def getPixelCount(self) -> int: ...
    def getPixelInterpolated(self, double: float, double2: float) -> int: ...
    def getPixelValue(self, int: int, int2: int) -> float: ...
    def getPixels(self) -> typing.Any: ...
    def getPixelsCopy(self) -> typing.Any: ...
    def getRoi(self) -> java.awt.Rectangle: ...
    @typing.overload
    def getRow(self, int: int, int2: int, floatArray: typing.List[float], int3: int) -> typing.List[float]: ...
    @typing.overload
    def getRow(self, int: int, int2: int, intArray: typing.List[int], int4: int) -> None: ...
    def getSnapshotPixels(self) -> typing.Any: ...
    def getStringWidth(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getWidth(self) -> int: ...
    @typing.overload
    def getf(self, int: int) -> float: ...
    @typing.overload
    def getf(self, int: int, int2: int) -> float: ...
    def insert(self, imageProcessor: ij.process.ImageProcessor, int: int, int2: int) -> None: ...
    def invert(self) -> None: ...
    def invertLut(self) -> None: ...
    def isColorLut(self) -> bool: ...
    def isInvertedLut(self) -> bool: ...
    def isPseudoColorLut(self) -> bool: ...
    def lineTo(self, int: int, int2: int) -> None: ...
    def log(self) -> None: ...
    def max(self, double: float) -> None: ...
    def maxValue(self) -> float: ...
    def medianFilter(self) -> None: ...
    def min(self, double: float) -> None: ...
    def minValue(self) -> float: ...
    def moveTo(self, int: int, int2: int) -> None: ...
    def multiply(self, double: float) -> None: ...
    def noise(self, double: float) -> None: ...
    def putColumn(self, int: int, int2: int, intArray: typing.List[int], int4: int) -> None: ...
    @typing.overload
    def putPixel(self, int: int, int2: int, int3: int) -> None: ...
    @typing.overload
    def putPixel(self, int: int, int2: int, intArray: typing.List[int]) -> None: ...
    def putPixelValue(self, int: int, int2: int, double: float) -> None: ...
    @typing.overload
    def putRow(self, int: int, int2: int, floatArray: typing.List[float], int3: int) -> None: ...
    @typing.overload
    def putRow(self, int: int, int2: int, intArray: typing.List[int], int4: int) -> None: ...
    @typing.overload
    def reset(self) -> None: ...
    @typing.overload
    def reset(self, imageProcessor: ij.process.ImageProcessor) -> None: ...
    def resetBinaryThreshold(self) -> None: ...
    def resetMinAndMax(self) -> None: ...
    def resetRoi(self) -> None: ...
    def resetThreshold(self) -> None: ...
    @typing.overload
    def resize(self, int: int, int2: int, boolean: bool) -> ij.process.ImageProcessor: ...
    @typing.overload
    def resize(self, int: int) -> ij.process.ImageProcessor: ...
    @typing.overload
    def resize(self, int: int, int2: int) -> ij.process.ImageProcessor: ...
    def rotate(self, double: float) -> None: ...
    def rotateLeft(self) -> ij.process.ImageProcessor: ...
    def rotateRight(self) -> ij.process.ImageProcessor: ...
    def scale(self, double: float, double2: float) -> None: ...
    @typing.overload
    def set(self, double: float) -> None: ...
    @typing.overload
    def set(self, int: int, int2: int) -> None: ...
    @typing.overload
    def set(self, int: int, int2: int, int3: int) -> None: ...
    def setAntialiasedText(self, boolean: bool) -> None: ...
    @typing.overload
    def setAutoThreshold(self, method: ij.process.AutoThresholder.Method, boolean: bool) -> None: ...
    @typing.overload
    def setAutoThreshold(self, method: ij.process.AutoThresholder.Method, boolean: bool, int: int) -> None: ...
    @typing.overload
    def setAutoThreshold(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setAutoThreshold(self, string: typing.Union[java.lang.String, str], boolean: bool, int: int) -> None: ...
    @typing.overload
    def setAutoThreshold(self, int: int, int2: int) -> None: ...
    def setBackgroundValue(self, double: float) -> None: ...
    def setCalibrationTable(self, floatArray: typing.List[float]) -> None: ...
    def setClipRect(self, rectangle: java.awt.Rectangle) -> None: ...
    @typing.overload
    def setColor(self, double: float) -> None: ...
    @typing.overload
    def setColor(self, int: int) -> None: ...
    @typing.overload
    def setColor(self, color: java.awt.Color) -> None: ...
    def setColorModel(self, colorModel: java.awt.image.ColorModel) -> None: ...
    def setDoRecording(self, boolean: bool) -> None: ...
    def setFloatArray(self, floatArray: typing.List[typing.List[float]]) -> None: ...
    def setFont(self, font: java.awt.Font) -> None: ...
    def setHistogramRange(self, double: float, double2: float) -> None: ...
    def setHistogramSize(self, int: int) -> None: ...
    def setIntArray(self, intArray: typing.List[typing.List[int]]) -> None: ...
    def setInterpolate(self, boolean: bool) -> None: ...
    def setJustification(self, int: int) -> None: ...
    def setLineWidth(self, int: int) -> None: ...
    def setLutAnimation(self, boolean: bool) -> None: ...
    def setMask(self, imageProcessor: ij.process.ImageProcessor) -> None: ...
    def setMinAndMax(self, double: float, double2: float) -> None: ...
    @typing.overload
    def setPixels(self, int: int, floatProcessor: ij.process.FloatProcessor) -> None: ...
    @typing.overload
    def setPixels(self, object: typing.Any) -> None: ...
    def setProgressBar(self, progressBar: ij.gui.ProgressBar) -> None: ...
    @typing.overload
    def setRoi(self, roi: ij.gui.Roi) -> None: ...
    @typing.overload
    def setRoi(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @typing.overload
    def setRoi(self, polygon: java.awt.Polygon) -> None: ...
    @typing.overload
    def setRoi(self, rectangle: java.awt.Rectangle) -> None: ...
    def setSnapshotCopyMode(self, boolean: bool) -> None: ...
    def setSnapshotPixels(self, object: typing.Any) -> None: ...
    def setThreshold(self, double: float, double2: float, int: int) -> None: ...
    def setValue(self, double: float) -> None: ...
    @typing.overload
    def setf(self, int: int, float: float) -> None: ...
    @typing.overload
    def setf(self, int: int, int2: int, float: float) -> None: ...
    def sharpen(self) -> None: ...
    def smooth(self) -> None: ...
    def snapshot(self) -> None: ...
    def sqr(self) -> None: ...
    def sqrt(self) -> None: ...
    def swapPixelArrays(self) -> None: ...
    def threshold(self, int: int) -> None: ...
    def toFloat(self, int: int, floatProcessor: ij.process.FloatProcessor) -> ij.process.FloatProcessor: ...
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def translate(self, double: float, double2: float) -> None: ...
    @typing.overload
    def translate(self, int: int, int2: int, boolean: bool) -> None: ...
    @typing.overload
    def translate(self, int: int, int2: int) -> None: ...
    def updateComposite(self, intArray: typing.List[int], int2: int) -> None: ...
    def xor(self, int: int) -> None: ...
    class MethodEntry: ...

class SearchableWindow(ij.text.TextWindow):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], int: int, int2: int): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def selectLine(self, int: int) -> None: ...

class VirtualImagePlus(ij.ImagePlus):
    def __init__(self, string: typing.Union[java.lang.String, str], imageStack: ij.ImageStack): ...
    def close(self) -> None: ...
    @typing.overload
    def getStatistics(self) -> ij.process.ImageStatistics: ...
    @typing.overload
    def getStatistics(self, int: int) -> ij.process.ImageStatistics: ...
    @typing.overload
    def getStatistics(self, int: int, int2: int) -> ij.process.ImageStatistics: ...
    @typing.overload
    def getStatistics(self, int: int, int2: int, double: float, double2: float) -> ij.process.ImageStatistics: ...
    def setLUTs(self, lUTArray: typing.List[ij.process.LUT]) -> None: ...
    def setReader(self, iFormatReader: bioformats_jar._loci.formats.IFormatReader) -> None: ...
    def setSlice(self, int: int) -> None: ...

class VirtualReader(loci.formats.ReaderWrapper):
    def __init__(self, iFormatReader: bioformats_jar._loci.formats.IFormatReader): ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def close(self) -> None: ...
    def setRefCount(self, int: int) -> None: ...

class WindowTools:
    @staticmethod
    def addScrollBars(container: java.awt.Container) -> None: ...
    @staticmethod
    def getCheckboxes(genericDialog: ij.gui.GenericDialog) -> java.util.List[java.awt.Checkbox]: ...
    @staticmethod
    def getChoices(genericDialog: ij.gui.GenericDialog) -> java.util.List[java.awt.Choice]: ...
    @staticmethod
    def getNumericFields(genericDialog: ij.gui.GenericDialog) -> java.util.List[java.awt.TextField]: ...
    @staticmethod
    def placeWindow(window: java.awt.Window) -> None: ...
    @typing.overload
    @staticmethod
    def reportException(throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    @staticmethod
    def reportException(throwable: java.lang.Throwable, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def reportException(throwable: java.lang.Throwable, boolean: bool, string: typing.Union[java.lang.String, str]) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.plugins.util")``.

    BFVirtualStack: typing.Type[BFVirtualStack]
    BrowserOptionsWindow: typing.Type[BrowserOptionsWindow]
    DataBrowser: typing.Type[DataBrowser]
    IJStatusEchoer: typing.Type[IJStatusEchoer]
    ImageProcessorReader: typing.Type[ImageProcessorReader]
    ImageProcessorSource: typing.Type[ImageProcessorSource]
    LibraryChecker: typing.Type[LibraryChecker]
    LociPrefs: typing.Type[LociPrefs]
    LuraWave: typing.Type[LuraWave]
    ROIHandler: typing.Type[ROIHandler]
    RecordedImageProcessor: typing.Type[RecordedImageProcessor]
    SearchableWindow: typing.Type[SearchableWindow]
    VirtualImagePlus: typing.Type[VirtualImagePlus]
    VirtualReader: typing.Type[VirtualReader]
    WindowTools: typing.Type[WindowTools]
