import java.io
import java.lang
import java.util
import bioformats_jar._loci.poi.hpsf
import bioformats_jar._loci.poi.poifs.dev
import bioformats_jar._loci.poi.poifs.filesystem
import bioformats_jar._loci.poi.poifs.storage
import typing



class Child:
    def getNextChild(self) -> 'Child': ...
    def getPreviousChild(self) -> 'Child': ...
    def setNextChild(self, child: 'Child') -> None: ...
    def setPreviousChild(self, child: 'Child') -> None: ...

class PropertyConstants:
    PROPERTY_TYPE_OFFSET: typing.ClassVar[int] = ...
    DIRECTORY_TYPE: typing.ClassVar[int] = ...
    DOCUMENT_TYPE: typing.ClassVar[int] = ...
    ROOT_TYPE: typing.ClassVar[int] = ...

class PropertyTable(loci.poi.poifs.filesystem.BATManaged, bioformats_jar._loci.poi.poifs.storage.BlockWritable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int, rawDataBlockList: bioformats_jar._loci.poi.poifs.storage.RawDataBlockList): ...
    def addProperty(self, property: 'Property') -> None: ...
    def countBlocks(self) -> int: ...
    def getRoot(self) -> 'RootProperty': ...
    def getStartBlock(self) -> int: ...
    def preWrite(self) -> None: ...
    def removeProperty(self, property: 'Property') -> None: ...
    def setStartBlock(self, int: int) -> None: ...
    def writeBlocks(self, outputStream: java.io.OutputStream) -> None: ...

class Parent(Child):
    def addChild(self, property: 'Property') -> None: ...
    def getChildren(self) -> java.util.Iterator: ...
    def setNextChild(self, child: Child) -> None: ...
    def setPreviousChild(self, child: Child) -> None: ...

class Property(Child, bioformats_jar._loci.poi.poifs.dev.POIFSViewable):
    def getName(self) -> java.lang.String: ...
    def getNextChild(self) -> Child: ...
    def getPreviousChild(self) -> Child: ...
    def getShortDescription(self) -> java.lang.String: ...
    def getSize(self) -> int: ...
    def getStartBlock(self) -> int: ...
    def getStorageClsid(self) -> bioformats_jar._loci.poi.hpsf.ClassID: ...
    def getViewableArray(self) -> typing.List[typing.Any]: ...
    def getViewableIterator(self) -> java.util.Iterator: ...
    def isDirectory(self) -> bool: ...
    @staticmethod
    def isSmall(int: int) -> bool: ...
    def preferArray(self) -> bool: ...
    def setNextChild(self, child: Child) -> None: ...
    def setPreviousChild(self, child: Child) -> None: ...
    def setStartBlock(self, int: int) -> None: ...
    def setStorageClsid(self, classID: bioformats_jar._loci.poi.hpsf.ClassID) -> None: ...
    def shouldUseSmallBlocks(self) -> bool: ...
    def writeData(self, outputStream: java.io.OutputStream) -> None: ...

class DirectoryProperty(Property, Parent):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addChild(self, property: Property) -> None: ...
    def changeName(self, property: Property, string: typing.Union[java.lang.String, str]) -> bool: ...
    def deleteChild(self, property: Property) -> bool: ...
    def getChildren(self) -> java.util.Iterator: ...
    def isDirectory(self) -> bool: ...
    class PropertyComparator(java.util.Comparator):
        def __init__(self): ...
        def compare(self, object: typing.Any, object2: typing.Any) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...

class DocumentProperty(Property):
    def __init__(self, string: typing.Union[java.lang.String, str], int: int): ...
    def getDocument(self) -> bioformats_jar._loci.poi.poifs.filesystem.POIFSDocument: ...
    def isDirectory(self) -> bool: ...
    def setDocument(self, pOIFSDocument: bioformats_jar._loci.poi.poifs.filesystem.POIFSDocument) -> None: ...
    def shouldUseSmallBlocks(self) -> bool: ...

class RootProperty(DirectoryProperty):
    def setSize(self, int: int) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.poi.poifs.property")``.

    Child: typing.Type[Child]
    DirectoryProperty: typing.Type[DirectoryProperty]
    DocumentProperty: typing.Type[DocumentProperty]
    Parent: typing.Type[Parent]
    Property: typing.Type[Property]
    PropertyConstants: typing.Type[PropertyConstants]
    PropertyTable: typing.Type[PropertyTable]
    RootProperty: typing.Type[RootProperty]
