import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeParametersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/parameters#id DataSnowflakeParameters#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If parameter_type is set to "OBJECT" then object_name is the name of the object to display object parameters for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/parameters#object_name DataSnowflakeParameters#object_name}
    */
    readonly objectName?: string;
    /**
    * If parameter_type is set to "OBJECT" then object_type is the type of object to display object parameters for. Valid values are any object supported by the IN clause of the [SHOW PARAMETERS](https://docs.snowflake.com/en/sql-reference/sql/show-parameters.html#parameters) statement, including: WAREHOUSE | DATABASE | SCHEMA | TASK | TABLE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/parameters#object_type DataSnowflakeParameters#object_type}
    */
    readonly objectType?: string;
    /**
    * The type of parameter to filter by. Valid values are: "ACCOUNT", "SESSION", "OBJECT".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/parameters#parameter_type DataSnowflakeParameters#parameter_type}
    */
    readonly parameterType?: string;
    /**
    * Allows limiting the list of parameters by name using LIKE clause. Refer to [Limiting the List of Parameters by Name](https://docs.snowflake.com/en/sql-reference/parameters.html#limiting-the-list-of-parameters-by-name)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/parameters#pattern DataSnowflakeParameters#pattern}
    */
    readonly pattern?: string;
}
export interface DataSnowflakeParametersParameters {
}
export declare function dataSnowflakeParametersParametersToTerraform(struct?: DataSnowflakeParametersParameters): any;
export declare class DataSnowflakeParametersParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeParametersParameters | undefined;
    set internalValue(value: DataSnowflakeParametersParameters | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get type(): string;
    get value(): string;
}
export declare class DataSnowflakeParametersParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeParametersParametersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/parameters snowflake_parameters}
*/
export declare class DataSnowflakeParameters extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_parameters";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/parameters snowflake_parameters} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeParametersConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeParametersConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _objectName?;
    get objectName(): string;
    set objectName(value: string);
    resetObjectName(): void;
    get objectNameInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    resetObjectType(): void;
    get objectTypeInput(): string | undefined;
    private _parameterType?;
    get parameterType(): string;
    set parameterType(value: string);
    resetParameterType(): void;
    get parameterTypeInput(): string | undefined;
    private _parameters;
    get parameters(): DataSnowflakeParametersParametersList;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
