import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SnowflakeProviderConfig {
    /**
    * The name of the Snowflake account. Can also come from the `SNOWFLAKE_ACCOUNT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#account SnowflakeProvider#account}
    */
    readonly account: string;
    /**
    * Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_USE_BROWSER_AUTH` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#browser_auth SnowflakeProvider#browser_auth}
    */
    readonly browserAuth?: boolean | cdktf.IResolvable;
    /**
    * Supports passing in a custom host value to the snowflake go driver for use with privatelink.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#host SnowflakeProvider#host}
    */
    readonly host?: string;
    /**
    * Token for use with OAuth. Generating the token is left to other tools. Cannot be used with `browser_auth`, `private_key_path`, `oauth_refresh_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_ACCESS_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_access_token SnowflakeProvider#oauth_access_token}
    */
    readonly oauthAccessToken?: string;
    /**
    * Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_client_id SnowflakeProvider#oauth_client_id}
    */
    readonly oauthClientId?: string;
    /**
    * Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_client_secret SnowflakeProvider#oauth_client_secret}
    */
    readonly oauthClientSecret?: string;
    /**
    * Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_ENDPOINT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_endpoint SnowflakeProvider#oauth_endpoint}
    */
    readonly oauthEndpoint?: string;
    /**
    * Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_REDIRECT_URL` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_redirect_url SnowflakeProvider#oauth_redirect_url}
    */
    readonly oauthRedirectUrl?: string;
    /**
    * Token for use with OAuth. Setup and generation of the token is left to other tools. Should be used in conjunction with `oauth_client_id`, `oauth_client_secret`, `oauth_endpoint`, `oauth_redirect_url`. Cannot be used with `browser_auth`, `private_key_path`, `oauth_access_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_REFRESH_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_refresh_token SnowflakeProvider#oauth_refresh_token}
    */
    readonly oauthRefreshToken?: string;
    /**
    * Password for username+password auth. Cannot be used with `browser_auth` or `private_key_path`. Can be sourced from `SNOWFLAKE_PASSWORD` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#password SnowflakeProvider#password}
    */
    readonly password?: string;
    /**
    * Support custom port values to snowflake go driver for use with privatelink. Can be sourced from `SNOWFLAKE_PORT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#port SnowflakeProvider#port}
    */
    readonly port?: number;
    /**
    * Private Key for username+private-key auth. Cannot be used with `browser_auth` or `password`. Can be sourced from `SNOWFLAKE_PRIVATE_KEY` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#private_key SnowflakeProvider#private_key}
    */
    readonly privateKey?: string;
    /**
    * Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and des-ede3-cbc
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#private_key_passphrase SnowflakeProvider#private_key_passphrase}
    */
    readonly privateKeyPassphrase?: string;
    /**
    * Path to a private key for using keypair authentication. Cannot be used with `browser_auth`, `oauth_access_token` or `password`. Can be sourced from `SNOWFLAKE_PRIVATE_KEY_PATH` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#private_key_path SnowflakeProvider#private_key_path}
    */
    readonly privateKeyPath?: string;
    /**
    * Support custom protocols to snowflake go driver. Can be sourced from `SNOWFLAKE_PROTOCOL` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#protocol SnowflakeProvider#protocol}
    */
    readonly protocol?: string;
    /**
    * [Snowflake region](https://docs.snowflake.com/en/user-guide/intro-regions.html) to use.  Required if using the [legacy format for the `account` identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#format-2-legacy-account-locator-in-a-region) in the form of `<cloud_region_id>.<cloud>`. Can be sourced from the `SNOWFLAKE_REGION` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#region SnowflakeProvider#region}
    */
    readonly region?: string;
    /**
    * Snowflake role to use for operations. If left unset, default role for user will be used. Can be sourced from the `SNOWFLAKE_ROLE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#role SnowflakeProvider#role}
    */
    readonly role?: string;
    /**
    * Username for username+password authentication. Can come from the `SNOWFLAKE_USER` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#username SnowflakeProvider#username}
    */
    readonly username: string;
    /**
    * Sets the default warehouse. Optional. Can be sourced from SNOWFLAKE_WAREHOUSE environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#warehouse SnowflakeProvider#warehouse}
    */
    readonly warehouse?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#alias SnowflakeProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake snowflake}
*/
export declare class SnowflakeProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "snowflake";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake snowflake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnowflakeProviderConfig
    */
    constructor(scope: Construct, id: string, config: SnowflakeProviderConfig);
    private _account?;
    get account(): string | undefined;
    set account(value: string | undefined);
    get accountInput(): string | undefined;
    private _browserAuth?;
    get browserAuth(): boolean | cdktf.IResolvable | undefined;
    set browserAuth(value: boolean | cdktf.IResolvable | undefined);
    resetBrowserAuth(): void;
    get browserAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _oauthAccessToken?;
    get oauthAccessToken(): string | undefined;
    set oauthAccessToken(value: string | undefined);
    resetOauthAccessToken(): void;
    get oauthAccessTokenInput(): string | undefined;
    private _oauthClientId?;
    get oauthClientId(): string | undefined;
    set oauthClientId(value: string | undefined);
    resetOauthClientId(): void;
    get oauthClientIdInput(): string | undefined;
    private _oauthClientSecret?;
    get oauthClientSecret(): string | undefined;
    set oauthClientSecret(value: string | undefined);
    resetOauthClientSecret(): void;
    get oauthClientSecretInput(): string | undefined;
    private _oauthEndpoint?;
    get oauthEndpoint(): string | undefined;
    set oauthEndpoint(value: string | undefined);
    resetOauthEndpoint(): void;
    get oauthEndpointInput(): string | undefined;
    private _oauthRedirectUrl?;
    get oauthRedirectUrl(): string | undefined;
    set oauthRedirectUrl(value: string | undefined);
    resetOauthRedirectUrl(): void;
    get oauthRedirectUrlInput(): string | undefined;
    private _oauthRefreshToken?;
    get oauthRefreshToken(): string | undefined;
    set oauthRefreshToken(value: string | undefined);
    resetOauthRefreshToken(): void;
    get oauthRefreshTokenInput(): string | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _privateKey?;
    get privateKey(): string | undefined;
    set privateKey(value: string | undefined);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _privateKeyPassphrase?;
    get privateKeyPassphrase(): string | undefined;
    set privateKeyPassphrase(value: string | undefined);
    resetPrivateKeyPassphrase(): void;
    get privateKeyPassphraseInput(): string | undefined;
    private _privateKeyPath?;
    get privateKeyPath(): string | undefined;
    set privateKeyPath(value: string | undefined);
    resetPrivateKeyPath(): void;
    get privateKeyPathInput(): string | undefined;
    private _protocol?;
    get protocol(): string | undefined;
    set protocol(value: string | undefined);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _role?;
    get role(): string | undefined;
    set role(value: string | undefined);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    get usernameInput(): string | undefined;
    private _warehouse?;
    get warehouse(): string | undefined;
    set warehouse(value: string | undefined);
    resetWarehouse(): void;
    get warehouseInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
