# mypy-boto3-iotanalytics

[![PyPI - mypy-boto3-iotanalytics](https://img.shields.io/pypi/v/mypy-boto3-iotanalytics.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotanalytics)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iotanalytics.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotanalytics)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.IoTAnalytics 1.14.52](https://boto3.amazonaws.com/v1/documentation/api/1.14.52/reference/services/iotanalytics.html#IoTAnalytics) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `IoTAnalytics` service.

```bash
python -m pip install boto3-stubs[iotanalytics]
```

## How to use

### Client annotations

`IoTAnalyticsClient` provides annotations for `boto3.client("iotanalytics")`.

```python
import boto3

from mypy_boto3_iotanalytics import IoTAnalyticsClient
from mypy_boto3_iotanalytics.paginator import (
    ListChannelsPaginator,
    ListDatasetContentsPaginator,
    ListDatasetsPaginator,
    ListDatastoresPaginator,
    ListPipelinesPaginator,
)
from mypy_boto3_iotanalytics.type_defs import AddAttributesActivityTypeDef, ...

client: IoTAnalyticsClient = boto3.client("iotanalytics")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoTAnalyticsClient = session.client("iotanalytics")
```

### Paginators annotations

`mypy_boto3_iotanalytics.paginator` module contains type annotations for all paginators.

```python

client: IoTAnalyticsClient = boto3.client("iotanalytics")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_channels_paginator: ListChannelsPaginator = client.get_paginator("list_channels")
list_dataset_contents_paginator: ListDatasetContentsPaginator = client.get_paginator("list_dataset_contents")
list_datasets_paginator: ListDatasetsPaginator = client.get_paginator("list_datasets")
list_datastores_paginator: ListDatastoresPaginator = client.get_paginator("list_datastores")
list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
```







### Typed dictionations

`mypy_boto3_iotanalytics.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AddAttributesActivityTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_iotanalytics` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("iotanalytics")

session_client = boto3.Session().client("iotanalytics")
```
