# Generated by Django 3.0.3 on 2020-03-22 13:38

from django.conf import settings
import django.contrib.auth.validators
import django.core.files.storage
import django.core.validators
from django.db import migrations, models
import django.utils.timezone
import phonenumber_field.modelfields
import precise_bbcode.fields

import db.models
import db.validators
import editorjs.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='Member',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False,
                                                     help_text='Designates that this user has all permissions without explicitly assigning them.',
                                                     verbose_name='superuser status')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'},
                                              help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.',
                                              max_length=150, unique=True,
                                              validators=[django.contrib.auth.validators.UnicodeUsernameValidator()],
                                              verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('date_of_birth', models.DateField()),
                ('is_staff', models.BooleanField(default=False,
                                                 help_text='Designates whether the user can log into this admin site.',
                                                 verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True,
                                                  help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.',
                                                  verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('avatar', models.ImageField(storage=django.core.files.storage.FileSystemStorage,
                                             upload_to=db.models.Member.member_avatar_path, verbose_name='avatar')),
                ('web_site', models.URLField(max_length=2048, verbose_name='web site')),
                ('gender', models.CharField(max_length=1, verbose_name='gender')),
                ('occupation', models.CharField(max_length=255, verbose_name='occupation')),
                ('phone_number', phonenumber_field.modelfields.PhoneNumberField(blank=True, max_length=128, region=None,
                                                                                verbose_name='phone number')),
                ('privilege_start_date', models.DateField(null=True, verbose_name='privilege start date')),
                ('postal_address', models.CharField(max_length=1024, verbose_name='postal address')),
                ('postal_address_2', models.CharField(max_length=1024, verbose_name='postal address 2')),
                ('postal_city', models.CharField(max_length=200, verbose_name='postal city')),
                ('postal_code', models.CharField(max_length=20, verbose_name='postal code')),
                ('language', models.CharField(max_length=2, verbose_name='language')),
                ('locked', models.BooleanField(default=False, verbose_name='locked')),
                ('theme', models.CharField(
                    choices=[('muses_default', 'Default'), ('muses_classic', 'Classic'), ('muses_rose', 'Rose'),
                             ('muses_blue', 'Blue'), ('muses_green', 'Green'), ('muses_orange', 'Orange')],
                    default='muses_default', max_length=30, verbose_name='theme')),
                ('connections_counter', models.IntegerField(default=0, verbose_name='connections counter')),
                ('page_views_counter', models.IntegerField(default=0, verbose_name='page views counter')),
                ('email_notification_on_new_comment',
                 models.BooleanField(default=False, verbose_name='email notification on new comment')),
                ('email_notification_on_new_message',
                 models.BooleanField(default=False, verbose_name='email notification on new message')),
                ('mailbox_collapsing', models.BooleanField(default=False, verbose_name='mailbox collapsing')),
                ('mailbox_blocked', models.BooleanField(default=False, verbose_name='mailbox blocked')),
                ('tz_name', models.CharField(
                    choices=[('Africa/Abidjan', 'Africa/Abidjan'), ('Africa/Accra', 'Africa/Accra'),
                             ('Africa/Addis_Ababa', 'Africa/Addis_Ababa'), ('Africa/Algiers', 'Africa/Algiers'),
                             ('Africa/Asmara', 'Africa/Asmara'), ('Africa/Asmera', 'Africa/Asmera'),
                             ('Africa/Bamako', 'Africa/Bamako'), ('Africa/Bangui', 'Africa/Bangui'),
                             ('Africa/Banjul', 'Africa/Banjul'), ('Africa/Bissau', 'Africa/Bissau'),
                             ('Africa/Blantyre', 'Africa/Blantyre'), ('Africa/Brazzaville', 'Africa/Brazzaville'),
                             ('Africa/Bujumbura', 'Africa/Bujumbura'), ('Africa/Cairo', 'Africa/Cairo'),
                             ('Africa/Casablanca', 'Africa/Casablanca'), ('Africa/Ceuta', 'Africa/Ceuta'),
                             ('Africa/Conakry', 'Africa/Conakry'), ('Africa/Dakar', 'Africa/Dakar'),
                             ('Africa/Dar_es_Salaam', 'Africa/Dar_es_Salaam'), ('Africa/Djibouti', 'Africa/Djibouti'),
                             ('Africa/Douala', 'Africa/Douala'), ('Africa/El_Aaiun', 'Africa/El_Aaiun'),
                             ('Africa/Freetown', 'Africa/Freetown'), ('Africa/Gaborone', 'Africa/Gaborone'),
                             ('Africa/Harare', 'Africa/Harare'), ('Africa/Johannesburg', 'Africa/Johannesburg'),
                             ('Africa/Juba', 'Africa/Juba'), ('Africa/Kampala', 'Africa/Kampala'),
                             ('Africa/Khartoum', 'Africa/Khartoum'), ('Africa/Kigali', 'Africa/Kigali'),
                             ('Africa/Kinshasa', 'Africa/Kinshasa'), ('Africa/Lagos', 'Africa/Lagos'),
                             ('Africa/Libreville', 'Africa/Libreville'), ('Africa/Lome', 'Africa/Lome'),
                             ('Africa/Luanda', 'Africa/Luanda'), ('Africa/Lubumbashi', 'Africa/Lubumbashi'),
                             ('Africa/Lusaka', 'Africa/Lusaka'), ('Africa/Malabo', 'Africa/Malabo'),
                             ('Africa/Maputo', 'Africa/Maputo'), ('Africa/Maseru', 'Africa/Maseru'),
                             ('Africa/Mbabane', 'Africa/Mbabane'), ('Africa/Mogadishu', 'Africa/Mogadishu'),
                             ('Africa/Monrovia', 'Africa/Monrovia'), ('Africa/Nairobi', 'Africa/Nairobi'),
                             ('Africa/Ndjamena', 'Africa/Ndjamena'), ('Africa/Niamey', 'Africa/Niamey'),
                             ('Africa/Nouakchott', 'Africa/Nouakchott'), ('Africa/Ouagadougou', 'Africa/Ouagadougou'),
                             ('Africa/Porto-Novo', 'Africa/Porto-Novo'), ('Africa/Sao_Tome', 'Africa/Sao_Tome'),
                             ('Africa/Timbuktu', 'Africa/Timbuktu'), ('Africa/Tripoli', 'Africa/Tripoli'),
                             ('Africa/Tunis', 'Africa/Tunis'), ('Africa/Windhoek', 'Africa/Windhoek'),
                             ('America/Adak', 'America/Adak'), ('America/Anchorage', 'America/Anchorage'),
                             ('America/Anguilla', 'America/Anguilla'), ('America/Antigua', 'America/Antigua'),
                             ('America/Araguaina', 'America/Araguaina'),
                             ('America/Argentina/Buenos_Aires', 'America/Argentina/Buenos_Aires'),
                             ('America/Argentina/Catamarca', 'America/Argentina/Catamarca'),
                             ('America/Argentina/ComodRivadavia', 'America/Argentina/ComodRivadavia'),
                             ('America/Argentina/Cordoba', 'America/Argentina/Cordoba'),
                             ('America/Argentina/Jujuy', 'America/Argentina/Jujuy'),
                             ('America/Argentina/La_Rioja', 'America/Argentina/La_Rioja'),
                             ('America/Argentina/Mendoza', 'America/Argentina/Mendoza'),
                             ('America/Argentina/Rio_Gallegos', 'America/Argentina/Rio_Gallegos'),
                             ('America/Argentina/Salta', 'America/Argentina/Salta'),
                             ('America/Argentina/San_Juan', 'America/Argentina/San_Juan'),
                             ('America/Argentina/San_Luis', 'America/Argentina/San_Luis'),
                             ('America/Argentina/Tucuman', 'America/Argentina/Tucuman'),
                             ('America/Argentina/Ushuaia', 'America/Argentina/Ushuaia'),
                             ('America/Aruba', 'America/Aruba'), ('America/Asuncion', 'America/Asuncion'),
                             ('America/Atikokan', 'America/Atikokan'), ('America/Atka', 'America/Atka'),
                             ('America/Bahia', 'America/Bahia'), ('America/Bahia_Banderas', 'America/Bahia_Banderas'),
                             ('America/Barbados', 'America/Barbados'), ('America/Belem', 'America/Belem'),
                             ('America/Belize', 'America/Belize'), ('America/Blanc-Sablon', 'America/Blanc-Sablon'),
                             ('America/Boa_Vista', 'America/Boa_Vista'), ('America/Bogota', 'America/Bogota'),
                             ('America/Boise', 'America/Boise'), ('America/Buenos_Aires', 'America/Buenos_Aires'),
                             ('America/Cambridge_Bay', 'America/Cambridge_Bay'),
                             ('America/Campo_Grande', 'America/Campo_Grande'), ('America/Cancun', 'America/Cancun'),
                             ('America/Caracas', 'America/Caracas'), ('America/Catamarca', 'America/Catamarca'),
                             ('America/Cayenne', 'America/Cayenne'), ('America/Cayman', 'America/Cayman'),
                             ('America/Chicago', 'America/Chicago'), ('America/Chihuahua', 'America/Chihuahua'),
                             ('America/Coral_Harbour', 'America/Coral_Harbour'), ('America/Cordoba', 'America/Cordoba'),
                             ('America/Costa_Rica', 'America/Costa_Rica'), ('America/Creston', 'America/Creston'),
                             ('America/Cuiaba', 'America/Cuiaba'), ('America/Curacao', 'America/Curacao'),
                             ('America/Danmarkshavn', 'America/Danmarkshavn'), ('America/Dawson', 'America/Dawson'),
                             ('America/Dawson_Creek', 'America/Dawson_Creek'), ('America/Denver', 'America/Denver'),
                             ('America/Detroit', 'America/Detroit'), ('America/Dominica', 'America/Dominica'),
                             ('America/Edmonton', 'America/Edmonton'), ('America/Eirunepe', 'America/Eirunepe'),
                             ('America/El_Salvador', 'America/El_Salvador'), ('America/Ensenada', 'America/Ensenada'),
                             ('America/Fort_Nelson', 'America/Fort_Nelson'),
                             ('America/Fort_Wayne', 'America/Fort_Wayne'), ('America/Fortaleza', 'America/Fortaleza'),
                             ('America/Glace_Bay', 'America/Glace_Bay'), ('America/Godthab', 'America/Godthab'),
                             ('America/Goose_Bay', 'America/Goose_Bay'), ('America/Grand_Turk', 'America/Grand_Turk'),
                             ('America/Grenada', 'America/Grenada'), ('America/Guadeloupe', 'America/Guadeloupe'),
                             ('America/Guatemala', 'America/Guatemala'), ('America/Guayaquil', 'America/Guayaquil'),
                             ('America/Guyana', 'America/Guyana'), ('America/Halifax', 'America/Halifax'),
                             ('America/Havana', 'America/Havana'), ('America/Hermosillo', 'America/Hermosillo'),
                             ('America/Indiana/Indianapolis', 'America/Indiana/Indianapolis'),
                             ('America/Indiana/Knox', 'America/Indiana/Knox'),
                             ('America/Indiana/Marengo', 'America/Indiana/Marengo'),
                             ('America/Indiana/Petersburg', 'America/Indiana/Petersburg'),
                             ('America/Indiana/Tell_City', 'America/Indiana/Tell_City'),
                             ('America/Indiana/Vevay', 'America/Indiana/Vevay'),
                             ('America/Indiana/Vincennes', 'America/Indiana/Vincennes'),
                             ('America/Indiana/Winamac', 'America/Indiana/Winamac'),
                             ('America/Indianapolis', 'America/Indianapolis'), ('America/Inuvik', 'America/Inuvik'),
                             ('America/Iqaluit', 'America/Iqaluit'), ('America/Jamaica', 'America/Jamaica'),
                             ('America/Jujuy', 'America/Jujuy'), ('America/Juneau', 'America/Juneau'),
                             ('America/Kentucky/Louisville', 'America/Kentucky/Louisville'),
                             ('America/Kentucky/Monticello', 'America/Kentucky/Monticello'),
                             ('America/Knox_IN', 'America/Knox_IN'), ('America/Kralendijk', 'America/Kralendijk'),
                             ('America/La_Paz', 'America/La_Paz'), ('America/Lima', 'America/Lima'),
                             ('America/Los_Angeles', 'America/Los_Angeles'),
                             ('America/Louisville', 'America/Louisville'),
                             ('America/Lower_Princes', 'America/Lower_Princes'), ('America/Maceio', 'America/Maceio'),
                             ('America/Managua', 'America/Managua'), ('America/Manaus', 'America/Manaus'),
                             ('America/Marigot', 'America/Marigot'), ('America/Martinique', 'America/Martinique'),
                             ('America/Matamoros', 'America/Matamoros'), ('America/Mazatlan', 'America/Mazatlan'),
                             ('America/Mendoza', 'America/Mendoza'), ('America/Menominee', 'America/Menominee'),
                             ('America/Merida', 'America/Merida'), ('America/Metlakatla', 'America/Metlakatla'),
                             ('America/Mexico_City', 'America/Mexico_City'), ('America/Miquelon', 'America/Miquelon'),
                             ('America/Moncton', 'America/Moncton'), ('America/Monterrey', 'America/Monterrey'),
                             ('America/Montevideo', 'America/Montevideo'), ('America/Montreal', 'America/Montreal'),
                             ('America/Montserrat', 'America/Montserrat'), ('America/Nassau', 'America/Nassau'),
                             ('America/New_York', 'America/New_York'), ('America/Nipigon', 'America/Nipigon'),
                             ('America/Nome', 'America/Nome'), ('America/Noronha', 'America/Noronha'),
                             ('America/North_Dakota/Beulah', 'America/North_Dakota/Beulah'),
                             ('America/North_Dakota/Center', 'America/North_Dakota/Center'),
                             ('America/North_Dakota/New_Salem', 'America/North_Dakota/New_Salem'),
                             ('America/Ojinaga', 'America/Ojinaga'), ('America/Panama', 'America/Panama'),
                             ('America/Pangnirtung', 'America/Pangnirtung'),
                             ('America/Paramaribo', 'America/Paramaribo'), ('America/Phoenix', 'America/Phoenix'),
                             ('America/Port-au-Prince', 'America/Port-au-Prince'),
                             ('America/Port_of_Spain', 'America/Port_of_Spain'),
                             ('America/Porto_Acre', 'America/Porto_Acre'),
                             ('America/Porto_Velho', 'America/Porto_Velho'),
                             ('America/Puerto_Rico', 'America/Puerto_Rico'),
                             ('America/Punta_Arenas', 'America/Punta_Arenas'),
                             ('America/Rainy_River', 'America/Rainy_River'),
                             ('America/Rankin_Inlet', 'America/Rankin_Inlet'), ('America/Recife', 'America/Recife'),
                             ('America/Regina', 'America/Regina'), ('America/Resolute', 'America/Resolute'),
                             ('America/Rio_Branco', 'America/Rio_Branco'), ('America/Rosario', 'America/Rosario'),
                             ('America/Santa_Isabel', 'America/Santa_Isabel'), ('America/Santarem', 'America/Santarem'),
                             ('America/Santiago', 'America/Santiago'),
                             ('America/Santo_Domingo', 'America/Santo_Domingo'),
                             ('America/Sao_Paulo', 'America/Sao_Paulo'),
                             ('America/Scoresbysund', 'America/Scoresbysund'), ('America/Shiprock', 'America/Shiprock'),
                             ('America/Sitka', 'America/Sitka'), ('America/St_Barthelemy', 'America/St_Barthelemy'),
                             ('America/St_Johns', 'America/St_Johns'), ('America/St_Kitts', 'America/St_Kitts'),
                             ('America/St_Lucia', 'America/St_Lucia'), ('America/St_Thomas', 'America/St_Thomas'),
                             ('America/St_Vincent', 'America/St_Vincent'),
                             ('America/Swift_Current', 'America/Swift_Current'),
                             ('America/Tegucigalpa', 'America/Tegucigalpa'), ('America/Thule', 'America/Thule'),
                             ('America/Thunder_Bay', 'America/Thunder_Bay'), ('America/Tijuana', 'America/Tijuana'),
                             ('America/Toronto', 'America/Toronto'), ('America/Tortola', 'America/Tortola'),
                             ('America/Vancouver', 'America/Vancouver'), ('America/Virgin', 'America/Virgin'),
                             ('America/Whitehorse', 'America/Whitehorse'), ('America/Winnipeg', 'America/Winnipeg'),
                             ('America/Yakutat', 'America/Yakutat'), ('America/Yellowknife', 'America/Yellowknife'),
                             ('Antarctica/Casey', 'Antarctica/Casey'), ('Antarctica/Davis', 'Antarctica/Davis'),
                             ('Antarctica/DumontDUrville', 'Antarctica/DumontDUrville'),
                             ('Antarctica/Macquarie', 'Antarctica/Macquarie'),
                             ('Antarctica/Mawson', 'Antarctica/Mawson'), ('Antarctica/McMurdo', 'Antarctica/McMurdo'),
                             ('Antarctica/Palmer', 'Antarctica/Palmer'), ('Antarctica/Rothera', 'Antarctica/Rothera'),
                             ('Antarctica/South_Pole', 'Antarctica/South_Pole'),
                             ('Antarctica/Syowa', 'Antarctica/Syowa'), ('Antarctica/Troll', 'Antarctica/Troll'),
                             ('Antarctica/Vostok', 'Antarctica/Vostok'), ('Arctic/Longyearbyen', 'Arctic/Longyearbyen'),
                             ('Asia/Aden', 'Asia/Aden'), ('Asia/Almaty', 'Asia/Almaty'), ('Asia/Amman', 'Asia/Amman'),
                             ('Asia/Anadyr', 'Asia/Anadyr'), ('Asia/Aqtau', 'Asia/Aqtau'),
                             ('Asia/Aqtobe', 'Asia/Aqtobe'), ('Asia/Ashgabat', 'Asia/Ashgabat'),
                             ('Asia/Ashkhabad', 'Asia/Ashkhabad'), ('Asia/Atyrau', 'Asia/Atyrau'),
                             ('Asia/Baghdad', 'Asia/Baghdad'), ('Asia/Bahrain', 'Asia/Bahrain'),
                             ('Asia/Baku', 'Asia/Baku'), ('Asia/Bangkok', 'Asia/Bangkok'),
                             ('Asia/Barnaul', 'Asia/Barnaul'), ('Asia/Beirut', 'Asia/Beirut'),
                             ('Asia/Bishkek', 'Asia/Bishkek'), ('Asia/Brunei', 'Asia/Brunei'),
                             ('Asia/Calcutta', 'Asia/Calcutta'), ('Asia/Chita', 'Asia/Chita'),
                             ('Asia/Choibalsan', 'Asia/Choibalsan'), ('Asia/Chongqing', 'Asia/Chongqing'),
                             ('Asia/Chungking', 'Asia/Chungking'), ('Asia/Colombo', 'Asia/Colombo'),
                             ('Asia/Dacca', 'Asia/Dacca'), ('Asia/Damascus', 'Asia/Damascus'),
                             ('Asia/Dhaka', 'Asia/Dhaka'), ('Asia/Dili', 'Asia/Dili'), ('Asia/Dubai', 'Asia/Dubai'),
                             ('Asia/Dushanbe', 'Asia/Dushanbe'), ('Asia/Famagusta', 'Asia/Famagusta'),
                             ('Asia/Gaza', 'Asia/Gaza'), ('Asia/Harbin', 'Asia/Harbin'), ('Asia/Hebron', 'Asia/Hebron'),
                             ('Asia/Ho_Chi_Minh', 'Asia/Ho_Chi_Minh'), ('Asia/Hong_Kong', 'Asia/Hong_Kong'),
                             ('Asia/Hovd', 'Asia/Hovd'), ('Asia/Irkutsk', 'Asia/Irkutsk'),
                             ('Asia/Istanbul', 'Asia/Istanbul'), ('Asia/Jakarta', 'Asia/Jakarta'),
                             ('Asia/Jayapura', 'Asia/Jayapura'), ('Asia/Jerusalem', 'Asia/Jerusalem'),
                             ('Asia/Kabul', 'Asia/Kabul'), ('Asia/Kamchatka', 'Asia/Kamchatka'),
                             ('Asia/Karachi', 'Asia/Karachi'), ('Asia/Kashgar', 'Asia/Kashgar'),
                             ('Asia/Kathmandu', 'Asia/Kathmandu'), ('Asia/Katmandu', 'Asia/Katmandu'),
                             ('Asia/Khandyga', 'Asia/Khandyga'), ('Asia/Kolkata', 'Asia/Kolkata'),
                             ('Asia/Krasnoyarsk', 'Asia/Krasnoyarsk'), ('Asia/Kuala_Lumpur', 'Asia/Kuala_Lumpur'),
                             ('Asia/Kuching', 'Asia/Kuching'), ('Asia/Kuwait', 'Asia/Kuwait'),
                             ('Asia/Macao', 'Asia/Macao'), ('Asia/Macau', 'Asia/Macau'),
                             ('Asia/Magadan', 'Asia/Magadan'), ('Asia/Makassar', 'Asia/Makassar'),
                             ('Asia/Manila', 'Asia/Manila'), ('Asia/Muscat', 'Asia/Muscat'),
                             ('Asia/Nicosia', 'Asia/Nicosia'), ('Asia/Novokuznetsk', 'Asia/Novokuznetsk'),
                             ('Asia/Novosibirsk', 'Asia/Novosibirsk'), ('Asia/Omsk', 'Asia/Omsk'),
                             ('Asia/Oral', 'Asia/Oral'), ('Asia/Phnom_Penh', 'Asia/Phnom_Penh'),
                             ('Asia/Pontianak', 'Asia/Pontianak'), ('Asia/Pyongyang', 'Asia/Pyongyang'),
                             ('Asia/Qatar', 'Asia/Qatar'), ('Asia/Qostanay', 'Asia/Qostanay'),
                             ('Asia/Qyzylorda', 'Asia/Qyzylorda'), ('Asia/Rangoon', 'Asia/Rangoon'),
                             ('Asia/Riyadh', 'Asia/Riyadh'), ('Asia/Saigon', 'Asia/Saigon'),
                             ('Asia/Sakhalin', 'Asia/Sakhalin'), ('Asia/Samarkand', 'Asia/Samarkand'),
                             ('Asia/Seoul', 'Asia/Seoul'), ('Asia/Shanghai', 'Asia/Shanghai'),
                             ('Asia/Singapore', 'Asia/Singapore'), ('Asia/Srednekolymsk', 'Asia/Srednekolymsk'),
                             ('Asia/Taipei', 'Asia/Taipei'), ('Asia/Tashkent', 'Asia/Tashkent'),
                             ('Asia/Tbilisi', 'Asia/Tbilisi'), ('Asia/Tehran', 'Asia/Tehran'),
                             ('Asia/Tel_Aviv', 'Asia/Tel_Aviv'), ('Asia/Thimbu', 'Asia/Thimbu'),
                             ('Asia/Thimphu', 'Asia/Thimphu'), ('Asia/Tokyo', 'Asia/Tokyo'),
                             ('Asia/Tomsk', 'Asia/Tomsk'), ('Asia/Ujung_Pandang', 'Asia/Ujung_Pandang'),
                             ('Asia/Ulaanbaatar', 'Asia/Ulaanbaatar'), ('Asia/Ulan_Bator', 'Asia/Ulan_Bator'),
                             ('Asia/Urumqi', 'Asia/Urumqi'), ('Asia/Ust-Nera', 'Asia/Ust-Nera'),
                             ('Asia/Vientiane', 'Asia/Vientiane'), ('Asia/Vladivostok', 'Asia/Vladivostok'),
                             ('Asia/Yakutsk', 'Asia/Yakutsk'), ('Asia/Yangon', 'Asia/Yangon'),
                             ('Asia/Yekaterinburg', 'Asia/Yekaterinburg'), ('Asia/Yerevan', 'Asia/Yerevan'),
                             ('Atlantic/Azores', 'Atlantic/Azores'), ('Atlantic/Bermuda', 'Atlantic/Bermuda'),
                             ('Atlantic/Canary', 'Atlantic/Canary'), ('Atlantic/Cape_Verde', 'Atlantic/Cape_Verde'),
                             ('Atlantic/Faeroe', 'Atlantic/Faeroe'), ('Atlantic/Faroe', 'Atlantic/Faroe'),
                             ('Atlantic/Jan_Mayen', 'Atlantic/Jan_Mayen'), ('Atlantic/Madeira', 'Atlantic/Madeira'),
                             ('Atlantic/Reykjavik', 'Atlantic/Reykjavik'),
                             ('Atlantic/South_Georgia', 'Atlantic/South_Georgia'),
                             ('Atlantic/St_Helena', 'Atlantic/St_Helena'), ('Atlantic/Stanley', 'Atlantic/Stanley'),
                             ('Australia/ACT', 'Australia/ACT'), ('Australia/Adelaide', 'Australia/Adelaide'),
                             ('Australia/Brisbane', 'Australia/Brisbane'),
                             ('Australia/Broken_Hill', 'Australia/Broken_Hill'),
                             ('Australia/Canberra', 'Australia/Canberra'), ('Australia/Currie', 'Australia/Currie'),
                             ('Australia/Darwin', 'Australia/Darwin'), ('Australia/Eucla', 'Australia/Eucla'),
                             ('Australia/Hobart', 'Australia/Hobart'), ('Australia/LHI', 'Australia/LHI'),
                             ('Australia/Lindeman', 'Australia/Lindeman'),
                             ('Australia/Lord_Howe', 'Australia/Lord_Howe'),
                             ('Australia/Melbourne', 'Australia/Melbourne'), ('Australia/NSW', 'Australia/NSW'),
                             ('Australia/North', 'Australia/North'), ('Australia/Perth', 'Australia/Perth'),
                             ('Australia/Queensland', 'Australia/Queensland'), ('Australia/South', 'Australia/South'),
                             ('Australia/Sydney', 'Australia/Sydney'), ('Australia/Tasmania', 'Australia/Tasmania'),
                             ('Australia/Victoria', 'Australia/Victoria'), ('Australia/West', 'Australia/West'),
                             ('Australia/Yancowinna', 'Australia/Yancowinna'), ('Brazil/Acre', 'Brazil/Acre'),
                             ('Brazil/DeNoronha', 'Brazil/DeNoronha'), ('Brazil/East', 'Brazil/East'),
                             ('Brazil/West', 'Brazil/West'), ('CET', 'CET'), ('CST6CDT', 'CST6CDT'),
                             ('Canada/Atlantic', 'Canada/Atlantic'), ('Canada/Central', 'Canada/Central'),
                             ('Canada/Eastern', 'Canada/Eastern'), ('Canada/Mountain', 'Canada/Mountain'),
                             ('Canada/Newfoundland', 'Canada/Newfoundland'), ('Canada/Pacific', 'Canada/Pacific'),
                             ('Canada/Saskatchewan', 'Canada/Saskatchewan'), ('Canada/Yukon', 'Canada/Yukon'),
                             ('Chile/Continental', 'Chile/Continental'), ('Chile/EasterIsland', 'Chile/EasterIsland'),
                             ('Cuba', 'Cuba'), ('EET', 'EET'), ('EST', 'EST'), ('EST5EDT', 'EST5EDT'),
                             ('Egypt', 'Egypt'), ('Eire', 'Eire'), ('Etc/GMT', 'Etc/GMT'), ('Etc/GMT+0', 'Etc/GMT+0'),
                             ('Etc/GMT+1', 'Etc/GMT+1'), ('Etc/GMT+10', 'Etc/GMT+10'), ('Etc/GMT+11', 'Etc/GMT+11'),
                             ('Etc/GMT+12', 'Etc/GMT+12'), ('Etc/GMT+2', 'Etc/GMT+2'), ('Etc/GMT+3', 'Etc/GMT+3'),
                             ('Etc/GMT+4', 'Etc/GMT+4'), ('Etc/GMT+5', 'Etc/GMT+5'), ('Etc/GMT+6', 'Etc/GMT+6'),
                             ('Etc/GMT+7', 'Etc/GMT+7'), ('Etc/GMT+8', 'Etc/GMT+8'), ('Etc/GMT+9', 'Etc/GMT+9'),
                             ('Etc/GMT-0', 'Etc/GMT-0'), ('Etc/GMT-1', 'Etc/GMT-1'), ('Etc/GMT-10', 'Etc/GMT-10'),
                             ('Etc/GMT-11', 'Etc/GMT-11'), ('Etc/GMT-12', 'Etc/GMT-12'), ('Etc/GMT-13', 'Etc/GMT-13'),
                             ('Etc/GMT-14', 'Etc/GMT-14'), ('Etc/GMT-2', 'Etc/GMT-2'), ('Etc/GMT-3', 'Etc/GMT-3'),
                             ('Etc/GMT-4', 'Etc/GMT-4'), ('Etc/GMT-5', 'Etc/GMT-5'), ('Etc/GMT-6', 'Etc/GMT-6'),
                             ('Etc/GMT-7', 'Etc/GMT-7'), ('Etc/GMT-8', 'Etc/GMT-8'), ('Etc/GMT-9', 'Etc/GMT-9'),
                             ('Etc/GMT0', 'Etc/GMT0'), ('Etc/Greenwich', 'Etc/Greenwich'), ('Etc/UCT', 'Etc/UCT'),
                             ('Etc/UTC', 'Etc/UTC'), ('Etc/Universal', 'Etc/Universal'), ('Etc/Zulu', 'Etc/Zulu'),
                             ('Europe/Amsterdam', 'Europe/Amsterdam'), ('Europe/Andorra', 'Europe/Andorra'),
                             ('Europe/Astrakhan', 'Europe/Astrakhan'), ('Europe/Athens', 'Europe/Athens'),
                             ('Europe/Belfast', 'Europe/Belfast'), ('Europe/Belgrade', 'Europe/Belgrade'),
                             ('Europe/Berlin', 'Europe/Berlin'), ('Europe/Bratislava', 'Europe/Bratislava'),
                             ('Europe/Brussels', 'Europe/Brussels'), ('Europe/Bucharest', 'Europe/Bucharest'),
                             ('Europe/Budapest', 'Europe/Budapest'), ('Europe/Busingen', 'Europe/Busingen'),
                             ('Europe/Chisinau', 'Europe/Chisinau'), ('Europe/Copenhagen', 'Europe/Copenhagen'),
                             ('Europe/Dublin', 'Europe/Dublin'), ('Europe/Gibraltar', 'Europe/Gibraltar'),
                             ('Europe/Guernsey', 'Europe/Guernsey'), ('Europe/Helsinki', 'Europe/Helsinki'),
                             ('Europe/Isle_of_Man', 'Europe/Isle_of_Man'), ('Europe/Istanbul', 'Europe/Istanbul'),
                             ('Europe/Jersey', 'Europe/Jersey'), ('Europe/Kaliningrad', 'Europe/Kaliningrad'),
                             ('Europe/Kiev', 'Europe/Kiev'), ('Europe/Kirov', 'Europe/Kirov'),
                             ('Europe/Lisbon', 'Europe/Lisbon'), ('Europe/Ljubljana', 'Europe/Ljubljana'),
                             ('Europe/London', 'Europe/London'), ('Europe/Luxembourg', 'Europe/Luxembourg'),
                             ('Europe/Madrid', 'Europe/Madrid'), ('Europe/Malta', 'Europe/Malta'),
                             ('Europe/Mariehamn', 'Europe/Mariehamn'), ('Europe/Minsk', 'Europe/Minsk'),
                             ('Europe/Monaco', 'Europe/Monaco'), ('Europe/Moscow', 'Europe/Moscow'),
                             ('Europe/Nicosia', 'Europe/Nicosia'), ('Europe/Oslo', 'Europe/Oslo'),
                             ('Europe/Paris', 'Europe/Paris'), ('Europe/Podgorica', 'Europe/Podgorica'),
                             ('Europe/Prague', 'Europe/Prague'), ('Europe/Riga', 'Europe/Riga'),
                             ('Europe/Rome', 'Europe/Rome'), ('Europe/Samara', 'Europe/Samara'),
                             ('Europe/San_Marino', 'Europe/San_Marino'), ('Europe/Sarajevo', 'Europe/Sarajevo'),
                             ('Europe/Saratov', 'Europe/Saratov'), ('Europe/Simferopol', 'Europe/Simferopol'),
                             ('Europe/Skopje', 'Europe/Skopje'), ('Europe/Sofia', 'Europe/Sofia'),
                             ('Europe/Stockholm', 'Europe/Stockholm'), ('Europe/Tallinn', 'Europe/Tallinn'),
                             ('Europe/Tirane', 'Europe/Tirane'), ('Europe/Tiraspol', 'Europe/Tiraspol'),
                             ('Europe/Ulyanovsk', 'Europe/Ulyanovsk'), ('Europe/Uzhgorod', 'Europe/Uzhgorod'),
                             ('Europe/Vaduz', 'Europe/Vaduz'), ('Europe/Vatican', 'Europe/Vatican'),
                             ('Europe/Vienna', 'Europe/Vienna'), ('Europe/Vilnius', 'Europe/Vilnius'),
                             ('Europe/Volgograd', 'Europe/Volgograd'), ('Europe/Warsaw', 'Europe/Warsaw'),
                             ('Europe/Zagreb', 'Europe/Zagreb'), ('Europe/Zaporozhye', 'Europe/Zaporozhye'),
                             ('Europe/Zurich', 'Europe/Zurich'), ('GB', 'GB'), ('GB-Eire', 'GB-Eire'), ('GMT', 'GMT'),
                             ('GMT+0', 'GMT+0'), ('GMT-0', 'GMT-0'), ('GMT0', 'GMT0'), ('Greenwich', 'Greenwich'),
                             ('HST', 'HST'), ('Hongkong', 'Hongkong'), ('Iceland', 'Iceland'),
                             ('Indian/Antananarivo', 'Indian/Antananarivo'), ('Indian/Chagos', 'Indian/Chagos'),
                             ('Indian/Christmas', 'Indian/Christmas'), ('Indian/Cocos', 'Indian/Cocos'),
                             ('Indian/Comoro', 'Indian/Comoro'), ('Indian/Kerguelen', 'Indian/Kerguelen'),
                             ('Indian/Mahe', 'Indian/Mahe'), ('Indian/Maldives', 'Indian/Maldives'),
                             ('Indian/Mauritius', 'Indian/Mauritius'), ('Indian/Mayotte', 'Indian/Mayotte'),
                             ('Indian/Reunion', 'Indian/Reunion'), ('Iran', 'Iran'), ('Israel', 'Israel'),
                             ('Jamaica', 'Jamaica'), ('Japan', 'Japan'), ('Kwajalein', 'Kwajalein'), ('Libya', 'Libya'),
                             ('MET', 'MET'), ('MST', 'MST'), ('MST7MDT', 'MST7MDT'),
                             ('Mexico/BajaNorte', 'Mexico/BajaNorte'), ('Mexico/BajaSur', 'Mexico/BajaSur'),
                             ('Mexico/General', 'Mexico/General'), ('NZ', 'NZ'), ('NZ-CHAT', 'NZ-CHAT'),
                             ('Navajo', 'Navajo'), ('PRC', 'PRC'), ('PST8PDT', 'PST8PDT'),
                             ('Pacific/Apia', 'Pacific/Apia'), ('Pacific/Auckland', 'Pacific/Auckland'),
                             ('Pacific/Bougainville', 'Pacific/Bougainville'), ('Pacific/Chatham', 'Pacific/Chatham'),
                             ('Pacific/Chuuk', 'Pacific/Chuuk'), ('Pacific/Easter', 'Pacific/Easter'),
                             ('Pacific/Efate', 'Pacific/Efate'), ('Pacific/Enderbury', 'Pacific/Enderbury'),
                             ('Pacific/Fakaofo', 'Pacific/Fakaofo'), ('Pacific/Fiji', 'Pacific/Fiji'),
                             ('Pacific/Funafuti', 'Pacific/Funafuti'), ('Pacific/Galapagos', 'Pacific/Galapagos'),
                             ('Pacific/Gambier', 'Pacific/Gambier'), ('Pacific/Guadalcanal', 'Pacific/Guadalcanal'),
                             ('Pacific/Guam', 'Pacific/Guam'), ('Pacific/Honolulu', 'Pacific/Honolulu'),
                             ('Pacific/Johnston', 'Pacific/Johnston'), ('Pacific/Kiritimati', 'Pacific/Kiritimati'),
                             ('Pacific/Kosrae', 'Pacific/Kosrae'), ('Pacific/Kwajalein', 'Pacific/Kwajalein'),
                             ('Pacific/Majuro', 'Pacific/Majuro'), ('Pacific/Marquesas', 'Pacific/Marquesas'),
                             ('Pacific/Midway', 'Pacific/Midway'), ('Pacific/Nauru', 'Pacific/Nauru'),
                             ('Pacific/Niue', 'Pacific/Niue'), ('Pacific/Norfolk', 'Pacific/Norfolk'),
                             ('Pacific/Noumea', 'Pacific/Noumea'), ('Pacific/Pago_Pago', 'Pacific/Pago_Pago'),
                             ('Pacific/Palau', 'Pacific/Palau'), ('Pacific/Pitcairn', 'Pacific/Pitcairn'),
                             ('Pacific/Pohnpei', 'Pacific/Pohnpei'), ('Pacific/Ponape', 'Pacific/Ponape'),
                             ('Pacific/Port_Moresby', 'Pacific/Port_Moresby'),
                             ('Pacific/Rarotonga', 'Pacific/Rarotonga'), ('Pacific/Saipan', 'Pacific/Saipan'),
                             ('Pacific/Samoa', 'Pacific/Samoa'), ('Pacific/Tahiti', 'Pacific/Tahiti'),
                             ('Pacific/Tarawa', 'Pacific/Tarawa'), ('Pacific/Tongatapu', 'Pacific/Tongatapu'),
                             ('Pacific/Truk', 'Pacific/Truk'), ('Pacific/Wake', 'Pacific/Wake'),
                             ('Pacific/Wallis', 'Pacific/Wallis'), ('Pacific/Yap', 'Pacific/Yap'), ('Poland', 'Poland'),
                             ('Portugal', 'Portugal'), ('ROC', 'ROC'), ('ROK', 'ROK'), ('Singapore', 'Singapore'),
                             ('Turkey', 'Turkey'), ('UCT', 'UCT'), ('US/Alaska', 'US/Alaska'),
                             ('US/Aleutian', 'US/Aleutian'), ('US/Arizona', 'US/Arizona'), ('US/Central', 'US/Central'),
                             ('US/East-Indiana', 'US/East-Indiana'), ('US/Eastern', 'US/Eastern'),
                             ('US/Hawaii', 'US/Hawaii'), ('US/Indiana-Starke', 'US/Indiana-Starke'),
                             ('US/Michigan', 'US/Michigan'), ('US/Mountain', 'US/Mountain'),
                             ('US/Pacific', 'US/Pacific'), ('US/Samoa', 'US/Samoa'), ('UTC', 'UTC'),
                             ('Universal', 'Universal'), ('W-SU', 'W-SU'), ('WET', 'WET'), ('Zulu', 'Zulu')],
                    max_length=64)),
                ('story', models.TextField(default='', verbose_name='story')),
                ('status', models.CharField(choices=[('R', 'REGULAR'), ('P', 'PRIVILEGE')], default='R', max_length=10,
                                            verbose_name='status')),
                ('blocked_contacts',
                 models.ManyToManyField(related_name='_member_blocked_contacts_+', to=settings.AUTH_USER_MODEL)),
                ('groups', models.ManyToManyField(blank=True,
                                                  help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.',
                                                  related_name='user_set', related_query_name='user', to='auth.Group',
                                                  verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.',
                                                            related_name='user_set', related_query_name='user',
                                                            to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'member',
                'verbose_name_plural': 'members',
            },
        ),
        migrations.CreateModel(
            name='Admonition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('subject', models.CharField(db_index=True, default='no subject', max_length=255, unique=True,
                                             verbose_name='subject')),
                ('content', models.TextField(blank=True, null=True, verbose_name='content')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdmonitionTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('subject', models.CharField(db_index=True, default='no subject', max_length=255, unique=True,
                                             verbose_name='subject')),
                ('content', models.TextField(blank=True, null=True, verbose_name='content')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Book',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('isbn', models.CharField(max_length=20, verbose_name='isbn')),
                ('published_at', models.DateField(verbose_name='published date')),
                ('visible', models.BooleanField(default=False, verbose_name='visible')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='book_author',
                                             to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'book',
                'verbose_name_plural': 'books',
            },
        ),
        migrations.CreateModel(
            name='BookPart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('title', models.CharField(db_index=True, max_length=255, verbose_name='title')),
                ('order', models.IntegerField(blank=True, null=True, verbose_name='order')),
                ('book',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='book_ref', to='db.Book')),
            ],
            options={
                'verbose_name': 'bookpart',
                'verbose_name_plural': 'bookparts',
            },
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('content', editorjs.fields.EditorJSField(verbose_name='content')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comment_author',
                                             to=settings.AUTH_USER_MODEL)),
                ('readings', models.ManyToManyField(to=settings.AUTH_USER_MODEL)),
                ('reply_to',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comment_reply_to',
                                   to='db.Comment')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Contest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('name', models.CharField(db_index=True, max_length=255, verbose_name='name')),
                ('starts_at',
                 models.DateField(db_index=True, validators=[db.validators.not_passed], verbose_name='start at')),
                ('ends_at',
                 models.DateField(db_index=True, validators=[db.validators.not_passed], verbose_name='ends at')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CorrectionRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('summary',
                 editorjs.fields.EditorJSField(blank=True, max_length=2000, null=True, verbose_name='summary')),
                ('_bbcode_content_rendered', models.TextField(blank=True, editable=False, null=True)),
                ('bbcode_content', precise_bbcode.fields.BBCodeTextField(blank=True, no_rendered_field=True, null=True,
                                                                         verbose_name='bbcode content')),
                ('content', editorjs.fields.EditorJSField(blank=True, null=True, verbose_name='content')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Faq',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('order', models.IntegerField(verbose_name='order')),
                ('question', models.CharField(max_length=2048, null=True, verbose_name='question')),
                ('answer', models.TextField(verbose_name='answer')),
            ],
            options={
                'verbose_name': 'Faq',
                'verbose_name_plural': 'Faqs',
            },
        ),
        migrations.CreateModel(
            name='License',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('name', models.CharField(max_length=255, null=True, verbose_name='name')),
                ('text', models.TextField(null=True, verbose_name='text')),
                ('logo', models.ImageField(null=True, upload_to='', verbose_name='logo')),
                ('active', models.BooleanField(default=False, verbose_name='active')),
            ],
            options={
                'verbose_name': 'license',
                'verbose_name_plural': 'licenses',
            },
        ),
        migrations.CreateModel(
            name='Post',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('old_slug', models.URLField(max_length=2048, verbose_name='old slug')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('summary',
                 editorjs.fields.EditorJSField(blank=True, max_length=2000, null=True, verbose_name='summary')),
                ('_bbcode_content_rendered', models.TextField(blank=True, editable=False, null=True)),
                ('bbcode_content', precise_bbcode.fields.BBCodeTextField(blank=True, no_rendered_field=True, null=True,
                                                                         verbose_name='bbcode content')),
                ('content', editorjs.fields.EditorJSField(blank=True, null=True, verbose_name='content')),
                ('status', models.CharField(
                    choices=[('draft', 'DRAFT'), ('published', 'PUBLISHED'), ('warned', 'WARNED'),
                             ('archived', 'ARCHIVED')], default='draft', max_length=20, verbose_name='status')),
                ('hits_counter', models.IntegerField(default=0, verbose_name='hits count')),
                ('revisions_counter', models.IntegerField(default=0, verbose_name='revisions count')),
                ('validated_at', models.DateTimeField(null=True, verbose_name='validated at')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='post_author',
                                             to=settings.AUTH_USER_MODEL)),
                ('book_part',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='book_part_ref',
                                   to='db.BookPart')),
                ('readings', models.ManyToManyField(to=settings.AUTH_USER_MODEL)),
                ('revision',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='revision_ref',
                                   to='db.Post')),
            ],
            options={
                'verbose_name': 'post',
                'verbose_name_plural': 'posts',
            },
        ),
        migrations.CreateModel(
            name='Section',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('short_name', models.CharField(db_index=True, default='no short name', max_length=20, unique=True,
                                                verbose_name='short name')),
                ('name', models.CharField(db_index=True, default='no name', max_length=255, verbose_name='name')),
                ('order', models.IntegerField(default=0, unique=True, verbose_name='order')),
                ('description', models.TextField(max_length=1024, null=True, verbose_name='description')),
                ('status',
                 models.IntegerField(choices=[(1, 'active'), (2, 'disabled')], default=2, verbose_name='status')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this section belongs to.',
                                                  related_name='section_set', related_query_name='section',
                                                  to='auth.Group', verbose_name='groups')),
            ],
            options={
                'verbose_name': 'section',
                'verbose_name_plural': 'sections',
            },
        ),
        migrations.CreateModel(
            name='SiteParam',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('key',
                 models.CharField(db_index=True, default='no name', max_length=255, unique=True, verbose_name='key')),
                ('value', models.CharField(db_index=True, default='no value', max_length=2048, unique=True,
                                           verbose_name='value')),
            ],
            options={
                'verbose_name': 'site parameter',
                'verbose_name_plural': 'site parameters',
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('name', models.CharField(db_index=True, max_length=255, unique=True)),
                ('enable_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='enable at')),
                ('disable_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='disable at')),
                ('type', models.CharField(blank=True,
                                          choices=[(0, 'category'), (1, 'theme'), (2, 'prosody'), (3, 'form'),
                                                   (4, 'user'), (5, 'event')], default=4, max_length=255,
                                          verbose_name='type')),
                ('mature', models.BooleanField(blank=True, default=False, verbose_name='mature')),
                ('active', models.BooleanField(default=False, verbose_name='active')),
                ('valid_sections', models.ManyToManyField(to='db.Section')),
            ],
            options={
                'verbose_name': 'tag',
                'verbose_name_plural': 'tags',
            },
        ),
        migrations.CreateModel(
            name='PostRating',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('level', models.PositiveSmallIntegerField(default=0,
                                                           validators=[django.core.validators.MaxValueValidator(5),
                                                                       django.core.validators.MinValueValidator(1)],
                                                           verbose_name='level')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL,
                                            verbose_name='owner')),
                ('post', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='db.Post')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PostList',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('name', models.CharField(max_length=255, null=True, verbose_name='name')),
                ('removable', models.BooleanField(default=True, verbose_name='removable')),
                ('public', models.BooleanField(default=False, verbose_name='public')),
                ('type',
                 models.IntegerField(choices=[(1, 'Favourite'), (2, 'Reading')], default=2, verbose_name='type')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('posts', models.ManyToManyField(to='db.Post')),
            ],
            options={
                'verbose_name': 'Post List',
                'verbose_name_plural': 'Post Lists',
            },
        ),
        migrations.CreateModel(
            name='PostLike',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('level', models.PositiveSmallIntegerField(default=0,
                                                           validators=[django.core.validators.MaxValueValidator(5),
                                                                       django.core.validators.MinValueValidator(1)],
                                                           verbose_name='level')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL,
                                            verbose_name='owner')),
                ('post', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='db.Post')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PostAlert',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('type', models.CharField(
                    choices=[('plagiarism', 'Plagiarism'), ('spelling', 'Spelling'), ('bad_category', 'Bad category'),
                             ('hate', 'Hate'), ('other', 'Other')], default='other', max_length=30,
                    verbose_name='type')),
                ('details', models.TextField(default='', max_length=1000, verbose_name='details')),
                ('status', models.IntegerField(default=1, verbose_name='status')),
                ('post', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='db.Post')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='post',
            name='section',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='section_ref',
                                    to='db.Section'),
        ),
        migrations.AddField(
            model_name='post',
            name='tags',
            field=models.ManyToManyField(to='db.Tag'),
        ),
        migrations.AddField(
            model_name='post',
            name='validated_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING,
                                    related_name='validated_by', to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('subject', models.CharField(db_index=True, default='no subject', max_length=255, unique=True,
                                             verbose_name='subject')),
                ('content', models.TextField(blank=True, null=True, verbose_name='content')),
                ('message_box',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='message_box',
                                   to=settings.AUTH_USER_MODEL)),
                ('recipient', models.ManyToManyField(related_name='recipients', related_query_name='recipients',
                                                     to=settings.AUTH_USER_MODEL, verbose_name='recipient')),
                ('sender', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sender_ref',
                                             to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'message',
                'verbose_name_plural': 'messages',
            },
        ),
        migrations.CreateModel(
            name='CorrectionRequestAction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('action', models.CharField(choices=[(1, 'Correction'), (2, 'Validation')], default=1, max_length=30,
                                            verbose_name='action')),
                ('correction_request',
                 models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='db.CorrectionRequest')),
                ('owner',
                 models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Correction Request',
                'verbose_name_plural': 'Correction Requests',
            },
        ),
        migrations.AddField(
            model_name='correctionrequest',
            name='post',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='db.Post'),
        ),
        migrations.CreateModel(
            name='CommentRating',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('level', models.PositiveSmallIntegerField(default=0,
                                                           validators=[django.core.validators.MaxValueValidator(5),
                                                                       django.core.validators.MinValueValidator(1)],
                                                           verbose_name='level')),
                ('comment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='db.Comment')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL,
                                            verbose_name='owner')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CommentLike',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('level', models.PositiveSmallIntegerField(default=0,
                                                           validators=[django.core.validators.MaxValueValidator(5),
                                                                       django.core.validators.MinValueValidator(1)],
                                                           verbose_name='level')),
                ('comment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='db.Comment')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL,
                                            verbose_name='owner')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CommentAlert',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('type', models.CharField(
                    choices=[('plagiarism', 'Plagiarism'), ('spelling', 'Spelling'), ('bad_category', 'Bad category'),
                             ('hate', 'Hate'), ('other', 'Other')], default='other', max_length=30,
                    verbose_name='type')),
                ('details', models.TextField(default='', max_length=1000, verbose_name='details')),
                ('status', models.IntegerField(default=1, verbose_name='status')),
                ('comment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='db.Comment')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='book',
            name='license',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='book_license',
                                    to='db.License'),
        ),
        migrations.CreateModel(
            name='AdmonitionAction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='deleted at')),
                ('message', models.TextField(verbose_name='message')),
                ('type', models.CharField(
                    choices=[('systemAction', 'System Action'), ('msgFromUser', 'Message from member'),
                             ('msgToUser', 'Message to member'), ('internalMsg', 'Internal message')],
                    default='systemAction', max_length=30, verbose_name='type')),
                ('admonition', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='db.Admonition')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
