/*
 * Decompiled with CFR 0.152.
 */
package org.trustyai.arrowconverters;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.pojo.Schema;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.trustyai.arrowconverters.ArrowConverters;
import org.trustyai.arrowconverters.PredictionProviderArrow;

public class PPAWrapper
implements PredictionProvider {
    PredictionProviderArrow ppa;
    RootAllocator allocator;
    Schema inputSchema;

    public PPAWrapper(PredictionProviderArrow ppa, PredictionInput prototype) {
        this.ppa = ppa;
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
        this.inputSchema = ArrowConverters.generatePrototypePISchema(prototype);
    }

    public RootAllocator getAllocator() {
        return this.allocator;
    }

    public CompletableFuture<List<PredictionOutput>> predictAsync(List<PredictionInput> inputs) {
        CompletableFuture<byte[]> outBuf = CompletableFuture.supplyAsync(() -> ArrowConverters.write(ArrowConverters.convertPItoVSR(inputs, this.inputSchema, this.allocator)));
        CompletionStage resultBuffer = outBuf.thenCompose(ob -> this.ppa.predictAsync((byte[])ob));
        return ((CompletableFuture)resultBuffer).thenApply(rb -> ArrowConverters.read(rb, this.getAllocator()));
    }
}

