import { Function } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
/**
 * Props for `SipMediaApplication`.
 */
export interface SipMediaAppProps {
    /**
     * region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler
     *
     * @default - same region as stack deployment
     */
    readonly region?: string;
    /**
     * endpoint for SipMediaApplication(required)
     *
     * @default - none
     */
    readonly endpoint: Function['functionArn'];
    /**
     * name for SipMediaApplication (optional)
     *
     * @default - unique ID for resource
     */
    readonly name?: string;
}
export declare class ChimeSipMediaApp extends Construct {
    readonly sipMediaAppId: string;
    constructor(scope: Construct, id: string, props: SipMediaAppProps);
}
//# sourceMappingURL=sipMediaApplication.d.ts.map