"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sipRuleValidator = void 0;
var E164_NUMBER = /^\+[1-9]\d{10,14}$/;
var URI_HOSTNAME = /^[0-9a-z]{22}.voiceconnector.chime.aws$/;
var SMA_ID = /^[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}$/;
function sipRuleValidator(props) {
    if (props.triggerType) {
        if (props.triggerValue.includes('Token')) {
        }
        else {
            if (props.triggerType === 'ToPhoneNumber' &&
                !E164_NUMBER.test(props.triggerValue)) {
                throw new Error('Trigger Value must be must be valid E.164 number');
            }
            if (props.triggerType === 'RequestUriHostname' &&
                !URI_HOSTNAME.test(props.triggerValue)) {
                throw new Error('Trigger Value must be valid Chime Voice Connector');
            }
        }
    }
    for (var target of props.targetApplications) {
        if (target.sipMediaApplicationId.includes('Token')) {
        }
        else {
            if (!SMA_ID.test(target.sipMediaApplicationId)) {
                throw new Error('sipMediaApplicationId must be valid');
            }
        }
    }
    for (var target of props.targetApplications) {
        if (target.priority < 1 || target.priority > 25) {
            throw new Error('Priority should be between 1 and 25');
        }
    }
    for (var target of props.targetApplications) {
        if (target.region) {
            if (!(target.region.includes('Token[AWS.Region.') ||
                target.region === 'us-east-1' ||
                target.region === 'us-west-2')) {
                throw new Error('Region must be us-east-1 or us-west-2');
            }
        }
    }
    return true;
}
exports.sipRuleValidator = sipRuleValidator;
//# sourceMappingURL=data:application/json;base64,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