import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessContextManagerServicePerimeterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the ServicePerimeter and its use. Does not affect
  behavior.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#description AccessContextManagerServicePerimeter#description}
    */
    readonly description?: string;
    /**
    * Resource name for the ServicePerimeter. The short_name component must
  begin with a letter and only include alphanumeric and '_'.
  Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#name AccessContextManagerServicePerimeter#name}
    */
    readonly name: string;
    /**
    * The AccessPolicy this ServicePerimeter lives in.
  Format: accessPolicies/{policy_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#parent AccessContextManagerServicePerimeter#parent}
    */
    readonly parent: string;
    /**
    * Specifies the type of the Perimeter. There are two types: regular and
  bridge. Regular Service Perimeter contains resources, access levels,
  and restricted services. Every resource can be in at most
  ONE regular Service Perimeter.
  
  In addition to being in a regular service perimeter, a resource can also
  be in zero or more perimeter bridges. A perimeter bridge only contains
  resources. Cross project operations are permitted if all effected
  resources share some perimeter (whether bridge or regular). Perimeter
  Bridge does not contain access levels or services: those are governed
  entirely by the regular perimeter that resource is in.
  
  Perimeter Bridges are typically useful when building more complex
  topologies with many independent perimeters that need to share some data
  with a common perimeter, but should not be able to share data among
  themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#perimeter_type AccessContextManagerServicePerimeter#perimeter_type}
    */
    readonly perimeterType?: string;
    /**
    * Human readable title. Must be unique within the Policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#title AccessContextManagerServicePerimeter#title}
    */
    readonly title: string;
    /**
    * Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists
  for all Service Perimeters, and that spec is identical to the status for those
  Service Perimeters. When this flag is set, it inhibits the generation of the
  implicit spec, thereby allowing the user to explicitly provide a
  configuration ("spec") to use in a dry-run version of the Service Perimeter.
  This allows the user to test changes to the enforced config ("status") without
  actually enforcing them. This testing is done through analyzing the differences
  between currently enforced and suggested restrictions. useExplicitDryRunSpec must
  bet set to True if any of the fields in the spec are set to non-default values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#use_explicit_dry_run_spec AccessContextManagerServicePerimeter#use_explicit_dry_run_spec}
    */
    readonly useExplicitDryRunSpec?: boolean | cdktf.IResolvable;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#spec AccessContextManagerServicePerimeter#spec}
    */
    readonly spec?: AccessContextManagerServicePerimeterSpec;
    /**
    * status block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#status AccessContextManagerServicePerimeter#status}
    */
    readonly status?: AccessContextManagerServicePerimeterStatus;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#timeouts AccessContextManagerServicePerimeter#timeouts}
    */
    readonly timeouts?: AccessContextManagerServicePerimeterTimeouts;
}
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom {
    /**
    * A list of identities that are allowed access through this 'EgressPolicy'.
  Should be in the format of email address. The email address should
  represent individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identities AccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access to outside the
  perimeter. If left unspecified, then members of 'identities' field will
  be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identity_type AccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
}
export declare function accessContextManagerServicePerimeterSpecEgressPoliciesEgressFromToTerraform(struct?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromOutputReference | AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom): any;
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
}
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors {
    /**
    * Value for 'method' should be a valid method name for the corresponding
  'serviceName' in 'ApiOperation'. If '*' used as value for method,
  then ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method AccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#permission AccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with serviceName
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#service_name AccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method_selectors AccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsToTerraform(struct?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo {
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', that match this to stanza. A request matches
  if it contains a resource in this list. If * is specified for resources,
  then this 'EgressTo' rule will authorize access to all resources outside
  the perimeter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#operations AccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecEgressPoliciesEgressToToTerraform(struct?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOutputReference | AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo): any;
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo | undefined);
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
    set operations(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | cdktf.IResolvable);
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterSpecEgressPolicies {
    /**
    * egress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_from AccessContextManagerServicePerimeter#egress_from}
    */
    readonly egressFrom?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom;
    /**
    * egress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_to AccessContextManagerServicePerimeter#egress_to}
    */
    readonly egressTo?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo;
}
export declare function accessContextManagerServicePerimeterSpecEgressPoliciesToTerraform(struct?: AccessContextManagerServicePerimeterSpecEgressPolicies | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources {
    /**
    * An 'AccessLevel' resource name that allow resources within the
  'ServicePerimeters' to be accessed from the internet. 'AccessLevels' listed
  must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
  'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
  resources within the perimeter can only be accessed via Google Cloud calls
  with request origins within the perimeter.
  Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
  If * is specified, then all IngressSources will be allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#access_level AccessContextManagerServicePerimeter#access_level}
    */
    readonly accessLevel?: string;
    /**
    * A Google Cloud resource that is allowed to ingress the perimeter.
  Requests from these resources will be allowed to access perimeter data.
  Currently only projects are allowed. Format 'projects/{project_number}'
  The project may be in any Google Cloud organization, not just the
  organization that the perimeter is defined in. '*' is not allowed, the case
  of allowing all Google Cloud resources only is not supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resource AccessContextManagerServicePerimeter#resource}
    */
    readonly resource?: string;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom {
    /**
    * A list of identities that are allowed access through this ingress policy.
  Should be in the format of email address. The email address should represent
  individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identities AccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access from outside the
  perimeter. If left unspecified, then members of 'identities' field will be
  allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identity_type AccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#sources AccessContextManagerServicePerimeter#sources}
    */
    readonly sources?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesIngressFromToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromOutputReference | AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom): any;
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources?;
    get sources(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
    set sources(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | cdktf.IResolvable);
    resetSources(): void;
    get sourcesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | undefined;
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors {
    /**
    * Value for method should be a valid method name for the corresponding
  serviceName in 'ApiOperation'. If '*' used as value for 'method', then
  ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method AccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#permission AccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with 'serviceName'
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#service_name AccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method_selectors AccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo {
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', protected by this 'ServicePerimeter'
  that are allowed to be accessed by sources defined in the
  corresponding 'IngressFrom'. A request matches if it contains
  a resource in this list. If '*' is specified for resources,
  then this 'IngressTo' rule will authorize access to all
  resources inside the perimeter, provided that the request
  also matches the 'operations' field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#operations AccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesIngressToToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOutputReference | AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo): any;
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo | undefined);
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
    set operations(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | cdktf.IResolvable);
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterSpecIngressPolicies {
    /**
    * ingress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_from AccessContextManagerServicePerimeter#ingress_from}
    */
    readonly ingressFrom?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom;
    /**
    * ingress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_to AccessContextManagerServicePerimeter#ingress_to}
    */
    readonly ingressTo?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPolicies | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterSpecVpcAccessibleServices {
    /**
    * The list of APIs usable within the Service Perimeter.
  Must be empty unless 'enableRestriction' is True.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#allowed_services AccessContextManagerServicePerimeter#allowed_services}
    */
    readonly allowedServices?: string[];
    /**
    * Whether to restrict API calls within the Service Perimeter to the
  list of APIs specified in 'allowedServices'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#enable_restriction AccessContextManagerServicePerimeter#enable_restriction}
    */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecVpcAccessibleServicesToTerraform(struct?: AccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference | AccessContextManagerServicePerimeterSpecVpcAccessibleServices): any;
export declare class AccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined);
    private _allowedServices?;
    get allowedServices(): string[];
    set allowedServices(value: string[]);
    resetAllowedServices(): void;
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    get enableRestriction(): boolean | cdktf.IResolvable;
    set enableRestriction(value: boolean | cdktf.IResolvable);
    resetEnableRestriction(): void;
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AccessContextManagerServicePerimeterSpec {
    /**
    * A list of AccessLevel resource names that allow resources within
  the ServicePerimeter to be accessed from the internet.
  AccessLevels listed must be in the same policy as this
  ServicePerimeter. Referencing a nonexistent AccessLevel is a
  syntax error. If no AccessLevel names are listed, resources within
  the perimeter can only be accessed via GCP calls with request
  origins within the perimeter. For Service Perimeter Bridge, must
  be empty.
  
  Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#access_levels AccessContextManagerServicePerimeter#access_levels}
    */
    readonly accessLevels?: string[];
    /**
    * A list of GCP resources that are inside of the service perimeter.
  Currently only projects are allowed.
  Format: projects/{project_number}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * GCP services that are subject to the Service Perimeter
  restrictions. Must contain a list of services. For example, if
  'storage.googleapis.com' is specified, access to the storage
  buckets inside the perimeter must meet the perimeter's access
  restrictions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#restricted_services AccessContextManagerServicePerimeter#restricted_services}
    */
    readonly restrictedServices?: string[];
    /**
    * egress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_policies AccessContextManagerServicePerimeter#egress_policies}
    */
    readonly egressPolicies?: AccessContextManagerServicePerimeterSpecEgressPolicies[] | cdktf.IResolvable;
    /**
    * ingress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_policies AccessContextManagerServicePerimeter#ingress_policies}
    */
    readonly ingressPolicies?: AccessContextManagerServicePerimeterSpecIngressPolicies[] | cdktf.IResolvable;
    /**
    * vpc_accessible_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#vpc_accessible_services AccessContextManagerServicePerimeter#vpc_accessible_services}
    */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimeterSpecVpcAccessibleServices;
}
export declare function accessContextManagerServicePerimeterSpecToTerraform(struct?: AccessContextManagerServicePerimeterSpecOutputReference | AccessContextManagerServicePerimeterSpec): any;
export declare class AccessContextManagerServicePerimeterSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpec | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpec | undefined);
    private _accessLevels?;
    get accessLevels(): string[];
    set accessLevels(value: string[]);
    resetAccessLevels(): void;
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    get restrictedServices(): string[];
    set restrictedServices(value: string[]);
    resetRestrictedServices(): void;
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies?;
    get egressPolicies(): AccessContextManagerServicePerimeterSpecEgressPolicies[] | cdktf.IResolvable;
    set egressPolicies(value: AccessContextManagerServicePerimeterSpecEgressPolicies[] | cdktf.IResolvable);
    resetEgressPolicies(): void;
    get egressPoliciesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecEgressPolicies[] | undefined;
    private _ingressPolicies?;
    get ingressPolicies(): AccessContextManagerServicePerimeterSpecIngressPolicies[] | cdktf.IResolvable;
    set ingressPolicies(value: AccessContextManagerServicePerimeterSpecIngressPolicies[] | cdktf.IResolvable);
    resetIngressPolicies(): void;
    get ingressPoliciesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecIngressPolicies[] | undefined;
    private _vpcAccessibleServices;
    get vpcAccessibleServices(): AccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference;
    putVpcAccessibleServices(value: AccessContextManagerServicePerimeterSpecVpcAccessibleServices): void;
    resetVpcAccessibleServices(): void;
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined;
}
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom {
    /**
    * A list of identities that are allowed access through this 'EgressPolicy'.
  Should be in the format of email address. The email address should
  represent individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identities AccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access to outside the
  perimeter. If left unspecified, then members of 'identities' field will
  be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identity_type AccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
}
export declare function accessContextManagerServicePerimeterStatusEgressPoliciesEgressFromToTerraform(struct?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromOutputReference | AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom): any;
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
}
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors {
    /**
    * Value for 'method' should be a valid method name for the corresponding
  'serviceName' in 'ApiOperation'. If '*' used as value for method,
  then ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method AccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#permission AccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with serviceName
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#service_name AccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method_selectors AccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsToTerraform(struct?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo {
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', that match this to stanza. A request matches
  if it contains a resource in this list. If * is specified for resources,
  then this 'EgressTo' rule will authorize access to all resources outside
  the perimeter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#operations AccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusEgressPoliciesEgressToToTerraform(struct?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOutputReference | AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo): any;
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo | undefined);
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
    set operations(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | cdktf.IResolvable);
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterStatusEgressPolicies {
    /**
    * egress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_from AccessContextManagerServicePerimeter#egress_from}
    */
    readonly egressFrom?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom;
    /**
    * egress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_to AccessContextManagerServicePerimeter#egress_to}
    */
    readonly egressTo?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo;
}
export declare function accessContextManagerServicePerimeterStatusEgressPoliciesToTerraform(struct?: AccessContextManagerServicePerimeterStatusEgressPolicies | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources {
    /**
    * An 'AccessLevel' resource name that allow resources within the
  'ServicePerimeters' to be accessed from the internet. 'AccessLevels' listed
  must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
  'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
  resources within the perimeter can only be accessed via Google Cloud calls
  with request origins within the perimeter.
  Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
  If * is specified, then all IngressSources will be allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#access_level AccessContextManagerServicePerimeter#access_level}
    */
    readonly accessLevel?: string;
    /**
    * A Google Cloud resource that is allowed to ingress the perimeter.
  Requests from these resources will be allowed to access perimeter data.
  Currently only projects are allowed. Format 'projects/{project_number}'
  The project may be in any Google Cloud organization, not just the
  organization that the perimeter is defined in. '*' is not allowed, the case
  of allowing all Google Cloud resources only is not supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resource AccessContextManagerServicePerimeter#resource}
    */
    readonly resource?: string;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom {
    /**
    * A list of identities that are allowed access through this ingress policy.
  Should be in the format of email address. The email address should represent
  individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identities AccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access from outside the
  perimeter. If left unspecified, then members of 'identities' field will be
  allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identity_type AccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#sources AccessContextManagerServicePerimeter#sources}
    */
    readonly sources?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesIngressFromToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromOutputReference | AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom): any;
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources?;
    get sources(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
    set sources(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | cdktf.IResolvable);
    resetSources(): void;
    get sourcesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | undefined;
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors {
    /**
    * Value for method should be a valid method name for the corresponding
  serviceName in 'ApiOperation'. If '*' used as value for 'method', then
  ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method AccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#permission AccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with 'serviceName'
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#service_name AccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method_selectors AccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo {
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', protected by this 'ServicePerimeter'
  that are allowed to be accessed by sources defined in the
  corresponding 'IngressFrom'. A request matches if it contains
  a resource in this list. If '*' is specified for resources,
  then this 'IngressTo' rule will authorize access to all
  resources inside the perimeter, provided that the request
  also matches the 'operations' field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#operations AccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesIngressToToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOutputReference | AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo): any;
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo | undefined);
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations?;
    get operations(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
    set operations(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | cdktf.IResolvable);
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterStatusIngressPolicies {
    /**
    * ingress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_from AccessContextManagerServicePerimeter#ingress_from}
    */
    readonly ingressFrom?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom;
    /**
    * ingress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_to AccessContextManagerServicePerimeter#ingress_to}
    */
    readonly ingressTo?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPolicies | cdktf.IResolvable): any;
export interface AccessContextManagerServicePerimeterStatusVpcAccessibleServices {
    /**
    * The list of APIs usable within the Service Perimeter.
  Must be empty unless 'enableRestriction' is True.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#allowed_services AccessContextManagerServicePerimeter#allowed_services}
    */
    readonly allowedServices?: string[];
    /**
    * Whether to restrict API calls within the Service Perimeter to the
  list of APIs specified in 'allowedServices'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#enable_restriction AccessContextManagerServicePerimeter#enable_restriction}
    */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusVpcAccessibleServicesToTerraform(struct?: AccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference | AccessContextManagerServicePerimeterStatusVpcAccessibleServices): any;
export declare class AccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined);
    private _allowedServices?;
    get allowedServices(): string[];
    set allowedServices(value: string[]);
    resetAllowedServices(): void;
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    get enableRestriction(): boolean | cdktf.IResolvable;
    set enableRestriction(value: boolean | cdktf.IResolvable);
    resetEnableRestriction(): void;
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AccessContextManagerServicePerimeterStatus {
    /**
    * A list of AccessLevel resource names that allow resources within
  the ServicePerimeter to be accessed from the internet.
  AccessLevels listed must be in the same policy as this
  ServicePerimeter. Referencing a nonexistent AccessLevel is a
  syntax error. If no AccessLevel names are listed, resources within
  the perimeter can only be accessed via GCP calls with request
  origins within the perimeter. For Service Perimeter Bridge, must
  be empty.
  
  Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#access_levels AccessContextManagerServicePerimeter#access_levels}
    */
    readonly accessLevels?: string[];
    /**
    * A list of GCP resources that are inside of the service perimeter.
  Currently only projects are allowed.
  Format: projects/{project_number}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * GCP services that are subject to the Service Perimeter
  restrictions. Must contain a list of services. For example, if
  'storage.googleapis.com' is specified, access to the storage
  buckets inside the perimeter must meet the perimeter's access
  restrictions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#restricted_services AccessContextManagerServicePerimeter#restricted_services}
    */
    readonly restrictedServices?: string[];
    /**
    * egress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_policies AccessContextManagerServicePerimeter#egress_policies}
    */
    readonly egressPolicies?: AccessContextManagerServicePerimeterStatusEgressPolicies[] | cdktf.IResolvable;
    /**
    * ingress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_policies AccessContextManagerServicePerimeter#ingress_policies}
    */
    readonly ingressPolicies?: AccessContextManagerServicePerimeterStatusIngressPolicies[] | cdktf.IResolvable;
    /**
    * vpc_accessible_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#vpc_accessible_services AccessContextManagerServicePerimeter#vpc_accessible_services}
    */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimeterStatusVpcAccessibleServices;
}
export declare function accessContextManagerServicePerimeterStatusToTerraform(struct?: AccessContextManagerServicePerimeterStatusOutputReference | AccessContextManagerServicePerimeterStatus): any;
export declare class AccessContextManagerServicePerimeterStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatus | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatus | undefined);
    private _accessLevels?;
    get accessLevels(): string[];
    set accessLevels(value: string[]);
    resetAccessLevels(): void;
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    get restrictedServices(): string[];
    set restrictedServices(value: string[]);
    resetRestrictedServices(): void;
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies?;
    get egressPolicies(): AccessContextManagerServicePerimeterStatusEgressPolicies[] | cdktf.IResolvable;
    set egressPolicies(value: AccessContextManagerServicePerimeterStatusEgressPolicies[] | cdktf.IResolvable);
    resetEgressPolicies(): void;
    get egressPoliciesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusEgressPolicies[] | undefined;
    private _ingressPolicies?;
    get ingressPolicies(): AccessContextManagerServicePerimeterStatusIngressPolicies[] | cdktf.IResolvable;
    set ingressPolicies(value: AccessContextManagerServicePerimeterStatusIngressPolicies[] | cdktf.IResolvable);
    resetIngressPolicies(): void;
    get ingressPoliciesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusIngressPolicies[] | undefined;
    private _vpcAccessibleServices;
    get vpcAccessibleServices(): AccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference;
    putVpcAccessibleServices(value: AccessContextManagerServicePerimeterStatusVpcAccessibleServices): void;
    resetVpcAccessibleServices(): void;
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined;
}
export interface AccessContextManagerServicePerimeterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#create AccessContextManagerServicePerimeter#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#delete AccessContextManagerServicePerimeter#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#update AccessContextManagerServicePerimeter#update}
    */
    readonly update?: string;
}
export declare function accessContextManagerServicePerimeterTimeoutsToTerraform(struct?: AccessContextManagerServicePerimeterTimeoutsOutputReference | AccessContextManagerServicePerimeterTimeouts | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterTimeouts | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter google_access_context_manager_service_perimeter}
*/
export declare class AccessContextManagerServicePerimeter extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_service_perimeter";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter google_access_context_manager_service_perimeter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccessContextManagerServicePerimeterConfig
    */
    constructor(scope: Construct, id: string, config: AccessContextManagerServicePerimeterConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _perimeterType?;
    get perimeterType(): string;
    set perimeterType(value: string);
    resetPerimeterType(): void;
    get perimeterTypeInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    get updateTime(): string;
    private _useExplicitDryRunSpec?;
    get useExplicitDryRunSpec(): boolean | cdktf.IResolvable;
    set useExplicitDryRunSpec(value: boolean | cdktf.IResolvable);
    resetUseExplicitDryRunSpec(): void;
    get useExplicitDryRunSpecInput(): boolean | cdktf.IResolvable | undefined;
    private _spec;
    get spec(): AccessContextManagerServicePerimeterSpecOutputReference;
    putSpec(value: AccessContextManagerServicePerimeterSpec): void;
    resetSpec(): void;
    get specInput(): AccessContextManagerServicePerimeterSpec | undefined;
    private _status;
    get status(): AccessContextManagerServicePerimeterStatusOutputReference;
    putStatus(value: AccessContextManagerServicePerimeterStatus): void;
    resetStatus(): void;
    get statusInput(): AccessContextManagerServicePerimeterStatus | undefined;
    private _timeouts;
    get timeouts(): AccessContextManagerServicePerimeterTimeoutsOutputReference;
    putTimeouts(value: AccessContextManagerServicePerimeterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AccessContextManagerServicePerimeterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
