"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BillingBudget = exports.BillingBudgetTimeoutsOutputReference = exports.billingBudgetTimeoutsToTerraform = exports.billingBudgetThresholdRulesToTerraform = exports.BillingBudgetBudgetFilterOutputReference = exports.billingBudgetBudgetFilterToTerraform = exports.BillingBudgetAmountOutputReference = exports.billingBudgetAmountToTerraform = exports.BillingBudgetAmountSpecifiedAmountOutputReference = exports.billingBudgetAmountSpecifiedAmountToTerraform = exports.BillingBudgetAllUpdatesRuleOutputReference = exports.billingBudgetAllUpdatesRuleToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function billingBudgetAllUpdatesRuleToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disable_default_iam_recipients: cdktf.booleanToTerraform(struct.disableDefaultIamRecipients),
        monitoring_notification_channels: cdktf.listMapper(cdktf.stringToTerraform)(struct.monitoringNotificationChannels),
        pubsub_topic: cdktf.stringToTerraform(struct.pubsubTopic),
        schema_version: cdktf.stringToTerraform(struct.schemaVersion),
    };
}
exports.billingBudgetAllUpdatesRuleToTerraform = billingBudgetAllUpdatesRuleToTerraform;
class BillingBudgetAllUpdatesRuleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._disableDefaultIamRecipients !== undefined) {
            hasAnyValues = true;
            internalValueResult.disableDefaultIamRecipients = this._disableDefaultIamRecipients;
        }
        if (this._monitoringNotificationChannels !== undefined) {
            hasAnyValues = true;
            internalValueResult.monitoringNotificationChannels = this._monitoringNotificationChannels;
        }
        if (this._pubsubTopic !== undefined) {
            hasAnyValues = true;
            internalValueResult.pubsubTopic = this._pubsubTopic;
        }
        if (this._schemaVersion !== undefined) {
            hasAnyValues = true;
            internalValueResult.schemaVersion = this._schemaVersion;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._disableDefaultIamRecipients = undefined;
            this._monitoringNotificationChannels = undefined;
            this._pubsubTopic = undefined;
            this._schemaVersion = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._disableDefaultIamRecipients = value.disableDefaultIamRecipients;
            this._monitoringNotificationChannels = value.monitoringNotificationChannels;
            this._pubsubTopic = value.pubsubTopic;
            this._schemaVersion = value.schemaVersion;
        }
    }
    get disableDefaultIamRecipients() {
        return this.getBooleanAttribute('disable_default_iam_recipients');
    }
    set disableDefaultIamRecipients(value) {
        this._disableDefaultIamRecipients = value;
    }
    resetDisableDefaultIamRecipients() {
        this._disableDefaultIamRecipients = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableDefaultIamRecipientsInput() {
        return this._disableDefaultIamRecipients;
    }
    get monitoringNotificationChannels() {
        return this.getListAttribute('monitoring_notification_channels');
    }
    set monitoringNotificationChannels(value) {
        this._monitoringNotificationChannels = value;
    }
    resetMonitoringNotificationChannels() {
        this._monitoringNotificationChannels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get monitoringNotificationChannelsInput() {
        return this._monitoringNotificationChannels;
    }
    get pubsubTopic() {
        return this.getStringAttribute('pubsub_topic');
    }
    set pubsubTopic(value) {
        this._pubsubTopic = value;
    }
    resetPubsubTopic() {
        this._pubsubTopic = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pubsubTopicInput() {
        return this._pubsubTopic;
    }
    get schemaVersion() {
        return this.getStringAttribute('schema_version');
    }
    set schemaVersion(value) {
        this._schemaVersion = value;
    }
    resetSchemaVersion() {
        this._schemaVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get schemaVersionInput() {
        return this._schemaVersion;
    }
}
exports.BillingBudgetAllUpdatesRuleOutputReference = BillingBudgetAllUpdatesRuleOutputReference;
_a = JSII_RTTI_SYMBOL_1;
BillingBudgetAllUpdatesRuleOutputReference[_a] = { fqn: "@cdktf/provider-google.BillingBudgetAllUpdatesRuleOutputReference", version: "0.7.4" };
function billingBudgetAmountSpecifiedAmountToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        currency_code: cdktf.stringToTerraform(struct.currencyCode),
        nanos: cdktf.numberToTerraform(struct.nanos),
        units: cdktf.stringToTerraform(struct.units),
    };
}
exports.billingBudgetAmountSpecifiedAmountToTerraform = billingBudgetAmountSpecifiedAmountToTerraform;
class BillingBudgetAmountSpecifiedAmountOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._currencyCode !== undefined) {
            hasAnyValues = true;
            internalValueResult.currencyCode = this._currencyCode;
        }
        if (this._nanos !== undefined) {
            hasAnyValues = true;
            internalValueResult.nanos = this._nanos;
        }
        if (this._units !== undefined) {
            hasAnyValues = true;
            internalValueResult.units = this._units;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._currencyCode = undefined;
            this._nanos = undefined;
            this._units = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._currencyCode = value.currencyCode;
            this._nanos = value.nanos;
            this._units = value.units;
        }
    }
    get currencyCode() {
        return this.getStringAttribute('currency_code');
    }
    set currencyCode(value) {
        this._currencyCode = value;
    }
    resetCurrencyCode() {
        this._currencyCode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get currencyCodeInput() {
        return this._currencyCode;
    }
    get nanos() {
        return this.getNumberAttribute('nanos');
    }
    set nanos(value) {
        this._nanos = value;
    }
    resetNanos() {
        this._nanos = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nanosInput() {
        return this._nanos;
    }
    get units() {
        return this.getStringAttribute('units');
    }
    set units(value) {
        this._units = value;
    }
    resetUnits() {
        this._units = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get unitsInput() {
        return this._units;
    }
}
exports.BillingBudgetAmountSpecifiedAmountOutputReference = BillingBudgetAmountSpecifiedAmountOutputReference;
_b = JSII_RTTI_SYMBOL_1;
BillingBudgetAmountSpecifiedAmountOutputReference[_b] = { fqn: "@cdktf/provider-google.BillingBudgetAmountSpecifiedAmountOutputReference", version: "0.7.4" };
function billingBudgetAmountToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        last_period_amount: cdktf.booleanToTerraform(struct.lastPeriodAmount),
        specified_amount: billingBudgetAmountSpecifiedAmountToTerraform(struct.specifiedAmount),
    };
}
exports.billingBudgetAmountToTerraform = billingBudgetAmountToTerraform;
class BillingBudgetAmountOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // specified_amount - computed: false, optional: true, required: false
        this._specifiedAmount = new BillingBudgetAmountSpecifiedAmountOutputReference(this, "specified_amount");
    }
    get internalValue() {
        var _g, _h;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._lastPeriodAmount !== undefined) {
            hasAnyValues = true;
            internalValueResult.lastPeriodAmount = this._lastPeriodAmount;
        }
        if (((_g = this._specifiedAmount) === null || _g === void 0 ? void 0 : _g.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.specifiedAmount = (_h = this._specifiedAmount) === null || _h === void 0 ? void 0 : _h.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._lastPeriodAmount = undefined;
            this._specifiedAmount.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._lastPeriodAmount = value.lastPeriodAmount;
            this._specifiedAmount.internalValue = value.specifiedAmount;
        }
    }
    get lastPeriodAmount() {
        return this.getBooleanAttribute('last_period_amount');
    }
    set lastPeriodAmount(value) {
        this._lastPeriodAmount = value;
    }
    resetLastPeriodAmount() {
        this._lastPeriodAmount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lastPeriodAmountInput() {
        return this._lastPeriodAmount;
    }
    get specifiedAmount() {
        return this._specifiedAmount;
    }
    putSpecifiedAmount(value) {
        this._specifiedAmount.internalValue = value;
    }
    resetSpecifiedAmount() {
        this._specifiedAmount.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get specifiedAmountInput() {
        return this._specifiedAmount.internalValue;
    }
}
exports.BillingBudgetAmountOutputReference = BillingBudgetAmountOutputReference;
_c = JSII_RTTI_SYMBOL_1;
BillingBudgetAmountOutputReference[_c] = { fqn: "@cdktf/provider-google.BillingBudgetAmountOutputReference", version: "0.7.4" };
function billingBudgetBudgetFilterToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        credit_types: cdktf.listMapper(cdktf.stringToTerraform)(struct.creditTypes),
        credit_types_treatment: cdktf.stringToTerraform(struct.creditTypesTreatment),
        labels: cdktf.hashMapper(cdktf.stringToTerraform)(struct.labels),
        projects: cdktf.listMapper(cdktf.stringToTerraform)(struct.projects),
        services: cdktf.listMapper(cdktf.stringToTerraform)(struct.services),
        subaccounts: cdktf.listMapper(cdktf.stringToTerraform)(struct.subaccounts),
    };
}
exports.billingBudgetBudgetFilterToTerraform = billingBudgetBudgetFilterToTerraform;
class BillingBudgetBudgetFilterOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._creditTypes !== undefined) {
            hasAnyValues = true;
            internalValueResult.creditTypes = this._creditTypes;
        }
        if (this._creditTypesTreatment !== undefined) {
            hasAnyValues = true;
            internalValueResult.creditTypesTreatment = this._creditTypesTreatment;
        }
        if (this._labels !== undefined) {
            hasAnyValues = true;
            internalValueResult.labels = this._labels;
        }
        if (this._projects !== undefined) {
            hasAnyValues = true;
            internalValueResult.projects = this._projects;
        }
        if (this._services !== undefined) {
            hasAnyValues = true;
            internalValueResult.services = this._services;
        }
        if (this._subaccounts !== undefined) {
            hasAnyValues = true;
            internalValueResult.subaccounts = this._subaccounts;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._creditTypes = undefined;
            this._creditTypesTreatment = undefined;
            this._labels = undefined;
            this._projects = undefined;
            this._services = undefined;
            this._subaccounts = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._creditTypes = value.creditTypes;
            this._creditTypesTreatment = value.creditTypesTreatment;
            this._labels = value.labels;
            this._projects = value.projects;
            this._services = value.services;
            this._subaccounts = value.subaccounts;
        }
    }
    get creditTypes() {
        return this.getListAttribute('credit_types');
    }
    set creditTypes(value) {
        this._creditTypes = value;
    }
    resetCreditTypes() {
        this._creditTypes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get creditTypesInput() {
        return this._creditTypes;
    }
    get creditTypesTreatment() {
        return this.getStringAttribute('credit_types_treatment');
    }
    set creditTypesTreatment(value) {
        this._creditTypesTreatment = value;
    }
    resetCreditTypesTreatment() {
        this._creditTypesTreatment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get creditTypesTreatmentInput() {
        return this._creditTypesTreatment;
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get projects() {
        return cdktf.Fn.tolist(this.getListAttribute('projects'));
    }
    set projects(value) {
        this._projects = value;
    }
    resetProjects() {
        this._projects = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectsInput() {
        return this._projects;
    }
    get services() {
        return this.getListAttribute('services');
    }
    set services(value) {
        this._services = value;
    }
    resetServices() {
        this._services = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get servicesInput() {
        return this._services;
    }
    get subaccounts() {
        return this.getListAttribute('subaccounts');
    }
    set subaccounts(value) {
        this._subaccounts = value;
    }
    resetSubaccounts() {
        this._subaccounts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subaccountsInput() {
        return this._subaccounts;
    }
}
exports.BillingBudgetBudgetFilterOutputReference = BillingBudgetBudgetFilterOutputReference;
_d = JSII_RTTI_SYMBOL_1;
BillingBudgetBudgetFilterOutputReference[_d] = { fqn: "@cdktf/provider-google.BillingBudgetBudgetFilterOutputReference", version: "0.7.4" };
function billingBudgetThresholdRulesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        spend_basis: cdktf.stringToTerraform(struct.spendBasis),
        threshold_percent: cdktf.numberToTerraform(struct.thresholdPercent),
    };
}
exports.billingBudgetThresholdRulesToTerraform = billingBudgetThresholdRulesToTerraform;
function billingBudgetTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.billingBudgetTimeoutsToTerraform = billingBudgetTimeoutsToTerraform;
class BillingBudgetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.BillingBudgetTimeoutsOutputReference = BillingBudgetTimeoutsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
BillingBudgetTimeoutsOutputReference[_e] = { fqn: "@cdktf/provider-google.BillingBudgetTimeoutsOutputReference", version: "0.7.4" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/billing_budget google_billing_budget}
*/
class BillingBudget extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/billing_budget google_billing_budget} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BillingBudgetConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_billing_budget',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '3.90.1',
                providerVersionConstraint: '~> 3.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // all_updates_rule - computed: false, optional: true, required: false
        this._allUpdatesRule = new BillingBudgetAllUpdatesRuleOutputReference(this, "all_updates_rule");
        // amount - computed: false, optional: false, required: true
        this._amount = new BillingBudgetAmountOutputReference(this, "amount");
        // budget_filter - computed: false, optional: true, required: false
        this._budgetFilter = new BillingBudgetBudgetFilterOutputReference(this, "budget_filter");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new BillingBudgetTimeoutsOutputReference(this, "timeouts");
        this._billingAccount = config.billingAccount;
        this._displayName = config.displayName;
        this._allUpdatesRule.internalValue = config.allUpdatesRule;
        this._amount.internalValue = config.amount;
        this._budgetFilter.internalValue = config.budgetFilter;
        this._thresholdRules = config.thresholdRules;
        this._timeouts.internalValue = config.timeouts;
    }
    get billingAccount() {
        return this.getStringAttribute('billing_account');
    }
    set billingAccount(value) {
        this._billingAccount = value;
    }
    // Temporarily expose input value. Use with caution.
    get billingAccountInput() {
        return this._billingAccount;
    }
    get displayName() {
        return this.getStringAttribute('display_name');
    }
    set displayName(value) {
        this._displayName = value;
    }
    resetDisplayName() {
        this._displayName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get displayNameInput() {
        return this._displayName;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    get allUpdatesRule() {
        return this._allUpdatesRule;
    }
    putAllUpdatesRule(value) {
        this._allUpdatesRule.internalValue = value;
    }
    resetAllUpdatesRule() {
        this._allUpdatesRule.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allUpdatesRuleInput() {
        return this._allUpdatesRule.internalValue;
    }
    get amount() {
        return this._amount;
    }
    putAmount(value) {
        this._amount.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get amountInput() {
        return this._amount.internalValue;
    }
    get budgetFilter() {
        return this._budgetFilter;
    }
    putBudgetFilter(value) {
        this._budgetFilter.internalValue = value;
    }
    resetBudgetFilter() {
        this._budgetFilter.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get budgetFilterInput() {
        return this._budgetFilter.internalValue;
    }
    get thresholdRules() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('threshold_rules');
    }
    set thresholdRules(value) {
        this._thresholdRules = value;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdRulesInput() {
        return this._thresholdRules;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            billing_account: cdktf.stringToTerraform(this._billingAccount),
            display_name: cdktf.stringToTerraform(this._displayName),
            all_updates_rule: billingBudgetAllUpdatesRuleToTerraform(this._allUpdatesRule.internalValue),
            amount: billingBudgetAmountToTerraform(this._amount.internalValue),
            budget_filter: billingBudgetBudgetFilterToTerraform(this._budgetFilter.internalValue),
            threshold_rules: cdktf.listMapper(billingBudgetThresholdRulesToTerraform)(this._thresholdRules),
            timeouts: billingBudgetTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.BillingBudget = BillingBudget;
_f = JSII_RTTI_SYMBOL_1;
BillingBudget[_f] = { fqn: "@cdktf/provider-google.BillingBudget", version: "0.7.4" };
// =================
// STATIC PROPERTIES
// =================
BillingBudget.tfResourceType = "google_billing_budget";
//# sourceMappingURL=data:application/json;base64,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