import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudAssetFolderFeedConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of the full names of the assets to receive updates. You must specify either or both of
  assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
  exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
  See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#asset_names CloudAssetFolderFeed#asset_names}
    */
    readonly assetNames?: string[];
    /**
    * A list of types of the assets to receive updates. You must specify either or both of assetNames
  and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
  the feed. For example: "compute.googleapis.com/Disk"
  See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
  supported asset types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#asset_types CloudAssetFolderFeed#asset_types}
    */
    readonly assetTypes?: string[];
    /**
    * The project whose identity will be used when sending messages to the
  destination pubsub topic. It also specifies the project for API
  enablement check, quota, and billing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#billing_project CloudAssetFolderFeed#billing_project}
    */
    readonly billingProject: string;
    /**
    * Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#content_type CloudAssetFolderFeed#content_type}
    */
    readonly contentType?: string;
    /**
    * This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#feed_id CloudAssetFolderFeed#feed_id}
    */
    readonly feedId: string;
    /**
    * The folder this feed should be created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#folder CloudAssetFolderFeed#folder}
    */
    readonly folder: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#condition CloudAssetFolderFeed#condition}
    */
    readonly condition?: CloudAssetFolderFeedCondition;
    /**
    * feed_output_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#feed_output_config CloudAssetFolderFeed#feed_output_config}
    */
    readonly feedOutputConfig: CloudAssetFolderFeedFeedOutputConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#timeouts CloudAssetFolderFeed#timeouts}
    */
    readonly timeouts?: CloudAssetFolderFeedTimeouts;
}
export interface CloudAssetFolderFeedCondition {
    /**
    * Description of the expression. This is a longer text which describes the expression,
  e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#description CloudAssetFolderFeed#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#expression CloudAssetFolderFeed#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file
  name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#location CloudAssetFolderFeed#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
  This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#title CloudAssetFolderFeed#title}
    */
    readonly title?: string;
}
export declare function cloudAssetFolderFeedConditionToTerraform(struct?: CloudAssetFolderFeedConditionOutputReference | CloudAssetFolderFeedCondition): any;
export declare class CloudAssetFolderFeedConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAssetFolderFeedCondition | undefined;
    set internalValue(value: CloudAssetFolderFeedCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface CloudAssetFolderFeedFeedOutputConfigPubsubDestination {
    /**
    * Destination on Cloud Pubsub topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#topic CloudAssetFolderFeed#topic}
    */
    readonly topic: string;
}
export declare function cloudAssetFolderFeedFeedOutputConfigPubsubDestinationToTerraform(struct?: CloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference | CloudAssetFolderFeedFeedOutputConfigPubsubDestination): any;
export declare class CloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAssetFolderFeedFeedOutputConfigPubsubDestination | undefined;
    set internalValue(value: CloudAssetFolderFeedFeedOutputConfigPubsubDestination | undefined);
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface CloudAssetFolderFeedFeedOutputConfig {
    /**
    * pubsub_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#pubsub_destination CloudAssetFolderFeed#pubsub_destination}
    */
    readonly pubsubDestination: CloudAssetFolderFeedFeedOutputConfigPubsubDestination;
}
export declare function cloudAssetFolderFeedFeedOutputConfigToTerraform(struct?: CloudAssetFolderFeedFeedOutputConfigOutputReference | CloudAssetFolderFeedFeedOutputConfig): any;
export declare class CloudAssetFolderFeedFeedOutputConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAssetFolderFeedFeedOutputConfig | undefined;
    set internalValue(value: CloudAssetFolderFeedFeedOutputConfig | undefined);
    private _pubsubDestination;
    get pubsubDestination(): CloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference;
    putPubsubDestination(value: CloudAssetFolderFeedFeedOutputConfigPubsubDestination): void;
    get pubsubDestinationInput(): CloudAssetFolderFeedFeedOutputConfigPubsubDestination | undefined;
}
export interface CloudAssetFolderFeedTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#create CloudAssetFolderFeed#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#delete CloudAssetFolderFeed#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#update CloudAssetFolderFeed#update}
    */
    readonly update?: string;
}
export declare function cloudAssetFolderFeedTimeoutsToTerraform(struct?: CloudAssetFolderFeedTimeoutsOutputReference | CloudAssetFolderFeedTimeouts | cdktf.IResolvable): any;
export declare class CloudAssetFolderFeedTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAssetFolderFeedTimeouts | undefined;
    set internalValue(value: CloudAssetFolderFeedTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed google_cloud_asset_folder_feed}
*/
export declare class CloudAssetFolderFeed extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_asset_folder_feed";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed google_cloud_asset_folder_feed} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudAssetFolderFeedConfig
    */
    constructor(scope: Construct, id: string, config: CloudAssetFolderFeedConfig);
    private _assetNames?;
    get assetNames(): string[];
    set assetNames(value: string[]);
    resetAssetNames(): void;
    get assetNamesInput(): string[] | undefined;
    private _assetTypes?;
    get assetTypes(): string[];
    set assetTypes(value: string[]);
    resetAssetTypes(): void;
    get assetTypesInput(): string[] | undefined;
    private _billingProject?;
    get billingProject(): string;
    set billingProject(value: string);
    get billingProjectInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _feedId?;
    get feedId(): string;
    set feedId(value: string);
    get feedIdInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get folderId(): string;
    get id(): string;
    get name(): string;
    private _condition;
    get condition(): CloudAssetFolderFeedConditionOutputReference;
    putCondition(value: CloudAssetFolderFeedCondition): void;
    resetCondition(): void;
    get conditionInput(): CloudAssetFolderFeedCondition | undefined;
    private _feedOutputConfig;
    get feedOutputConfig(): CloudAssetFolderFeedFeedOutputConfigOutputReference;
    putFeedOutputConfig(value: CloudAssetFolderFeedFeedOutputConfig): void;
    get feedOutputConfigInput(): CloudAssetFolderFeedFeedOutputConfig | undefined;
    private _timeouts;
    get timeouts(): CloudAssetFolderFeedTimeoutsOutputReference;
    putTimeouts(value: CloudAssetFolderFeedTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudAssetFolderFeedTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
