import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeBackendServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Lifetime of cookies in seconds if session_affinity is
  GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
  only until the end of the browser session (or equivalent). The
  maximum allowed value for TTL is one day.
  
  When the load balancing scheme is INTERNAL, this field is not used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#affinity_cookie_ttl_sec ComputeBackendService#affinity_cookie_ttl_sec}
    */
    readonly affinityCookieTtlSec?: number;
    /**
    * Time for which instance will be drained (not accept new
  connections, but still work to finish started).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#connection_draining_timeout_sec ComputeBackendService#connection_draining_timeout_sec}
    */
    readonly connectionDrainingTimeoutSec?: number;
    /**
    * Headers that the HTTP/S load balancer should add to proxied
  requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#custom_request_headers ComputeBackendService#custom_request_headers}
    */
    readonly customRequestHeaders?: string[];
    /**
    * Headers that the HTTP/S load balancer should add to proxied
  responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#custom_response_headers ComputeBackendService#custom_response_headers}
    */
    readonly customResponseHeaders?: string[];
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#description ComputeBackendService#description}
    */
    readonly description?: string;
    /**
    * If true, enable Cloud CDN for this BackendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#enable_cdn ComputeBackendService#enable_cdn}
    */
    readonly enableCdn?: boolean | cdktf.IResolvable;
    /**
    * The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
  for health checking this BackendService. Currently at most one health
  check can be specified.
  
  A health check must be specified unless the backend service uses an internet
  or serverless NEG as a backend.
  
  For internal load balancing, a URL to a HealthCheck resource must be specified instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#health_checks ComputeBackendService#health_checks}
    */
    readonly healthChecks?: string[];
    /**
    * Indicates whether the backend service will be used with internal or
  external load balancing. A backend service created for one type of
  load balancing cannot be used with the other. Default value: "EXTERNAL" Possible values: ["EXTERNAL", "INTERNAL_SELF_MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#load_balancing_scheme ComputeBackendService#load_balancing_scheme}
    */
    readonly loadBalancingScheme?: string;
    /**
    * The load balancing algorithm used within the scope of the locality.
  The possible values are -
  
  * ROUND_ROBIN - This is a simple policy in which each healthy backend
                  is selected in round robin order.
  
  * LEAST_REQUEST - An O(1) algorithm which selects two random healthy
                    hosts and picks the host which has fewer active requests.
  
  * RING_HASH - The ring/modulo hash load balancer implements consistent
                hashing to backends. The algorithm has the property that the
                addition/removal of a host from a set of N hosts only affects
                1/N of the requests.
  
  * RANDOM - The load balancer selects a random healthy host.
  
  * ORIGINAL_DESTINATION - Backend host is selected based on the client
                           connection metadata, i.e., connections are opened
                           to the same address as the destination address of
                           the incoming connection before the connection
                           was redirected to the load balancer.
  
  * MAGLEV - used as a drop in replacement for the ring hash load balancer.
             Maglev is not as stable as ring hash but has faster table lookup
             build times and host selection times. For more information about
             Maglev, refer to https://ai.google/research/pubs/pub44824
  
  This field is applicable only when the load_balancing_scheme is set to
  INTERNAL_SELF_MANAGED. Possible values: ["ROUND_ROBIN", "LEAST_REQUEST", "RING_HASH", "RANDOM", "ORIGINAL_DESTINATION", "MAGLEV"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#locality_lb_policy ComputeBackendService#locality_lb_policy}
    */
    readonly localityLbPolicy?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#name ComputeBackendService#name}
    */
    readonly name: string;
    /**
    * Name of backend port. The same name should appear in the instance
  groups referenced by this service. Required when the load balancing
  scheme is EXTERNAL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#port_name ComputeBackendService#port_name}
    */
    readonly portName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#project ComputeBackendService#project}
    */
    readonly project?: string;
    /**
    * The protocol this BackendService uses to communicate with backends.
  The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
  types and may result in errors if used with the GA API. Possible values: ["HTTP", "HTTPS", "HTTP2", "TCP", "SSL", "GRPC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#protocol ComputeBackendService#protocol}
    */
    readonly protocol?: string;
    /**
    * The security policy associated with this backend service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#security_policy ComputeBackendService#security_policy}
    */
    readonly securityPolicy?: string;
    /**
    * Type of session affinity to use. The default is NONE. Session affinity is
  not applicable if the protocol is UDP. Possible values: ["NONE", "CLIENT_IP", "CLIENT_IP_PORT_PROTO", "CLIENT_IP_PROTO", "GENERATED_COOKIE", "HEADER_FIELD", "HTTP_COOKIE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#session_affinity ComputeBackendService#session_affinity}
    */
    readonly sessionAffinity?: string;
    /**
    * How many seconds to wait for the backend before considering it a
  failed request. Default is 30 seconds. Valid range is [1, 86400].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#timeout_sec ComputeBackendService#timeout_sec}
    */
    readonly timeoutSec?: number;
    /**
    * backend block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#backend ComputeBackendService#backend}
    */
    readonly backend?: ComputeBackendServiceBackend[] | cdktf.IResolvable;
    /**
    * cdn_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#cdn_policy ComputeBackendService#cdn_policy}
    */
    readonly cdnPolicy?: ComputeBackendServiceCdnPolicy;
    /**
    * circuit_breakers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#circuit_breakers ComputeBackendService#circuit_breakers}
    */
    readonly circuitBreakers?: ComputeBackendServiceCircuitBreakers;
    /**
    * consistent_hash block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#consistent_hash ComputeBackendService#consistent_hash}
    */
    readonly consistentHash?: ComputeBackendServiceConsistentHash;
    /**
    * iap block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#iap ComputeBackendService#iap}
    */
    readonly iap?: ComputeBackendServiceIap;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#log_config ComputeBackendService#log_config}
    */
    readonly logConfig?: ComputeBackendServiceLogConfig;
    /**
    * outlier_detection block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#outlier_detection ComputeBackendService#outlier_detection}
    */
    readonly outlierDetection?: ComputeBackendServiceOutlierDetection;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#timeouts ComputeBackendService#timeouts}
    */
    readonly timeouts?: ComputeBackendServiceTimeouts;
}
export interface ComputeBackendServiceBackend {
    /**
    * Specifies the balancing mode for this backend.
  
  For global HTTP(S) or TCP/SSL load balancing, the default is
  UTILIZATION. Valid values are UTILIZATION, RATE (for HTTP(S))
  and CONNECTION (for TCP/SSL). Default value: "UTILIZATION" Possible values: ["UTILIZATION", "RATE", "CONNECTION"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#balancing_mode ComputeBackendService#balancing_mode}
    */
    readonly balancingMode?: string;
    /**
    * A multiplier applied to the group's maximum servicing capacity
  (based on UTILIZATION, RATE or CONNECTION).
  
  Default value is 1, which means the group will serve up to 100%
  of its configured capacity (depending on balancingMode). A
  setting of 0 means the group is completely drained, offering
  0% of its available Capacity. Valid range is [0.0,1.0].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#capacity_scaler ComputeBackendService#capacity_scaler}
    */
    readonly capacityScaler?: number;
    /**
    * An optional description of this resource.
  Provide this property when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#description ComputeBackendService#description}
    */
    readonly description?: string;
    /**
    * The fully-qualified URL of an Instance Group or Network Endpoint
  Group resource. In case of instance group this defines the list
  of instances that serve traffic. Member virtual machine
  instances from each instance group must live in the same zone as
  the instance group itself. No two backends in a backend service
  are allowed to use same Instance Group resource.
  
  For Network Endpoint Groups this defines list of endpoints. All
  endpoints of Network Endpoint Group must be hosted on instances
  located in the same zone as the Network Endpoint Group.
  
  Backend services cannot mix Instance Group and
  Network Endpoint Group backends.
  
  Note that you must specify an Instance Group or Network Endpoint
  Group resource using the fully-qualified URL, rather than a
  partial URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#group ComputeBackendService#group}
    */
    readonly group: string;
    /**
    * The max number of simultaneous connections for the group. Can
  be used with either CONNECTION or UTILIZATION balancing modes.
  
  For CONNECTION mode, either maxConnections or one
  of maxConnectionsPerInstance or maxConnectionsPerEndpoint,
  as appropriate for group type, must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_connections ComputeBackendService#max_connections}
    */
    readonly maxConnections?: number;
    /**
    * The max number of simultaneous connections that a single backend
  network endpoint can handle. This is used to calculate the
  capacity of the group. Can be used in either CONNECTION or
  UTILIZATION balancing modes.
  
  For CONNECTION mode, either
  maxConnections or maxConnectionsPerEndpoint must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_connections_per_endpoint ComputeBackendService#max_connections_per_endpoint}
    */
    readonly maxConnectionsPerEndpoint?: number;
    /**
    * The max number of simultaneous connections that a single
  backend instance can handle. This is used to calculate the
  capacity of the group. Can be used in either CONNECTION or
  UTILIZATION balancing modes.
  
  For CONNECTION mode, either maxConnections or
  maxConnectionsPerInstance must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_connections_per_instance ComputeBackendService#max_connections_per_instance}
    */
    readonly maxConnectionsPerInstance?: number;
    /**
    * The max requests per second (RPS) of the group.
  
  Can be used with either RATE or UTILIZATION balancing modes,
  but required if RATE mode. For RATE mode, either maxRate or one
  of maxRatePerInstance or maxRatePerEndpoint, as appropriate for
  group type, must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_rate ComputeBackendService#max_rate}
    */
    readonly maxRate?: number;
    /**
    * The max requests per second (RPS) that a single backend network
  endpoint can handle. This is used to calculate the capacity of
  the group. Can be used in either balancing mode. For RATE mode,
  either maxRate or maxRatePerEndpoint must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_rate_per_endpoint ComputeBackendService#max_rate_per_endpoint}
    */
    readonly maxRatePerEndpoint?: number;
    /**
    * The max requests per second (RPS) that a single backend
  instance can handle. This is used to calculate the capacity of
  the group. Can be used in either balancing mode. For RATE mode,
  either maxRate or maxRatePerInstance must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_rate_per_instance ComputeBackendService#max_rate_per_instance}
    */
    readonly maxRatePerInstance?: number;
    /**
    * Used when balancingMode is UTILIZATION. This ratio defines the
  CPU utilization target for the group. Valid range is [0.0, 1.0].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_utilization ComputeBackendService#max_utilization}
    */
    readonly maxUtilization?: number;
}
export declare function computeBackendServiceBackendToTerraform(struct?: ComputeBackendServiceBackend | cdktf.IResolvable): any;
export interface ComputeBackendServiceCdnPolicyCacheKeyPolicy {
    /**
    * If true requests to different hosts will be cached separately.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#include_host ComputeBackendService#include_host}
    */
    readonly includeHost?: boolean | cdktf.IResolvable;
    /**
    * If true, http and https requests will be cached separately.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#include_protocol ComputeBackendService#include_protocol}
    */
    readonly includeProtocol?: boolean | cdktf.IResolvable;
    /**
    * If true, include query string parameters in the cache key
  according to query_string_whitelist and
  query_string_blacklist. If neither is set, the entire query
  string will be included.
  
  If false, the query string will be excluded from the cache
  key entirely.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#include_query_string ComputeBackendService#include_query_string}
    */
    readonly includeQueryString?: boolean | cdktf.IResolvable;
    /**
    * Names of query string parameters to exclude in cache keys.
  
  All other parameters will be included. Either specify
  query_string_whitelist or query_string_blacklist, not both.
  '&' and '=' will be percent encoded and not treated as
  delimiters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#query_string_blacklist ComputeBackendService#query_string_blacklist}
    */
    readonly queryStringBlacklist?: string[];
    /**
    * Names of query string parameters to include in cache keys.
  
  All other parameters will be excluded. Either specify
  query_string_whitelist or query_string_blacklist, not both.
  '&' and '=' will be percent encoded and not treated as
  delimiters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#query_string_whitelist ComputeBackendService#query_string_whitelist}
    */
    readonly queryStringWhitelist?: string[];
}
export declare function computeBackendServiceCdnPolicyCacheKeyPolicyToTerraform(struct?: ComputeBackendServiceCdnPolicyCacheKeyPolicyOutputReference | ComputeBackendServiceCdnPolicyCacheKeyPolicy): any;
export declare class ComputeBackendServiceCdnPolicyCacheKeyPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceCdnPolicyCacheKeyPolicy | undefined;
    set internalValue(value: ComputeBackendServiceCdnPolicyCacheKeyPolicy | undefined);
    private _includeHost?;
    get includeHost(): boolean | cdktf.IResolvable;
    set includeHost(value: boolean | cdktf.IResolvable);
    resetIncludeHost(): void;
    get includeHostInput(): boolean | cdktf.IResolvable | undefined;
    private _includeProtocol?;
    get includeProtocol(): boolean | cdktf.IResolvable;
    set includeProtocol(value: boolean | cdktf.IResolvable);
    resetIncludeProtocol(): void;
    get includeProtocolInput(): boolean | cdktf.IResolvable | undefined;
    private _includeQueryString?;
    get includeQueryString(): boolean | cdktf.IResolvable;
    set includeQueryString(value: boolean | cdktf.IResolvable);
    resetIncludeQueryString(): void;
    get includeQueryStringInput(): boolean | cdktf.IResolvable | undefined;
    private _queryStringBlacklist?;
    get queryStringBlacklist(): string[];
    set queryStringBlacklist(value: string[]);
    resetQueryStringBlacklist(): void;
    get queryStringBlacklistInput(): string[] | undefined;
    private _queryStringWhitelist?;
    get queryStringWhitelist(): string[];
    set queryStringWhitelist(value: string[]);
    resetQueryStringWhitelist(): void;
    get queryStringWhitelistInput(): string[] | undefined;
}
export interface ComputeBackendServiceCdnPolicyNegativeCachingPolicy {
    /**
    * The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 308, 404, 405, 410, 421, 451 and 501
  can be specified as values, and you cannot specify a status code more than once.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#code ComputeBackendService#code}
    */
    readonly code?: number;
    /**
    * The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s
  (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#ttl ComputeBackendService#ttl}
    */
    readonly ttl?: number;
}
export declare function computeBackendServiceCdnPolicyNegativeCachingPolicyToTerraform(struct?: ComputeBackendServiceCdnPolicyNegativeCachingPolicy | cdktf.IResolvable): any;
export interface ComputeBackendServiceCdnPolicy {
    /**
    * Specifies the cache setting for all responses from this backend.
  The possible values are: USE_ORIGIN_HEADERS, FORCE_CACHE_ALL and CACHE_ALL_STATIC Possible values: ["USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", "CACHE_ALL_STATIC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#cache_mode ComputeBackendService#cache_mode}
    */
    readonly cacheMode?: string;
    /**
    * Specifies the maximum allowed TTL for cached content served by this origin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#client_ttl ComputeBackendService#client_ttl}
    */
    readonly clientTtl?: number;
    /**
    * Specifies the default TTL for cached content served by this origin for responses
  that do not have an existing valid TTL (max-age or s-max-age).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#default_ttl ComputeBackendService#default_ttl}
    */
    readonly defaultTtl?: number;
    /**
    * Specifies the maximum allowed TTL for cached content served by this origin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_ttl ComputeBackendService#max_ttl}
    */
    readonly maxTtl?: number;
    /**
    * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#negative_caching ComputeBackendService#negative_caching}
    */
    readonly negativeCaching?: boolean | cdktf.IResolvable;
    /**
    * Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#serve_while_stale ComputeBackendService#serve_while_stale}
    */
    readonly serveWhileStale?: number;
    /**
    * Maximum number of seconds the response to a signed URL request
  will be considered fresh, defaults to 1hr (3600s). After this
  time period, the response will be revalidated before
  being served.
  
  When serving responses to signed URL requests, Cloud CDN will
  internally behave as though all responses from this backend had a
  "Cache-Control: public, max-age=[TTL]" header, regardless of any
  existing Cache-Control header. The actual headers served in
  responses will not be altered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#signed_url_cache_max_age_sec ComputeBackendService#signed_url_cache_max_age_sec}
    */
    readonly signedUrlCacheMaxAgeSec?: number;
    /**
    * cache_key_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#cache_key_policy ComputeBackendService#cache_key_policy}
    */
    readonly cacheKeyPolicy?: ComputeBackendServiceCdnPolicyCacheKeyPolicy;
    /**
    * negative_caching_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#negative_caching_policy ComputeBackendService#negative_caching_policy}
    */
    readonly negativeCachingPolicy?: ComputeBackendServiceCdnPolicyNegativeCachingPolicy[] | cdktf.IResolvable;
}
export declare function computeBackendServiceCdnPolicyToTerraform(struct?: ComputeBackendServiceCdnPolicyOutputReference | ComputeBackendServiceCdnPolicy): any;
export declare class ComputeBackendServiceCdnPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceCdnPolicy | undefined;
    set internalValue(value: ComputeBackendServiceCdnPolicy | undefined);
    private _cacheMode?;
    get cacheMode(): string;
    set cacheMode(value: string);
    resetCacheMode(): void;
    get cacheModeInput(): string | undefined;
    private _clientTtl?;
    get clientTtl(): number;
    set clientTtl(value: number);
    resetClientTtl(): void;
    get clientTtlInput(): number | undefined;
    private _defaultTtl?;
    get defaultTtl(): number;
    set defaultTtl(value: number);
    resetDefaultTtl(): void;
    get defaultTtlInput(): number | undefined;
    private _maxTtl?;
    get maxTtl(): number;
    set maxTtl(value: number);
    resetMaxTtl(): void;
    get maxTtlInput(): number | undefined;
    private _negativeCaching?;
    get negativeCaching(): boolean | cdktf.IResolvable;
    set negativeCaching(value: boolean | cdktf.IResolvable);
    resetNegativeCaching(): void;
    get negativeCachingInput(): boolean | cdktf.IResolvable | undefined;
    private _serveWhileStale?;
    get serveWhileStale(): number;
    set serveWhileStale(value: number);
    resetServeWhileStale(): void;
    get serveWhileStaleInput(): number | undefined;
    private _signedUrlCacheMaxAgeSec?;
    get signedUrlCacheMaxAgeSec(): number;
    set signedUrlCacheMaxAgeSec(value: number);
    resetSignedUrlCacheMaxAgeSec(): void;
    get signedUrlCacheMaxAgeSecInput(): number | undefined;
    private _cacheKeyPolicy;
    get cacheKeyPolicy(): ComputeBackendServiceCdnPolicyCacheKeyPolicyOutputReference;
    putCacheKeyPolicy(value: ComputeBackendServiceCdnPolicyCacheKeyPolicy): void;
    resetCacheKeyPolicy(): void;
    get cacheKeyPolicyInput(): ComputeBackendServiceCdnPolicyCacheKeyPolicy | undefined;
    private _negativeCachingPolicy?;
    get negativeCachingPolicy(): ComputeBackendServiceCdnPolicyNegativeCachingPolicy[] | cdktf.IResolvable;
    set negativeCachingPolicy(value: ComputeBackendServiceCdnPolicyNegativeCachingPolicy[] | cdktf.IResolvable);
    resetNegativeCachingPolicy(): void;
    get negativeCachingPolicyInput(): cdktf.IResolvable | ComputeBackendServiceCdnPolicyNegativeCachingPolicy[] | undefined;
}
export interface ComputeBackendServiceCircuitBreakers {
    /**
    * The maximum number of connections to the backend cluster.
  Defaults to 1024.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_connections ComputeBackendService#max_connections}
    */
    readonly maxConnections?: number;
    /**
    * The maximum number of pending requests to the backend cluster.
  Defaults to 1024.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_pending_requests ComputeBackendService#max_pending_requests}
    */
    readonly maxPendingRequests?: number;
    /**
    * The maximum number of parallel requests to the backend cluster.
  Defaults to 1024.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_requests ComputeBackendService#max_requests}
    */
    readonly maxRequests?: number;
    /**
    * Maximum requests for a single backend connection. This parameter
  is respected by both the HTTP/1.1 and HTTP/2 implementations. If
  not specified, there is no limit. Setting this parameter to 1
  will effectively disable keep alive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_requests_per_connection ComputeBackendService#max_requests_per_connection}
    */
    readonly maxRequestsPerConnection?: number;
    /**
    * The maximum number of parallel retries to the backend cluster.
  Defaults to 3.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_retries ComputeBackendService#max_retries}
    */
    readonly maxRetries?: number;
}
export declare function computeBackendServiceCircuitBreakersToTerraform(struct?: ComputeBackendServiceCircuitBreakersOutputReference | ComputeBackendServiceCircuitBreakers): any;
export declare class ComputeBackendServiceCircuitBreakersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceCircuitBreakers | undefined;
    set internalValue(value: ComputeBackendServiceCircuitBreakers | undefined);
    private _maxConnections?;
    get maxConnections(): number;
    set maxConnections(value: number);
    resetMaxConnections(): void;
    get maxConnectionsInput(): number | undefined;
    private _maxPendingRequests?;
    get maxPendingRequests(): number;
    set maxPendingRequests(value: number);
    resetMaxPendingRequests(): void;
    get maxPendingRequestsInput(): number | undefined;
    private _maxRequests?;
    get maxRequests(): number;
    set maxRequests(value: number);
    resetMaxRequests(): void;
    get maxRequestsInput(): number | undefined;
    private _maxRequestsPerConnection?;
    get maxRequestsPerConnection(): number;
    set maxRequestsPerConnection(value: number);
    resetMaxRequestsPerConnection(): void;
    get maxRequestsPerConnectionInput(): number | undefined;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
}
export interface ComputeBackendServiceConsistentHashHttpCookieTtl {
    /**
    * Span of time that's a fraction of a second at nanosecond
  resolution. Durations less than one second are represented
  with a 0 seconds field and a positive nanos field. Must
  be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#nanos ComputeBackendService#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second.
  Must be from 0 to 315,576,000,000 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#seconds ComputeBackendService#seconds}
    */
    readonly seconds: number;
}
export declare function computeBackendServiceConsistentHashHttpCookieTtlToTerraform(struct?: ComputeBackendServiceConsistentHashHttpCookieTtlOutputReference | ComputeBackendServiceConsistentHashHttpCookieTtl): any;
export declare class ComputeBackendServiceConsistentHashHttpCookieTtlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceConsistentHashHttpCookieTtl | undefined;
    set internalValue(value: ComputeBackendServiceConsistentHashHttpCookieTtl | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface ComputeBackendServiceConsistentHashHttpCookie {
    /**
    * Name of the cookie.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#name ComputeBackendService#name}
    */
    readonly name?: string;
    /**
    * Path to set for the cookie.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#path ComputeBackendService#path}
    */
    readonly path?: string;
    /**
    * ttl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#ttl ComputeBackendService#ttl}
    */
    readonly ttl?: ComputeBackendServiceConsistentHashHttpCookieTtl;
}
export declare function computeBackendServiceConsistentHashHttpCookieToTerraform(struct?: ComputeBackendServiceConsistentHashHttpCookieOutputReference | ComputeBackendServiceConsistentHashHttpCookie): any;
export declare class ComputeBackendServiceConsistentHashHttpCookieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceConsistentHashHttpCookie | undefined;
    set internalValue(value: ComputeBackendServiceConsistentHashHttpCookie | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _ttl;
    get ttl(): ComputeBackendServiceConsistentHashHttpCookieTtlOutputReference;
    putTtl(value: ComputeBackendServiceConsistentHashHttpCookieTtl): void;
    resetTtl(): void;
    get ttlInput(): ComputeBackendServiceConsistentHashHttpCookieTtl | undefined;
}
export interface ComputeBackendServiceConsistentHash {
    /**
    * The hash based on the value of the specified header field.
  This field is applicable if the sessionAffinity is set to HEADER_FIELD.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#http_header_name ComputeBackendService#http_header_name}
    */
    readonly httpHeaderName?: string;
    /**
    * The minimum number of virtual nodes to use for the hash ring.
  Larger ring sizes result in more granular load
  distributions. If the number of hosts in the load balancing pool
  is larger than the ring size, each host will be assigned a single
  virtual node.
  Defaults to 1024.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#minimum_ring_size ComputeBackendService#minimum_ring_size}
    */
    readonly minimumRingSize?: number;
    /**
    * http_cookie block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#http_cookie ComputeBackendService#http_cookie}
    */
    readonly httpCookie?: ComputeBackendServiceConsistentHashHttpCookie;
}
export declare function computeBackendServiceConsistentHashToTerraform(struct?: ComputeBackendServiceConsistentHashOutputReference | ComputeBackendServiceConsistentHash): any;
export declare class ComputeBackendServiceConsistentHashOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceConsistentHash | undefined;
    set internalValue(value: ComputeBackendServiceConsistentHash | undefined);
    private _httpHeaderName?;
    get httpHeaderName(): string;
    set httpHeaderName(value: string);
    resetHttpHeaderName(): void;
    get httpHeaderNameInput(): string | undefined;
    private _minimumRingSize?;
    get minimumRingSize(): number;
    set minimumRingSize(value: number);
    resetMinimumRingSize(): void;
    get minimumRingSizeInput(): number | undefined;
    private _httpCookie;
    get httpCookie(): ComputeBackendServiceConsistentHashHttpCookieOutputReference;
    putHttpCookie(value: ComputeBackendServiceConsistentHashHttpCookie): void;
    resetHttpCookie(): void;
    get httpCookieInput(): ComputeBackendServiceConsistentHashHttpCookie | undefined;
}
export interface ComputeBackendServiceIap {
    /**
    * OAuth2 Client ID for IAP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#oauth2_client_id ComputeBackendService#oauth2_client_id}
    */
    readonly oauth2ClientId: string;
    /**
    * OAuth2 Client Secret for IAP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#oauth2_client_secret ComputeBackendService#oauth2_client_secret}
    */
    readonly oauth2ClientSecret: string;
}
export declare function computeBackendServiceIapToTerraform(struct?: ComputeBackendServiceIapOutputReference | ComputeBackendServiceIap): any;
export declare class ComputeBackendServiceIapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceIap | undefined;
    set internalValue(value: ComputeBackendServiceIap | undefined);
    private _oauth2ClientId?;
    get oauth2ClientId(): string;
    set oauth2ClientId(value: string);
    get oauth2ClientIdInput(): string | undefined;
    private _oauth2ClientSecret?;
    get oauth2ClientSecret(): string;
    set oauth2ClientSecret(value: string);
    get oauth2ClientSecretInput(): string | undefined;
    get oauth2ClientSecretSha256(): string;
}
export interface ComputeBackendServiceLogConfig {
    /**
    * Whether to enable logging for the load balancer traffic served by this backend service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#enable ComputeBackendService#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
    * This field can only be specified if logging is enabled for this backend service. The value of
  the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer
  where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported.
  The default value is 1.0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#sample_rate ComputeBackendService#sample_rate}
    */
    readonly sampleRate?: number;
}
export declare function computeBackendServiceLogConfigToTerraform(struct?: ComputeBackendServiceLogConfigOutputReference | ComputeBackendServiceLogConfig): any;
export declare class ComputeBackendServiceLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceLogConfig | undefined;
    set internalValue(value: ComputeBackendServiceLogConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _sampleRate?;
    get sampleRate(): number;
    set sampleRate(value: number);
    resetSampleRate(): void;
    get sampleRateInput(): number | undefined;
}
export interface ComputeBackendServiceOutlierDetectionBaseEjectionTime {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#nanos ComputeBackendService#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#seconds ComputeBackendService#seconds}
    */
    readonly seconds: number;
}
export declare function computeBackendServiceOutlierDetectionBaseEjectionTimeToTerraform(struct?: ComputeBackendServiceOutlierDetectionBaseEjectionTimeOutputReference | ComputeBackendServiceOutlierDetectionBaseEjectionTime): any;
export declare class ComputeBackendServiceOutlierDetectionBaseEjectionTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceOutlierDetectionBaseEjectionTime | undefined;
    set internalValue(value: ComputeBackendServiceOutlierDetectionBaseEjectionTime | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface ComputeBackendServiceOutlierDetectionInterval {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#nanos ComputeBackendService#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#seconds ComputeBackendService#seconds}
    */
    readonly seconds: number;
}
export declare function computeBackendServiceOutlierDetectionIntervalToTerraform(struct?: ComputeBackendServiceOutlierDetectionIntervalOutputReference | ComputeBackendServiceOutlierDetectionInterval): any;
export declare class ComputeBackendServiceOutlierDetectionIntervalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceOutlierDetectionInterval | undefined;
    set internalValue(value: ComputeBackendServiceOutlierDetectionInterval | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface ComputeBackendServiceOutlierDetection {
    /**
    * Number of errors before a host is ejected from the connection pool. When the
  backend host is accessed over HTTP, a 5xx return code qualifies as an error.
  Defaults to 5.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#consecutive_errors ComputeBackendService#consecutive_errors}
    */
    readonly consecutiveErrors?: number;
    /**
    * The number of consecutive gateway failures (502, 503, 504 status or connection
  errors that are mapped to one of those status codes) before a consecutive
  gateway failure ejection occurs. Defaults to 5.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#consecutive_gateway_failure ComputeBackendService#consecutive_gateway_failure}
    */
    readonly consecutiveGatewayFailure?: number;
    /**
    * The percentage chance that a host will be actually ejected when an outlier
  status is detected through consecutive 5xx. This setting can be used to disable
  ejection or to ramp it up slowly. Defaults to 100.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#enforcing_consecutive_errors ComputeBackendService#enforcing_consecutive_errors}
    */
    readonly enforcingConsecutiveErrors?: number;
    /**
    * The percentage chance that a host will be actually ejected when an outlier
  status is detected through consecutive gateway failures. This setting can be
  used to disable ejection or to ramp it up slowly. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#enforcing_consecutive_gateway_failure ComputeBackendService#enforcing_consecutive_gateway_failure}
    */
    readonly enforcingConsecutiveGatewayFailure?: number;
    /**
    * The percentage chance that a host will be actually ejected when an outlier
  status is detected through success rate statistics. This setting can be used to
  disable ejection or to ramp it up slowly. Defaults to 100.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#enforcing_success_rate ComputeBackendService#enforcing_success_rate}
    */
    readonly enforcingSuccessRate?: number;
    /**
    * Maximum percentage of hosts in the load balancing pool for the backend service
  that can be ejected. Defaults to 10%.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#max_ejection_percent ComputeBackendService#max_ejection_percent}
    */
    readonly maxEjectionPercent?: number;
    /**
    * The number of hosts in a cluster that must have enough request volume to detect
  success rate outliers. If the number of hosts is less than this setting, outlier
  detection via success rate statistics is not performed for any host in the
  cluster. Defaults to 5.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#success_rate_minimum_hosts ComputeBackendService#success_rate_minimum_hosts}
    */
    readonly successRateMinimumHosts?: number;
    /**
    * The minimum number of total requests that must be collected in one interval (as
  defined by the interval duration above) to include this host in success rate
  based outlier detection. If the volume is lower than this setting, outlier
  detection via success rate statistics is not performed for that host. Defaults
  to 100.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#success_rate_request_volume ComputeBackendService#success_rate_request_volume}
    */
    readonly successRateRequestVolume?: number;
    /**
    * This factor is used to determine the ejection threshold for success rate outlier
  ejection. The ejection threshold is the difference between the mean success
  rate, and the product of this factor and the standard deviation of the mean
  success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided
  by a thousand to get a double. That is, if the desired factor is 1.9, the
  runtime value should be 1900. Defaults to 1900.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#success_rate_stdev_factor ComputeBackendService#success_rate_stdev_factor}
    */
    readonly successRateStdevFactor?: number;
    /**
    * base_ejection_time block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#base_ejection_time ComputeBackendService#base_ejection_time}
    */
    readonly baseEjectionTime?: ComputeBackendServiceOutlierDetectionBaseEjectionTime;
    /**
    * interval block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#interval ComputeBackendService#interval}
    */
    readonly interval?: ComputeBackendServiceOutlierDetectionInterval;
}
export declare function computeBackendServiceOutlierDetectionToTerraform(struct?: ComputeBackendServiceOutlierDetectionOutputReference | ComputeBackendServiceOutlierDetection): any;
export declare class ComputeBackendServiceOutlierDetectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceOutlierDetection | undefined;
    set internalValue(value: ComputeBackendServiceOutlierDetection | undefined);
    private _consecutiveErrors?;
    get consecutiveErrors(): number;
    set consecutiveErrors(value: number);
    resetConsecutiveErrors(): void;
    get consecutiveErrorsInput(): number | undefined;
    private _consecutiveGatewayFailure?;
    get consecutiveGatewayFailure(): number;
    set consecutiveGatewayFailure(value: number);
    resetConsecutiveGatewayFailure(): void;
    get consecutiveGatewayFailureInput(): number | undefined;
    private _enforcingConsecutiveErrors?;
    get enforcingConsecutiveErrors(): number;
    set enforcingConsecutiveErrors(value: number);
    resetEnforcingConsecutiveErrors(): void;
    get enforcingConsecutiveErrorsInput(): number | undefined;
    private _enforcingConsecutiveGatewayFailure?;
    get enforcingConsecutiveGatewayFailure(): number;
    set enforcingConsecutiveGatewayFailure(value: number);
    resetEnforcingConsecutiveGatewayFailure(): void;
    get enforcingConsecutiveGatewayFailureInput(): number | undefined;
    private _enforcingSuccessRate?;
    get enforcingSuccessRate(): number;
    set enforcingSuccessRate(value: number);
    resetEnforcingSuccessRate(): void;
    get enforcingSuccessRateInput(): number | undefined;
    private _maxEjectionPercent?;
    get maxEjectionPercent(): number;
    set maxEjectionPercent(value: number);
    resetMaxEjectionPercent(): void;
    get maxEjectionPercentInput(): number | undefined;
    private _successRateMinimumHosts?;
    get successRateMinimumHosts(): number;
    set successRateMinimumHosts(value: number);
    resetSuccessRateMinimumHosts(): void;
    get successRateMinimumHostsInput(): number | undefined;
    private _successRateRequestVolume?;
    get successRateRequestVolume(): number;
    set successRateRequestVolume(value: number);
    resetSuccessRateRequestVolume(): void;
    get successRateRequestVolumeInput(): number | undefined;
    private _successRateStdevFactor?;
    get successRateStdevFactor(): number;
    set successRateStdevFactor(value: number);
    resetSuccessRateStdevFactor(): void;
    get successRateStdevFactorInput(): number | undefined;
    private _baseEjectionTime;
    get baseEjectionTime(): ComputeBackendServiceOutlierDetectionBaseEjectionTimeOutputReference;
    putBaseEjectionTime(value: ComputeBackendServiceOutlierDetectionBaseEjectionTime): void;
    resetBaseEjectionTime(): void;
    get baseEjectionTimeInput(): ComputeBackendServiceOutlierDetectionBaseEjectionTime | undefined;
    private _interval;
    get interval(): ComputeBackendServiceOutlierDetectionIntervalOutputReference;
    putInterval(value: ComputeBackendServiceOutlierDetectionInterval): void;
    resetInterval(): void;
    get intervalInput(): ComputeBackendServiceOutlierDetectionInterval | undefined;
}
export interface ComputeBackendServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#create ComputeBackendService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#delete ComputeBackendService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service#update ComputeBackendService#update}
    */
    readonly update?: string;
}
export declare function computeBackendServiceTimeoutsToTerraform(struct?: ComputeBackendServiceTimeoutsOutputReference | ComputeBackendServiceTimeouts | cdktf.IResolvable): any;
export declare class ComputeBackendServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendServiceTimeouts | undefined;
    set internalValue(value: ComputeBackendServiceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service google_compute_backend_service}
*/
export declare class ComputeBackendService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_backend_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service google_compute_backend_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeBackendServiceConfig
    */
    constructor(scope: Construct, id: string, config: ComputeBackendServiceConfig);
    private _affinityCookieTtlSec?;
    get affinityCookieTtlSec(): number;
    set affinityCookieTtlSec(value: number);
    resetAffinityCookieTtlSec(): void;
    get affinityCookieTtlSecInput(): number | undefined;
    private _connectionDrainingTimeoutSec?;
    get connectionDrainingTimeoutSec(): number;
    set connectionDrainingTimeoutSec(value: number);
    resetConnectionDrainingTimeoutSec(): void;
    get connectionDrainingTimeoutSecInput(): number | undefined;
    get creationTimestamp(): string;
    private _customRequestHeaders?;
    get customRequestHeaders(): string[];
    set customRequestHeaders(value: string[]);
    resetCustomRequestHeaders(): void;
    get customRequestHeadersInput(): string[] | undefined;
    private _customResponseHeaders?;
    get customResponseHeaders(): string[];
    set customResponseHeaders(value: string[]);
    resetCustomResponseHeaders(): void;
    get customResponseHeadersInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableCdn?;
    get enableCdn(): boolean | cdktf.IResolvable;
    set enableCdn(value: boolean | cdktf.IResolvable);
    resetEnableCdn(): void;
    get enableCdnInput(): boolean | cdktf.IResolvable | undefined;
    get fingerprint(): string;
    private _healthChecks?;
    get healthChecks(): string[];
    set healthChecks(value: string[]);
    resetHealthChecks(): void;
    get healthChecksInput(): string[] | undefined;
    get id(): string;
    private _loadBalancingScheme?;
    get loadBalancingScheme(): string;
    set loadBalancingScheme(value: string);
    resetLoadBalancingScheme(): void;
    get loadBalancingSchemeInput(): string | undefined;
    private _localityLbPolicy?;
    get localityLbPolicy(): string;
    set localityLbPolicy(value: string);
    resetLocalityLbPolicy(): void;
    get localityLbPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _securityPolicy?;
    get securityPolicy(): string;
    set securityPolicy(value: string);
    resetSecurityPolicy(): void;
    get securityPolicyInput(): string | undefined;
    get selfLink(): string;
    private _sessionAffinity?;
    get sessionAffinity(): string;
    set sessionAffinity(value: string);
    resetSessionAffinity(): void;
    get sessionAffinityInput(): string | undefined;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    private _backend?;
    get backend(): ComputeBackendServiceBackend[] | cdktf.IResolvable;
    set backend(value: ComputeBackendServiceBackend[] | cdktf.IResolvable);
    resetBackend(): void;
    get backendInput(): cdktf.IResolvable | ComputeBackendServiceBackend[] | undefined;
    private _cdnPolicy;
    get cdnPolicy(): ComputeBackendServiceCdnPolicyOutputReference;
    putCdnPolicy(value: ComputeBackendServiceCdnPolicy): void;
    resetCdnPolicy(): void;
    get cdnPolicyInput(): ComputeBackendServiceCdnPolicy | undefined;
    private _circuitBreakers;
    get circuitBreakers(): ComputeBackendServiceCircuitBreakersOutputReference;
    putCircuitBreakers(value: ComputeBackendServiceCircuitBreakers): void;
    resetCircuitBreakers(): void;
    get circuitBreakersInput(): ComputeBackendServiceCircuitBreakers | undefined;
    private _consistentHash;
    get consistentHash(): ComputeBackendServiceConsistentHashOutputReference;
    putConsistentHash(value: ComputeBackendServiceConsistentHash): void;
    resetConsistentHash(): void;
    get consistentHashInput(): ComputeBackendServiceConsistentHash | undefined;
    private _iap;
    get iap(): ComputeBackendServiceIapOutputReference;
    putIap(value: ComputeBackendServiceIap): void;
    resetIap(): void;
    get iapInput(): ComputeBackendServiceIap | undefined;
    private _logConfig;
    get logConfig(): ComputeBackendServiceLogConfigOutputReference;
    putLogConfig(value: ComputeBackendServiceLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): ComputeBackendServiceLogConfig | undefined;
    private _outlierDetection;
    get outlierDetection(): ComputeBackendServiceOutlierDetectionOutputReference;
    putOutlierDetection(value: ComputeBackendServiceOutlierDetection): void;
    resetOutlierDetection(): void;
    get outlierDetectionInput(): ComputeBackendServiceOutlierDetection | undefined;
    private _timeouts;
    get timeouts(): ComputeBackendServiceTimeoutsOutputReference;
    putTimeouts(value: ComputeBackendServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeBackendServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
