import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeInstanceGroupManagerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The base instance name to use for instances in this group. The value must be a valid RFC1035 name. Supported characters are lowercase letters, numbers, and hyphens (-). Instances are named by appending a hyphen and a random four-character string to the base instance name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#base_instance_name ComputeInstanceGroupManager#base_instance_name}
    */
    readonly baseInstanceName: string;
    /**
    * An optional textual description of the instance group manager.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#description ComputeInstanceGroupManager#description}
    */
    readonly description?: string;
    /**
    * The name of the instance group manager. Must be 1-63 characters long and comply with RFC1035. Supported characters include lowercase letters, numbers, and hyphens.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#name ComputeInstanceGroupManager#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#project ComputeInstanceGroupManager#project}
    */
    readonly project?: string;
    /**
    * The full URL of all target pools to which new instances in the group are added. Updating the target pools attribute does not affect existing instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#target_pools ComputeInstanceGroupManager#target_pools}
    */
    readonly targetPools?: string[];
    /**
    * The target number of running instances for this managed instance group. This value should always be explicitly set unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#target_size ComputeInstanceGroupManager#target_size}
    */
    readonly targetSize?: number;
    /**
    * Whether to wait for all instances to be created/updated before returning. Note that if this is set to true and the operation does not succeed, Terraform will continue trying until it times out.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#wait_for_instances ComputeInstanceGroupManager#wait_for_instances}
    */
    readonly waitForInstances?: boolean | cdktf.IResolvable;
    /**
    * When used with wait_for_instances specifies the status to wait for. When STABLE is specified this resource will wait until the instances are stable before returning. When UPDATED is set, it will wait for the version target to be reached and any per instance configs to be effective as well as all instances to be stable before returning.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#wait_for_instances_status ComputeInstanceGroupManager#wait_for_instances_status}
    */
    readonly waitForInstancesStatus?: string;
    /**
    * The zone that instances in this group should be created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#zone ComputeInstanceGroupManager#zone}
    */
    readonly zone?: string;
    /**
    * auto_healing_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#auto_healing_policies ComputeInstanceGroupManager#auto_healing_policies}
    */
    readonly autoHealingPolicies?: ComputeInstanceGroupManagerAutoHealingPolicies;
    /**
    * named_port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#named_port ComputeInstanceGroupManager#named_port}
    */
    readonly namedPort?: ComputeInstanceGroupManagerNamedPort[] | cdktf.IResolvable;
    /**
    * stateful_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#stateful_disk ComputeInstanceGroupManager#stateful_disk}
    */
    readonly statefulDisk?: ComputeInstanceGroupManagerStatefulDisk[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#timeouts ComputeInstanceGroupManager#timeouts}
    */
    readonly timeouts?: ComputeInstanceGroupManagerTimeouts;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#update_policy ComputeInstanceGroupManager#update_policy}
    */
    readonly updatePolicy?: ComputeInstanceGroupManagerUpdatePolicy;
    /**
    * version block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#version ComputeInstanceGroupManager#version}
    */
    readonly version: ComputeInstanceGroupManagerVersion[] | cdktf.IResolvable;
}
export interface ComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs {
}
export declare function computeInstanceGroupManagerStatusStatefulPerInstanceConfigsToTerraform(struct?: ComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs): any;
export declare class ComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs | undefined;
    set internalValue(value: ComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs | undefined);
    get allEffective(): cdktf.IResolvable;
}
export declare class ComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsOutputReference;
}
export interface ComputeInstanceGroupManagerStatusStateful {
}
export declare function computeInstanceGroupManagerStatusStatefulToTerraform(struct?: ComputeInstanceGroupManagerStatusStateful): any;
export declare class ComputeInstanceGroupManagerStatusStatefulOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceGroupManagerStatusStateful | undefined;
    set internalValue(value: ComputeInstanceGroupManagerStatusStateful | undefined);
    get hasStatefulConfig(): cdktf.IResolvable;
    private _perInstanceConfigs;
    get perInstanceConfigs(): ComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsList;
}
export declare class ComputeInstanceGroupManagerStatusStatefulList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceGroupManagerStatusStatefulOutputReference;
}
export interface ComputeInstanceGroupManagerStatusVersionTarget {
}
export declare function computeInstanceGroupManagerStatusVersionTargetToTerraform(struct?: ComputeInstanceGroupManagerStatusVersionTarget): any;
export declare class ComputeInstanceGroupManagerStatusVersionTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceGroupManagerStatusVersionTarget | undefined;
    set internalValue(value: ComputeInstanceGroupManagerStatusVersionTarget | undefined);
    get isReached(): cdktf.IResolvable;
}
export declare class ComputeInstanceGroupManagerStatusVersionTargetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceGroupManagerStatusVersionTargetOutputReference;
}
export interface ComputeInstanceGroupManagerStatus {
}
export declare function computeInstanceGroupManagerStatusToTerraform(struct?: ComputeInstanceGroupManagerStatus): any;
export declare class ComputeInstanceGroupManagerStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceGroupManagerStatus | undefined;
    set internalValue(value: ComputeInstanceGroupManagerStatus | undefined);
    get isStable(): cdktf.IResolvable;
    private _stateful;
    get stateful(): ComputeInstanceGroupManagerStatusStatefulList;
    private _versionTarget;
    get versionTarget(): ComputeInstanceGroupManagerStatusVersionTargetList;
}
export declare class ComputeInstanceGroupManagerStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceGroupManagerStatusOutputReference;
}
export interface ComputeInstanceGroupManagerAutoHealingPolicies {
    /**
    * The health check resource that signals autohealing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#health_check ComputeInstanceGroupManager#health_check}
    */
    readonly healthCheck: string;
    /**
    * The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. Between 0 and 3600.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#initial_delay_sec ComputeInstanceGroupManager#initial_delay_sec}
    */
    readonly initialDelaySec: number;
}
export declare function computeInstanceGroupManagerAutoHealingPoliciesToTerraform(struct?: ComputeInstanceGroupManagerAutoHealingPoliciesOutputReference | ComputeInstanceGroupManagerAutoHealingPolicies): any;
export declare class ComputeInstanceGroupManagerAutoHealingPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceGroupManagerAutoHealingPolicies | undefined;
    set internalValue(value: ComputeInstanceGroupManagerAutoHealingPolicies | undefined);
    private _healthCheck?;
    get healthCheck(): string;
    set healthCheck(value: string);
    get healthCheckInput(): string | undefined;
    private _initialDelaySec?;
    get initialDelaySec(): number;
    set initialDelaySec(value: number);
    get initialDelaySecInput(): number | undefined;
}
export interface ComputeInstanceGroupManagerNamedPort {
    /**
    * The name of the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#name ComputeInstanceGroupManager#name}
    */
    readonly name: string;
    /**
    * The port number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#port ComputeInstanceGroupManager#port}
    */
    readonly port: number;
}
export declare function computeInstanceGroupManagerNamedPortToTerraform(struct?: ComputeInstanceGroupManagerNamedPort | cdktf.IResolvable): any;
export interface ComputeInstanceGroupManagerStatefulDisk {
    /**
    * A value that prescribes what should happen to the stateful disk when the VM instance is deleted. The available options are NEVER and ON_PERMANENT_INSTANCE_DELETION. NEVER - detach the disk when the VM is deleted, but do not delete the disk. ON_PERMANENT_INSTANCE_DELETION will delete the stateful disk when the VM is permanently deleted from the instance group. The default is NEVER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#delete_rule ComputeInstanceGroupManager#delete_rule}
    */
    readonly deleteRule?: string;
    /**
    * The device name of the disk to be attached.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#device_name ComputeInstanceGroupManager#device_name}
    */
    readonly deviceName: string;
}
export declare function computeInstanceGroupManagerStatefulDiskToTerraform(struct?: ComputeInstanceGroupManagerStatefulDisk | cdktf.IResolvable): any;
export interface ComputeInstanceGroupManagerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#create ComputeInstanceGroupManager#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#delete ComputeInstanceGroupManager#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#update ComputeInstanceGroupManager#update}
    */
    readonly update?: string;
}
export declare function computeInstanceGroupManagerTimeoutsToTerraform(struct?: ComputeInstanceGroupManagerTimeoutsOutputReference | ComputeInstanceGroupManagerTimeouts | cdktf.IResolvable): any;
export declare class ComputeInstanceGroupManagerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceGroupManagerTimeouts | undefined;
    set internalValue(value: ComputeInstanceGroupManagerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ComputeInstanceGroupManagerUpdatePolicy {
    /**
    * The maximum number of instances that can be created above the specified targetSize during the update process. Conflicts with max_surge_percent. If neither is set, defaults to 1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#max_surge_fixed ComputeInstanceGroupManager#max_surge_fixed}
    */
    readonly maxSurgeFixed?: number;
    /**
    * The maximum number of instances(calculated as percentage) that can be created above the specified targetSize during the update process. Conflicts with max_surge_fixed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#max_surge_percent ComputeInstanceGroupManager#max_surge_percent}
    */
    readonly maxSurgePercent?: number;
    /**
    * The maximum number of instances that can be unavailable during the update process. Conflicts with max_unavailable_percent. If neither is set, defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#max_unavailable_fixed ComputeInstanceGroupManager#max_unavailable_fixed}
    */
    readonly maxUnavailableFixed?: number;
    /**
    * The maximum number of instances(calculated as percentage) that can be unavailable during the update process. Conflicts with max_unavailable_fixed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#max_unavailable_percent ComputeInstanceGroupManager#max_unavailable_percent}
    */
    readonly maxUnavailablePercent?: number;
    /**
    * Minimum number of seconds to wait for after a newly created instance becomes available. This value must be from range [0, 3600].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#min_ready_sec ComputeInstanceGroupManager#min_ready_sec}
    */
    readonly minReadySec?: number;
    /**
    * Minimal action to be taken on an instance. You can specify either RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a RESTART, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#minimal_action ComputeInstanceGroupManager#minimal_action}
    */
    readonly minimalAction: string;
    /**
    * The instance replacement method for managed instance groups. Valid values are: "RECREATE", "SUBSTITUTE". If SUBSTITUTE (default), the group replaces VM instances with new instances that have randomly generated names. If RECREATE, instance names are preserved.  You must also set max_unavailable_fixed or max_unavailable_percent to be greater than 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#replacement_method ComputeInstanceGroupManager#replacement_method}
    */
    readonly replacementMethod?: string;
    /**
    * The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#type ComputeInstanceGroupManager#type}
    */
    readonly type: string;
}
export declare function computeInstanceGroupManagerUpdatePolicyToTerraform(struct?: ComputeInstanceGroupManagerUpdatePolicyOutputReference | ComputeInstanceGroupManagerUpdatePolicy): any;
export declare class ComputeInstanceGroupManagerUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceGroupManagerUpdatePolicy | undefined;
    set internalValue(value: ComputeInstanceGroupManagerUpdatePolicy | undefined);
    private _maxSurgeFixed?;
    get maxSurgeFixed(): number;
    set maxSurgeFixed(value: number);
    resetMaxSurgeFixed(): void;
    get maxSurgeFixedInput(): number | undefined;
    private _maxSurgePercent?;
    get maxSurgePercent(): number;
    set maxSurgePercent(value: number);
    resetMaxSurgePercent(): void;
    get maxSurgePercentInput(): number | undefined;
    private _maxUnavailableFixed?;
    get maxUnavailableFixed(): number;
    set maxUnavailableFixed(value: number);
    resetMaxUnavailableFixed(): void;
    get maxUnavailableFixedInput(): number | undefined;
    private _maxUnavailablePercent?;
    get maxUnavailablePercent(): number;
    set maxUnavailablePercent(value: number);
    resetMaxUnavailablePercent(): void;
    get maxUnavailablePercentInput(): number | undefined;
    private _minReadySec?;
    get minReadySec(): number;
    set minReadySec(value: number);
    resetMinReadySec(): void;
    get minReadySecInput(): number | undefined;
    private _minimalAction?;
    get minimalAction(): string;
    set minimalAction(value: string);
    get minimalActionInput(): string | undefined;
    private _replacementMethod?;
    get replacementMethod(): string;
    set replacementMethod(value: string);
    resetReplacementMethod(): void;
    get replacementMethodInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ComputeInstanceGroupManagerVersionTargetSize {
    /**
    * The number of instances which are managed for this version. Conflicts with percent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#fixed ComputeInstanceGroupManager#fixed}
    */
    readonly fixed?: number;
    /**
    * The number of instances (calculated as percentage) which are managed for this version. Conflicts with fixed. Note that when using percent, rounding will be in favor of explicitly set target_size values; a managed instance group with 2 instances and 2 versions, one of which has a target_size.percent of 60 will create 2 instances of that version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#percent ComputeInstanceGroupManager#percent}
    */
    readonly percent?: number;
}
export declare function computeInstanceGroupManagerVersionTargetSizeToTerraform(struct?: ComputeInstanceGroupManagerVersionTargetSizeOutputReference | ComputeInstanceGroupManagerVersionTargetSize): any;
export declare class ComputeInstanceGroupManagerVersionTargetSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceGroupManagerVersionTargetSize | undefined;
    set internalValue(value: ComputeInstanceGroupManagerVersionTargetSize | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface ComputeInstanceGroupManagerVersion {
    /**
    * The full URL to an instance template from which all new instances of this version will be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#instance_template ComputeInstanceGroupManager#instance_template}
    */
    readonly instanceTemplate: string;
    /**
    * Version name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#name ComputeInstanceGroupManager#name}
    */
    readonly name?: string;
    /**
    * target_size block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager#target_size ComputeInstanceGroupManager#target_size}
    */
    readonly targetSize?: ComputeInstanceGroupManagerVersionTargetSize;
}
export declare function computeInstanceGroupManagerVersionToTerraform(struct?: ComputeInstanceGroupManagerVersion | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager google_compute_instance_group_manager}
*/
export declare class ComputeInstanceGroupManager extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_instance_group_manager";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager google_compute_instance_group_manager} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeInstanceGroupManagerConfig
    */
    constructor(scope: Construct, id: string, config: ComputeInstanceGroupManagerConfig);
    private _baseInstanceName?;
    get baseInstanceName(): string;
    set baseInstanceName(value: string);
    get baseInstanceNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    get id(): string;
    get instanceGroup(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get operation(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _status;
    get status(): ComputeInstanceGroupManagerStatusList;
    private _targetPools?;
    get targetPools(): string[];
    set targetPools(value: string[]);
    resetTargetPools(): void;
    get targetPoolsInput(): string[] | undefined;
    private _targetSize?;
    get targetSize(): number;
    set targetSize(value: number);
    resetTargetSize(): void;
    get targetSizeInput(): number | undefined;
    private _waitForInstances?;
    get waitForInstances(): boolean | cdktf.IResolvable;
    set waitForInstances(value: boolean | cdktf.IResolvable);
    resetWaitForInstances(): void;
    get waitForInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForInstancesStatus?;
    get waitForInstancesStatus(): string;
    set waitForInstancesStatus(value: string);
    resetWaitForInstancesStatus(): void;
    get waitForInstancesStatusInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _autoHealingPolicies;
    get autoHealingPolicies(): ComputeInstanceGroupManagerAutoHealingPoliciesOutputReference;
    putAutoHealingPolicies(value: ComputeInstanceGroupManagerAutoHealingPolicies): void;
    resetAutoHealingPolicies(): void;
    get autoHealingPoliciesInput(): ComputeInstanceGroupManagerAutoHealingPolicies | undefined;
    private _namedPort?;
    get namedPort(): ComputeInstanceGroupManagerNamedPort[] | cdktf.IResolvable;
    set namedPort(value: ComputeInstanceGroupManagerNamedPort[] | cdktf.IResolvable);
    resetNamedPort(): void;
    get namedPortInput(): cdktf.IResolvable | ComputeInstanceGroupManagerNamedPort[] | undefined;
    private _statefulDisk?;
    get statefulDisk(): ComputeInstanceGroupManagerStatefulDisk[] | cdktf.IResolvable;
    set statefulDisk(value: ComputeInstanceGroupManagerStatefulDisk[] | cdktf.IResolvable);
    resetStatefulDisk(): void;
    get statefulDiskInput(): cdktf.IResolvable | ComputeInstanceGroupManagerStatefulDisk[] | undefined;
    private _timeouts;
    get timeouts(): ComputeInstanceGroupManagerTimeoutsOutputReference;
    putTimeouts(value: ComputeInstanceGroupManagerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeInstanceGroupManagerTimeouts | undefined;
    private _updatePolicy;
    get updatePolicy(): ComputeInstanceGroupManagerUpdatePolicyOutputReference;
    putUpdatePolicy(value: ComputeInstanceGroupManagerUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): ComputeInstanceGroupManagerUpdatePolicy | undefined;
    private _version?;
    get version(): ComputeInstanceGroupManagerVersion[] | cdktf.IResolvable;
    set version(value: ComputeInstanceGroupManagerVersion[] | cdktf.IResolvable);
    get versionInput(): cdktf.IResolvable | ComputeInstanceGroupManagerVersion[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
