import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSecurityPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this security policy. Max size is 2048.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#description ComputeSecurityPolicy#description}
    */
    readonly description?: string;
    /**
    * The name of the security policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#name ComputeSecurityPolicy#name}
    */
    readonly name: string;
    /**
    * The project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#project ComputeSecurityPolicy#project}
    */
    readonly project?: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#rule ComputeSecurityPolicy#rule}
    */
    readonly rule?: ComputeSecurityPolicyRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#timeouts ComputeSecurityPolicy#timeouts}
    */
    readonly timeouts?: ComputeSecurityPolicyTimeouts;
}
export interface ComputeSecurityPolicyRuleMatchConfig {
    /**
    * Set of IP addresses or ranges (IPV4 or IPV6) in CIDR notation to match against inbound traffic. There is a limit of 10 IP ranges per rule. A value of '*' matches all IPs (can be used to override the default behavior).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#src_ip_ranges ComputeSecurityPolicy#src_ip_ranges}
    */
    readonly srcIpRanges: string[];
}
export declare function computeSecurityPolicyRuleMatchConfigToTerraform(struct?: ComputeSecurityPolicyRuleMatchConfigOutputReference | ComputeSecurityPolicyRuleMatchConfig): any;
export declare class ComputeSecurityPolicyRuleMatchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleMatchConfig | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleMatchConfig | undefined);
    private _srcIpRanges?;
    get srcIpRanges(): string[];
    set srcIpRanges(value: string[]);
    get srcIpRangesInput(): string[] | undefined;
}
export interface ComputeSecurityPolicyRuleMatchExpr {
    /**
    * Textual representation of an expression in Common Expression Language syntax. The application context of the containing message determines which well-known feature set of CEL is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#expression ComputeSecurityPolicy#expression}
    */
    readonly expression: string;
}
export declare function computeSecurityPolicyRuleMatchExprToTerraform(struct?: ComputeSecurityPolicyRuleMatchExprOutputReference | ComputeSecurityPolicyRuleMatchExpr): any;
export declare class ComputeSecurityPolicyRuleMatchExprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleMatchExpr | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleMatchExpr | undefined);
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
}
export interface ComputeSecurityPolicyRuleMatch {
    /**
    * Predefined rule expression. If this field is specified, config must also be specified. Available options:   SRC_IPS_V1: Must specify the corresponding src_ip_ranges field in config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#versioned_expr ComputeSecurityPolicy#versioned_expr}
    */
    readonly versionedExpr?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#config ComputeSecurityPolicy#config}
    */
    readonly config?: ComputeSecurityPolicyRuleMatchConfig;
    /**
    * expr block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#expr ComputeSecurityPolicy#expr}
    */
    readonly expr?: ComputeSecurityPolicyRuleMatchExpr;
}
export declare function computeSecurityPolicyRuleMatchToTerraform(struct?: ComputeSecurityPolicyRuleMatchOutputReference | ComputeSecurityPolicyRuleMatch): any;
export declare class ComputeSecurityPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleMatch | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleMatch | undefined);
    private _versionedExpr?;
    get versionedExpr(): string;
    set versionedExpr(value: string);
    resetVersionedExpr(): void;
    get versionedExprInput(): string | undefined;
    private _config;
    get config(): ComputeSecurityPolicyRuleMatchConfigOutputReference;
    putConfig(value: ComputeSecurityPolicyRuleMatchConfig): void;
    resetConfig(): void;
    get configInput(): ComputeSecurityPolicyRuleMatchConfig | undefined;
    private _expr;
    get expr(): ComputeSecurityPolicyRuleMatchExprOutputReference;
    putExpr(value: ComputeSecurityPolicyRuleMatchExpr): void;
    resetExpr(): void;
    get exprInput(): ComputeSecurityPolicyRuleMatchExpr | undefined;
}
export interface ComputeSecurityPolicyRule {
    /**
    * Action to take when match matches the request. Valid values:   "allow" : allow access to target, "deny(status)" : deny access to target, returns the HTTP response code specified (valid values are 403, 404 and 502)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#action ComputeSecurityPolicy#action}
    */
    readonly action: string;
    /**
    * An optional description of this rule. Max size is 64.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#description ComputeSecurityPolicy#description}
    */
    readonly description?: string;
    /**
    * When set to true, the action specified above is not enforced. Stackdriver logs for requests that trigger a preview action are annotated as such.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#preview ComputeSecurityPolicy#preview}
    */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
    * An unique positive integer indicating the priority of evaluation for a rule. Rules are evaluated from highest priority (lowest numerically) to lowest priority (highest numerically) in order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#priority ComputeSecurityPolicy#priority}
    */
    readonly priority: number;
    /**
    * match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#match ComputeSecurityPolicy#match}
    */
    readonly match: ComputeSecurityPolicyRuleMatch;
}
export declare function computeSecurityPolicyRuleToTerraform(struct?: ComputeSecurityPolicyRule | cdktf.IResolvable): any;
export interface ComputeSecurityPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#create ComputeSecurityPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#delete ComputeSecurityPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#update ComputeSecurityPolicy#update}
    */
    readonly update?: string;
}
export declare function computeSecurityPolicyTimeoutsToTerraform(struct?: ComputeSecurityPolicyTimeoutsOutputReference | ComputeSecurityPolicyTimeouts | cdktf.IResolvable): any;
export declare class ComputeSecurityPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyTimeouts | undefined;
    set internalValue(value: ComputeSecurityPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy google_compute_security_policy}
*/
export declare class ComputeSecurityPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_security_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy google_compute_security_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSecurityPolicyConfig
    */
    constructor(scope: Construct, id: string, config: ComputeSecurityPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _rule?;
    get rule(): ComputeSecurityPolicyRule[] | cdktf.IResolvable;
    set rule(value: ComputeSecurityPolicyRule[] | cdktf.IResolvable);
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | ComputeSecurityPolicyRule[] | undefined;
    private _timeouts;
    get timeouts(): ComputeSecurityPolicyTimeoutsOutputReference;
    putTimeouts(value: ComputeSecurityPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeSecurityPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
