import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSslCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The certificate in PEM format.
  The certificate chain must be no greater than 5 certs long.
  The chain must include at least one intermediate cert.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate#certificate ComputeSslCertificate#certificate}
    */
    readonly certificate: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate#description ComputeSslCertificate#description}
    */
    readonly description?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
  
  
  These are in the same namespace as the managed SSL certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate#name ComputeSslCertificate#name}
    */
    readonly name?: string;
    /**
    * Creates a unique name beginning with the specified prefix. Conflicts with name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate#name_prefix ComputeSslCertificate#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * The write-only private key in PEM format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate#private_key ComputeSslCertificate#private_key}
    */
    readonly privateKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate#project ComputeSslCertificate#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate#timeouts ComputeSslCertificate#timeouts}
    */
    readonly timeouts?: ComputeSslCertificateTimeouts;
}
export interface ComputeSslCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate#create ComputeSslCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate#delete ComputeSslCertificate#delete}
    */
    readonly delete?: string;
}
export declare function computeSslCertificateTimeoutsToTerraform(struct?: ComputeSslCertificateTimeoutsOutputReference | ComputeSslCertificateTimeouts | cdktf.IResolvable): any;
export declare class ComputeSslCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSslCertificateTimeouts | undefined;
    set internalValue(value: ComputeSslCertificateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate google_compute_ssl_certificate}
*/
export declare class ComputeSslCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_ssl_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate google_compute_ssl_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSslCertificateConfig
    */
    constructor(scope: Construct, id: string, config: ComputeSslCertificateConfig);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    get certificateInput(): string | undefined;
    get certificateId(): number;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): ComputeSslCertificateTimeoutsOutputReference;
    putTimeouts(value: ComputeSslCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeSslCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
