import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogEntryGroupIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member#entry_group DataCatalogEntryGroupIamMember#entry_group}
    */
    readonly entryGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member#member DataCatalogEntryGroupIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member#project DataCatalogEntryGroupIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member#region DataCatalogEntryGroupIamMember#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member#role DataCatalogEntryGroupIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member#condition DataCatalogEntryGroupIamMember#condition}
    */
    readonly condition?: DataCatalogEntryGroupIamMemberCondition;
}
export interface DataCatalogEntryGroupIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member#description DataCatalogEntryGroupIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member#expression DataCatalogEntryGroupIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member#title DataCatalogEntryGroupIamMember#title}
    */
    readonly title: string;
}
export declare function dataCatalogEntryGroupIamMemberConditionToTerraform(struct?: DataCatalogEntryGroupIamMemberConditionOutputReference | DataCatalogEntryGroupIamMemberCondition): any;
export declare class DataCatalogEntryGroupIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogEntryGroupIamMemberCondition | undefined;
    set internalValue(value: DataCatalogEntryGroupIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member google_data_catalog_entry_group_iam_member}
*/
export declare class DataCatalogEntryGroupIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_entry_group_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group_iam_member google_data_catalog_entry_group_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCatalogEntryGroupIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: DataCatalogEntryGroupIamMemberConfig);
    private _entryGroup?;
    get entryGroup(): string;
    set entryGroup(value: string);
    get entryGroupInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): DataCatalogEntryGroupIamMemberConditionOutputReference;
    putCondition(value: DataCatalogEntryGroupIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): DataCatalogEntryGroupIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
