import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogTagTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name for this template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#display_name DataCatalogTagTemplate#display_name}
    */
    readonly displayName?: string;
    /**
    * This confirms the deletion of any possible tags using this template. Must be set to true in order to delete the tag template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#force_delete DataCatalogTagTemplate#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#project DataCatalogTagTemplate#project}
    */
    readonly project?: string;
    /**
    * Template location region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#region DataCatalogTagTemplate#region}
    */
    readonly region?: string;
    /**
    * The id of the tag template to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#tag_template_id DataCatalogTagTemplate#tag_template_id}
    */
    readonly tagTemplateId: string;
    /**
    * fields block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#fields DataCatalogTagTemplate#fields}
    */
    readonly fields: DataCatalogTagTemplateFields[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#timeouts DataCatalogTagTemplate#timeouts}
    */
    readonly timeouts?: DataCatalogTagTemplateTimeouts;
}
export interface DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues {
    /**
    * The display name of the enum value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#display_name DataCatalogTagTemplate#display_name}
    */
    readonly displayName: string;
}
export declare function dataCatalogTagTemplateFieldsTypeEnumTypeAllowedValuesToTerraform(struct?: DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues | cdktf.IResolvable): any;
export interface DataCatalogTagTemplateFieldsTypeEnumType {
    /**
    * allowed_values block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#allowed_values DataCatalogTagTemplate#allowed_values}
    */
    readonly allowedValues: DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[] | cdktf.IResolvable;
}
export declare function dataCatalogTagTemplateFieldsTypeEnumTypeToTerraform(struct?: DataCatalogTagTemplateFieldsTypeEnumTypeOutputReference | DataCatalogTagTemplateFieldsTypeEnumType): any;
export declare class DataCatalogTagTemplateFieldsTypeEnumTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogTagTemplateFieldsTypeEnumType | undefined;
    set internalValue(value: DataCatalogTagTemplateFieldsTypeEnumType | undefined);
    private _allowedValues?;
    get allowedValues(): DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[] | cdktf.IResolvable;
    set allowedValues(value: DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[] | cdktf.IResolvable);
    get allowedValuesInput(): cdktf.IResolvable | DataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[] | undefined;
}
export interface DataCatalogTagTemplateFieldsType {
    /**
    * Represents primitive types - string, bool etc.
   Exactly one of 'primitive_type' or 'enum_type' must be set Possible values: ["DOUBLE", "STRING", "BOOL", "TIMESTAMP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#primitive_type DataCatalogTagTemplate#primitive_type}
    */
    readonly primitiveType?: string;
    /**
    * enum_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#enum_type DataCatalogTagTemplate#enum_type}
    */
    readonly enumType?: DataCatalogTagTemplateFieldsTypeEnumType;
}
export declare function dataCatalogTagTemplateFieldsTypeToTerraform(struct?: DataCatalogTagTemplateFieldsTypeOutputReference | DataCatalogTagTemplateFieldsType): any;
export declare class DataCatalogTagTemplateFieldsTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogTagTemplateFieldsType | undefined;
    set internalValue(value: DataCatalogTagTemplateFieldsType | undefined);
    private _primitiveType?;
    get primitiveType(): string;
    set primitiveType(value: string);
    resetPrimitiveType(): void;
    get primitiveTypeInput(): string | undefined;
    private _enumType;
    get enumType(): DataCatalogTagTemplateFieldsTypeEnumTypeOutputReference;
    putEnumType(value: DataCatalogTagTemplateFieldsTypeEnumType): void;
    resetEnumType(): void;
    get enumTypeInput(): DataCatalogTagTemplateFieldsTypeEnumType | undefined;
}
export interface DataCatalogTagTemplateFields {
    /**
    * A description for this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#description DataCatalogTagTemplate#description}
    */
    readonly description?: string;
    /**
    * The display name for this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#display_name DataCatalogTagTemplate#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#field_id DataCatalogTagTemplate#field_id}
    */
    readonly fieldId: string;
    /**
    * Whether this is a required field. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#is_required DataCatalogTagTemplate#is_required}
    */
    readonly isRequired?: boolean | cdktf.IResolvable;
    /**
    * The order of this field with respect to other fields in this tag template.
  A higher value indicates a more important field. The value can be negative.
  Multiple fields can have the same order, and field orders within a tag do not have to be sequential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#order DataCatalogTagTemplate#order}
    */
    readonly order?: number;
    /**
    * type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#type DataCatalogTagTemplate#type}
    */
    readonly type: DataCatalogTagTemplateFieldsType;
}
export declare function dataCatalogTagTemplateFieldsToTerraform(struct?: DataCatalogTagTemplateFields | cdktf.IResolvable): any;
export interface DataCatalogTagTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#create DataCatalogTagTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#delete DataCatalogTagTemplate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template#update DataCatalogTagTemplate#update}
    */
    readonly update?: string;
}
export declare function dataCatalogTagTemplateTimeoutsToTerraform(struct?: DataCatalogTagTemplateTimeoutsOutputReference | DataCatalogTagTemplateTimeouts | cdktf.IResolvable): any;
export declare class DataCatalogTagTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogTagTemplateTimeouts | undefined;
    set internalValue(value: DataCatalogTagTemplateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template google_data_catalog_tag_template}
*/
export declare class DataCatalogTagTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_tag_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template google_data_catalog_tag_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCatalogTagTemplateConfig
    */
    constructor(scope: Construct, id: string, config: DataCatalogTagTemplateConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _forceDelete?;
    get forceDelete(): boolean | cdktf.IResolvable;
    set forceDelete(value: boolean | cdktf.IResolvable);
    resetForceDelete(): void;
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tagTemplateId?;
    get tagTemplateId(): string;
    set tagTemplateId(value: string);
    get tagTemplateIdInput(): string | undefined;
    private _fields?;
    get fields(): DataCatalogTagTemplateFields[] | cdktf.IResolvable;
    set fields(value: DataCatalogTagTemplateFields[] | cdktf.IResolvable);
    get fieldsInput(): cdktf.IResolvable | DataCatalogTagTemplateFields[] | undefined;
    private _timeouts;
    get timeouts(): DataCatalogTagTemplateTimeoutsOutputReference;
    putTimeouts(value: DataCatalogTagTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataCatalogTagTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
