import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleTpuTensorflowVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/tpu_tensorflow_versions#project DataGoogleTpuTensorflowVersions#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/tpu_tensorflow_versions#zone DataGoogleTpuTensorflowVersions#zone}
    */
    readonly zone?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/tpu_tensorflow_versions google_tpu_tensorflow_versions}
*/
export declare class DataGoogleTpuTensorflowVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_tpu_tensorflow_versions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/tpu_tensorflow_versions google_tpu_tensorflow_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleTpuTensorflowVersionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleTpuTensorflowVersionsConfig);
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get versions(): string[];
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
