import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocWorkflowTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see [JSON representation of duration](https://developers.google.com/protocol-buffers/docs/proto3#json)). The timeout duration must be from 10 minutes ("600s") to 24 hours ("86400s"). The timer begins when the first job is submitted. If the workflow is running at the end of the timeout period, any remaining jobs are cancelled, the workflow is ended, and if the workflow was running on a [managed cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster), the cluster is deleted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#dag_timeout DataprocWorkflowTemplate#dag_timeout}
    */
    readonly dagTimeout?: string;
    /**
    * Optional. The labels to associate with this template. These labels will be propagated to all jobs and clusters created by the workflow instance. Label **keys** must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be empty, but, if present, must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#labels DataprocWorkflowTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#location DataprocWorkflowTemplate#location}
    */
    readonly location: string;
    /**
    * Output only. The resource name of the workflow template, as described in https://cloud.google.com/apis/design/resource_names. * For `projects.regions.workflowTemplates`, the resource name of the template has the following format: `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}` * For `projects.locations.workflowTemplates`, the resource name of the template has the following format: `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#name DataprocWorkflowTemplate#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#project DataprocWorkflowTemplate#project}
    */
    readonly project?: string;
    /**
    * Output only. The current version of this workflow template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#version DataprocWorkflowTemplate#version}
    */
    readonly version?: number;
    /**
    * jobs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jobs DataprocWorkflowTemplate#jobs}
    */
    readonly jobs: DataprocWorkflowTemplateJobs[] | cdktf.IResolvable;
    /**
    * parameters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#parameters DataprocWorkflowTemplate#parameters}
    */
    readonly parameters?: DataprocWorkflowTemplateParameters[] | cdktf.IResolvable;
    /**
    * placement block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#placement DataprocWorkflowTemplate#placement}
    */
    readonly placement: DataprocWorkflowTemplatePlacement;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#timeouts DataprocWorkflowTemplate#timeouts}
    */
    readonly timeouts?: DataprocWorkflowTemplateTimeouts;
}
export interface DataprocWorkflowTemplateJobsHadoopJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsHadoopJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsHadoopJobLoggingConfig): any;
export declare class DataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsHadoopJob {
    /**
    * Optional. HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#archive_uris DataprocWorkflowTemplate#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Optional. The arguments to pass to the driver. Do not include arguments, such as `-libjars` or `-Dfoo=bar`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#args DataprocWorkflowTemplate#args}
    */
    readonly args?: string[];
    /**
    * Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#file_uris DataprocWorkflowTemplate#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_class DataprocWorkflowTemplate#main_class}
    */
    readonly mainClass?: string;
    /**
    * The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_jar_file_uri DataprocWorkflowTemplate#main_jar_file_uri}
    */
    readonly mainJarFileUri?: string;
    /**
    * Optional. A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsHadoopJobLoggingConfig;
}
export declare function dataprocWorkflowTemplateJobsHadoopJobToTerraform(struct?: DataprocWorkflowTemplateJobsHadoopJobOutputReference | DataprocWorkflowTemplateJobsHadoopJob): any;
export declare class DataprocWorkflowTemplateJobsHadoopJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsHadoopJob | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsHadoopJob | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string;
    set mainClass(value: string);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string;
    set mainJarFileUri(value: string);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): DataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsHadoopJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined;
}
export interface DataprocWorkflowTemplateJobsHiveJobQueryList {
    /**
    * Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#queries DataprocWorkflowTemplate#queries}
    */
    readonly queries: string[];
}
export declare function dataprocWorkflowTemplateJobsHiveJobQueryListToTerraform(struct?: DataprocWorkflowTemplateJobsHiveJobQueryListOutputReference | DataprocWorkflowTemplateJobsHiveJobQueryList): any;
export declare class DataprocWorkflowTemplateJobsHiveJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsHiveJobQueryList | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsHiveJobQueryList | undefined);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateJobsHiveJob {
    /**
    * Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}
    */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
    * Optional. HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * Optional. A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * The HCFS URI of the script that contains Hive queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_file_uri DataprocWorkflowTemplate#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * Optional. Mapping of query variable names to values (equivalent to the Hive command: `SET name="value";`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#script_variables DataprocWorkflowTemplate#script_variables}
    */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
    * query_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_list DataprocWorkflowTemplate#query_list}
    */
    readonly queryList?: DataprocWorkflowTemplateJobsHiveJobQueryList;
}
export declare function dataprocWorkflowTemplateJobsHiveJobToTerraform(struct?: DataprocWorkflowTemplateJobsHiveJobOutputReference | DataprocWorkflowTemplateJobsHiveJob): any;
export declare class DataprocWorkflowTemplateJobsHiveJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsHiveJob | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsHiveJob | undefined);
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable;
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    };
    set scriptVariables(value: {
        [key: string]: string;
    });
    resetScriptVariables(): void;
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryList;
    get queryList(): DataprocWorkflowTemplateJobsHiveJobQueryListOutputReference;
    putQueryList(value: DataprocWorkflowTemplateJobsHiveJobQueryList): void;
    resetQueryList(): void;
    get queryListInput(): DataprocWorkflowTemplateJobsHiveJobQueryList | undefined;
}
export interface DataprocWorkflowTemplateJobsPigJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsPigJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsPigJobLoggingConfig): any;
export declare class DataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsPigJobQueryList {
    /**
    * Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#queries DataprocWorkflowTemplate#queries}
    */
    readonly queries: string[];
}
export declare function dataprocWorkflowTemplateJobsPigJobQueryListToTerraform(struct?: DataprocWorkflowTemplateJobsPigJobQueryListOutputReference | DataprocWorkflowTemplateJobsPigJobQueryList): any;
export declare class DataprocWorkflowTemplateJobsPigJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsPigJobQueryList | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsPigJobQueryList | undefined);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateJobsPigJob {
    /**
    * Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}
    */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
    * Optional. HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * Optional. A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * The HCFS URI of the script that contains the Pig queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_file_uri DataprocWorkflowTemplate#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * Optional. Mapping of query variable names to values (equivalent to the Pig command: `name=[value]`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#script_variables DataprocWorkflowTemplate#script_variables}
    */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPigJobLoggingConfig;
    /**
    * query_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_list DataprocWorkflowTemplate#query_list}
    */
    readonly queryList?: DataprocWorkflowTemplateJobsPigJobQueryList;
}
export declare function dataprocWorkflowTemplateJobsPigJobToTerraform(struct?: DataprocWorkflowTemplateJobsPigJobOutputReference | DataprocWorkflowTemplateJobsPigJob): any;
export declare class DataprocWorkflowTemplateJobsPigJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsPigJob | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsPigJob | undefined);
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable;
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    };
    set scriptVariables(value: {
        [key: string]: string;
    });
    resetScriptVariables(): void;
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): DataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsPigJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined;
    private _queryList;
    get queryList(): DataprocWorkflowTemplateJobsPigJobQueryListOutputReference;
    putQueryList(value: DataprocWorkflowTemplateJobsPigJobQueryList): void;
    resetQueryList(): void;
    get queryListInput(): DataprocWorkflowTemplateJobsPigJobQueryList | undefined;
}
export interface DataprocWorkflowTemplateJobsPrestoJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsPrestoJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsPrestoJobLoggingConfig): any;
export declare class DataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsPrestoJobQueryList {
    /**
    * Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#queries DataprocWorkflowTemplate#queries}
    */
    readonly queries: string[];
}
export declare function dataprocWorkflowTemplateJobsPrestoJobQueryListToTerraform(struct?: DataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference | DataprocWorkflowTemplateJobsPrestoJobQueryList): any;
export declare class DataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsPrestoJobQueryList | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsPrestoJobQueryList | undefined);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateJobsPrestoJob {
    /**
    * Optional. Presto client tags to attach to this query
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#client_tags DataprocWorkflowTemplate#client_tags}
    */
    readonly clientTags?: string[];
    /**
    * Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}
    */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
    * Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#output_format DataprocWorkflowTemplate#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Optional. A mapping of property names to values. Used to set Presto [session properties](https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * The HCFS URI of the script that contains SQL queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_file_uri DataprocWorkflowTemplate#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPrestoJobLoggingConfig;
    /**
    * query_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_list DataprocWorkflowTemplate#query_list}
    */
    readonly queryList?: DataprocWorkflowTemplateJobsPrestoJobQueryList;
}
export declare function dataprocWorkflowTemplateJobsPrestoJobToTerraform(struct?: DataprocWorkflowTemplateJobsPrestoJobOutputReference | DataprocWorkflowTemplateJobsPrestoJob): any;
export declare class DataprocWorkflowTemplateJobsPrestoJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsPrestoJob | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsPrestoJob | undefined);
    private _clientTags?;
    get clientTags(): string[];
    set clientTags(value: string[]);
    resetClientTags(): void;
    get clientTagsInput(): string[] | undefined;
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable;
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _loggingConfig;
    get loggingConfig(): DataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsPrestoJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined;
    private _queryList;
    get queryList(): DataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference;
    putQueryList(value: DataprocWorkflowTemplateJobsPrestoJobQueryList): void;
    resetQueryList(): void;
    get queryListInput(): DataprocWorkflowTemplateJobsPrestoJobQueryList | undefined;
}
export interface DataprocWorkflowTemplateJobsPysparkJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsPysparkJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsPysparkJobLoggingConfig): any;
export declare class DataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsPysparkJob {
    /**
    * Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#archive_uris DataprocWorkflowTemplate#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#args DataprocWorkflowTemplate#args}
    */
    readonly args?: string[];
    /**
    * Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#file_uris DataprocWorkflowTemplate#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_python_file_uri DataprocWorkflowTemplate#main_python_file_uri}
    */
    readonly mainPythonFileUri: string;
    /**
    * Optional. A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#python_file_uris DataprocWorkflowTemplate#python_file_uris}
    */
    readonly pythonFileUris?: string[];
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPysparkJobLoggingConfig;
}
export declare function dataprocWorkflowTemplateJobsPysparkJobToTerraform(struct?: DataprocWorkflowTemplateJobsPysparkJobOutputReference | DataprocWorkflowTemplateJobsPysparkJob): any;
export declare class DataprocWorkflowTemplateJobsPysparkJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsPysparkJob | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsPysparkJob | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainPythonFileUri?;
    get mainPythonFileUri(): string;
    set mainPythonFileUri(value: string);
    get mainPythonFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _pythonFileUris?;
    get pythonFileUris(): string[];
    set pythonFileUris(value: string[]);
    resetPythonFileUris(): void;
    get pythonFileUrisInput(): string[] | undefined;
    private _loggingConfig;
    get loggingConfig(): DataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsPysparkJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined;
}
export interface DataprocWorkflowTemplateJobsScheduling {
    /**
    * Optional. Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window. Maximum value is 10.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#max_failures_per_hour DataprocWorkflowTemplate#max_failures_per_hour}
    */
    readonly maxFailuresPerHour?: number;
    /**
    * Optional. Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#max_failures_total DataprocWorkflowTemplate#max_failures_total}
    */
    readonly maxFailuresTotal?: number;
}
export declare function dataprocWorkflowTemplateJobsSchedulingToTerraform(struct?: DataprocWorkflowTemplateJobsSchedulingOutputReference | DataprocWorkflowTemplateJobsScheduling): any;
export declare class DataprocWorkflowTemplateJobsSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsScheduling | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsScheduling | undefined);
    private _maxFailuresPerHour?;
    get maxFailuresPerHour(): number;
    set maxFailuresPerHour(value: number);
    resetMaxFailuresPerHour(): void;
    get maxFailuresPerHourInput(): number | undefined;
    private _maxFailuresTotal?;
    get maxFailuresTotal(): number;
    set maxFailuresTotal(value: number);
    resetMaxFailuresTotal(): void;
    get maxFailuresTotalInput(): number | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsSparkJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsSparkJobLoggingConfig): any;
export declare class DataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkJob {
    /**
    * Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#archive_uris DataprocWorkflowTemplate#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#args DataprocWorkflowTemplate#args}
    */
    readonly args?: string[];
    /**
    * Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#file_uris DataprocWorkflowTemplate#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in `jar_file_uris`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_class DataprocWorkflowTemplate#main_class}
    */
    readonly mainClass?: string;
    /**
    * The HCFS URI of the jar file that contains the main class.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_jar_file_uri DataprocWorkflowTemplate#main_jar_file_uri}
    */
    readonly mainJarFileUri?: string;
    /**
    * Optional. A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkJobLoggingConfig;
}
export declare function dataprocWorkflowTemplateJobsSparkJobToTerraform(struct?: DataprocWorkflowTemplateJobsSparkJobOutputReference | DataprocWorkflowTemplateJobsSparkJob): any;
export declare class DataprocWorkflowTemplateJobsSparkJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsSparkJob | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsSparkJob | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string;
    set mainClass(value: string);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string;
    set mainJarFileUri(value: string);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): DataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsSparkJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkRJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsSparkRJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsSparkRJobLoggingConfig): any;
export declare class DataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkRJob {
    /**
    * Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#archive_uris DataprocWorkflowTemplate#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#args DataprocWorkflowTemplate#args}
    */
    readonly args?: string[];
    /**
    * Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#file_uris DataprocWorkflowTemplate#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_r_file_uri DataprocWorkflowTemplate#main_r_file_uri}
    */
    readonly mainRFileUri: string;
    /**
    * Optional. A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkRJobLoggingConfig;
}
export declare function dataprocWorkflowTemplateJobsSparkRJobToTerraform(struct?: DataprocWorkflowTemplateJobsSparkRJobOutputReference | DataprocWorkflowTemplateJobsSparkRJob): any;
export declare class DataprocWorkflowTemplateJobsSparkRJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsSparkRJob | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsSparkRJob | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _mainRFileUri?;
    get mainRFileUri(): string;
    set mainRFileUri(value: string);
    get mainRFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): DataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsSparkRJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig): any;
export declare class DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkSqlJobQueryList {
    /**
    * Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#queries DataprocWorkflowTemplate#queries}
    */
    readonly queries: string[];
}
export declare function dataprocWorkflowTemplateJobsSparkSqlJobQueryListToTerraform(struct?: DataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference | DataprocWorkflowTemplateJobsSparkSqlJobQueryList): any;
export declare class DataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkSqlJob {
    /**
    * Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * The HCFS URI of the script that contains SQL queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_file_uri DataprocWorkflowTemplate#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#script_variables DataprocWorkflowTemplate#script_variables}
    */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig;
    /**
    * query_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_list DataprocWorkflowTemplate#query_list}
    */
    readonly queryList?: DataprocWorkflowTemplateJobsSparkSqlJobQueryList;
}
export declare function dataprocWorkflowTemplateJobsSparkSqlJobToTerraform(struct?: DataprocWorkflowTemplateJobsSparkSqlJobOutputReference | DataprocWorkflowTemplateJobsSparkSqlJob): any;
export declare class DataprocWorkflowTemplateJobsSparkSqlJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateJobsSparkSqlJob | undefined;
    set internalValue(value: DataprocWorkflowTemplateJobsSparkSqlJob | undefined);
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    };
    set scriptVariables(value: {
        [key: string]: string;
    });
    resetScriptVariables(): void;
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined;
    private _queryList;
    get queryList(): DataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference;
    putQueryList(value: DataprocWorkflowTemplateJobsSparkSqlJobQueryList): void;
    resetQueryList(): void;
    get queryListInput(): DataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined;
}
export interface DataprocWorkflowTemplateJobs {
    /**
    * Optional. The labels to associate with this job. Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: p{Ll}p{Lo}{0,62} Label values must be between 1 and 63 characters long, and must conform to the following regular expression: [p{Ll}p{Lo}p{N}_-]{0,63} No more than 32 labels can be associated with a given job.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#labels DataprocWorkflowTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Optional. The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#prerequisite_step_ids DataprocWorkflowTemplate#prerequisite_step_ids}
    */
    readonly prerequisiteStepIds?: string[];
    /**
    * Required. The step id. The id must be unique among all jobs within the template. The step id is used as prefix for job id, as job `goog-dataproc-workflow-step-id` label, and in prerequisiteStepIds field from other steps. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#step_id DataprocWorkflowTemplate#step_id}
    */
    readonly stepId: string;
    /**
    * hadoop_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#hadoop_job DataprocWorkflowTemplate#hadoop_job}
    */
    readonly hadoopJob?: DataprocWorkflowTemplateJobsHadoopJob;
    /**
    * hive_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#hive_job DataprocWorkflowTemplate#hive_job}
    */
    readonly hiveJob?: DataprocWorkflowTemplateJobsHiveJob;
    /**
    * pig_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#pig_job DataprocWorkflowTemplate#pig_job}
    */
    readonly pigJob?: DataprocWorkflowTemplateJobsPigJob;
    /**
    * presto_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#presto_job DataprocWorkflowTemplate#presto_job}
    */
    readonly prestoJob?: DataprocWorkflowTemplateJobsPrestoJob;
    /**
    * pyspark_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#pyspark_job DataprocWorkflowTemplate#pyspark_job}
    */
    readonly pysparkJob?: DataprocWorkflowTemplateJobsPysparkJob;
    /**
    * scheduling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#scheduling DataprocWorkflowTemplate#scheduling}
    */
    readonly scheduling?: DataprocWorkflowTemplateJobsScheduling;
    /**
    * spark_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#spark_job DataprocWorkflowTemplate#spark_job}
    */
    readonly sparkJob?: DataprocWorkflowTemplateJobsSparkJob;
    /**
    * spark_r_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#spark_r_job DataprocWorkflowTemplate#spark_r_job}
    */
    readonly sparkRJob?: DataprocWorkflowTemplateJobsSparkRJob;
    /**
    * spark_sql_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#spark_sql_job DataprocWorkflowTemplate#spark_sql_job}
    */
    readonly sparkSqlJob?: DataprocWorkflowTemplateJobsSparkSqlJob;
}
export declare function dataprocWorkflowTemplateJobsToTerraform(struct?: DataprocWorkflowTemplateJobs | cdktf.IResolvable): any;
export interface DataprocWorkflowTemplateParametersValidationRegex {
    /**
    * Required. RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#regexes DataprocWorkflowTemplate#regexes}
    */
    readonly regexes: string[];
}
export declare function dataprocWorkflowTemplateParametersValidationRegexToTerraform(struct?: DataprocWorkflowTemplateParametersValidationRegexOutputReference | DataprocWorkflowTemplateParametersValidationRegex): any;
export declare class DataprocWorkflowTemplateParametersValidationRegexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateParametersValidationRegex | undefined;
    set internalValue(value: DataprocWorkflowTemplateParametersValidationRegex | undefined);
    private _regexes?;
    get regexes(): string[];
    set regexes(value: string[]);
    get regexesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateParametersValidationValues {
    /**
    * Required. List of allowed values for the parameter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#values DataprocWorkflowTemplate#values}
    */
    readonly values: string[];
}
export declare function dataprocWorkflowTemplateParametersValidationValuesToTerraform(struct?: DataprocWorkflowTemplateParametersValidationValuesOutputReference | DataprocWorkflowTemplateParametersValidationValues): any;
export declare class DataprocWorkflowTemplateParametersValidationValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateParametersValidationValues | undefined;
    set internalValue(value: DataprocWorkflowTemplateParametersValidationValues | undefined);
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateParametersValidation {
    /**
    * regex block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#regex DataprocWorkflowTemplate#regex}
    */
    readonly regex?: DataprocWorkflowTemplateParametersValidationRegex;
    /**
    * values block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#values DataprocWorkflowTemplate#values}
    */
    readonly values?: DataprocWorkflowTemplateParametersValidationValues;
}
export declare function dataprocWorkflowTemplateParametersValidationToTerraform(struct?: DataprocWorkflowTemplateParametersValidationOutputReference | DataprocWorkflowTemplateParametersValidation): any;
export declare class DataprocWorkflowTemplateParametersValidationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateParametersValidation | undefined;
    set internalValue(value: DataprocWorkflowTemplateParametersValidation | undefined);
    private _regex;
    get regex(): DataprocWorkflowTemplateParametersValidationRegexOutputReference;
    putRegex(value: DataprocWorkflowTemplateParametersValidationRegex): void;
    resetRegex(): void;
    get regexInput(): DataprocWorkflowTemplateParametersValidationRegex | undefined;
    private _values;
    get values(): DataprocWorkflowTemplateParametersValidationValuesOutputReference;
    putValues(value: DataprocWorkflowTemplateParametersValidationValues): void;
    resetValues(): void;
    get valuesInput(): DataprocWorkflowTemplateParametersValidationValues | undefined;
}
export interface DataprocWorkflowTemplateParameters {
    /**
    * Optional. Brief description of the parameter. Must not exceed 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#description DataprocWorkflowTemplate#description}
    */
    readonly description?: string;
    /**
    * Required. Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths. A field path is similar in syntax to a google.protobuf.FieldMask. For example, a field path that references the zone field of a workflow template's cluster selector would be specified as `placement.clusterSelector.zone`. Also, field paths can reference fields using the following syntax: * Values in maps can be referenced by key: * labels['key'] * placement.clusterSelector.clusterLabels['key'] * placement.managedCluster.labels['key'] * placement.clusterSelector.clusterLabels['key'] * jobs['step-id'].labels['key'] * Jobs in the jobs list can be referenced by step-id: * jobs['step-id'].hadoopJob.mainJarFileUri * jobs['step-id'].hiveJob.queryFileUri * jobs['step-id'].pySparkJob.mainPythonFileUri * jobs['step-id'].hadoopJob.jarFileUris[0] * jobs['step-id'].hadoopJob.archiveUris[0] * jobs['step-id'].hadoopJob.fileUris[0] * jobs['step-id'].pySparkJob.pythonFileUris[0] * Items in repeated fields can be referenced by a zero-based index: * jobs['step-id'].sparkJob.args[0] * Other examples: * jobs['step-id'].hadoopJob.properties['key'] * jobs['step-id'].hadoopJob.args[0] * jobs['step-id'].hiveJob.scriptVariables['key'] * jobs['step-id'].hadoopJob.mainJarFileUri * placement.clusterSelector.zone It may not be possible to parameterize maps and repeated fields in their entirety since only individual map values and individual items in repeated fields can be referenced. For example, the following field paths are invalid: - placement.clusterSelector.clusterLabels - jobs['step-id'].sparkJob.args
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#fields DataprocWorkflowTemplate#fields}
    */
    readonly fields: string[];
    /**
    * Required. Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#name DataprocWorkflowTemplate#name}
    */
    readonly name: string;
    /**
    * validation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#validation DataprocWorkflowTemplate#validation}
    */
    readonly validation?: DataprocWorkflowTemplateParametersValidation;
}
export declare function dataprocWorkflowTemplateParametersToTerraform(struct?: DataprocWorkflowTemplateParameters | cdktf.IResolvable): any;
export interface DataprocWorkflowTemplatePlacementClusterSelector {
    /**
    * Required. The cluster labels. Cluster must have all labels to match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cluster_labels DataprocWorkflowTemplate#cluster_labels}
    */
    readonly clusterLabels: {
        [key: string]: string;
    };
    /**
    * Optional. The zone where workflow process executes. This parameter does not affect the selection of the cluster. If unspecified, the zone of the first cluster matching the selector is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#zone DataprocWorkflowTemplate#zone}
    */
    readonly zone?: string;
}
export declare function dataprocWorkflowTemplatePlacementClusterSelectorToTerraform(struct?: DataprocWorkflowTemplatePlacementClusterSelectorOutputReference | DataprocWorkflowTemplatePlacementClusterSelector): any;
export declare class DataprocWorkflowTemplatePlacementClusterSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementClusterSelector | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementClusterSelector | undefined);
    private _clusterLabels?;
    get clusterLabels(): {
        [key: string]: string;
    };
    set clusterLabels(value: {
        [key: string]: string;
    });
    get clusterLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig {
    /**
    * Optional. The autoscaling policy used by the cluster. Only resource names including projectid and location (region) are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]` * `projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]` Note that the policy must be in the same project and Dataproc region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#policy DataprocWorkflowTemplate#policy}
    */
    readonly policy?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined);
    private _policy?;
    get policy(): string;
    set policy(value: string);
    resetPolicy(): void;
    get policyInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig {
    /**
    * Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#gce_pd_kms_key_name DataprocWorkflowTemplate#gce_pd_kms_key_name}
    */
    readonly gcePdKmsKeyName?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined);
    private _gcePdKmsKeyName?;
    get gcePdKmsKeyName(): string;
    set gcePdKmsKeyName(value: string);
    resetGcePdKmsKeyName(): void;
    get gcePdKmsKeyNameInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig {
    /**
    * Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#enable_http_port_access DataprocWorkflowTemplate#enable_http_port_access}
    */
    readonly enableHttpPortAccess?: boolean | cdktf.IResolvable;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined);
    private _enableHttpPortAccess?;
    get enableHttpPortAccess(): boolean | cdktf.IResolvable;
    set enableHttpPortAccess(value: boolean | cdktf.IResolvable);
    resetEnableHttpPortAccess(): void;
    get enableHttpPortAccessInput(): boolean | cdktf.IResolvable | undefined;
    httpPorts(key: string): string | cdktf.IResolvable;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity {
    /**
    * Required. The URI of a sole-tenant [node group resource](https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that the cluster will be created on. A full URL, partial URI, or node group name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1` * `projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1` * `node-group-1`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#node_group DataprocWorkflowTemplate#node_group}
    */
    readonly nodeGroup: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined);
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    get nodeGroupInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity {
    /**
    * Optional. Type of reservation to consume Possible values: TYPE_UNSPECIFIED, NO_RESERVATION, ANY_RESERVATION, SPECIFIC_RESERVATION
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#consume_reservation_type DataprocWorkflowTemplate#consume_reservation_type}
    */
    readonly consumeReservationType?: string;
    /**
    * Optional. Corresponds to the label key of reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#key DataprocWorkflowTemplate#key}
    */
    readonly key?: string;
    /**
    * Optional. Corresponds to the label values of reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#values DataprocWorkflowTemplate#values}
    */
    readonly values?: string[];
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    resetConsumeReservationType(): void;
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig {
    /**
    * Optional. If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This `internal_ip_only` restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#internal_ip_only DataprocWorkflowTemplate#internal_ip_only}
    */
    readonly internalIpOnly?: boolean | cdktf.IResolvable;
    /**
    * The Compute Engine metadata entries to add to all instances (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#metadata DataprocWorkflowTemplate#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither `network_uri` nor `subnetwork_uri` is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for more information). A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default` * `projects/[project_id]/regions/global/default` * `default`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#network DataprocWorkflowTemplate#network}
    */
    readonly network?: string;
    /**
    * Optional. The type of IPv6 access for a cluster. Possible values: PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED, INHERIT_FROM_SUBNETWORK, OUTBOUND, BIDIRECTIONAL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#private_ipv6_google_access DataprocWorkflowTemplate#private_ipv6_google_access}
    */
    readonly privateIpv6GoogleAccess?: string;
    /**
    * Optional. The [Dataproc service account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc) (also see [VM Data Plane identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity)) used by Dataproc cluster VM instances to access Google Cloud Platform services. If not specified, the [Compute Engine default service account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#service_account DataprocWorkflowTemplate#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Optional. The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: * https://www.googleapis.com/auth/cloud.useraccounts.readonly * https://www.googleapis.com/auth/devstorage.read_write * https://www.googleapis.com/auth/logging.write If no scopes are specified, the following defaults are also provided: * https://www.googleapis.com/auth/bigquery * https://www.googleapis.com/auth/bigtable.admin.table * https://www.googleapis.com/auth/bigtable.data * https://www.googleapis.com/auth/devstorage.full_control
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#service_account_scopes DataprocWorkflowTemplate#service_account_scopes}
    */
    readonly serviceAccountScopes?: string[];
    /**
    * Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0` * `projects/[project_id]/regions/us-east1/subnetworks/sub0` * `sub0`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#subnetwork DataprocWorkflowTemplate#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The Compute Engine tags to add to all instances (see [Tagging instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#tags DataprocWorkflowTemplate#tags}
    */
    readonly tags?: string[];
    /**
    * Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]` * `projects/[project_id]/zones/[zone]` * `us-central1-f`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#zone DataprocWorkflowTemplate#zone}
    */
    readonly zone?: string;
    /**
    * node_group_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#node_group_affinity DataprocWorkflowTemplate#node_group_affinity}
    */
    readonly nodeGroupAffinity?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#reservation_affinity DataprocWorkflowTemplate#reservation_affinity}
    */
    readonly reservationAffinity?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined);
    private _internalIpOnly?;
    get internalIpOnly(): boolean | cdktf.IResolvable;
    set internalIpOnly(value: boolean | cdktf.IResolvable);
    resetInternalIpOnly(): void;
    get internalIpOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _privateIpv6GoogleAccess?;
    get privateIpv6GoogleAccess(): string;
    set privateIpv6GoogleAccess(value: string);
    resetPrivateIpv6GoogleAccess(): void;
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    get serviceAccountScopes(): string[];
    set serviceAccountScopes(value: string[]);
    resetServiceAccountScopes(): void;
    get serviceAccountScopesInput(): string[] | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _nodeGroupAffinity;
    get nodeGroupAffinity(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference;
    putNodeGroupAffinity(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity): void;
    resetNodeGroupAffinity(): void;
    get nodeGroupAffinityInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined;
    private _reservationAffinity;
    get reservationAffinity(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference;
    putReservationAffinity(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions {
    /**
    * Required. Cloud Storage URI of executable file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#executable_file DataprocWorkflowTemplate#executable_file}
    */
    readonly executableFile?: string;
    /**
    * Optional. Amount of time executable has to complete. Default is 10 minutes (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)). Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#execution_timeout DataprocWorkflowTemplate#execution_timeout}
    */
    readonly executionTimeout?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActionsToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions | cdktf.IResolvable): any;
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig {
    /**
    * Optional. The time when cluster will be auto-deleted (see JSON representation of [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#auto_delete_time DataprocWorkflowTemplate#auto_delete_time}
    */
    readonly autoDeleteTime?: string;
    /**
    * Optional. The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#auto_delete_ttl DataprocWorkflowTemplate#auto_delete_ttl}
    */
    readonly autoDeleteTtl?: string;
    /**
    * Optional. The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#idle_delete_ttl DataprocWorkflowTemplate#idle_delete_ttl}
    */
    readonly idleDeleteTtl?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined);
    private _autoDeleteTime?;
    get autoDeleteTime(): string;
    set autoDeleteTime(value: string);
    resetAutoDeleteTime(): void;
    get autoDeleteTimeInput(): string | undefined;
    private _autoDeleteTtl?;
    get autoDeleteTtl(): string;
    set autoDeleteTtl(value: string);
    resetAutoDeleteTtl(): void;
    get autoDeleteTtlInput(): string | undefined;
    private _idleDeleteTtl?;
    get idleDeleteTtl(): string;
    set idleDeleteTtl(value: string);
    resetIdleDeleteTtl(): void;
    get idleDeleteTtlInput(): string | undefined;
    get idleStartTime(): string;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig {
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig | undefined);
    get instanceGroupManagerName(): string;
    get instanceTemplateName(): string;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigOutputReference;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_count DataprocWorkflowTemplate#accelerator_count}
    */
    readonly acceleratorCount?: number;
    /**
    * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_type DataprocWorkflowTemplate#accelerator_type}
    */
    readonly acceleratorType?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorsToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators | cdktf.IResolvable): any;
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig {
    /**
    * Optional. Size in GB of the boot disk (default is 500GB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig {
    /**
    * Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#image DataprocWorkflowTemplate#image}
    */
    readonly image?: string;
    /**
    * Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#machine_type DataprocWorkflowTemplate#machine_type}
    */
    readonly machineType?: string;
    /**
    * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Optional. The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_instances DataprocWorkflowTemplate#num_instances}
    */
    readonly numInstances?: number;
    /**
    * Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#preemptibility DataprocWorkflowTemplate#preemptibility}
    */
    readonly preemptibility?: string;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerators DataprocWorkflowTemplate#accelerators}
    */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#disk_config DataprocWorkflowTemplate#disk_config}
    */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    get instanceNames(): string[];
    get isPreemptible(): cdktf.IResolvable;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _managedGroupConfig;
    get managedGroupConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigList;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string;
    set preemptibility(value: string);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _accelerators?;
    get accelerators(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    set accelerators(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable);
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig {
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig | undefined);
    get instanceGroupManagerName(): string;
    get instanceTemplateName(): string;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigOutputReference;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_count DataprocWorkflowTemplate#accelerator_count}
    */
    readonly acceleratorCount?: number;
    /**
    * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_type DataprocWorkflowTemplate#accelerator_type}
    */
    readonly acceleratorType?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorsToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators | cdktf.IResolvable): any;
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig {
    /**
    * Optional. Size in GB of the boot disk (default is 500GB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig {
    /**
    * Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#image DataprocWorkflowTemplate#image}
    */
    readonly image?: string;
    /**
    * Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#machine_type DataprocWorkflowTemplate#machine_type}
    */
    readonly machineType?: string;
    /**
    * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Optional. The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_instances DataprocWorkflowTemplate#num_instances}
    */
    readonly numInstances?: number;
    /**
    * Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#preemptibility DataprocWorkflowTemplate#preemptibility}
    */
    readonly preemptibility?: string;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerators DataprocWorkflowTemplate#accelerators}
    */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#disk_config DataprocWorkflowTemplate#disk_config}
    */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    get instanceNames(): string[];
    get isPreemptible(): cdktf.IResolvable;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _managedGroupConfig;
    get managedGroupConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigList;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string;
    set preemptibility(value: string);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _accelerators?;
    get accelerators(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | cdktf.IResolvable;
    set accelerators(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | cdktf.IResolvable);
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig {
    /**
    * Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cross_realm_trust_admin_server DataprocWorkflowTemplate#cross_realm_trust_admin_server}
    */
    readonly crossRealmTrustAdminServer?: string;
    /**
    * Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cross_realm_trust_kdc DataprocWorkflowTemplate#cross_realm_trust_kdc}
    */
    readonly crossRealmTrustKdc?: string;
    /**
    * Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cross_realm_trust_realm DataprocWorkflowTemplate#cross_realm_trust_realm}
    */
    readonly crossRealmTrustRealm?: string;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cross_realm_trust_shared_password DataprocWorkflowTemplate#cross_realm_trust_shared_password}
    */
    readonly crossRealmTrustSharedPassword?: string;
    /**
    * Optional. Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#enable_kerberos DataprocWorkflowTemplate#enable_kerberos}
    */
    readonly enableKerberos?: boolean | cdktf.IResolvable;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#kdc_db_key DataprocWorkflowTemplate#kdc_db_key}
    */
    readonly kdcDbKey?: string;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#key_password DataprocWorkflowTemplate#key_password}
    */
    readonly keyPassword?: string;
    /**
    * Optional. The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#keystore DataprocWorkflowTemplate#keystore}
    */
    readonly keystore?: string;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#keystore_password DataprocWorkflowTemplate#keystore_password}
    */
    readonly keystorePassword?: string;
    /**
    * Optional. The uri of the KMS key used to encrypt various sensitive files.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#kms_key DataprocWorkflowTemplate#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Optional. The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#realm DataprocWorkflowTemplate#realm}
    */
    readonly realm?: string;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#root_principal_password DataprocWorkflowTemplate#root_principal_password}
    */
    readonly rootPrincipalPassword?: string;
    /**
    * Optional. The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#tgt_lifetime_hours DataprocWorkflowTemplate#tgt_lifetime_hours}
    */
    readonly tgtLifetimeHours?: number;
    /**
    * Optional. The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#truststore DataprocWorkflowTemplate#truststore}
    */
    readonly truststore?: string;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#truststore_password DataprocWorkflowTemplate#truststore_password}
    */
    readonly truststorePassword?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined);
    private _crossRealmTrustAdminServer?;
    get crossRealmTrustAdminServer(): string;
    set crossRealmTrustAdminServer(value: string);
    resetCrossRealmTrustAdminServer(): void;
    get crossRealmTrustAdminServerInput(): string | undefined;
    private _crossRealmTrustKdc?;
    get crossRealmTrustKdc(): string;
    set crossRealmTrustKdc(value: string);
    resetCrossRealmTrustKdc(): void;
    get crossRealmTrustKdcInput(): string | undefined;
    private _crossRealmTrustRealm?;
    get crossRealmTrustRealm(): string;
    set crossRealmTrustRealm(value: string);
    resetCrossRealmTrustRealm(): void;
    get crossRealmTrustRealmInput(): string | undefined;
    private _crossRealmTrustSharedPassword?;
    get crossRealmTrustSharedPassword(): string;
    set crossRealmTrustSharedPassword(value: string);
    resetCrossRealmTrustSharedPassword(): void;
    get crossRealmTrustSharedPasswordInput(): string | undefined;
    private _enableKerberos?;
    get enableKerberos(): boolean | cdktf.IResolvable;
    set enableKerberos(value: boolean | cdktf.IResolvable);
    resetEnableKerberos(): void;
    get enableKerberosInput(): boolean | cdktf.IResolvable | undefined;
    private _kdcDbKey?;
    get kdcDbKey(): string;
    set kdcDbKey(value: string);
    resetKdcDbKey(): void;
    get kdcDbKeyInput(): string | undefined;
    private _keyPassword?;
    get keyPassword(): string;
    set keyPassword(value: string);
    resetKeyPassword(): void;
    get keyPasswordInput(): string | undefined;
    private _keystore?;
    get keystore(): string;
    set keystore(value: string);
    resetKeystore(): void;
    get keystoreInput(): string | undefined;
    private _keystorePassword?;
    get keystorePassword(): string;
    set keystorePassword(value: string);
    resetKeystorePassword(): void;
    get keystorePasswordInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _realm?;
    get realm(): string;
    set realm(value: string);
    resetRealm(): void;
    get realmInput(): string | undefined;
    private _rootPrincipalPassword?;
    get rootPrincipalPassword(): string;
    set rootPrincipalPassword(value: string);
    resetRootPrincipalPassword(): void;
    get rootPrincipalPasswordInput(): string | undefined;
    private _tgtLifetimeHours?;
    get tgtLifetimeHours(): number;
    set tgtLifetimeHours(value: number);
    resetTgtLifetimeHours(): void;
    get tgtLifetimeHoursInput(): number | undefined;
    private _truststore?;
    get truststore(): string;
    set truststore(value: string);
    resetTruststore(): void;
    get truststoreInput(): string | undefined;
    private _truststorePassword?;
    get truststorePassword(): string;
    set truststorePassword(value: string);
    resetTruststorePassword(): void;
    get truststorePasswordInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig {
    /**
    * kerberos_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#kerberos_config DataprocWorkflowTemplate#kerberos_config}
    */
    readonly kerberosConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined);
    private _kerberosConfig;
    get kerberosConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference;
    putKerberosConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig): void;
    resetKerberosConfig(): void;
    get kerberosConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig {
    /**
    * Optional. The version of software inside the cluster. It must be one of the supported [Dataproc Versions](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the ["preview" version](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#image_version DataprocWorkflowTemplate#image_version}
    */
    readonly imageVersion?: string;
    /**
    * Optional. The set of components to activate on the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#optional_components DataprocWorkflowTemplate#optional_components}
    */
    readonly optionalComponents?: string[];
    /**
    * Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined);
    private _imageVersion?;
    get imageVersion(): string;
    set imageVersion(value: string);
    resetImageVersion(): void;
    get imageVersionInput(): string | undefined;
    private _optionalComponents?;
    get optionalComponents(): string[];
    set optionalComponents(value: string[]);
    resetOptionalComponents(): void;
    get optionalComponentsInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig {
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig | undefined);
    get instanceGroupManagerName(): string;
    get instanceTemplateName(): string;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigOutputReference;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_count DataprocWorkflowTemplate#accelerator_count}
    */
    readonly acceleratorCount?: number;
    /**
    * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_type DataprocWorkflowTemplate#accelerator_type}
    */
    readonly acceleratorType?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorsToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators | cdktf.IResolvable): any;
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig {
    /**
    * Optional. Size in GB of the boot disk (default is 500GB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig {
    /**
    * Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#image DataprocWorkflowTemplate#image}
    */
    readonly image?: string;
    /**
    * Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#machine_type DataprocWorkflowTemplate#machine_type}
    */
    readonly machineType?: string;
    /**
    * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Optional. The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_instances DataprocWorkflowTemplate#num_instances}
    */
    readonly numInstances?: number;
    /**
    * Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#preemptibility DataprocWorkflowTemplate#preemptibility}
    */
    readonly preemptibility?: string;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerators DataprocWorkflowTemplate#accelerators}
    */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#disk_config DataprocWorkflowTemplate#disk_config}
    */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    get instanceNames(): string[];
    get isPreemptible(): cdktf.IResolvable;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _managedGroupConfig;
    get managedGroupConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigList;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string;
    set preemptibility(value: string);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _accelerators?;
    get accelerators(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    set accelerators(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable);
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfig {
    /**
    * Optional. A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see [Dataproc staging bucket](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). **This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.**
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#staging_bucket DataprocWorkflowTemplate#staging_bucket}
    */
    readonly stagingBucket?: string;
    /**
    * Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket. **This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.**
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#temp_bucket DataprocWorkflowTemplate#temp_bucket}
    */
    readonly tempBucket?: string;
    /**
    * autoscaling_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#autoscaling_config DataprocWorkflowTemplate#autoscaling_config}
    */
    readonly autoscalingConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#encryption_config DataprocWorkflowTemplate#encryption_config}
    */
    readonly encryptionConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig;
    /**
    * endpoint_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#endpoint_config DataprocWorkflowTemplate#endpoint_config}
    */
    readonly endpointConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig;
    /**
    * gce_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#gce_cluster_config DataprocWorkflowTemplate#gce_cluster_config}
    */
    readonly gceClusterConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig;
    /**
    * initialization_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#initialization_actions DataprocWorkflowTemplate#initialization_actions}
    */
    readonly initializationActions?: DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | cdktf.IResolvable;
    /**
    * lifecycle_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#lifecycle_config DataprocWorkflowTemplate#lifecycle_config}
    */
    readonly lifecycleConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig;
    /**
    * master_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#master_config DataprocWorkflowTemplate#master_config}
    */
    readonly masterConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig;
    /**
    * secondary_worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#secondary_worker_config DataprocWorkflowTemplate#secondary_worker_config}
    */
    readonly secondaryWorkerConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig;
    /**
    * security_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#security_config DataprocWorkflowTemplate#security_config}
    */
    readonly securityConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig;
    /**
    * software_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#software_config DataprocWorkflowTemplate#software_config}
    */
    readonly softwareConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig;
    /**
    * worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#worker_config DataprocWorkflowTemplate#worker_config}
    */
    readonly workerConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfig): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfig | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfig | undefined);
    private _stagingBucket?;
    get stagingBucket(): string;
    set stagingBucket(value: string);
    resetStagingBucket(): void;
    get stagingBucketInput(): string | undefined;
    private _tempBucket?;
    get tempBucket(): string;
    set tempBucket(value: string);
    resetTempBucket(): void;
    get tempBucketInput(): string | undefined;
    private _autoscalingConfig;
    get autoscalingConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference;
    putAutoscalingConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig): void;
    resetAutoscalingConfig(): void;
    get autoscalingConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined;
    private _encryptionConfig;
    get encryptionConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined;
    private _endpointConfig;
    get endpointConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference;
    putEndpointConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig): void;
    resetEndpointConfig(): void;
    get endpointConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined;
    private _gceClusterConfig;
    get gceClusterConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference;
    putGceClusterConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig): void;
    resetGceClusterConfig(): void;
    get gceClusterConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined;
    private _initializationActions?;
    get initializationActions(): DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | cdktf.IResolvable;
    set initializationActions(value: DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | cdktf.IResolvable);
    resetInitializationActions(): void;
    get initializationActionsInput(): cdktf.IResolvable | DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | undefined;
    private _lifecycleConfig;
    get lifecycleConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference;
    putLifecycleConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig): void;
    resetLifecycleConfig(): void;
    get lifecycleConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined;
    private _masterConfig;
    get masterConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference;
    putMasterConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig): void;
    resetMasterConfig(): void;
    get masterConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined;
    private _secondaryWorkerConfig;
    get secondaryWorkerConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference;
    putSecondaryWorkerConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig): void;
    resetSecondaryWorkerConfig(): void;
    get secondaryWorkerConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined;
    private _securityConfig;
    get securityConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference;
    putSecurityConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig): void;
    resetSecurityConfig(): void;
    get securityConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined;
    private _softwareConfig;
    get softwareConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference;
    putSoftwareConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined;
    private _workerConfig;
    get workerConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference;
    putWorkerConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedCluster {
    /**
    * Required. The cluster name prefix. A unique cluster name will be formed by appending a random suffix. The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cluster_name DataprocWorkflowTemplate#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Optional. The labels to associate with this cluster. Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: p{Ll}p{Lo}{0,62} Label values must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: [p{Ll}p{Lo}p{N}_-]{0,63} No more than 32 labels can be associated with a given cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#labels DataprocWorkflowTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#config DataprocWorkflowTemplate#config}
    */
    readonly config: DataprocWorkflowTemplatePlacementManagedClusterConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterOutputReference | DataprocWorkflowTemplatePlacementManagedCluster): any;
export declare class DataprocWorkflowTemplatePlacementManagedClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacementManagedCluster | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedCluster | undefined);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _config;
    get config(): DataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference;
    putConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfig): void;
    get configInput(): DataprocWorkflowTemplatePlacementManagedClusterConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacement {
    /**
    * cluster_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cluster_selector DataprocWorkflowTemplate#cluster_selector}
    */
    readonly clusterSelector?: DataprocWorkflowTemplatePlacementClusterSelector;
    /**
    * managed_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#managed_cluster DataprocWorkflowTemplate#managed_cluster}
    */
    readonly managedCluster?: DataprocWorkflowTemplatePlacementManagedCluster;
}
export declare function dataprocWorkflowTemplatePlacementToTerraform(struct?: DataprocWorkflowTemplatePlacementOutputReference | DataprocWorkflowTemplatePlacement): any;
export declare class DataprocWorkflowTemplatePlacementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplatePlacement | undefined;
    set internalValue(value: DataprocWorkflowTemplatePlacement | undefined);
    private _clusterSelector;
    get clusterSelector(): DataprocWorkflowTemplatePlacementClusterSelectorOutputReference;
    putClusterSelector(value: DataprocWorkflowTemplatePlacementClusterSelector): void;
    resetClusterSelector(): void;
    get clusterSelectorInput(): DataprocWorkflowTemplatePlacementClusterSelector | undefined;
    private _managedCluster;
    get managedCluster(): DataprocWorkflowTemplatePlacementManagedClusterOutputReference;
    putManagedCluster(value: DataprocWorkflowTemplatePlacementManagedCluster): void;
    resetManagedCluster(): void;
    get managedClusterInput(): DataprocWorkflowTemplatePlacementManagedCluster | undefined;
}
export interface DataprocWorkflowTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#create DataprocWorkflowTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#delete DataprocWorkflowTemplate#delete}
    */
    readonly delete?: string;
}
export declare function dataprocWorkflowTemplateTimeoutsToTerraform(struct?: DataprocWorkflowTemplateTimeoutsOutputReference | DataprocWorkflowTemplateTimeouts | cdktf.IResolvable): any;
export declare class DataprocWorkflowTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocWorkflowTemplateTimeouts | undefined;
    set internalValue(value: DataprocWorkflowTemplateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template google_dataproc_workflow_template}
*/
export declare class DataprocWorkflowTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_workflow_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template google_dataproc_workflow_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataprocWorkflowTemplateConfig
    */
    constructor(scope: Construct, id: string, config: DataprocWorkflowTemplateConfig);
    get createTime(): string;
    private _dagTimeout?;
    get dagTimeout(): string;
    set dagTimeout(value: string);
    resetDagTimeout(): void;
    get dagTimeoutInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _jobs?;
    get jobs(): DataprocWorkflowTemplateJobs[] | cdktf.IResolvable;
    set jobs(value: DataprocWorkflowTemplateJobs[] | cdktf.IResolvable);
    get jobsInput(): cdktf.IResolvable | DataprocWorkflowTemplateJobs[] | undefined;
    private _parameters?;
    get parameters(): DataprocWorkflowTemplateParameters[] | cdktf.IResolvable;
    set parameters(value: DataprocWorkflowTemplateParameters[] | cdktf.IResolvable);
    resetParameters(): void;
    get parametersInput(): cdktf.IResolvable | DataprocWorkflowTemplateParameters[] | undefined;
    private _placement;
    get placement(): DataprocWorkflowTemplatePlacementOutputReference;
    putPlacement(value: DataprocWorkflowTemplatePlacement): void;
    get placementInput(): DataprocWorkflowTemplatePlacement | undefined;
    private _timeouts;
    get timeouts(): DataprocWorkflowTemplateTimeoutsOutputReference;
    putTimeouts(value: DataprocWorkflowTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataprocWorkflowTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
