import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EssentialContactsContactConfig extends cdktf.TerraformMetaArguments {
    /**
    * The email address to send notifications to. This does not need to be a Google account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact#email EssentialContactsContact#email}
    */
    readonly email: string;
    /**
    * The preferred language for notifications, as a ISO 639-1 language code. See Supported languages for a list of supported languages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact#language_tag EssentialContactsContact#language_tag}
    */
    readonly languageTag: string;
    /**
    * The categories of notifications that the contact will receive communications for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact#notification_category_subscriptions EssentialContactsContact#notification_category_subscriptions}
    */
    readonly notificationCategorySubscriptions: string[];
    /**
    * The resource to save this contact for. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact#parent EssentialContactsContact#parent}
    */
    readonly parent: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact#timeouts EssentialContactsContact#timeouts}
    */
    readonly timeouts?: EssentialContactsContactTimeouts;
}
export interface EssentialContactsContactTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact#create EssentialContactsContact#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact#delete EssentialContactsContact#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact#update EssentialContactsContact#update}
    */
    readonly update?: string;
}
export declare function essentialContactsContactTimeoutsToTerraform(struct?: EssentialContactsContactTimeoutsOutputReference | EssentialContactsContactTimeouts | cdktf.IResolvable): any;
export declare class EssentialContactsContactTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EssentialContactsContactTimeouts | undefined;
    set internalValue(value: EssentialContactsContactTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact google_essential_contacts_contact}
*/
export declare class EssentialContactsContact extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_essential_contacts_contact";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact google_essential_contacts_contact} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EssentialContactsContactConfig
    */
    constructor(scope: Construct, id: string, config: EssentialContactsContactConfig);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    get id(): string;
    private _languageTag?;
    get languageTag(): string;
    set languageTag(value: string);
    get languageTagInput(): string | undefined;
    get name(): string;
    private _notificationCategorySubscriptions?;
    get notificationCategorySubscriptions(): string[];
    set notificationCategorySubscriptions(value: string[]);
    get notificationCategorySubscriptionsInput(): string[] | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _timeouts;
    get timeouts(): EssentialContactsContactTimeoutsOutputReference;
    putTimeouts(value: EssentialContactsContactTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): EssentialContactsContactTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
