import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapTunnelInstanceIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding#instance IapTunnelInstanceIamBinding#instance}
    */
    readonly instance: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding#members IapTunnelInstanceIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding#project IapTunnelInstanceIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding#role IapTunnelInstanceIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding#zone IapTunnelInstanceIamBinding#zone}
    */
    readonly zone?: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding#condition IapTunnelInstanceIamBinding#condition}
    */
    readonly condition?: IapTunnelInstanceIamBindingCondition;
}
export interface IapTunnelInstanceIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding#description IapTunnelInstanceIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding#expression IapTunnelInstanceIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding#title IapTunnelInstanceIamBinding#title}
    */
    readonly title: string;
}
export declare function iapTunnelInstanceIamBindingConditionToTerraform(struct?: IapTunnelInstanceIamBindingConditionOutputReference | IapTunnelInstanceIamBindingCondition): any;
export declare class IapTunnelInstanceIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IapTunnelInstanceIamBindingCondition | undefined;
    set internalValue(value: IapTunnelInstanceIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding google_iap_tunnel_instance_iam_binding}
*/
export declare class IapTunnelInstanceIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iap_tunnel_instance_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_binding google_iap_tunnel_instance_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IapTunnelInstanceIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: IapTunnelInstanceIamBindingConfig);
    get etag(): string;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _condition;
    get condition(): IapTunnelInstanceIamBindingConditionOutputReference;
    putCondition(value: IapTunnelInstanceIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): IapTunnelInstanceIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
