import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MemcacheInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full name of the GCE network to connect the instance to.  If not provided,
  'default' will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#authorized_network MemcacheInstance#authorized_network}
    */
    readonly authorizedNetwork?: string;
    /**
    * A user-visible name for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#display_name MemcacheInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#labels MemcacheInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The major version of Memcached software. If not provided, latest supported version will be used.
  Currently the latest supported major version is MEMCACHE_1_5. The minor version will be automatically
  determined by our system based on the latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#memcache_version MemcacheInstance#memcache_version}
    */
    readonly memcacheVersion?: string;
    /**
    * The resource name of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#name MemcacheInstance#name}
    */
    readonly name: string;
    /**
    * Number of nodes in the memcache instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#node_count MemcacheInstance#node_count}
    */
    readonly nodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#project MemcacheInstance#project}
    */
    readonly project?: string;
    /**
    * The region of the Memcache instance. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#region MemcacheInstance#region}
    */
    readonly region?: string;
    /**
    * Zones where memcache nodes should be provisioned.  If not
  provided, all zones will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#zones MemcacheInstance#zones}
    */
    readonly zones?: string[];
    /**
    * memcache_parameters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#memcache_parameters MemcacheInstance#memcache_parameters}
    */
    readonly memcacheParameters?: MemcacheInstanceMemcacheParameters;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#node_config MemcacheInstance#node_config}
    */
    readonly nodeConfig: MemcacheInstanceNodeConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#timeouts MemcacheInstance#timeouts}
    */
    readonly timeouts?: MemcacheInstanceTimeouts;
}
export interface MemcacheInstanceMemcacheNodes {
}
export declare function memcacheInstanceMemcacheNodesToTerraform(struct?: MemcacheInstanceMemcacheNodes): any;
export declare class MemcacheInstanceMemcacheNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MemcacheInstanceMemcacheNodes | undefined;
    set internalValue(value: MemcacheInstanceMemcacheNodes | undefined);
    get host(): string;
    get nodeId(): string;
    get port(): number;
    get state(): string;
    get zone(): string;
}
export declare class MemcacheInstanceMemcacheNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MemcacheInstanceMemcacheNodesOutputReference;
}
export interface MemcacheInstanceMemcacheParameters {
    /**
    * User-defined set of parameters to use in the memcache process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#params MemcacheInstance#params}
    */
    readonly params?: {
        [key: string]: string;
    };
}
export declare function memcacheInstanceMemcacheParametersToTerraform(struct?: MemcacheInstanceMemcacheParametersOutputReference | MemcacheInstanceMemcacheParameters): any;
export declare class MemcacheInstanceMemcacheParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MemcacheInstanceMemcacheParameters | undefined;
    set internalValue(value: MemcacheInstanceMemcacheParameters | undefined);
    get id(): string;
    private _params?;
    get params(): {
        [key: string]: string;
    };
    set params(value: {
        [key: string]: string;
    });
    resetParams(): void;
    get paramsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface MemcacheInstanceNodeConfig {
    /**
    * Number of CPUs per node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#cpu_count MemcacheInstance#cpu_count}
    */
    readonly cpuCount: number;
    /**
    * Memory size in Mebibytes for each memcache node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#memory_size_mb MemcacheInstance#memory_size_mb}
    */
    readonly memorySizeMb: number;
}
export declare function memcacheInstanceNodeConfigToTerraform(struct?: MemcacheInstanceNodeConfigOutputReference | MemcacheInstanceNodeConfig): any;
export declare class MemcacheInstanceNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MemcacheInstanceNodeConfig | undefined;
    set internalValue(value: MemcacheInstanceNodeConfig | undefined);
    private _cpuCount?;
    get cpuCount(): number;
    set cpuCount(value: number);
    get cpuCountInput(): number | undefined;
    private _memorySizeMb?;
    get memorySizeMb(): number;
    set memorySizeMb(value: number);
    get memorySizeMbInput(): number | undefined;
}
export interface MemcacheInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#create MemcacheInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#delete MemcacheInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance#update MemcacheInstance#update}
    */
    readonly update?: string;
}
export declare function memcacheInstanceTimeoutsToTerraform(struct?: MemcacheInstanceTimeoutsOutputReference | MemcacheInstanceTimeouts | cdktf.IResolvable): any;
export declare class MemcacheInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MemcacheInstanceTimeouts | undefined;
    set internalValue(value: MemcacheInstanceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/memcache_instance google_memcache_instance}
*/
export declare class MemcacheInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_memcache_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/memcache_instance google_memcache_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MemcacheInstanceConfig
    */
    constructor(scope: Construct, id: string, config: MemcacheInstanceConfig);
    private _authorizedNetwork?;
    get authorizedNetwork(): string;
    set authorizedNetwork(value: string);
    resetAuthorizedNetwork(): void;
    get authorizedNetworkInput(): string | undefined;
    get createTime(): string;
    get discoveryEndpoint(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get memcacheFullVersion(): string;
    private _memcacheNodes;
    get memcacheNodes(): MemcacheInstanceMemcacheNodesList;
    private _memcacheVersion?;
    get memcacheVersion(): string;
    set memcacheVersion(value: string);
    resetMemcacheVersion(): void;
    get memcacheVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _memcacheParameters;
    get memcacheParameters(): MemcacheInstanceMemcacheParametersOutputReference;
    putMemcacheParameters(value: MemcacheInstanceMemcacheParameters): void;
    resetMemcacheParameters(): void;
    get memcacheParametersInput(): MemcacheInstanceMemcacheParameters | undefined;
    private _nodeConfig;
    get nodeConfig(): MemcacheInstanceNodeConfigOutputReference;
    putNodeConfig(value: MemcacheInstanceNodeConfig): void;
    get nodeConfigInput(): MemcacheInstanceNodeConfig | undefined;
    private _timeouts;
    get timeouts(): MemcacheInstanceTimeoutsOutputReference;
    putTimeouts(value: MemcacheInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MemcacheInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
