import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectAccessApprovalSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of email addresses to which notifications relating to approval requests should be sent.
  Notifications relating to a resource will be sent to all emails in the settings of ancestor
  resources of that resource. A maximum of 50 email addresses are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings#notification_emails ProjectAccessApprovalSettings#notification_emails}
    */
    readonly notificationEmails?: string[];
    /**
    * Deprecated in favor of 'project_id'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings#project ProjectAccessApprovalSettings#project}
    */
    readonly project?: string;
    /**
    * ID of the project of the access approval settings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings#project_id ProjectAccessApprovalSettings#project_id}
    */
    readonly projectId: string;
    /**
    * enrolled_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings#enrolled_services ProjectAccessApprovalSettings#enrolled_services}
    */
    readonly enrolledServices: ProjectAccessApprovalSettingsEnrolledServices[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings#timeouts ProjectAccessApprovalSettings#timeouts}
    */
    readonly timeouts?: ProjectAccessApprovalSettingsTimeouts;
}
export interface ProjectAccessApprovalSettingsEnrolledServices {
    /**
    * The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive):
    all
    appengine.googleapis.com
    bigquery.googleapis.com
    bigtable.googleapis.com
    cloudkms.googleapis.com
    compute.googleapis.com
    dataflow.googleapis.com
    iam.googleapis.com
    pubsub.googleapis.com
    storage.googleapis.com
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings#cloud_product ProjectAccessApprovalSettings#cloud_product}
    */
    readonly cloudProduct: string;
    /**
    * The enrollment level of the service. Default value: "BLOCK_ALL" Possible values: ["BLOCK_ALL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings#enrollment_level ProjectAccessApprovalSettings#enrollment_level}
    */
    readonly enrollmentLevel?: string;
}
export declare function projectAccessApprovalSettingsEnrolledServicesToTerraform(struct?: ProjectAccessApprovalSettingsEnrolledServices | cdktf.IResolvable): any;
export interface ProjectAccessApprovalSettingsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings#create ProjectAccessApprovalSettings#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings#delete ProjectAccessApprovalSettings#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings#update ProjectAccessApprovalSettings#update}
    */
    readonly update?: string;
}
export declare function projectAccessApprovalSettingsTimeoutsToTerraform(struct?: ProjectAccessApprovalSettingsTimeoutsOutputReference | ProjectAccessApprovalSettingsTimeouts | cdktf.IResolvable): any;
export declare class ProjectAccessApprovalSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProjectAccessApprovalSettingsTimeouts | undefined;
    set internalValue(value: ProjectAccessApprovalSettingsTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings google_project_access_approval_settings}
*/
export declare class ProjectAccessApprovalSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project_access_approval_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings google_project_access_approval_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectAccessApprovalSettingsConfig
    */
    constructor(scope: Construct, id: string, config: ProjectAccessApprovalSettingsConfig);
    get enrolledAncestor(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    private _notificationEmails?;
    get notificationEmails(): string[];
    set notificationEmails(value: string[]);
    resetNotificationEmails(): void;
    get notificationEmailsInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _enrolledServices?;
    get enrolledServices(): ProjectAccessApprovalSettingsEnrolledServices[] | cdktf.IResolvable;
    set enrolledServices(value: ProjectAccessApprovalSettingsEnrolledServices[] | cdktf.IResolvable);
    get enrolledServicesInput(): cdktf.IResolvable | ProjectAccessApprovalSettingsEnrolledServices[] | undefined;
    private _timeouts;
    get timeouts(): ProjectAccessApprovalSettingsTimeoutsOutputReference;
    putTimeouts(value: ProjectAccessApprovalSettingsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ProjectAccessApprovalSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
