import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SourcerepoRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Resource name of the repository, of the form '{{repo}}'.
  The repo name may contain slashes. eg, 'name/with/slash'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#name SourcerepoRepository#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#project SourcerepoRepository#project}
    */
    readonly project?: string;
    /**
    * pubsub_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#pubsub_configs SourcerepoRepository#pubsub_configs}
    */
    readonly pubsubConfigs?: SourcerepoRepositoryPubsubConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#timeouts SourcerepoRepository#timeouts}
    */
    readonly timeouts?: SourcerepoRepositoryTimeouts;
}
export interface SourcerepoRepositoryPubsubConfigs {
    /**
    * The format of the Cloud Pub/Sub messages.
  - PROTOBUF: The message payload is a serialized protocol buffer of SourceRepoEvent.
  - JSON: The message payload is a JSON string of SourceRepoEvent. Possible values: ["PROTOBUF", "JSON"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#message_format SourcerepoRepository#message_format}
    */
    readonly messageFormat: string;
    /**
    * Email address of the service account used for publishing Cloud Pub/Sub messages.
  This service account needs to be in the same project as the PubsubConfig. When added,
  the caller needs to have iam.serviceAccounts.actAs permission on this service account.
  If unspecified, it defaults to the compute engine default service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#service_account_email SourcerepoRepository#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#topic SourcerepoRepository#topic}
    */
    readonly topic: string;
}
export declare function sourcerepoRepositoryPubsubConfigsToTerraform(struct?: SourcerepoRepositoryPubsubConfigs | cdktf.IResolvable): any;
export interface SourcerepoRepositoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#create SourcerepoRepository#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#delete SourcerepoRepository#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#update SourcerepoRepository#update}
    */
    readonly update?: string;
}
export declare function sourcerepoRepositoryTimeoutsToTerraform(struct?: SourcerepoRepositoryTimeoutsOutputReference | SourcerepoRepositoryTimeouts | cdktf.IResolvable): any;
export declare class SourcerepoRepositoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SourcerepoRepositoryTimeouts | undefined;
    set internalValue(value: SourcerepoRepositoryTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository google_sourcerepo_repository}
*/
export declare class SourcerepoRepository extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sourcerepo_repository";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository google_sourcerepo_repository} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SourcerepoRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: SourcerepoRepositoryConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get size(): number;
    get url(): string;
    private _pubsubConfigs?;
    get pubsubConfigs(): SourcerepoRepositoryPubsubConfigs[] | cdktf.IResolvable;
    set pubsubConfigs(value: SourcerepoRepositoryPubsubConfigs[] | cdktf.IResolvable);
    resetPubsubConfigs(): void;
    get pubsubConfigsInput(): cdktf.IResolvable | SourcerepoRepositoryPubsubConfigs[] | undefined;
    private _timeouts;
    get timeouts(): SourcerepoRepositoryTimeoutsOutputReference;
    putTimeouts(value: SourcerepoRepositoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SourcerepoRepositoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
